/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.calls;

import com.intellij.lang.ASTNode;
import java.util.ArrayList;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassKind;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.MemberDescriptor;
import org.jetbrains.jet.lang.descriptors.Modality;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.descriptors.Visibilities;
import org.jetbrains.jet.lang.diagnostics.Errors;
import org.jetbrains.jet.lang.evaluate.ConstantExpressionEvaluator;
import org.jetbrains.jet.lang.psi.Call;
import org.jetbrains.jet.lang.psi.JetCallExpression;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetPsiUtil;
import org.jetbrains.jet.lang.psi.JetQualifiedExpression;
import org.jetbrains.jet.lang.psi.JetReferenceExpression;
import org.jetbrains.jet.lang.psi.JetSimpleNameExpression;
import org.jetbrains.jet.lang.psi.JetSuperExpression;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.TemporaryBindingTrace;
import org.jetbrains.jet.lang.resolve.calls.CallResolver;
import org.jetbrains.jet.lang.resolve.calls.context.BasicCallResolutionContext;
import org.jetbrains.jet.lang.resolve.calls.context.CheckValueArgumentsMode;
import org.jetbrains.jet.lang.resolve.calls.context.ContextDependency;
import org.jetbrains.jet.lang.resolve.calls.context.ResolutionContext;
import org.jetbrains.jet.lang.resolve.calls.context.TemporaryTraceAndCache;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedCallWithTrace;
import org.jetbrains.jet.lang.resolve.calls.results.OverloadResolutionResults;
import org.jetbrains.jet.lang.resolve.calls.results.OverloadResolutionResultsImpl;
import org.jetbrains.jet.lang.resolve.calls.results.OverloadResolutionResultsUtil;
import org.jetbrains.jet.lang.resolve.calls.util.CallMaker;
import org.jetbrains.jet.lang.resolve.constants.CompileTimeConstant;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.ChainedScope;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.resolve.scopes.JetScopeImpl;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.jet.lang.types.ErrorUtils;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.JetTypeInfo;
import org.jetbrains.jet.lang.types.NamespaceType;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.expressions.BasicExpressionTypingVisitor;
import org.jetbrains.jet.lang.types.expressions.DataFlowUtils;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingContext;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingServices;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;
import org.jetbrains.jet.lexer.JetTokens;
import org.jetbrains.jet.utils.Printer;

public class CallExpressionResolver {
    @NotNull
    private ExpressionTypingServices expressionTypingServices;

    public void setExpressionTypingServices(@NotNull ExpressionTypingServices expressionTypingServices) {
        if (expressionTypingServices == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expressionTypingServices", "org/jetbrains/jet/lang/resolve/calls/CallExpressionResolver", "setExpressionTypingServices"));
        }
        this.expressionTypingServices = expressionTypingServices;
    }

    @Nullable
    private JetType lookupNamespaceOrClassObject(@NotNull JetSimpleNameExpression expression, @NotNull ExpressionTypingContext context) {
        JetType classObjectType;
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/resolve/calls/CallExpressionResolver", "lookupNamespaceOrClassObject"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/resolve/calls/CallExpressionResolver", "lookupNamespaceOrClassObject"));
        }
        Name referencedName = expression.getReferencedNameAsName();
        final ClassifierDescriptor classifier = context.scope.getClassifier(referencedName);
        if (classifier != null && (classObjectType = classifier.getClassObjectType()) != null) {
            context.trace.record(BindingContext.REFERENCE_TARGET, expression, classifier);
            JetType result = CallExpressionResolver.getExtendedClassObjectType(expression, classObjectType, classifier, context);
            CallExpressionResolver.checkClassObjectVisibility(classifier, expression, context);
            return DataFlowUtils.checkType(result, (JetExpression)expression, (ResolutionContext)context);
        }
        JetType[] result = new JetType[1];
        TemporaryBindingTrace temporaryTrace = TemporaryBindingTrace.create(context.trace, "trace for namespace/class object lookup of name", referencedName);
        if (this.furtherNameLookup(expression, result, (ResolutionContext)context.replaceBindingTrace(temporaryTrace))) {
            temporaryTrace.commit();
            return DataFlowUtils.checkType(result[0], (JetExpression)expression, (ResolutionContext)context);
        }
        if (classifier != null) {
            if (classifier instanceof TypeParameterDescriptor) {
                if (JetPsiUtil.isLHSOfDot(expression)) {
                    context.trace.report(Errors.TYPE_PARAMETER_ON_LHS_OF_DOT.on(expression, (TypeParameterDescriptor)classifier));
                } else {
                    context.trace.report(Errors.TYPE_PARAMETER_IS_NOT_AN_EXPRESSION.on(expression, (TypeParameterDescriptor)classifier));
                }
            } else if (!JetPsiUtil.isLHSOfDot(expression)) {
                context.trace.report(Errors.NO_CLASS_OBJECT.on(expression, classifier));
            }
            context.trace.record(BindingContext.REFERENCE_TARGET, expression, classifier);
            JetScope scopeForStaticMembersResolution = classifier instanceof ClassDescriptor ? DescriptorUtils.getStaticNestedClassesScope((ClassDescriptor)classifier) : new JetScopeImpl(){

                @Override
                @NotNull
                public DeclarationDescriptor getContainingDeclaration() {
                    ClassifierDescriptor classifierDescriptor = classifier;
                    if (classifierDescriptor == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/CallExpressionResolver$1", "getContainingDeclaration"));
                    }
                    return classifierDescriptor;
                }

                public String toString() {
                    return "Scope for the type parameter on the left hand side of dot";
                }

                @Override
                public void printScopeStructure(@NotNull Printer p) {
                    if (p == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "org/jetbrains/jet/lang/resolve/calls/CallExpressionResolver$1", "printScopeStructure"));
                    }
                    p.println(this.toString(), " for ", classifier);
                }
            };
            return new NamespaceType(referencedName, scopeForStaticMembersResolution, ReceiverValue.NO_RECEIVER);
        }
        temporaryTrace.commit();
        return result[0];
    }

    private static void checkClassObjectVisibility(@NotNull ClassifierDescriptor classifier, @NotNull JetSimpleNameExpression expression, @NotNull ExpressionTypingContext context) {
        if (classifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classifier", "org/jetbrains/jet/lang/resolve/calls/CallExpressionResolver", "checkClassObjectVisibility"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/resolve/calls/CallExpressionResolver", "checkClassObjectVisibility"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/resolve/calls/CallExpressionResolver", "checkClassObjectVisibility"));
        }
        if (!(classifier instanceof ClassDescriptor)) {
            return;
        }
        ClassDescriptor classObject = ((ClassDescriptor)classifier).getClassObjectDescriptor();
        assert (classObject != null) : "This check should be done only for classes with class objects: " + classifier;
        DeclarationDescriptor from = context.scopeForVisibility.getContainingDeclaration();
        if (!Visibilities.isVisible(classObject, from)) {
            context.trace.report(Errors.INVISIBLE_MEMBER.on(expression, classObject, classObject.getVisibility(), from));
        }
    }

    @NotNull
    private static JetType getExtendedClassObjectType(@NotNull JetSimpleNameExpression expression, @NotNull JetType classObjectType, @NotNull ClassifierDescriptor classifier, @NotNull ResolutionContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/resolve/calls/CallExpressionResolver", "getExtendedClassObjectType"));
        }
        if (classObjectType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classObjectType", "org/jetbrains/jet/lang/resolve/calls/CallExpressionResolver", "getExtendedClassObjectType"));
        }
        if (classifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classifier", "org/jetbrains/jet/lang/resolve/calls/CallExpressionResolver", "getExtendedClassObjectType"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/resolve/calls/CallExpressionResolver", "getExtendedClassObjectType"));
        }
        if (!JetPsiUtil.isLHSOfDot(expression) || !(classifier instanceof ClassDescriptor)) {
            JetType jetType = classObjectType;
            if (jetType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/CallExpressionResolver", "getExtendedClassObjectType"));
            }
            return jetType;
        }
        ClassDescriptor classDescriptor = (ClassDescriptor)classifier;
        if (classDescriptor.getKind() == ClassKind.ENUM_ENTRY) {
            JetType jetType = classObjectType;
            if (jetType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/CallExpressionResolver", "getExtendedClassObjectType"));
            }
            return jetType;
        }
        ArrayList<JetScope> scopes = new ArrayList<JetScope>(3);
        scopes.add(classObjectType.getMemberScope());
        scopes.add(DescriptorUtils.getStaticNestedClassesScope(classDescriptor));
        Name referencedName = expression.getReferencedNameAsName();
        NamespaceDescriptor namespace = context.scope.getNamespace(referencedName);
        if (namespace != null) {
            scopes.add(namespace.getMemberScope());
        }
        ChainedScope scope = new ChainedScope((DeclarationDescriptor)classifier, scopes.toArray(new JetScope[scopes.size()]));
        NamespaceType namespaceType = new NamespaceType(referencedName, scope, new ExpressionReceiver(expression, classObjectType));
        if (namespaceType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/CallExpressionResolver", "getExtendedClassObjectType"));
        }
        return namespaceType;
    }

    private boolean furtherNameLookup(@NotNull JetSimpleNameExpression expression, @NotNull JetType[] result, @NotNull ResolutionContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/resolve/calls/CallExpressionResolver", "furtherNameLookup"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/jet/lang/resolve/calls/CallExpressionResolver", "furtherNameLookup"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/resolve/calls/CallExpressionResolver", "furtherNameLookup"));
        }
        NamespaceType namespaceType = this.lookupNamespaceType(expression, context);
        if (namespaceType == null) {
            return false;
        }
        if (JetPsiUtil.isLHSOfDot(expression)) {
            result[0] = namespaceType;
            return true;
        }
        context.trace.report(Errors.EXPRESSION_EXPECTED_NAMESPACE_FOUND.on(expression));
        result[0] = ErrorUtils.createErrorType("Type for " + expression.getReferencedNameAsName());
        return false;
    }

    @Nullable
    private NamespaceType lookupNamespaceType(@NotNull JetSimpleNameExpression expression, @NotNull ResolutionContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/resolve/calls/CallExpressionResolver", "lookupNamespaceType"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/resolve/calls/CallExpressionResolver", "lookupNamespaceType"));
        }
        Name name = expression.getReferencedNameAsName();
        NamespaceDescriptor namespace = context.scope.getNamespace(name);
        if (namespace == null) {
            return null;
        }
        context.trace.record(BindingContext.REFERENCE_TARGET, expression, namespace);
        ClassifierDescriptor classifier = context.scope.getClassifier(name);
        JetScope scope = classifier instanceof ClassDescriptor ? new ChainedScope((DeclarationDescriptor)namespace, namespace.getMemberScope(), DescriptorUtils.getStaticNestedClassesScope((ClassDescriptor)classifier)) : namespace.getMemberScope();
        return new NamespaceType(name, scope, ReceiverValue.NO_RECEIVER);
    }

    @Nullable
    public ResolvedCallWithTrace<FunctionDescriptor> getResolvedCallForFunction(@NotNull Call call, @NotNull JetExpression callExpression, @NotNull ResolutionContext context, @NotNull CheckValueArgumentsMode checkArguments, @NotNull boolean[] result) {
        if (call == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "org/jetbrains/jet/lang/resolve/calls/CallExpressionResolver", "getResolvedCallForFunction"));
        }
        if (callExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callExpression", "org/jetbrains/jet/lang/resolve/calls/CallExpressionResolver", "getResolvedCallForFunction"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/resolve/calls/CallExpressionResolver", "getResolvedCallForFunction"));
        }
        if (checkArguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "checkArguments", "org/jetbrains/jet/lang/resolve/calls/CallExpressionResolver", "getResolvedCallForFunction"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/jet/lang/resolve/calls/CallExpressionResolver", "getResolvedCallForFunction"));
        }
        CallResolver callResolver = this.expressionTypingServices.getCallResolver();
        OverloadResolutionResultsImpl<FunctionDescriptor> results = callResolver.resolveFunctionCall(BasicCallResolutionContext.create(context, call, checkArguments));
        if (!results.isNothing()) {
            this.checkSuper(call.getExplicitReceiver(), results, context.trace, callExpression);
            result[0] = true;
            return OverloadResolutionResultsUtil.getResultingCall(results, context.contextDependency);
        }
        result[0] = false;
        return null;
    }

    @Nullable
    private JetType getVariableType(@NotNull JetSimpleNameExpression nameExpression, @NotNull ReceiverValue receiver, @Nullable ASTNode callOperationNode, @NotNull ExpressionTypingContext context, @NotNull boolean[] result) {
        TemporaryTraceAndCache temporaryForNamespaceOrClassObject;
        if (nameExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameExpression", "org/jetbrains/jet/lang/resolve/calls/CallExpressionResolver", "getVariableType"));
        }
        if (receiver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiver", "org/jetbrains/jet/lang/resolve/calls/CallExpressionResolver", "getVariableType"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/resolve/calls/CallExpressionResolver", "getVariableType"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/jet/lang/resolve/calls/CallExpressionResolver", "getVariableType"));
        }
        TemporaryTraceAndCache temporaryForVariable = TemporaryTraceAndCache.create(context, "trace to resolve as local variable or property", nameExpression);
        CallResolver callResolver = this.expressionTypingServices.getCallResolver();
        Call call = CallMaker.makePropertyCall(receiver, callOperationNode, nameExpression);
        BasicCallResolutionContext contextForVariable = BasicCallResolutionContext.create(context.replaceTraceAndCache(temporaryForVariable), call, CheckValueArgumentsMode.ENABLED);
        OverloadResolutionResults<VariableDescriptor> resolutionResult = callResolver.resolveSimpleProperty(contextForVariable);
        if (resolutionResult.isSuccess()) {
            temporaryForVariable.commit();
            this.checkSuper(receiver, resolutionResult, context.trace, nameExpression);
            result[0] = true;
            return resolutionResult.isSingleResult() ? resolutionResult.getResultingDescriptor().getReturnType() : null;
        }
        ExpressionTypingContext newContext = receiver.exists() ? (ExpressionTypingContext)context.replaceScope(receiver.getType().getMemberScope()) : context;
        JetType jetType = this.lookupNamespaceOrClassObject(nameExpression, (ExpressionTypingContext)newContext.replaceTraceAndCache(temporaryForNamespaceOrClassObject = TemporaryTraceAndCache.create(context, "trace to resolve as namespace or class object", nameExpression)));
        if (jetType != null) {
            temporaryForNamespaceOrClassObject.commit();
            context.trace.record(BindingContext.RESOLUTION_SCOPE, nameExpression, context.scope);
            if (context.dataFlowInfo.hasTypeInfoConstraints()) {
                context.trace.record(BindingContext.NON_DEFAULT_EXPRESSION_DATA_FLOW, nameExpression, context.dataFlowInfo);
            }
            result[0] = true;
            return jetType;
        }
        temporaryForVariable.commit();
        result[0] = !resolutionResult.isNothing();
        return resolutionResult.isSingleResult() ? resolutionResult.getResultingDescriptor().getReturnType() : null;
    }

    @NotNull
    public JetTypeInfo getSimpleNameExpressionTypeInfo(@NotNull JetSimpleNameExpression nameExpression, @NotNull ReceiverValue receiver, @Nullable ASTNode callOperationNode, @NotNull ExpressionTypingContext context) {
        if (nameExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameExpression", "org/jetbrains/jet/lang/resolve/calls/CallExpressionResolver", "getSimpleNameExpressionTypeInfo"));
        }
        if (receiver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiver", "org/jetbrains/jet/lang/resolve/calls/CallExpressionResolver", "getSimpleNameExpressionTypeInfo"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/resolve/calls/CallExpressionResolver", "getSimpleNameExpressionTypeInfo"));
        }
        boolean[] result = new boolean[1];
        TemporaryTraceAndCache temporaryForVariable = TemporaryTraceAndCache.create(context, "trace to resolve as variable", nameExpression);
        JetType type = this.getVariableType(nameExpression, receiver, callOperationNode, (ExpressionTypingContext)context.replaceTraceAndCache(temporaryForVariable), result);
        if (result[0]) {
            temporaryForVariable.commit();
            if (type instanceof NamespaceType && !JetPsiUtil.isLHSOfDot(nameExpression)) {
                type = null;
            }
            JetTypeInfo jetTypeInfo = JetTypeInfo.create(type, context.dataFlowInfo);
            if (jetTypeInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/CallExpressionResolver", "getSimpleNameExpressionTypeInfo"));
            }
            return jetTypeInfo;
        }
        Call call = CallMaker.makeCall(nameExpression, receiver, callOperationNode, nameExpression, Collections.emptyList());
        TemporaryTraceAndCache temporaryForFunction = TemporaryTraceAndCache.create(context, "trace to resolve as function", nameExpression);
        Object newContext = context.replaceTraceAndCache(temporaryForFunction);
        ResolvedCallWithTrace<FunctionDescriptor> resolvedCall = this.getResolvedCallForFunction(call, nameExpression, (ResolutionContext)newContext, CheckValueArgumentsMode.ENABLED, result);
        if (result[0]) {
            FunctionDescriptor functionDescriptor = resolvedCall != null ? (FunctionDescriptor)resolvedCall.getResultingDescriptor() : null;
            temporaryForFunction.commit();
            boolean hasValueParameters = functionDescriptor == null || functionDescriptor.getValueParameters().size() > 0;
            context.trace.report(Errors.FUNCTION_CALL_EXPECTED.on(nameExpression, nameExpression, hasValueParameters));
            type = functionDescriptor != null ? functionDescriptor.getReturnType() : null;
            JetTypeInfo jetTypeInfo = JetTypeInfo.create(type, context.dataFlowInfo);
            if (jetTypeInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/CallExpressionResolver", "getSimpleNameExpressionTypeInfo"));
            }
            return jetTypeInfo;
        }
        temporaryForVariable.commit();
        JetTypeInfo jetTypeInfo = JetTypeInfo.create(null, context.dataFlowInfo);
        if (jetTypeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/CallExpressionResolver", "getSimpleNameExpressionTypeInfo"));
        }
        return jetTypeInfo;
    }

    @NotNull
    public JetTypeInfo getCallExpressionTypeInfo(@NotNull JetCallExpression callExpression, @NotNull ReceiverValue receiver, @Nullable ASTNode callOperationNode, @NotNull ExpressionTypingContext context) {
        if (callExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callExpression", "org/jetbrains/jet/lang/resolve/calls/CallExpressionResolver", "getCallExpressionTypeInfo"));
        }
        if (receiver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiver", "org/jetbrains/jet/lang/resolve/calls/CallExpressionResolver", "getCallExpressionTypeInfo"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/resolve/calls/CallExpressionResolver", "getCallExpressionTypeInfo"));
        }
        JetTypeInfo typeInfo = this.getCallExpressionTypeInfoWithoutFinalTypeCheck(callExpression, receiver, callOperationNode, context);
        if (context.contextDependency == ContextDependency.INDEPENDENT) {
            DataFlowUtils.checkType(typeInfo, (JetExpression)callExpression, (ResolutionContext)context);
        }
        JetTypeInfo jetTypeInfo = typeInfo;
        if (jetTypeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/CallExpressionResolver", "getCallExpressionTypeInfo"));
        }
        return jetTypeInfo;
    }

    @NotNull
    public JetTypeInfo getCallExpressionTypeInfoWithoutFinalTypeCheck(@NotNull JetCallExpression callExpression, @NotNull ReceiverValue receiver, @Nullable ASTNode callOperationNode, @NotNull ExpressionTypingContext context) {
        if (callExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callExpression", "org/jetbrains/jet/lang/resolve/calls/CallExpressionResolver", "getCallExpressionTypeInfoWithoutFinalTypeCheck"));
        }
        if (receiver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiver", "org/jetbrains/jet/lang/resolve/calls/CallExpressionResolver", "getCallExpressionTypeInfoWithoutFinalTypeCheck"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/resolve/calls/CallExpressionResolver", "getCallExpressionTypeInfoWithoutFinalTypeCheck"));
        }
        boolean[] result = new boolean[1];
        Call call = CallMaker.makeCall(receiver, callOperationNode, callExpression);
        TemporaryTraceAndCache temporaryForFunction = TemporaryTraceAndCache.create(context, "trace to resolve as function call", callExpression);
        ResolvedCallWithTrace<FunctionDescriptor> resolvedCall = this.getResolvedCallForFunction(call, callExpression, (ResolutionContext)context.replaceTraceAndCache(temporaryForFunction), CheckValueArgumentsMode.ENABLED, result);
        if (result[0]) {
            FunctionDescriptor functionDescriptor = resolvedCall != null ? (FunctionDescriptor)resolvedCall.getResultingDescriptor() : null;
            temporaryForFunction.commit();
            if (callExpression.getValueArgumentList() == null && callExpression.getFunctionLiteralArguments().isEmpty()) {
                boolean hasValueParameters = functionDescriptor == null || functionDescriptor.getValueParameters().size() > 0;
                context.trace.report(Errors.FUNCTION_CALL_EXPECTED.on(callExpression, callExpression, hasValueParameters));
            }
            if (functionDescriptor == null) {
                JetTypeInfo jetTypeInfo = JetTypeInfo.create(null, context.dataFlowInfo);
                if (jetTypeInfo == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/CallExpressionResolver", "getCallExpressionTypeInfoWithoutFinalTypeCheck"));
                }
                return jetTypeInfo;
            }
            JetType type = functionDescriptor.getReturnType();
            JetTypeInfo jetTypeInfo = JetTypeInfo.create(type, resolvedCall.getDataFlowInfoForArguments().getResultInfo());
            if (jetTypeInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/CallExpressionResolver", "getCallExpressionTypeInfoWithoutFinalTypeCheck"));
            }
            return jetTypeInfo;
        }
        JetExpression calleeExpression = callExpression.getCalleeExpression();
        if (calleeExpression instanceof JetSimpleNameExpression && callExpression.getTypeArgumentList() == null) {
            TemporaryTraceAndCache temporaryForVariable = TemporaryTraceAndCache.create(context, "trace to resolve as variable with 'invoke' call", callExpression);
            JetType type = this.getVariableType((JetSimpleNameExpression)calleeExpression, receiver, callOperationNode, (ExpressionTypingContext)context.replaceTraceAndCache(temporaryForVariable), result);
            if (result[0]) {
                temporaryForVariable.commit();
                context.trace.report(Errors.FUNCTION_EXPECTED.on((JetReferenceExpression)calleeExpression, calleeExpression, type != null ? type : ErrorUtils.createErrorType("")));
                JetTypeInfo jetTypeInfo = JetTypeInfo.create(null, context.dataFlowInfo);
                if (jetTypeInfo == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/CallExpressionResolver", "getCallExpressionTypeInfoWithoutFinalTypeCheck"));
                }
                return jetTypeInfo;
            }
        }
        temporaryForFunction.commit();
        JetTypeInfo jetTypeInfo = JetTypeInfo.create(null, context.dataFlowInfo);
        if (jetTypeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/CallExpressionResolver", "getCallExpressionTypeInfoWithoutFinalTypeCheck"));
        }
        return jetTypeInfo;
    }

    private void checkSuper(@NotNull ReceiverValue receiverValue, @NotNull OverloadResolutionResults<? extends CallableDescriptor> results, @NotNull BindingTrace trace, @NotNull JetExpression expression) {
        if (receiverValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiverValue", "org/jetbrains/jet/lang/resolve/calls/CallExpressionResolver", "checkSuper"));
        }
        if (results == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "results", "org/jetbrains/jet/lang/resolve/calls/CallExpressionResolver", "checkSuper"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/calls/CallExpressionResolver", "checkSuper"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/resolve/calls/CallExpressionResolver", "checkSuper"));
        }
        if (!results.isSingleResult()) {
            return;
        }
        if (!(receiverValue instanceof ExpressionReceiver)) {
            return;
        }
        JetExpression receiver = ((ExpressionReceiver)receiverValue).getExpression();
        CallableDescriptor descriptor = results.getResultingDescriptor();
        if (receiver instanceof JetSuperExpression && descriptor instanceof MemberDescriptor && ((MemberDescriptor)((Object)descriptor)).getModality() == Modality.ABSTRACT) {
            trace.report(Errors.ABSTRACT_SUPER_CALL.on(expression));
        }
    }

    @NotNull
    private JetTypeInfo getSelectorReturnTypeInfo(@NotNull ReceiverValue receiver, @Nullable ASTNode callOperationNode, @NotNull JetExpression selectorExpression, @NotNull ExpressionTypingContext context) {
        if (receiver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiver", "org/jetbrains/jet/lang/resolve/calls/CallExpressionResolver", "getSelectorReturnTypeInfo"));
        }
        if (selectorExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectorExpression", "org/jetbrains/jet/lang/resolve/calls/CallExpressionResolver", "getSelectorReturnTypeInfo"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/resolve/calls/CallExpressionResolver", "getSelectorReturnTypeInfo"));
        }
        if (selectorExpression instanceof JetCallExpression) {
            JetTypeInfo jetTypeInfo = this.getCallExpressionTypeInfoWithoutFinalTypeCheck((JetCallExpression)selectorExpression, receiver, callOperationNode, context);
            if (jetTypeInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/CallExpressionResolver", "getSelectorReturnTypeInfo"));
            }
            return jetTypeInfo;
        }
        if (selectorExpression instanceof JetSimpleNameExpression) {
            JetTypeInfo jetTypeInfo = this.getSimpleNameExpressionTypeInfo((JetSimpleNameExpression)selectorExpression, receiver, callOperationNode, context);
            if (jetTypeInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/CallExpressionResolver", "getSelectorReturnTypeInfo"));
            }
            return jetTypeInfo;
        }
        context.trace.report(Errors.ILLEGAL_SELECTOR.on(selectorExpression, selectorExpression.getText()));
        JetTypeInfo jetTypeInfo = JetTypeInfo.create(null, context.dataFlowInfo);
        if (jetTypeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/CallExpressionResolver", "getSelectorReturnTypeInfo"));
        }
        return jetTypeInfo;
    }

    @NotNull
    public JetTypeInfo getQualifiedExpressionTypeInfo(@NotNull JetQualifiedExpression expression, @NotNull ExpressionTypingContext context) {
        CompileTimeConstant<? extends Object> value;
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/resolve/calls/CallExpressionResolver", "getQualifiedExpressionTypeInfo"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/resolve/calls/CallExpressionResolver", "getQualifiedExpressionTypeInfo"));
        }
        JetExpression selectorExpression = expression.getSelectorExpression();
        JetExpression receiverExpression = expression.getReceiverExpression();
        Object contextForReceiver = ((ExpressionTypingContext)context.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE)).replaceContextDependency(ContextDependency.INDEPENDENT);
        JetTypeInfo receiverTypeInfo = this.expressionTypingServices.getTypeInfo(receiverExpression, (ResolutionContext)contextForReceiver);
        JetType receiverType = receiverTypeInfo.getType();
        if (selectorExpression == null) {
            JetTypeInfo jetTypeInfo = JetTypeInfo.create(null, context.dataFlowInfo);
            if (jetTypeInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/CallExpressionResolver", "getQualifiedExpressionTypeInfo"));
            }
            return jetTypeInfo;
        }
        if (receiverType == null) {
            receiverType = ErrorUtils.createErrorType("Type for " + expression.getText());
        }
        context = (ExpressionTypingContext)context.replaceDataFlowInfo(receiverTypeInfo.getDataFlowInfo());
        JetTypeInfo selectorReturnTypeInfo = this.getSelectorReturnTypeInfo(new ExpressionReceiver(receiverExpression, receiverType), expression.getOperationTokenNode(), selectorExpression, context);
        JetType selectorReturnType = selectorReturnTypeInfo.getType();
        if (!(receiverType instanceof NamespaceType) && expression.getOperationSign() == JetTokens.SAFE_ACCESS && selectorReturnType != null && !selectorReturnType.isNullable() && !KotlinBuiltIns.getInstance().isUnit(selectorReturnType) && receiverType.isNullable()) {
            selectorReturnType = TypeUtils.makeNullable(selectorReturnType);
        }
        if (selectorReturnType != null) {
            context.trace.record(BindingContext.EXPRESSION_TYPE, selectorExpression, selectorReturnType);
        }
        if ((value = ConstantExpressionEvaluator.object$.evaluate(expression, context.trace, context.expectedType)) != null) {
            JetTypeInfo jetTypeInfo = BasicExpressionTypingVisitor.createCompileTimeConstantTypeInfo(value, expression, context);
            if (jetTypeInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/CallExpressionResolver", "getQualifiedExpressionTypeInfo"));
            }
            return jetTypeInfo;
        }
        JetTypeInfo typeInfo = JetTypeInfo.create(selectorReturnType, selectorReturnTypeInfo.getDataFlowInfo());
        if (context.contextDependency == ContextDependency.INDEPENDENT) {
            DataFlowUtils.checkType(typeInfo, (JetExpression)expression, (ResolutionContext)context);
        }
        JetTypeInfo jetTypeInfo = typeInfo;
        if (jetTypeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/CallExpressionResolver", "getQualifiedExpressionTypeInfo"));
        }
        return jetTypeInfo;
    }
}

