/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve;

import com.google.common.collect.ImmutableSet;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ConcurrentWeakValueHashMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FilteringIterator;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ConstructorDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.jet.lang.diagnostics.Diagnostic;
import org.jetbrains.jet.lang.diagnostics.Severity;
import org.jetbrains.jet.lang.psi.JetAnnotated;
import org.jetbrains.jet.lang.psi.JetAnnotationEntry;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.Diagnostics;
import org.jetbrains.jet.lang.resolve.DiagnosticsElementsCache;
import org.jetbrains.jet.lang.resolve.SimpleDiagnostics;
import org.jetbrains.jet.lang.resolve.constants.ArrayValue;
import org.jetbrains.jet.lang.resolve.constants.CompileTimeConstant;
import org.jetbrains.jet.lang.resolve.constants.StringValue;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;

public class DiagnosticsWithSuppression
implements Diagnostics {
    private static final Logger LOG = Logger.getInstance(DiagnosticsWithSuppression.class);
    private final BindingContext context;
    private final Collection<Diagnostic> diagnostics;
    private final Map<JetAnnotated, Suppressor> suppressors;
    private final ClassDescriptor suppressClass;
    private final ValueParameterDescriptor suppressParameter;
    private final Condition<Diagnostic> filter;
    private final DiagnosticsElementsCache elementsCache;

    public DiagnosticsWithSuppression(@NotNull BindingContext context, @NotNull Collection<Diagnostic> diagnostics) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/resolve/DiagnosticsWithSuppression", "<init>"));
        }
        if (diagnostics == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diagnostics", "org/jetbrains/jet/lang/resolve/DiagnosticsWithSuppression", "<init>"));
        }
        this.suppressors = new ConcurrentWeakValueHashMap<JetAnnotated, Suppressor>();
        this.filter = new Condition<Diagnostic>(){

            @Override
            public boolean value(Diagnostic diagnostic) {
                return !DiagnosticsWithSuppression.this.isSuppressed(diagnostic);
            }
        };
        this.elementsCache = new DiagnosticsElementsCache(this);
        this.context = context;
        this.diagnostics = diagnostics;
        this.suppressClass = KotlinBuiltIns.getInstance().getSuppressAnnotationClass();
        ConstructorDescriptor primaryConstructor = this.suppressClass.getUnsubstitutedPrimaryConstructor();
        assert (primaryConstructor != null) : "No primary constructor in " + this.suppressClass;
        this.suppressParameter = primaryConstructor.getValueParameters().get(0);
    }

    @Override
    @NotNull
    public Diagnostics noSuppression() {
        SimpleDiagnostics simpleDiagnostics = new SimpleDiagnostics(this.diagnostics);
        if (simpleDiagnostics == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/DiagnosticsWithSuppression", "noSuppression"));
        }
        return simpleDiagnostics;
    }

    @Override
    @NotNull
    public Iterator<Diagnostic> iterator() {
        FilteringIterator filteringIterator = new FilteringIterator(this.diagnostics.iterator(), this.filter);
        if (filteringIterator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/DiagnosticsWithSuppression", "iterator"));
        }
        return filteringIterator;
    }

    @Override
    @NotNull
    public Collection<Diagnostic> all() {
        List<Diagnostic> list2 = ContainerUtil.filter(this.diagnostics, this.filter);
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/DiagnosticsWithSuppression", "all"));
        }
        return list2;
    }

    @Override
    @NotNull
    public Collection<Diagnostic> forElement(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "org/jetbrains/jet/lang/resolve/DiagnosticsWithSuppression", "forElement"));
        }
        Collection<Diagnostic> collection = this.elementsCache.getDiagnostics(psiElement);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/DiagnosticsWithSuppression", "forElement"));
        }
        return collection;
    }

    @Override
    public boolean isEmpty() {
        return this.all().isEmpty();
    }

    private boolean isSuppressed(@NotNull Diagnostic diagnostic) {
        if (diagnostic == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diagnostic", "org/jetbrains/jet/lang/resolve/DiagnosticsWithSuppression", "isSuppressed"));
        }
        PsiElement element = diagnostic.getPsiElement();
        JetAnnotated annotated = PsiTreeUtil.getParentOfType(element, JetAnnotated.class, false);
        if (annotated == null) {
            return false;
        }
        return this.isSuppressedByAnnotated(diagnostic, annotated, 0);
    }

    private boolean isSuppressedByAnnotated(@NotNull Diagnostic diagnostic, @NotNull JetAnnotated annotated, int debugDepth) {
        Suppressor suppressor;
        if (diagnostic == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diagnostic", "org/jetbrains/jet/lang/resolve/DiagnosticsWithSuppression", "isSuppressedByAnnotated"));
        }
        if (annotated == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotated", "org/jetbrains/jet/lang/resolve/DiagnosticsWithSuppression", "isSuppressedByAnnotated"));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Annotated: ", annotated.getName());
            LOG.debug("Depth: ", debugDepth);
            LOG.debug("Cache size: ", this.suppressors.size(), "\n");
        }
        if ((suppressor = this.getOrCreateSuppressor(annotated)).isSuppressed(diagnostic)) {
            return true;
        }
        JetAnnotated annotatedAbove = PsiTreeUtil.getParentOfType((PsiElement)suppressor.getAnnotatedElement(), JetAnnotated.class, true);
        if (annotatedAbove == null) {
            return false;
        }
        boolean suppressed = this.isSuppressedByAnnotated(diagnostic, annotatedAbove, debugDepth + 1);
        Suppressor suppressorAbove = this.suppressors.get(annotatedAbove);
        if (suppressorAbove != null && suppressorAbove.dominates(suppressor)) {
            this.suppressors.put(annotated, suppressorAbove);
        }
        return suppressed;
    }

    @NotNull
    private Suppressor getOrCreateSuppressor(@NotNull JetAnnotated annotated) {
        if (annotated == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotated", "org/jetbrains/jet/lang/resolve/DiagnosticsWithSuppression", "getOrCreateSuppressor"));
        }
        Suppressor suppressor = this.suppressors.get(annotated);
        if (suppressor == null) {
            Set<String> strings = this.getSuppressingStrings(annotated);
            suppressor = strings.isEmpty() ? new EmptySuppressor(annotated) : (strings.size() == 1 ? new SingularSuppressor(annotated, strings.iterator().next()) : new MultiSuppressor(annotated, strings));
            this.suppressors.put(annotated, suppressor);
        }
        Suppressor suppressor2 = suppressor;
        if (suppressor2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/DiagnosticsWithSuppression", "getOrCreateSuppressor"));
        }
        return suppressor2;
    }

    private Set<String> getSuppressingStrings(@NotNull JetAnnotated annotated) {
        if (annotated == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotated", "org/jetbrains/jet/lang/resolve/DiagnosticsWithSuppression", "getSuppressingStrings"));
        }
        ImmutableSet.Builder<String> builder = ImmutableSet.builder();
        for (JetAnnotationEntry annotationEntry : annotated.getAnnotationEntries()) {
            Map<ValueParameterDescriptor, CompileTimeConstant<?>> arguments2;
            CompileTimeConstant<?> value;
            AnnotationDescriptor annotationDescriptor = this.context.get(BindingContext.ANNOTATION, annotationEntry);
            if (annotationDescriptor == null || !this.suppressClass.equals(annotationDescriptor.getType().getConstructor().getDeclarationDescriptor()) || !((value = (arguments2 = annotationDescriptor.getAllValueArguments()).get(this.suppressParameter)) instanceof ArrayValue)) continue;
            ArrayValue arrayValue = (ArrayValue)value;
            Object values = arrayValue.getValue();
            DiagnosticsWithSuppression.addStrings(builder, values);
        }
        return builder.build();
    }

    public static boolean isSuppressedByStrings(@NotNull Diagnostic diagnostic, @NotNull Set<String> strings) {
        if (diagnostic == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diagnostic", "org/jetbrains/jet/lang/resolve/DiagnosticsWithSuppression", "isSuppressedByStrings"));
        }
        if (strings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "strings", "org/jetbrains/jet/lang/resolve/DiagnosticsWithSuppression", "isSuppressedByStrings"));
        }
        if (strings.contains("warnings") && diagnostic.getSeverity() == Severity.WARNING) {
            return true;
        }
        return strings.contains(diagnostic.getFactory().getName().toLowerCase());
    }

    private static void addStrings(ImmutableSet.Builder<String> builder, List<CompileTimeConstant<?>> values) {
        for (CompileTimeConstant<?> value : values) {
            if (!(value instanceof StringValue)) continue;
            StringValue stringValue = (StringValue)value;
            builder.add(stringValue.getValue().toLowerCase());
        }
    }

    private static class MultiSuppressor
    extends Suppressor {
        private final Set<String> strings;

        private MultiSuppressor(@NotNull JetAnnotated annotated, @NotNull Set<String> strings) {
            if (annotated == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotated", "org/jetbrains/jet/lang/resolve/DiagnosticsWithSuppression$MultiSuppressor", "<init>"));
            }
            if (strings == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "strings", "org/jetbrains/jet/lang/resolve/DiagnosticsWithSuppression$MultiSuppressor", "<init>"));
            }
            super(annotated);
            this.strings = strings;
        }

        @Override
        public boolean isSuppressed(@NotNull Diagnostic diagnostic) {
            if (diagnostic == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diagnostic", "org/jetbrains/jet/lang/resolve/DiagnosticsWithSuppression$MultiSuppressor", "isSuppressed"));
            }
            return DiagnosticsWithSuppression.isSuppressedByStrings(diagnostic, this.strings);
        }

        @Override
        public boolean dominates(@NotNull Suppressor other) {
            if (other == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "other", "org/jetbrains/jet/lang/resolve/DiagnosticsWithSuppression$MultiSuppressor", "dominates"));
            }
            return other instanceof EmptySuppressor;
        }
    }

    private static class SingularSuppressor
    extends Suppressor {
        private final String string;

        private SingularSuppressor(@NotNull JetAnnotated annotated, @NotNull String string) {
            if (annotated == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotated", "org/jetbrains/jet/lang/resolve/DiagnosticsWithSuppression$SingularSuppressor", "<init>"));
            }
            if (string == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "string", "org/jetbrains/jet/lang/resolve/DiagnosticsWithSuppression$SingularSuppressor", "<init>"));
            }
            super(annotated);
            this.string = string;
        }

        @Override
        public boolean isSuppressed(@NotNull Diagnostic diagnostic) {
            if (diagnostic == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diagnostic", "org/jetbrains/jet/lang/resolve/DiagnosticsWithSuppression$SingularSuppressor", "isSuppressed"));
            }
            return DiagnosticsWithSuppression.isSuppressedByStrings(diagnostic, ImmutableSet.of(this.string));
        }

        @Override
        public boolean dominates(@NotNull Suppressor other) {
            if (other == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "other", "org/jetbrains/jet/lang/resolve/DiagnosticsWithSuppression$SingularSuppressor", "dominates"));
            }
            return other instanceof EmptySuppressor || other instanceof SingularSuppressor && ((SingularSuppressor)other).string.equals(this.string);
        }
    }

    private static class EmptySuppressor
    extends Suppressor {
        private EmptySuppressor(@NotNull JetAnnotated annotated) {
            if (annotated == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotated", "org/jetbrains/jet/lang/resolve/DiagnosticsWithSuppression$EmptySuppressor", "<init>"));
            }
            super(annotated);
        }

        @Override
        public boolean isSuppressed(@NotNull Diagnostic diagnostic) {
            if (diagnostic == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diagnostic", "org/jetbrains/jet/lang/resolve/DiagnosticsWithSuppression$EmptySuppressor", "isSuppressed"));
            }
            return false;
        }

        @Override
        public boolean dominates(@NotNull Suppressor other) {
            if (other == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "other", "org/jetbrains/jet/lang/resolve/DiagnosticsWithSuppression$EmptySuppressor", "dominates"));
            }
            return other instanceof EmptySuppressor;
        }
    }

    private static abstract class Suppressor {
        private final JetAnnotated annotated;

        protected Suppressor(@NotNull JetAnnotated annotated) {
            if (annotated == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotated", "org/jetbrains/jet/lang/resolve/DiagnosticsWithSuppression$Suppressor", "<init>"));
            }
            this.annotated = annotated;
        }

        @NotNull
        public JetAnnotated getAnnotatedElement() {
            JetAnnotated jetAnnotated = this.annotated;
            if (jetAnnotated == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/DiagnosticsWithSuppression$Suppressor", "getAnnotatedElement"));
            }
            return jetAnnotated;
        }

        public abstract boolean isSuppressed(@NotNull Diagnostic var1);

        public abstract boolean dominates(@NotNull Suppressor var1);
    }
}

