/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import jet.Function0;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.CallableMemberDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassKind;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.ConstructorDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptorWithVisibility;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.Modality;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertySetterDescriptor;
import org.jetbrains.jet.lang.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.ScriptDescriptor;
import org.jetbrains.jet.lang.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.descriptors.Visibilities;
import org.jetbrains.jet.lang.descriptors.Visibility;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.ConstructorDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.impl.LocalVariableDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.MutableClassDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.PropertyDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.impl.PropertyGetterDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.impl.PropertySetterDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.impl.SimpleFunctionDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.impl.TypeParameterDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.impl.ValueParameterDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.impl.VariableDescriptorImpl;
import org.jetbrains.jet.lang.diagnostics.DiagnosticFactory1;
import org.jetbrains.jet.lang.diagnostics.Errors;
import org.jetbrains.jet.lang.psi.JetClass;
import org.jetbrains.jet.lang.psi.JetClassOrObject;
import org.jetbrains.jet.lang.psi.JetDeclaration;
import org.jetbrains.jet.lang.psi.JetDelegationSpecifier;
import org.jetbrains.jet.lang.psi.JetEnumEntry;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetModifierList;
import org.jetbrains.jet.lang.psi.JetModifierListOwner;
import org.jetbrains.jet.lang.psi.JetNamedDeclaration;
import org.jetbrains.jet.lang.psi.JetNamedFunction;
import org.jetbrains.jet.lang.psi.JetNullableType;
import org.jetbrains.jet.lang.psi.JetParameter;
import org.jetbrains.jet.lang.psi.JetProjectionKind;
import org.jetbrains.jet.lang.psi.JetProperty;
import org.jetbrains.jet.lang.psi.JetPropertyAccessor;
import org.jetbrains.jet.lang.psi.JetPsiUtil;
import org.jetbrains.jet.lang.psi.JetSimpleNameExpression;
import org.jetbrains.jet.lang.psi.JetTypeConstraint;
import org.jetbrains.jet.lang.psi.JetTypeElement;
import org.jetbrains.jet.lang.psi.JetTypeParameter;
import org.jetbrains.jet.lang.psi.JetTypeParameterListOwner;
import org.jetbrains.jet.lang.psi.JetTypeProjection;
import org.jetbrains.jet.lang.psi.JetTypeReference;
import org.jetbrains.jet.lang.psi.JetUserType;
import org.jetbrains.jet.lang.psi.JetVariableDeclaration;
import org.jetbrains.jet.lang.resolve.AnnotationResolver;
import org.jetbrains.jet.lang.resolve.AnnotationUtils;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingContextUtils;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.DelegatedPropertyResolver;
import org.jetbrains.jet.lang.resolve.DescriptorFactory;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.ModifiersChecker;
import org.jetbrains.jet.lang.resolve.TraceBasedRedeclarationHandler;
import org.jetbrains.jet.lang.resolve.TypeResolver;
import org.jetbrains.jet.lang.resolve.calls.autocasts.DataFlowInfo;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.resolve.scopes.JetScopeUtils;
import org.jetbrains.jet.lang.resolve.scopes.WritableScope;
import org.jetbrains.jet.lang.resolve.scopes.WritableScopeImpl;
import org.jetbrains.jet.lang.types.DeferredType;
import org.jetbrains.jet.lang.types.ErrorUtils;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeProjection;
import org.jetbrains.jet.lang.types.TypeSubstitutor;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.Variance;
import org.jetbrains.jet.lang.types.checker.JetTypeChecker;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingServices;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;
import org.jetbrains.jet.lexer.JetKeywordToken;
import org.jetbrains.jet.lexer.JetTokens;
import org.jetbrains.jet.util.StorageUtil;

public class DescriptorResolver {
    public static final Name COPY_METHOD_NAME = Name.identifier("copy");
    public static final String COMPONENT_FUNCTION_NAME_PREFIX = "component";
    @NotNull
    private TypeResolver typeResolver;
    @NotNull
    private AnnotationResolver annotationResolver;
    @NotNull
    private ExpressionTypingServices expressionTypingServices;
    @NotNull
    private DelegatedPropertyResolver delegatedPropertyResolver;

    public void setTypeResolver(@NotNull TypeResolver typeResolver) {
        if (typeResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeResolver", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "setTypeResolver"));
        }
        this.typeResolver = typeResolver;
    }

    public void setAnnotationResolver(@NotNull AnnotationResolver annotationResolver) {
        if (annotationResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationResolver", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "setAnnotationResolver"));
        }
        this.annotationResolver = annotationResolver;
    }

    public void setExpressionTypingServices(@NotNull ExpressionTypingServices expressionTypingServices) {
        if (expressionTypingServices == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expressionTypingServices", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "setExpressionTypingServices"));
        }
        this.expressionTypingServices = expressionTypingServices;
    }

    public void setDelegatedPropertyResolver(@NotNull DelegatedPropertyResolver delegatedPropertyResolver) {
        if (delegatedPropertyResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegatedPropertyResolver", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "setDelegatedPropertyResolver"));
        }
        this.delegatedPropertyResolver = delegatedPropertyResolver;
    }

    public void resolveMutableClassDescriptor(@NotNull JetClass classElement, @NotNull MutableClassDescriptor descriptor, BindingTrace trace) {
        if (classElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classElement", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "resolveMutableClassDescriptor"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "resolveMutableClassDescriptor"));
        }
        ArrayList<TypeParameterDescriptor> typeParameters = Lists.newArrayList();
        int index = 0;
        for (JetTypeParameter typeParameter : classElement.getTypeParameters()) {
            AnnotationResolver.reportUnsupportedAnnotationForTypeParameter(typeParameter, trace);
            TypeParameterDescriptorImpl typeParameterDescriptor = TypeParameterDescriptorImpl.createForFurtherModification(descriptor, Collections.<AnnotationDescriptor>emptyList(), typeParameter.hasModifier(JetTokens.REIFIED_KEYWORD), typeParameter.getVariance(), JetPsiUtil.safeName(typeParameter.getName()), index);
            trace.record(BindingContext.TYPE_PARAMETER, typeParameter, typeParameterDescriptor);
            typeParameters.add(typeParameterDescriptor);
            ++index;
        }
        descriptor.setTypeParameterDescriptors(typeParameters);
        Modality defaultModality = descriptor.getKind() == ClassKind.TRAIT ? Modality.ABSTRACT : Modality.FINAL;
        descriptor.setModality(ModifiersChecker.resolveModalityFromModifiers(classElement, defaultModality));
        descriptor.setVisibility(ModifiersChecker.resolveVisibilityFromModifiers(classElement, ModifiersChecker.getDefaultClassVisibility(descriptor)));
        trace.record(BindingContext.CLASS, classElement, descriptor);
    }

    public void resolveSupertypesForMutableClassDescriptor(@NotNull JetClassOrObject jetClass, @NotNull MutableClassDescriptor descriptor, BindingTrace trace) {
        if (jetClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jetClass", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "resolveSupertypesForMutableClassDescriptor"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "resolveSupertypesForMutableClassDescriptor"));
        }
        for (JetType supertype : this.resolveSupertypes(descriptor.getScopeForSupertypeResolution(), descriptor, jetClass, trace)) {
            descriptor.addSupertype(supertype);
        }
    }

    public List<JetType> resolveSupertypes(@NotNull JetScope scope, @NotNull ClassDescriptor classDescriptor, @NotNull JetClassOrObject jetClass, BindingTrace trace) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "resolveSupertypes"));
        }
        if (classDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "resolveSupertypes"));
        }
        if (jetClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jetClass", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "resolveSupertypes"));
        }
        ArrayList<JetType> supertypes = Lists.newArrayList();
        List<JetDelegationSpecifier> delegationSpecifiers = jetClass.getDelegationSpecifiers();
        Collection<JetType> declaredSupertypes = this.resolveDelegationSpecifiers(scope, delegationSpecifiers, this.typeResolver, trace, false);
        for (JetType declaredSupertype : declaredSupertypes) {
            DescriptorResolver.addValidSupertype(supertypes, declaredSupertype);
        }
        if (classDescriptor.getKind() == ClassKind.ENUM_CLASS && !this.containsClass(supertypes)) {
            supertypes.add(0, KotlinBuiltIns.getInstance().getEnumType(classDescriptor.getDefaultType()));
        }
        if (supertypes.isEmpty()) {
            JetType defaultSupertype = this.getDefaultSupertype(jetClass, trace);
            DescriptorResolver.addValidSupertype(supertypes, defaultSupertype);
        }
        return supertypes;
    }

    private static void addValidSupertype(List<JetType> supertypes, JetType declaredSupertype) {
        if (!declaredSupertype.isError()) {
            supertypes.add(declaredSupertype);
        }
    }

    private boolean containsClass(Collection<JetType> result) {
        for (JetType type : result) {
            ClassifierDescriptor descriptor = type.getConstructor().getDeclarationDescriptor();
            if (!(descriptor instanceof ClassDescriptor) || ((ClassDescriptor)descriptor).getKind() == ClassKind.TRAIT) continue;
            return true;
        }
        return false;
    }

    private JetType getDefaultSupertype(JetClassOrObject jetClass, BindingTrace trace) {
        if (jetClass instanceof JetEnumEntry) {
            JetClassOrObject parent = PsiTreeUtil.getParentOfType((PsiElement)jetClass, JetClassOrObject.class);
            ClassDescriptor parentDescriptor = trace.getBindingContext().get(BindingContext.CLASS, parent);
            if (parentDescriptor.getTypeConstructor().getParameters().isEmpty()) {
                return parentDescriptor.getDefaultType();
            }
            trace.report(Errors.NO_GENERICS_IN_SUPERTYPE_SPECIFIER.on(jetClass.getNameIdentifier()));
            return ErrorUtils.createErrorType("Supertype not specified");
        }
        if (jetClass instanceof JetClass && ((JetClass)jetClass).isAnnotation()) {
            return KotlinBuiltIns.getInstance().getAnnotationType();
        }
        return KotlinBuiltIns.getInstance().getAnyType();
    }

    public Collection<JetType> resolveDelegationSpecifiers(JetScope extensibleScope, List<JetDelegationSpecifier> delegationSpecifiers, @NotNull TypeResolver resolver, BindingTrace trace, boolean checkBounds) {
        if (resolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolver", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "resolveDelegationSpecifiers"));
        }
        if (delegationSpecifiers.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<JetType> result = Lists.newArrayList();
        for (JetDelegationSpecifier delegationSpecifier : delegationSpecifiers) {
            JetTypeReference typeReference = delegationSpecifier.getTypeReference();
            if (typeReference != null) {
                result.add(resolver.resolveType(extensibleScope, typeReference, trace, checkBounds));
                JetTypeElement bareSuperType = DescriptorResolver.checkNullableSupertypeAndStripQuestionMarks(trace, typeReference.getTypeElement());
                DescriptorResolver.checkProjectionsInImmediateArguments(trace, bareSuperType);
                continue;
            }
            result.add(ErrorUtils.createErrorType("No type reference"));
        }
        return result;
    }

    @Nullable
    private static JetTypeElement checkNullableSupertypeAndStripQuestionMarks(@NotNull BindingTrace trace, @Nullable JetTypeElement typeElement) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "checkNullableSupertypeAndStripQuestionMarks"));
        }
        while (typeElement instanceof JetNullableType) {
            JetNullableType nullableType = (JetNullableType)typeElement;
            if ((typeElement = nullableType.getInnerType()) instanceof JetNullableType) continue;
            trace.report(Errors.NULLABLE_SUPERTYPE.on(nullableType));
        }
        return typeElement;
    }

    private static void checkProjectionsInImmediateArguments(@NotNull BindingTrace trace, @Nullable JetTypeElement typeElement) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "checkProjectionsInImmediateArguments"));
        }
        if (typeElement instanceof JetUserType) {
            JetUserType userType = (JetUserType)typeElement;
            List<JetTypeProjection> typeArguments = userType.getTypeArguments();
            for (JetTypeProjection typeArgument : typeArguments) {
                if (typeArgument.getProjectionKind() == JetProjectionKind.NONE) continue;
                trace.report(Errors.PROJECTION_IN_IMMEDIATE_ARGUMENT_TO_SUPERTYPE.on(typeArgument));
            }
        }
    }

    @NotNull
    public SimpleFunctionDescriptor resolveFunctionDescriptorWithAnnotationArguments(@NotNull DeclarationDescriptor containingDescriptor, @NotNull JetScope scope, @NotNull JetNamedFunction function, @NotNull BindingTrace trace, @NotNull DataFlowInfo dataFlowInfo) {
        if (containingDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingDescriptor", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "resolveFunctionDescriptorWithAnnotationArguments"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "resolveFunctionDescriptorWithAnnotationArguments"));
        }
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "resolveFunctionDescriptorWithAnnotationArguments"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "resolveFunctionDescriptorWithAnnotationArguments"));
        }
        if (dataFlowInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataFlowInfo", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "resolveFunctionDescriptorWithAnnotationArguments"));
        }
        SimpleFunctionDescriptor simpleFunctionDescriptor = this.resolveFunctionDescriptor(containingDescriptor, scope, function, trace, dataFlowInfo, this.annotationResolver.resolveAnnotationsWithArguments(scope, function.getModifierList(), trace));
        if (simpleFunctionDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "resolveFunctionDescriptorWithAnnotationArguments"));
        }
        return simpleFunctionDescriptor;
    }

    @NotNull
    public SimpleFunctionDescriptor resolveFunctionDescriptor(@NotNull DeclarationDescriptor containingDescriptor, @NotNull JetScope scope, @NotNull JetNamedFunction function, @NotNull BindingTrace trace, @NotNull DataFlowInfo dataFlowInfo) {
        if (containingDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingDescriptor", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "resolveFunctionDescriptor"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "resolveFunctionDescriptor"));
        }
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "resolveFunctionDescriptor"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "resolveFunctionDescriptor"));
        }
        if (dataFlowInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataFlowInfo", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "resolveFunctionDescriptor"));
        }
        SimpleFunctionDescriptor simpleFunctionDescriptor = this.resolveFunctionDescriptor(containingDescriptor, scope, function, trace, dataFlowInfo, this.annotationResolver.resolveAnnotationsWithoutArguments(scope, function.getModifierList(), trace));
        if (simpleFunctionDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "resolveFunctionDescriptor"));
        }
        return simpleFunctionDescriptor;
    }

    @NotNull
    private SimpleFunctionDescriptor resolveFunctionDescriptor(@NotNull DeclarationDescriptor containingDescriptor, final @NotNull JetScope scope, final @NotNull JetNamedFunction function, final @NotNull BindingTrace trace, final @NotNull DataFlowInfo dataFlowInfo, @NotNull List<AnnotationDescriptor> annotations) {
        JetExpression bodyExpression;
        if (containingDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingDescriptor", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "resolveFunctionDescriptor"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "resolveFunctionDescriptor"));
        }
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "resolveFunctionDescriptor"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "resolveFunctionDescriptor"));
        }
        if (dataFlowInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataFlowInfo", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "resolveFunctionDescriptor"));
        }
        if (annotations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotations", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "resolveFunctionDescriptor"));
        }
        final SimpleFunctionDescriptorImpl functionDescriptor = new SimpleFunctionDescriptorImpl(containingDescriptor, annotations, JetPsiUtil.safeName(function.getName()), CallableMemberDescriptor.Kind.DECLARATION);
        WritableScopeImpl innerScope = new WritableScopeImpl(scope, functionDescriptor, new TraceBasedRedeclarationHandler(trace), "Function descriptor header scope");
        innerScope.addLabeledDeclaration(functionDescriptor);
        List<TypeParameterDescriptorImpl> typeParameterDescriptors = this.resolveTypeParametersForCallableDescriptor(functionDescriptor, innerScope, function.getTypeParameters(), trace);
        innerScope.changeLockLevel(WritableScope.LockLevel.BOTH);
        this.resolveGenericBounds(function, innerScope, typeParameterDescriptors, trace);
        JetType receiverType = null;
        JetTypeReference receiverTypeRef = function.getReceiverTypeRef();
        if (receiverTypeRef != null) {
            JetScope scopeForReceiver = function.hasTypeParameterListBeforeFunctionName() ? innerScope : scope;
            receiverType = this.typeResolver.resolveType(scopeForReceiver, receiverTypeRef, trace, true);
        }
        List<ValueParameterDescriptor> valueParameterDescriptors = this.resolveValueParameters(functionDescriptor, innerScope, function.getValueParameters(), trace);
        innerScope.changeLockLevel(WritableScope.LockLevel.READING);
        JetTypeReference returnTypeRef = function.getReturnTypeRef();
        JetType returnType = returnTypeRef != null ? this.typeResolver.resolveType(innerScope, returnTypeRef, trace, true) : (function.hasBlockBody() ? KotlinBuiltIns.getInstance().getUnitType() : ((bodyExpression = function.getBodyExpression()) != null ? DeferredType.create(trace, StorageUtil.createRecursionIntolerantLazyValueWithDefault(ErrorUtils.createErrorType("Recursive dependency"), new Function0<JetType>(){

            @Override
            public JetType invoke() {
                JetType type = DescriptorResolver.this.expressionTypingServices.getBodyExpressionType(trace, scope, dataFlowInfo, function, functionDescriptor);
                return DescriptorResolver.transformAnonymousTypeIfNeeded(functionDescriptor, function, type, trace);
            }
        })) : ErrorUtils.createErrorType("No type, no body")));
        boolean hasBody = function.getBodyExpression() != null;
        Modality modality = ModifiersChecker.resolveModalityFromModifiers(function, DescriptorResolver.getDefaultModality(containingDescriptor, hasBody));
        Visibility visibility = ModifiersChecker.resolveVisibilityFromModifiers(function, DescriptorResolver.getDefaultVisibility(function, containingDescriptor));
        functionDescriptor.initialize(receiverType, DescriptorUtils.getExpectedThisObjectIfNeeded(containingDescriptor), typeParameterDescriptors, (List)valueParameterDescriptors, returnType, modality, visibility);
        BindingContextUtils.recordFunctionDeclarationToDescriptor(trace, function, functionDescriptor);
        SimpleFunctionDescriptorImpl simpleFunctionDescriptorImpl = functionDescriptor;
        if (simpleFunctionDescriptorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "resolveFunctionDescriptor"));
        }
        return simpleFunctionDescriptorImpl;
    }

    @NotNull
    public static SimpleFunctionDescriptor createComponentFunctionDescriptor(int parameterIndex, @NotNull PropertyDescriptor property2, @NotNull ValueParameterDescriptor parameter, @NotNull ClassDescriptor classDescriptor, @NotNull BindingTrace trace) {
        if (property2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "createComponentFunctionDescriptor"));
        }
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "createComponentFunctionDescriptor"));
        }
        if (classDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "createComponentFunctionDescriptor"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "createComponentFunctionDescriptor"));
        }
        String functionName = COMPONENT_FUNCTION_NAME_PREFIX + parameterIndex;
        JetType returnType = property2.getType();
        SimpleFunctionDescriptorImpl functionDescriptor = new SimpleFunctionDescriptorImpl(classDescriptor, Collections.<AnnotationDescriptor>emptyList(), Name.identifier(functionName), CallableMemberDescriptor.Kind.SYNTHESIZED);
        functionDescriptor.initialize((JetType)null, classDescriptor.getThisAsReceiverParameter(), Collections.emptyList(), Collections.emptyList(), returnType, Modality.FINAL, property2.getVisibility());
        trace.record(BindingContext.DATA_CLASS_COMPONENT_FUNCTION, parameter, functionDescriptor);
        SimpleFunctionDescriptorImpl simpleFunctionDescriptorImpl = functionDescriptor;
        if (simpleFunctionDescriptorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "createComponentFunctionDescriptor"));
        }
        return simpleFunctionDescriptorImpl;
    }

    @NotNull
    public static SimpleFunctionDescriptor createCopyFunctionDescriptor(@NotNull Collection<ValueParameterDescriptor> constructorParameters, @NotNull ClassDescriptor classDescriptor, @NotNull BindingTrace trace) {
        if (constructorParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructorParameters", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "createCopyFunctionDescriptor"));
        }
        if (classDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "createCopyFunctionDescriptor"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "createCopyFunctionDescriptor"));
        }
        JetType returnType = classDescriptor.getDefaultType();
        SimpleFunctionDescriptorImpl functionDescriptor = new SimpleFunctionDescriptorImpl(classDescriptor, Collections.<AnnotationDescriptor>emptyList(), COPY_METHOD_NAME, CallableMemberDescriptor.Kind.SYNTHESIZED);
        ArrayList<ValueParameterDescriptorImpl> parameterDescriptors = Lists.newArrayList();
        for (ValueParameterDescriptor parameter : constructorParameters) {
            PropertyDescriptor propertyDescriptor = trace.getBindingContext().get(BindingContext.VALUE_PARAMETER_AS_PROPERTY, parameter);
            boolean declaresDefaultValue = propertyDescriptor != null;
            ValueParameterDescriptorImpl parameterDescriptor = new ValueParameterDescriptorImpl(functionDescriptor, parameter.getIndex(), parameter.getAnnotations(), parameter.getName(), parameter.getType(), declaresDefaultValue, parameter.getVarargElementType());
            parameterDescriptors.add(parameterDescriptor);
            if (!declaresDefaultValue) continue;
            trace.record(BindingContext.VALUE_PARAMETER_AS_PROPERTY, parameterDescriptor, propertyDescriptor);
        }
        functionDescriptor.initialize((JetType)null, classDescriptor.getThisAsReceiverParameter(), Collections.emptyList(), parameterDescriptors, returnType, Modality.FINAL, classDescriptor.getVisibility());
        trace.record(BindingContext.DATA_CLASS_COPY_FUNCTION, classDescriptor, functionDescriptor);
        SimpleFunctionDescriptorImpl simpleFunctionDescriptorImpl = functionDescriptor;
        if (simpleFunctionDescriptorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "createCopyFunctionDescriptor"));
        }
        return simpleFunctionDescriptorImpl;
    }

    public static Visibility getDefaultVisibility(JetModifierListOwner modifierListOwner, DeclarationDescriptor containingDescriptor) {
        JetModifierList modifierList;
        Visibility defaultVisibility = containingDescriptor instanceof ClassDescriptor ? ((modifierList = modifierListOwner.getModifierList()) != null && modifierList.hasModifier(JetTokens.OVERRIDE_KEYWORD) ? Visibilities.INHERITED : Visibilities.INTERNAL) : (containingDescriptor instanceof FunctionDescriptor ? Visibilities.LOCAL : Visibilities.INTERNAL);
        return defaultVisibility;
    }

    public static Modality getDefaultModality(DeclarationDescriptor containingDescriptor, boolean isBodyPresent) {
        Modality defaultModality;
        if (containingDescriptor instanceof ClassDescriptor) {
            boolean isTrait = ((ClassDescriptor)containingDescriptor).getKind() == ClassKind.TRAIT;
            boolean isDefinitelyAbstract = isTrait && !isBodyPresent;
            Modality basicModality = isTrait ? Modality.OPEN : Modality.FINAL;
            defaultModality = isDefinitelyAbstract ? Modality.ABSTRACT : basicModality;
        } else {
            defaultModality = Modality.FINAL;
        }
        return defaultModality;
    }

    @NotNull
    private List<ValueParameterDescriptor> resolveValueParameters(FunctionDescriptor functionDescriptor, WritableScope parameterScope, List<JetParameter> valueParameters, BindingTrace trace) {
        ArrayList<ValueParameterDescriptor> result = new ArrayList<ValueParameterDescriptor>();
        for (int i = 0; i < valueParameters.size(); ++i) {
            JetType type;
            JetParameter valueParameter = valueParameters.get(i);
            JetTypeReference typeReference = valueParameter.getTypeReference();
            if (typeReference == null) {
                trace.report(Errors.VALUE_PARAMETER_WITH_NO_TYPE_ANNOTATION.on(valueParameter));
                type = ErrorUtils.createErrorType("Type annotation was missing");
            } else {
                type = this.typeResolver.resolveType(parameterScope, typeReference, trace, true);
            }
            if (!(functionDescriptor instanceof ConstructorDescriptor)) {
                DescriptorResolver.checkParameterHasNoValOrVar(trace, valueParameter, Errors.VAL_OR_VAR_ON_FUN_PARAMETER);
                DescriptorResolver.checkParameterHasNoModifier(trace, valueParameter);
            } else {
                DescriptorResolver.checkConstructorParameterHasNoModifier(trace, valueParameter);
            }
            ValueParameterDescriptorImpl valueParameterDescriptor = this.resolveValueParameterDescriptor(parameterScope, functionDescriptor, valueParameter, i, type, trace);
            parameterScope.addVariableDescriptor(valueParameterDescriptor);
            result.add(valueParameterDescriptor);
        }
        ArrayList<ValueParameterDescriptor> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "resolveValueParameters"));
        }
        return arrayList;
    }

    @NotNull
    public ValueParameterDescriptorImpl resolveValueParameterDescriptor(JetScope scope, DeclarationDescriptor declarationDescriptor, JetParameter valueParameter, int index, JetType type, BindingTrace trace) {
        ValueParameterDescriptorImpl valueParameterDescriptorImpl = DescriptorResolver.resolveValueParameterDescriptor(declarationDescriptor, valueParameter, index, type, trace, this.annotationResolver.resolveAnnotationsWithoutArguments(scope, valueParameter.getModifierList(), trace));
        if (valueParameterDescriptorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "resolveValueParameterDescriptor"));
        }
        return valueParameterDescriptorImpl;
    }

    @NotNull
    public ValueParameterDescriptorImpl resolveValueParameterDescriptorWithAnnotationArguments(JetScope scope, DeclarationDescriptor declarationDescriptor, JetParameter valueParameter, int index, JetType type, BindingTrace trace) {
        ValueParameterDescriptorImpl valueParameterDescriptorImpl = DescriptorResolver.resolveValueParameterDescriptor(declarationDescriptor, valueParameter, index, type, trace, this.annotationResolver.resolveAnnotationsWithArguments(scope, valueParameter.getModifierList(), trace));
        if (valueParameterDescriptorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "resolveValueParameterDescriptorWithAnnotationArguments"));
        }
        return valueParameterDescriptorImpl;
    }

    @NotNull
    private static ValueParameterDescriptorImpl resolveValueParameterDescriptor(DeclarationDescriptor declarationDescriptor, JetParameter valueParameter, int index, JetType type, BindingTrace trace, List<AnnotationDescriptor> annotations) {
        JetType varargElementType = null;
        JetType variableType = type;
        if (valueParameter.hasModifier(JetTokens.VARARG_KEYWORD)) {
            varargElementType = type;
            variableType = DescriptorUtils.getVarargParameterType(type);
        }
        ValueParameterDescriptorImpl valueParameterDescriptor = new ValueParameterDescriptorImpl(declarationDescriptor, index, annotations, JetPsiUtil.safeName(valueParameter.getName()), variableType, valueParameter.getDefaultValue() != null, varargElementType);
        trace.record(BindingContext.VALUE_PARAMETER, valueParameter, valueParameterDescriptor);
        ValueParameterDescriptorImpl valueParameterDescriptorImpl = valueParameterDescriptor;
        if (valueParameterDescriptorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "resolveValueParameterDescriptor"));
        }
        return valueParameterDescriptorImpl;
    }

    public List<TypeParameterDescriptorImpl> resolveTypeParametersForCallableDescriptor(DeclarationDescriptor containingDescriptor, WritableScope extensibleScope, List<JetTypeParameter> typeParameters, BindingTrace trace) {
        ArrayList<TypeParameterDescriptorImpl> result = new ArrayList<TypeParameterDescriptorImpl>();
        int typeParametersSize = typeParameters.size();
        for (int i = 0; i < typeParametersSize; ++i) {
            JetTypeParameter typeParameter = typeParameters.get(i);
            result.add(this.resolveTypeParameterForCallableDescriptor(containingDescriptor, extensibleScope, typeParameter, i, trace));
        }
        return result;
    }

    private TypeParameterDescriptorImpl resolveTypeParameterForCallableDescriptor(DeclarationDescriptor containingDescriptor, WritableScope extensibleScope, JetTypeParameter typeParameter, int index, BindingTrace trace) {
        if (typeParameter.getVariance() != Variance.INVARIANT) {
            assert (!(containingDescriptor instanceof ClassifierDescriptor)) : "This method is intended for functions/properties";
            trace.report(Errors.VARIANCE_ON_TYPE_PARAMETER_OF_FUNCTION_OR_PROPERTY.on(typeParameter));
        }
        AnnotationResolver.reportUnsupportedAnnotationForTypeParameter(typeParameter, trace);
        TypeParameterDescriptorImpl typeParameterDescriptor = TypeParameterDescriptorImpl.createForFurtherModification(containingDescriptor, Collections.<AnnotationDescriptor>emptyList(), typeParameter.hasModifier(JetTokens.REIFIED_KEYWORD), typeParameter.getVariance(), JetPsiUtil.safeName(typeParameter.getName()), index);
        trace.record(BindingContext.TYPE_PARAMETER, typeParameter, typeParameterDescriptor);
        extensibleScope.addTypeParameterDescriptor(typeParameterDescriptor);
        return typeParameterDescriptor;
    }

    @NotNull
    public static ConstructorDescriptorImpl createAndRecordPrimaryConstructorForObject(@Nullable PsiElement object2, @NotNull ClassDescriptor classDescriptor, @NotNull BindingTrace trace) {
        if (classDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "createAndRecordPrimaryConstructorForObject"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "createAndRecordPrimaryConstructorForObject"));
        }
        ConstructorDescriptorImpl constructorDescriptor = DescriptorFactory.createPrimaryConstructorForObject(classDescriptor);
        if (object2 != null) {
            trace.record(BindingContext.CONSTRUCTOR, object2, constructorDescriptor);
        }
        ConstructorDescriptorImpl constructorDescriptorImpl = constructorDescriptor;
        if (constructorDescriptorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "createAndRecordPrimaryConstructorForObject"));
        }
        return constructorDescriptorImpl;
    }

    public void resolveGenericBounds(@NotNull JetTypeParameterListOwner declaration, JetScope scope, List<TypeParameterDescriptorImpl> parameters, BindingTrace trace) {
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "resolveGenericBounds"));
        }
        ArrayList<UpperBoundCheckerTask> deferredUpperBoundCheckerTasks = Lists.newArrayList();
        List<JetTypeParameter> typeParameters = declaration.getTypeParameters();
        HashMap<Name, TypeParameterDescriptorImpl> parameterByName = Maps.newHashMap();
        for (int i = 0; i < typeParameters.size(); ++i) {
            JetTypeParameter jetTypeParameter = typeParameters.get(i);
            TypeParameterDescriptorImpl typeParameterDescriptor = parameters.get(i);
            parameterByName.put(typeParameterDescriptor.getName(), typeParameterDescriptor);
            JetTypeReference extendsBound = jetTypeParameter.getExtendsBound();
            if (extendsBound == null) continue;
            JetType type = this.typeResolver.resolveType(scope, extendsBound, trace, false);
            typeParameterDescriptor.addUpperBound(type);
            deferredUpperBoundCheckerTasks.add(new UpperBoundCheckerTask(extendsBound, type, false));
        }
        for (JetTypeConstraint constraint : declaration.getTypeConstraints()) {
            JetSimpleNameExpression subjectTypeParameterName;
            if (constraint.isClassObjectContraint()) {
                trace.report(Errors.UNSUPPORTED.on(constraint, "Class objects constraints are not supported yet"));
            }
            if ((subjectTypeParameterName = constraint.getSubjectTypeParameterName()) == null) continue;
            Name referencedName = subjectTypeParameterName.getReferencedNameAsName();
            TypeParameterDescriptorImpl typeParameterDescriptor = (TypeParameterDescriptorImpl)parameterByName.get(referencedName);
            JetTypeReference boundTypeReference = constraint.getBoundTypeReference();
            JetType bound = null;
            if (boundTypeReference != null) {
                bound = this.typeResolver.resolveType(scope, boundTypeReference, trace, false);
                deferredUpperBoundCheckerTasks.add(new UpperBoundCheckerTask(boundTypeReference, bound, constraint.isClassObjectContraint()));
            }
            if (typeParameterDescriptor == null) {
                ClassifierDescriptor classifier = scope.getClassifier(referencedName);
                if (classifier != null) {
                    trace.report(Errors.NAME_IN_CONSTRAINT_IS_NOT_A_TYPE_PARAMETER.on(subjectTypeParameterName, constraint, declaration));
                    trace.record(BindingContext.REFERENCE_TARGET, subjectTypeParameterName, classifier);
                    continue;
                }
                trace.report(Errors.UNRESOLVED_REFERENCE.on(subjectTypeParameterName, subjectTypeParameterName));
                continue;
            }
            trace.record(BindingContext.REFERENCE_TARGET, subjectTypeParameterName, typeParameterDescriptor);
            if (bound == null) continue;
            if (constraint.isClassObjectContraint()) {
                typeParameterDescriptor.addClassObjectBound(bound);
                continue;
            }
            typeParameterDescriptor.addUpperBound(bound);
        }
        for (TypeParameterDescriptorImpl parameter : parameters) {
            PsiElement nameIdentifier;
            JetType classObjectType;
            PsiElement nameIdentifier2;
            parameter.addDefaultUpperBound();
            parameter.setInitialized();
            if (KotlinBuiltIns.getInstance().isNothing(parameter.getUpperBoundsAsType()) && (nameIdentifier2 = typeParameters.get(parameter.getIndex()).getNameIdentifier()) != null) {
                trace.report(Errors.CONFLICTING_UPPER_BOUNDS.on(nameIdentifier2, parameter));
            }
            if ((classObjectType = parameter.getClassObjectType()) == null || !KotlinBuiltIns.getInstance().isNothing(classObjectType) || (nameIdentifier = typeParameters.get(parameter.getIndex()).getNameIdentifier()) == null) continue;
            trace.report(Errors.CONFLICTING_CLASS_OBJECT_UPPER_BOUNDS.on(nameIdentifier, parameter));
        }
        for (UpperBoundCheckerTask checkerTask : deferredUpperBoundCheckerTasks) {
            DescriptorResolver.checkUpperBoundType(checkerTask.upperBound, checkerTask.upperBoundType, checkerTask.isClassObjectConstraint, trace);
        }
    }

    private static void checkUpperBoundType(JetTypeReference upperBound, JetType upperBoundType, boolean isClassObjectConstraint, BindingTrace trace) {
        if (!TypeUtils.canHaveSubtypes(JetTypeChecker.INSTANCE, upperBoundType)) {
            if (isClassObjectConstraint) {
                trace.report(Errors.FINAL_CLASS_OBJECT_UPPER_BOUND.on(upperBound, upperBoundType));
            } else {
                trace.report(Errors.FINAL_UPPER_BOUND.on(upperBound, upperBoundType));
            }
        }
    }

    @NotNull
    public VariableDescriptor resolveLocalVariableDescriptor(@NotNull JetScope scope, @NotNull JetParameter parameter, BindingTrace trace) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "resolveLocalVariableDescriptor"));
        }
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "resolveLocalVariableDescriptor"));
        }
        JetType type = this.resolveParameterType(scope, parameter, trace);
        VariableDescriptor variableDescriptor = this.resolveLocalVariableDescriptor(parameter, type, trace, scope);
        if (variableDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "resolveLocalVariableDescriptor"));
        }
        return variableDescriptor;
    }

    private JetType resolveParameterType(JetScope scope, JetParameter parameter, BindingTrace trace) {
        JetTypeReference typeReference = parameter.getTypeReference();
        JetType type = typeReference != null ? this.typeResolver.resolveType(scope, typeReference, trace, true) : ErrorUtils.createErrorType("Annotation is absent");
        if (parameter.hasModifier(JetTokens.VARARG_KEYWORD)) {
            return DescriptorUtils.getVarargParameterType(type);
        }
        return type;
    }

    public VariableDescriptor resolveLocalVariableDescriptor(@NotNull JetParameter parameter, @NotNull JetType type, BindingTrace trace, @NotNull JetScope scope) {
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "resolveLocalVariableDescriptor"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "resolveLocalVariableDescriptor"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "resolveLocalVariableDescriptor"));
        }
        LocalVariableDescriptor variableDescriptor = new LocalVariableDescriptor(scope.getContainingDeclaration(), this.annotationResolver.resolveAnnotationsWithArguments(scope, parameter.getModifierList(), trace), JetPsiUtil.safeName(parameter.getName()), type, false);
        trace.record(BindingContext.VALUE_PARAMETER, parameter, variableDescriptor);
        return variableDescriptor;
    }

    @NotNull
    public VariableDescriptor resolveLocalVariableDescriptor(JetScope scope, JetVariableDeclaration variable, DataFlowInfo dataFlowInfo, BindingTrace trace) {
        DeclarationDescriptor containingDeclaration = scope.getContainingDeclaration();
        if (JetPsiUtil.isScriptDeclaration(variable)) {
            PropertyDescriptorImpl propertyDescriptor = new PropertyDescriptorImpl(containingDeclaration, this.annotationResolver.resolveAnnotationsWithArguments(scope, variable.getModifierList(), trace), Modality.FINAL, Visibilities.INTERNAL, variable.isVar(), JetPsiUtil.safeName(variable.getName()), CallableMemberDescriptor.Kind.DECLARATION);
            JetType type = this.getVariableType(propertyDescriptor, scope, variable, dataFlowInfo, false, trace);
            ReceiverParameterDescriptor receiverParameter = ((ScriptDescriptor)containingDeclaration).getThisAsReceiverParameter();
            propertyDescriptor.setType(type, Collections.emptyList(), receiverParameter, (JetType)null);
            trace.record(BindingContext.VARIABLE, variable, propertyDescriptor);
            PropertyDescriptorImpl propertyDescriptorImpl = propertyDescriptor;
            if (propertyDescriptorImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "resolveLocalVariableDescriptor"));
            }
            return propertyDescriptorImpl;
        }
        VariableDescriptorImpl variableDescriptor = this.resolveLocalVariableDescriptorWithType(scope, variable, null, trace);
        JetType type = this.getVariableType(variableDescriptor, scope, variable, dataFlowInfo, false, trace);
        variableDescriptor.setOutType(type);
        VariableDescriptorImpl variableDescriptorImpl = variableDescriptor;
        if (variableDescriptorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "resolveLocalVariableDescriptor"));
        }
        return variableDescriptorImpl;
    }

    @NotNull
    public VariableDescriptorImpl resolveLocalVariableDescriptorWithType(@NotNull JetScope scope, @NotNull JetVariableDeclaration variable, @Nullable JetType type, @NotNull BindingTrace trace) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "resolveLocalVariableDescriptorWithType"));
        }
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "resolveLocalVariableDescriptorWithType"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "resolveLocalVariableDescriptorWithType"));
        }
        LocalVariableDescriptor variableDescriptor = new LocalVariableDescriptor(scope.getContainingDeclaration(), this.annotationResolver.resolveAnnotationsWithArguments(scope, variable.getModifierList(), trace), JetPsiUtil.safeName(variable.getName()), type, variable.isVar());
        trace.record(BindingContext.VARIABLE, variable, variableDescriptor);
        LocalVariableDescriptor localVariableDescriptor = variableDescriptor;
        if (localVariableDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "resolveLocalVariableDescriptorWithType"));
        }
        return localVariableDescriptor;
    }

    @NotNull
    public PropertyDescriptor resolvePropertyDescriptor(@NotNull DeclarationDescriptor containingDeclaration, @NotNull JetScope scope, @NotNull JetProperty property2, @NotNull BindingTrace trace, @NotNull DataFlowInfo dataFlowInfo) {
        List<TypeParameterDescriptorImpl> typeParameterDescriptors;
        JetScope scopeWithTypeParameters;
        if (containingDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingDeclaration", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "resolvePropertyDescriptor"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "resolvePropertyDescriptor"));
        }
        if (property2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "resolvePropertyDescriptor"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "resolvePropertyDescriptor"));
        }
        if (dataFlowInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataFlowInfo", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "resolvePropertyDescriptor"));
        }
        JetModifierList modifierList = property2.getModifierList();
        boolean isVar = property2.isVar();
        boolean hasBody = DescriptorResolver.hasBody(property2);
        Modality modality = containingDeclaration instanceof ClassDescriptor ? ModifiersChecker.resolveModalityFromModifiers(property2, DescriptorResolver.getDefaultModality(containingDeclaration, hasBody)) : Modality.FINAL;
        Visibility visibility = ModifiersChecker.resolveVisibilityFromModifiers(property2, DescriptorResolver.getDefaultVisibility(property2, containingDeclaration));
        PropertyDescriptorImpl propertyDescriptor = new PropertyDescriptorImpl(containingDeclaration, this.annotationResolver.resolveAnnotationsWithoutArguments(scope, modifierList, trace), modality, visibility, isVar, JetPsiUtil.safeName(property2.getName()), CallableMemberDescriptor.Kind.DECLARATION);
        JetType receiverType = null;
        List typeParameters = property2.getTypeParameters();
        if (typeParameters.isEmpty()) {
            scopeWithTypeParameters = scope;
            typeParameterDescriptors = Collections.emptyList();
        } else {
            WritableScopeImpl writableScope = new WritableScopeImpl(scope, containingDeclaration, new TraceBasedRedeclarationHandler(trace), "Scope with type parameters of a property");
            typeParameterDescriptors = this.resolveTypeParametersForCallableDescriptor(containingDeclaration, writableScope, typeParameters, trace);
            writableScope.changeLockLevel(WritableScope.LockLevel.READING);
            this.resolveGenericBounds(property2, writableScope, typeParameterDescriptors, trace);
            scopeWithTypeParameters = writableScope;
        }
        JetTypeReference receiverTypeRef = property2.getReceiverTypeRef();
        if (receiverTypeRef != null) {
            receiverType = this.typeResolver.resolveType(scopeWithTypeParameters, receiverTypeRef, trace, true);
        }
        ReceiverParameterDescriptor receiverDescriptor = DescriptorFactory.createReceiverParameterForCallable(propertyDescriptor, receiverType);
        JetScope propertyScope = JetScopeUtils.getPropertyDeclarationInnerScope(propertyDescriptor, scope, typeParameterDescriptors, ReceiverParameterDescriptor.NO_RECEIVER_PARAMETER, trace);
        JetType type = this.getVariableType(propertyDescriptor, propertyScope, property2, dataFlowInfo, true, trace);
        propertyDescriptor.setType(type, typeParameterDescriptors, DescriptorUtils.getExpectedThisObjectIfNeeded(containingDeclaration), receiverDescriptor);
        PropertyGetterDescriptorImpl getter = this.resolvePropertyGetterDescriptor(scopeWithTypeParameters, property2, propertyDescriptor, trace);
        PropertySetterDescriptor setter = this.resolvePropertySetterDescriptor(scopeWithTypeParameters, property2, propertyDescriptor, trace);
        propertyDescriptor.initialize(getter, setter);
        trace.record(BindingContext.VARIABLE, property2, propertyDescriptor);
        PropertyDescriptorImpl propertyDescriptorImpl = propertyDescriptor;
        if (propertyDescriptorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "resolvePropertyDescriptor"));
        }
        return propertyDescriptorImpl;
    }

    static boolean hasBody(JetProperty property2) {
        boolean hasBody;
        boolean bl = hasBody = property2.getDelegateExpressionOrInitializer() != null;
        if (!hasBody) {
            JetPropertyAccessor getter = property2.getGetter();
            if (getter != null && getter.getBodyExpression() != null) {
                hasBody = true;
            }
            JetPropertyAccessor setter = property2.getSetter();
            if (!hasBody && setter != null && setter.getBodyExpression() != null) {
                hasBody = true;
            }
        }
        return hasBody;
    }

    @NotNull
    private JetType getVariableType(final @NotNull VariableDescriptor variableDescriptor, final @NotNull JetScope scope, final @NotNull JetVariableDeclaration variable, final @NotNull DataFlowInfo dataFlowInfo, boolean notLocal, final @NotNull BindingTrace trace) {
        boolean hasDelegate;
        if (variableDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variableDescriptor", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "getVariableType"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "getVariableType"));
        }
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "getVariableType"));
        }
        if (dataFlowInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataFlowInfo", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "getVariableType"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "getVariableType"));
        }
        JetTypeReference propertyTypeRef = variable.getTypeRef();
        boolean bl = hasDelegate = variable instanceof JetProperty && ((JetProperty)variable).getDelegateExpression() != null;
        if (propertyTypeRef == null) {
            final JetExpression initializer = variable.getInitializer();
            if (initializer == null) {
                JetProperty property2;
                JetExpression propertyDelegateExpression;
                if (hasDelegate && variableDescriptor instanceof PropertyDescriptor && (propertyDelegateExpression = (property2 = (JetProperty)variable).getDelegateExpression()) != null) {
                    DeferredType deferredType = DeferredType.create(trace, StorageUtil.createRecursionIntolerantLazyValueWithDefault(ErrorUtils.createErrorType("Recursive dependency"), new Function0<JetType>(){

                        @Override
                        public JetType invoke() {
                            return DescriptorResolver.this.resolveDelegatedPropertyType(property2, (PropertyDescriptor)variableDescriptor, scope, propertyDelegateExpression, dataFlowInfo, trace);
                        }
                    }));
                    if (deferredType == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "getVariableType"));
                    }
                    return deferredType;
                }
                if (!notLocal) {
                    trace.report(Errors.VARIABLE_WITH_NO_TYPE_NO_INITIALIZER.on(variable));
                }
                JetType jetType = ErrorUtils.createErrorType("No type, no body");
                if (jetType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "getVariableType"));
                }
                return jetType;
            }
            if (notLocal) {
                DeferredType deferredType = DeferredType.create(trace, StorageUtil.createRecursionIntolerantLazyValueWithDefault(ErrorUtils.createErrorType("Recursive dependency"), new Function0<JetType>(){

                    @Override
                    public JetType invoke() {
                        JetType type = DescriptorResolver.this.resolveInitializerType(scope, initializer, dataFlowInfo, trace);
                        return DescriptorResolver.transformAnonymousTypeIfNeeded(variableDescriptor, variable, type, trace);
                    }
                }));
                if (deferredType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "getVariableType"));
                }
                return deferredType;
            }
            JetType jetType = this.resolveInitializerType(scope, initializer, dataFlowInfo, trace);
            if (jetType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "getVariableType"));
            }
            return jetType;
        }
        JetType jetType = this.typeResolver.resolveType(scope, propertyTypeRef, trace, true);
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "getVariableType"));
        }
        return jetType;
    }

    @NotNull
    private JetType resolveDelegatedPropertyType(@NotNull JetProperty property2, @NotNull PropertyDescriptor propertyDescriptor, @NotNull JetScope scope, @NotNull JetExpression delegateExpression, @NotNull DataFlowInfo dataFlowInfo, @NotNull BindingTrace trace) {
        JetType getterReturnType;
        if (property2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "resolveDelegatedPropertyType"));
        }
        if (propertyDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyDescriptor", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "resolveDelegatedPropertyType"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "resolveDelegatedPropertyType"));
        }
        if (delegateExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegateExpression", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "resolveDelegatedPropertyType"));
        }
        if (dataFlowInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataFlowInfo", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "resolveDelegatedPropertyType"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "resolveDelegatedPropertyType"));
        }
        JetScope accessorScope = JetScopeUtils.makeScopeForPropertyAccessor(propertyDescriptor, scope, trace);
        JetType type = this.delegatedPropertyResolver.resolveDelegateExpression(delegateExpression, property2, propertyDescriptor, scope, accessorScope, trace, dataFlowInfo);
        if (type != null && (getterReturnType = this.delegatedPropertyResolver.getDelegatedPropertyGetMethodReturnType(propertyDescriptor, delegateExpression, type, trace, accessorScope)) != null) {
            JetType jetType = getterReturnType;
            if (jetType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "resolveDelegatedPropertyType"));
            }
            return jetType;
        }
        JetType jetType = ErrorUtils.createErrorType("Type from delegate");
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "resolveDelegatedPropertyType"));
        }
        return jetType;
    }

    @Nullable
    private static JetType transformAnonymousTypeIfNeeded(@NotNull DeclarationDescriptorWithVisibility descriptor, @NotNull JetNamedDeclaration declaration, @NotNull JetType type, @NotNull BindingTrace trace) {
        boolean transformNeeded;
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "transformAnonymousTypeIfNeeded"));
        }
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "transformAnonymousTypeIfNeeded"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "transformAnonymousTypeIfNeeded"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "transformAnonymousTypeIfNeeded"));
        }
        ClassifierDescriptor classifierDescriptor = type.getConstructor().getDeclarationDescriptor();
        if (classifierDescriptor == null || !DescriptorUtils.isAnonymousObject(classifierDescriptor)) {
            return type;
        }
        boolean definedInClass = DescriptorUtils.getParentOfType(descriptor, ClassDescriptor.class) != null;
        boolean isLocal = descriptor.getContainingDeclaration() instanceof CallableDescriptor;
        Visibility visibility = descriptor.getVisibility();
        boolean bl = transformNeeded = !isLocal && !visibility.isPublicAPI() && (!definedInClass || !Visibilities.PRIVATE.equals(visibility));
        if (transformNeeded) {
            if (type.getConstructor().getSupertypes().size() == 1) {
                assert (type.getArguments().isEmpty()) : "Object expression couldn't have any type parameters!";
                return type.getConstructor().getSupertypes().iterator().next();
            }
            trace.report(Errors.AMBIGUOUS_ANONYMOUS_TYPE_INFERRED.on(declaration, type.getConstructor().getSupertypes()));
        }
        return type;
    }

    @NotNull
    private JetType resolveInitializerType(@NotNull JetScope scope, @NotNull JetExpression initializer, @NotNull DataFlowInfo dataFlowInfo, @NotNull BindingTrace trace) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "resolveInitializerType"));
        }
        if (initializer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initializer", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "resolveInitializerType"));
        }
        if (dataFlowInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataFlowInfo", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "resolveInitializerType"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "resolveInitializerType"));
        }
        JetType jetType = this.expressionTypingServices.safeGetType(scope, initializer, TypeUtils.NO_EXPECTED_TYPE, dataFlowInfo, trace);
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "resolveInitializerType"));
        }
        return jetType;
    }

    @Nullable
    private PropertySetterDescriptor resolvePropertySetterDescriptor(@NotNull JetScope scope, @NotNull JetProperty property2, @NotNull PropertyDescriptor propertyDescriptor, BindingTrace trace) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "resolvePropertySetterDescriptor"));
        }
        if (property2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "resolvePropertySetterDescriptor"));
        }
        if (propertyDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyDescriptor", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "resolvePropertySetterDescriptor"));
        }
        JetPropertyAccessor setter = property2.getSetter();
        PropertySetterDescriptorImpl setterDescriptor = null;
        if (setter != null) {
            List<AnnotationDescriptor> annotations = this.annotationResolver.resolveAnnotationsWithoutArguments(scope, setter.getModifierList(), trace);
            JetParameter parameter = setter.getParameter();
            setterDescriptor = new PropertySetterDescriptorImpl(propertyDescriptor, annotations, ModifiersChecker.resolveModalityFromModifiers(setter, propertyDescriptor.getModality()), ModifiersChecker.resolveVisibilityFromModifiers(setter, propertyDescriptor.getVisibility()), setter.getBodyExpression() != null, false, CallableMemberDescriptor.Kind.DECLARATION);
            if (parameter != null) {
                JetType type;
                JetTypeReference typeReference;
                JetExpression defaultValue = parameter.getDefaultValue();
                if (defaultValue != null) {
                    trace.report(Errors.SETTER_PARAMETER_WITH_DEFAULT_VALUE.on(defaultValue));
                }
                if ((typeReference = parameter.getTypeReference()) == null) {
                    type = propertyDescriptor.getType();
                } else {
                    type = this.typeResolver.resolveType(scope, typeReference, trace, true);
                    JetType inType = propertyDescriptor.getType();
                    if (inType != null && !TypeUtils.equalTypes(type, inType)) {
                        trace.report(Errors.WRONG_SETTER_PARAMETER_TYPE.on(typeReference, inType, type));
                    }
                }
                ValueParameterDescriptorImpl valueParameterDescriptor = this.resolveValueParameterDescriptor(scope, setterDescriptor, parameter, 0, type, trace);
                setterDescriptor.initialize(valueParameterDescriptor);
            } else {
                setterDescriptor.initializeDefault();
            }
            trace.record(BindingContext.PROPERTY_ACCESSOR, setter, setterDescriptor);
        } else if (property2.isVar()) {
            setterDescriptor = DescriptorFactory.createSetter(propertyDescriptor, property2.getDelegateExpression() == null);
        }
        if (!property2.isVar() && setter != null) {
            trace.report(Errors.VAL_WITH_SETTER.on(setter));
        }
        return setterDescriptor;
    }

    @Nullable
    private PropertyGetterDescriptorImpl resolvePropertyGetterDescriptor(@NotNull JetScope scope, @NotNull JetProperty property2, @NotNull PropertyDescriptor propertyDescriptor, BindingTrace trace) {
        PropertyGetterDescriptorImpl getterDescriptor;
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "resolvePropertyGetterDescriptor"));
        }
        if (property2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "resolvePropertyGetterDescriptor"));
        }
        if (propertyDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyDescriptor", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "resolvePropertyGetterDescriptor"));
        }
        JetPropertyAccessor getter = property2.getGetter();
        if (getter != null) {
            JetType outType;
            List<AnnotationDescriptor> annotations = this.annotationResolver.resolveAnnotationsWithoutArguments(scope, getter.getModifierList(), trace);
            JetType returnType = outType = propertyDescriptor.getType();
            JetTypeReference returnTypeReference = getter.getReturnTypeReference();
            if (returnTypeReference != null) {
                returnType = this.typeResolver.resolveType(scope, returnTypeReference, trace, true);
                if (outType != null && !TypeUtils.equalTypes(returnType, outType)) {
                    trace.report(Errors.WRONG_GETTER_RETURN_TYPE.on(returnTypeReference, propertyDescriptor.getReturnType(), outType));
                }
            }
            getterDescriptor = new PropertyGetterDescriptorImpl(propertyDescriptor, annotations, ModifiersChecker.resolveModalityFromModifiers(getter, propertyDescriptor.getModality()), ModifiersChecker.resolveVisibilityFromModifiers(getter, propertyDescriptor.getVisibility()), getter.getBodyExpression() != null, false, CallableMemberDescriptor.Kind.DECLARATION);
            getterDescriptor.initialize(returnType);
            trace.record(BindingContext.PROPERTY_ACCESSOR, getter, getterDescriptor);
        } else {
            getterDescriptor = DescriptorFactory.createGetter(propertyDescriptor, property2.getDelegateExpression() == null);
            getterDescriptor.initialize(propertyDescriptor.getType());
        }
        return getterDescriptor;
    }

    @NotNull
    private ConstructorDescriptorImpl createConstructorDescriptor(@NotNull JetScope scope, @NotNull ClassDescriptor classDescriptor, boolean isPrimary, @Nullable JetModifierList modifierList, @NotNull JetDeclaration declarationToTrace, List<TypeParameterDescriptor> typeParameters, @NotNull List<JetParameter> valueParameters, BindingTrace trace) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "createConstructorDescriptor"));
        }
        if (classDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "createConstructorDescriptor"));
        }
        if (declarationToTrace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declarationToTrace", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "createConstructorDescriptor"));
        }
        if (valueParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueParameters", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "createConstructorDescriptor"));
        }
        ConstructorDescriptorImpl constructorDescriptor = new ConstructorDescriptorImpl(classDescriptor, this.annotationResolver.resolveAnnotationsWithoutArguments(scope, modifierList, trace), isPrimary);
        trace.record(BindingContext.CONSTRUCTOR, declarationToTrace, constructorDescriptor);
        WritableScopeImpl parameterScope = new WritableScopeImpl(scope, constructorDescriptor, new TraceBasedRedeclarationHandler(trace), "Scope with value parameters of a constructor");
        parameterScope.changeLockLevel(WritableScope.LockLevel.BOTH);
        ConstructorDescriptorImpl constructor = constructorDescriptor.initialize(typeParameters, this.resolveValueParameters(constructorDescriptor, parameterScope, valueParameters, trace), ModifiersChecker.resolveVisibilityFromModifiers(modifierList, DescriptorUtils.getDefaultConstructorVisibility(classDescriptor)), DescriptorUtils.isConstructorOfStaticNestedClass(constructorDescriptor));
        if (DescriptorUtils.isAnnotationClass(classDescriptor)) {
            AnnotationUtils.checkConstructorParametersType(valueParameters, trace);
        }
        ConstructorDescriptorImpl constructorDescriptorImpl = constructor;
        if (constructorDescriptorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "createConstructorDescriptor"));
        }
        return constructorDescriptorImpl;
    }

    @Nullable
    public ConstructorDescriptorImpl resolvePrimaryConstructorDescriptor(@NotNull JetScope scope, @NotNull ClassDescriptor classDescriptor, @NotNull JetClass classElement, BindingTrace trace) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "resolvePrimaryConstructorDescriptor"));
        }
        if (classDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "resolvePrimaryConstructorDescriptor"));
        }
        if (classElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classElement", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "resolvePrimaryConstructorDescriptor"));
        }
        if (classDescriptor.getKind() == ClassKind.ENUM_ENTRY) {
            return null;
        }
        return this.createConstructorDescriptor(scope, classDescriptor, true, classElement.getPrimaryConstructorModifierList(), classElement, classDescriptor.getTypeConstructor().getParameters(), classElement.getPrimaryConstructorParameters(), trace);
    }

    @NotNull
    public PropertyDescriptor resolvePrimaryConstructorParameterToAProperty(@NotNull ClassDescriptor classDescriptor, @NotNull ValueParameterDescriptor valueParameter, @NotNull JetScope scope, @NotNull JetParameter parameter, BindingTrace trace) {
        ASTNode abstractNode;
        if (classDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "resolvePrimaryConstructorParameterToAProperty"));
        }
        if (valueParameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueParameter", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "resolvePrimaryConstructorParameterToAProperty"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "resolvePrimaryConstructorParameterToAProperty"));
        }
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "resolvePrimaryConstructorParameterToAProperty"));
        }
        JetType type = this.resolveParameterType(scope, parameter, trace);
        Name name = parameter.getNameAsSafeName();
        boolean isMutable = parameter.isMutable();
        JetModifierList modifierList = parameter.getModifierList();
        if (modifierList != null && (abstractNode = modifierList.getModifierNode(JetTokens.ABSTRACT_KEYWORD)) != null) {
            trace.report(Errors.ABSTRACT_PROPERTY_IN_PRIMARY_CONSTRUCTOR_PARAMETERS.on(parameter));
        }
        PropertyDescriptorImpl propertyDescriptor = new PropertyDescriptorImpl(classDescriptor, valueParameter.getAnnotations(), ModifiersChecker.resolveModalityFromModifiers(parameter, Modality.FINAL), ModifiersChecker.resolveVisibilityFromModifiers(parameter, Visibilities.INTERNAL), isMutable, name, CallableMemberDescriptor.Kind.DECLARATION);
        propertyDescriptor.setType(type, Collections.emptyList(), DescriptorUtils.getExpectedThisObjectIfNeeded(classDescriptor), ReceiverParameterDescriptor.NO_RECEIVER_PARAMETER);
        PropertyGetterDescriptorImpl getter = DescriptorFactory.createDefaultGetter(propertyDescriptor);
        PropertySetterDescriptorImpl setter = propertyDescriptor.isVar() ? DescriptorFactory.createDefaultSetter(propertyDescriptor) : null;
        propertyDescriptor.initialize(getter, setter);
        getter.initialize(propertyDescriptor.getType());
        trace.record(BindingContext.PRIMARY_CONSTRUCTOR_PARAMETER, parameter, propertyDescriptor);
        trace.record(BindingContext.VALUE_PARAMETER_AS_PROPERTY, valueParameter, propertyDescriptor);
        PropertyDescriptorImpl propertyDescriptorImpl = propertyDescriptor;
        if (propertyDescriptorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "resolvePrimaryConstructorParameterToAProperty"));
        }
        return propertyDescriptorImpl;
    }

    public static void checkBounds(@NotNull JetTypeReference typeReference, @NotNull JetType type, BindingTrace trace) {
        if (typeReference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeReference", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "checkBounds"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "checkBounds"));
        }
        if (type.isError()) {
            return;
        }
        JetTypeElement typeElement = typeReference.getTypeElement();
        if (typeElement == null) {
            return;
        }
        List<TypeParameterDescriptor> parameters = type.getConstructor().getParameters();
        List<TypeProjection> arguments2 = type.getArguments();
        assert (parameters.size() == arguments2.size());
        List<JetTypeReference> jetTypeArguments = typeElement.getTypeArgumentsAsTypes();
        assert (jetTypeArguments.size() == arguments2.size()) : typeElement.getText();
        TypeSubstitutor substitutor = TypeSubstitutor.create(type);
        for (int i = 0; i < jetTypeArguments.size(); ++i) {
            JetTypeReference jetTypeArgument = jetTypeArguments.get(i);
            if (jetTypeArgument == null) continue;
            JetType typeArgument = arguments2.get(i).getType();
            DescriptorResolver.checkBounds(jetTypeArgument, typeArgument, trace);
            TypeParameterDescriptor typeParameterDescriptor = parameters.get(i);
            DescriptorResolver.checkBounds(jetTypeArgument, typeArgument, typeParameterDescriptor, substitutor, trace);
        }
    }

    public static void checkBounds(@NotNull JetTypeReference jetTypeArgument, @NotNull JetType typeArgument, @NotNull TypeParameterDescriptor typeParameterDescriptor, @NotNull TypeSubstitutor substitutor, BindingTrace trace) {
        if (jetTypeArgument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jetTypeArgument", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "checkBounds"));
        }
        if (typeArgument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeArgument", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "checkBounds"));
        }
        if (typeParameterDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameterDescriptor", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "checkBounds"));
        }
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "checkBounds"));
        }
        for (JetType bound : typeParameterDescriptor.getUpperBounds()) {
            JetType substitutedBound = substitutor.safeSubstitute(bound, Variance.INVARIANT);
            if (JetTypeChecker.INSTANCE.isSubtypeOf(typeArgument, substitutedBound)) continue;
            trace.report(Errors.UPPER_BOUND_VIOLATED.on(jetTypeArgument, substitutedBound, typeArgument));
        }
    }

    @NotNull
    public static SimpleFunctionDescriptor createEnumClassObjectValuesMethod(@NotNull ClassDescriptor classObject, @NotNull BindingTrace trace) {
        if (classObject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classObject", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "createEnumClassObjectValuesMethod"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "createEnumClassObjectValuesMethod"));
        }
        final ClassDescriptor enumClassDescriptor = (ClassDescriptor)classObject.getContainingDeclaration();
        assert (DescriptorUtils.isEnumClass(enumClassDescriptor)) : "values should be created in enum class: " + enumClassDescriptor;
        SimpleFunctionDescriptor simpleFunctionDescriptor = DescriptorFactory.createEnumClassObjectValuesMethod(classObject, DeferredType.create(trace, new Function0<JetType>(){

            @Override
            public JetType invoke() {
                return KotlinBuiltIns.getInstance().getArrayType(enumClassDescriptor.getDefaultType());
            }
        }));
        if (simpleFunctionDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "createEnumClassObjectValuesMethod"));
        }
        return simpleFunctionDescriptor;
    }

    @NotNull
    public static SimpleFunctionDescriptor createEnumClassObjectValueOfMethod(@NotNull ClassDescriptor classObject, @NotNull BindingTrace trace) {
        if (classObject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classObject", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "createEnumClassObjectValueOfMethod"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "createEnumClassObjectValueOfMethod"));
        }
        final ClassDescriptor enumClassDescriptor = (ClassDescriptor)classObject.getContainingDeclaration();
        assert (DescriptorUtils.isEnumClass(enumClassDescriptor)) : "valueOf should be created in enum class: " + enumClassDescriptor;
        SimpleFunctionDescriptor simpleFunctionDescriptor = DescriptorFactory.createEnumClassObjectValueOfMethod(classObject, DeferredType.create(trace, new Function0<JetType>(){

            @Override
            public JetType invoke() {
                return enumClassDescriptor.getDefaultType();
            }
        }));
        if (simpleFunctionDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "createEnumClassObjectValueOfMethod"));
        }
        return simpleFunctionDescriptor;
    }

    public static boolean checkHasOuterClassInstance(@NotNull JetScope scope, @NotNull BindingTrace trace, @NotNull PsiElement reportErrorsOn, @NotNull ClassDescriptor target) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "checkHasOuterClassInstance"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "checkHasOuterClassInstance"));
        }
        if (reportErrorsOn == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reportErrorsOn", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "checkHasOuterClassInstance"));
        }
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "checkHasOuterClassInstance"));
        }
        return DescriptorResolver.checkHasOuterClassInstance(scope, trace, reportErrorsOn, target, true);
    }

    public static boolean checkHasOuterClassInstance(@NotNull JetScope scope, @NotNull BindingTrace trace, @NotNull PsiElement reportErrorsOn, @NotNull ClassDescriptor target, boolean doSuperClassCheck) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "checkHasOuterClassInstance"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "checkHasOuterClassInstance"));
        }
        if (reportErrorsOn == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reportErrorsOn", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "checkHasOuterClassInstance"));
        }
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "checkHasOuterClassInstance"));
        }
        for (DeclarationDescriptor descriptor = DescriptorUtils.getContainingClass(scope); descriptor != null; descriptor = descriptor.getContainingDeclaration()) {
            if (!(descriptor instanceof ClassDescriptor)) continue;
            ClassDescriptor classDescriptor = descriptor;
            if (classDescriptor == target) {
                return true;
            }
            if (doSuperClassCheck && DescriptorUtils.isSubclass(classDescriptor, target)) {
                return true;
            }
            if (!DescriptorUtils.isStaticNestedClass(classDescriptor)) continue;
            trace.report(Errors.INACCESSIBLE_OUTER_CLASS_EXPRESSION.on(reportErrorsOn, classDescriptor));
            return false;
        }
        return true;
    }

    public static void checkParameterHasNoValOrVar(@NotNull BindingTrace trace, @NotNull JetParameter parameter, @NotNull DiagnosticFactory1<PsiElement, JetKeywordToken> diagnosticFactory) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "checkParameterHasNoValOrVar"));
        }
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "checkParameterHasNoValOrVar"));
        }
        if (diagnosticFactory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diagnosticFactory", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "checkParameterHasNoValOrVar"));
        }
        ASTNode valOrVarNode = parameter.getValOrVarNode();
        if (valOrVarNode != null) {
            trace.report(diagnosticFactory.on(valOrVarNode.getPsi(), (JetKeywordToken)valOrVarNode.getElementType()));
        }
    }

    private static void checkConstructorParameterHasNoModifier(@NotNull BindingTrace trace, @NotNull JetParameter parameter) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "checkConstructorParameterHasNoModifier"));
        }
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "checkConstructorParameterHasNoModifier"));
        }
        if (parameter.getValOrVarNode() == null) {
            DescriptorResolver.checkParameterHasNoModifier(trace, parameter);
        }
    }

    public static void checkParameterHasNoModifier(@NotNull BindingTrace trace, @NotNull JetParameter parameter) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "checkParameterHasNoModifier"));
        }
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "org/jetbrains/jet/lang/resolve/DescriptorResolver", "checkParameterHasNoModifier"));
        }
        JetModifierList modifiers = parameter.getModifierList();
        if (modifiers != null) {
            for (ASTNode node = modifiers.getNode().getFirstChildNode(); node != null; node = node.getTreeNext()) {
                IElementType elementType = node.getElementType();
                if (elementType == JetTokens.VARARG_KEYWORD || !(elementType instanceof JetKeywordToken)) continue;
                trace.report(Errors.ILLEGAL_MODIFIER.on(node.getPsi(), (JetKeywordToken)elementType));
            }
        }
    }

    static final class UpperBoundCheckerTask {
        JetTypeReference upperBound;
        JetType upperBoundType;
        boolean isClassObjectConstraint;

        private UpperBoundCheckerTask(JetTypeReference upperBound, JetType upperBoundType, boolean classObjectConstraint) {
            this.upperBound = upperBound;
            this.upperBoundType = upperBoundType;
            this.isClassObjectConstraint = classObjectConstraint;
        }
    }
}

