/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.psi;

import com.intellij.extapi.psi.PsiFileBase;
import com.intellij.lang.ASTNode;
import com.intellij.lang.FileASTNode;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.JetNodeTypes;
import org.jetbrains.jet.lang.psi.JetDeclaration;
import org.jetbrains.jet.lang.psi.JetDeclarationContainer;
import org.jetbrains.jet.lang.psi.JetElement;
import org.jetbrains.jet.lang.psi.JetImportDirective;
import org.jetbrains.jet.lang.psi.JetImportList;
import org.jetbrains.jet.lang.psi.JetNamespaceHeader;
import org.jetbrains.jet.lang.psi.JetPsiUtil;
import org.jetbrains.jet.lang.psi.JetScript;
import org.jetbrains.jet.lang.psi.JetTreeVisitor;
import org.jetbrains.jet.lang.psi.JetVisitor;
import org.jetbrains.jet.lang.psi.JetVisitorVoid;
import org.jetbrains.jet.lang.psi.stubs.PsiJetFileStub;
import org.jetbrains.jet.plugin.JetFileType;
import org.jetbrains.jet.plugin.JetLanguage;

public class JetFile
extends PsiFileBase
implements JetDeclarationContainer,
JetElement {
    private final boolean isCompiled;

    public JetFile(FileViewProvider viewProvider, boolean compiled) {
        super(viewProvider, JetLanguage.INSTANCE);
        this.isCompiled = compiled;
    }

    @Override
    public FileASTNode getNode() {
        return super.getNode();
    }

    public boolean isCompiled() {
        return this.isCompiled;
    }

    @Override
    @NotNull
    public FileType getFileType() {
        JetFileType jetFileType = JetFileType.INSTANCE;
        if (jetFileType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetFile", "getFileType"));
        }
        return jetFileType;
    }

    @Override
    public String toString() {
        return "JetFile: " + this.getName();
    }

    @Override
    @NotNull
    public List<JetDeclaration> getDeclarations() {
        List<JetDeclaration> list2 = PsiTreeUtil.getChildrenOfTypeAsList(this, JetDeclaration.class);
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetFile", "getDeclarations"));
        }
        return list2;
    }

    @Nullable
    public JetImportList getImportList() {
        return this.findChildByClass(JetImportList.class);
    }

    @NotNull
    public List<JetImportDirective> getImportDirectives() {
        JetImportList importList = this.getImportList();
        List<JetImportDirective> list2 = importList != null ? importList.getImports() : Collections.emptyList();
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetFile", "getImportDirectives"));
        }
        return list2;
    }

    @Nullable
    public JetImportDirective findImportByAlias(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/psi/JetFile", "findImportByAlias"));
        }
        for (JetImportDirective directive : this.getImportDirectives()) {
            if (!name.equals(directive.getAliasName())) continue;
            return directive;
        }
        return null;
    }

    @Nullable
    public JetNamespaceHeader getNamespaceHeader() {
        ASTNode ast = this.getNode().findChildByType(JetNodeTypes.NAMESPACE_HEADER);
        return ast != null ? (JetNamespaceHeader)ast.getPsi() : null;
    }

    @Nullable
    public String getPackageName() {
        PsiJetFileStub stub = (PsiJetFileStub)this.getStub();
        if (stub != null) {
            return stub.getPackageName();
        }
        JetNamespaceHeader statement = this.getNamespaceHeader();
        return statement != null ? statement.getQualifiedName() : null;
    }

    @Nullable
    public JetScript getScript() {
        return PsiTreeUtil.getChildOfType(this, JetScript.class);
    }

    public boolean isScript() {
        PsiJetFileStub stub = (PsiJetFileStub)this.getStub();
        if (stub != null) {
            return stub.isScript();
        }
        return this.getScript() != null;
    }

    @Override
    @NotNull
    public String getName() {
        String string = super.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetFile", "getName"));
        }
        return string;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/jet/lang/psi/JetFile", "accept"));
        }
        if (visitor instanceof JetVisitorVoid) {
            this.accept((JetVisitorVoid)visitor);
        } else {
            visitor.visitFile(this);
        }
    }

    @Override
    public <D> void acceptChildren(@NotNull JetTreeVisitor<D> visitor, D data2) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/jet/lang/psi/JetFile", "acceptChildren"));
        }
        JetPsiUtil.visitChildren(this, visitor, data2);
    }

    @Override
    public void accept(@NotNull JetVisitorVoid visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/jet/lang/psi/JetFile", "accept"));
        }
        visitor.visitJetFile(this);
    }

    @Override
    public <R, D> R accept(@NotNull JetVisitor<R, D> visitor, D data2) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/jet/lang/psi/JetFile", "accept"));
        }
        return visitor.visitJetFile(this, data2);
    }
}

