/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.descriptors.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import jet.Function0;
import jet.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.CallableMemberDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassKind;
import org.jetbrains.jet.lang.descriptors.ConstructorDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.Modality;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.descriptors.Visibilities;
import org.jetbrains.jet.lang.descriptors.Visibility;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.ClassDescriptorBase;
import org.jetbrains.jet.lang.descriptors.impl.ConstructorDescriptorImpl;
import org.jetbrains.jet.lang.resolve.DescriptorFactory;
import org.jetbrains.jet.lang.resolve.OverridingUtil;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.name.SpecialNames;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.resolve.scopes.JetScopeImpl;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeConstructor;
import org.jetbrains.jet.lang.types.TypeConstructorImpl;
import org.jetbrains.jet.storage.MemoizedFunctionToNotNull;
import org.jetbrains.jet.storage.NotNullLazyValue;
import org.jetbrains.jet.storage.StorageManager;
import org.jetbrains.jet.utils.Printer;

public class EnumEntrySyntheticClassDescriptor
extends ClassDescriptorBase {
    private final ClassKind kind;
    private final TypeConstructor typeConstructor;
    private final ConstructorDescriptor primaryConstructor;
    private final JetScope scope;
    private final EnumEntrySyntheticClassDescriptor classObjectDescriptor;
    private final NotNullLazyValue<Collection<Name>> enumMemberNames;

    @NotNull
    public static EnumEntrySyntheticClassDescriptor create(@NotNull StorageManager storageManager, @NotNull ClassDescriptor enumClass, @NotNull Name name, @NotNull NotNullLazyValue<Collection<Name>> enumMemberNames) {
        if (storageManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storageManager", "org/jetbrains/jet/lang/descriptors/impl/EnumEntrySyntheticClassDescriptor", "create"));
        }
        if (enumClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "enumClass", "org/jetbrains/jet/lang/descriptors/impl/EnumEntrySyntheticClassDescriptor", "create"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/descriptors/impl/EnumEntrySyntheticClassDescriptor", "create"));
        }
        if (enumMemberNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "enumMemberNames", "org/jetbrains/jet/lang/descriptors/impl/EnumEntrySyntheticClassDescriptor", "create"));
        }
        JetType enumType = enumClass.getDefaultType();
        EnumEntrySyntheticClassDescriptor enumEntrySyntheticClassDescriptor = new EnumEntrySyntheticClassDescriptor(storageManager, enumClass, enumType, name, ClassKind.ENUM_ENTRY, enumMemberNames);
        if (enumEntrySyntheticClassDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/impl/EnumEntrySyntheticClassDescriptor", "create"));
        }
        return enumEntrySyntheticClassDescriptor;
    }

    private EnumEntrySyntheticClassDescriptor(@NotNull StorageManager storageManager, @NotNull ClassDescriptor containingClass, @NotNull JetType supertype, @NotNull Name name, @NotNull ClassKind kind, @NotNull NotNullLazyValue<Collection<Name>> enumMemberNames) {
        if (storageManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storageManager", "org/jetbrains/jet/lang/descriptors/impl/EnumEntrySyntheticClassDescriptor", "<init>"));
        }
        if (containingClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingClass", "org/jetbrains/jet/lang/descriptors/impl/EnumEntrySyntheticClassDescriptor", "<init>"));
        }
        if (supertype == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "supertype", "org/jetbrains/jet/lang/descriptors/impl/EnumEntrySyntheticClassDescriptor", "<init>"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/descriptors/impl/EnumEntrySyntheticClassDescriptor", "<init>"));
        }
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "org/jetbrains/jet/lang/descriptors/impl/EnumEntrySyntheticClassDescriptor", "<init>"));
        }
        if (enumMemberNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "enumMemberNames", "org/jetbrains/jet/lang/descriptors/impl/EnumEntrySyntheticClassDescriptor", "<init>"));
        }
        super(storageManager, containingClass, name);
        this.kind = kind;
        this.typeConstructor = new TypeConstructorImpl(this, this.getAnnotations(), true, "enum entry", Collections.emptyList(), Collections.singleton(supertype));
        this.scope = new EnumEntryScope(storageManager);
        this.enumMemberNames = enumMemberNames;
        ConstructorDescriptorImpl primaryConstructor = DescriptorFactory.createPrimaryConstructorForObject(this);
        primaryConstructor.setReturnType(this.getDefaultType());
        this.primaryConstructor = primaryConstructor;
        this.classObjectDescriptor = kind == ClassKind.CLASS_OBJECT ? null : new EnumEntrySyntheticClassDescriptor(storageManager, this, this.getDefaultType(), SpecialNames.getClassObjectName(name), ClassKind.CLASS_OBJECT, enumMemberNames);
    }

    @Override
    @NotNull
    protected JetScope getScopeForMemberLookup() {
        JetScope jetScope = this.scope;
        if (jetScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/impl/EnumEntrySyntheticClassDescriptor", "getScopeForMemberLookup"));
        }
        return jetScope;
    }

    @Override
    @NotNull
    public Collection<ConstructorDescriptor> getConstructors() {
        Set<ConstructorDescriptor> set = Collections.singleton(this.primaryConstructor);
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/impl/EnumEntrySyntheticClassDescriptor", "getConstructors"));
        }
        return set;
    }

    @Override
    @NotNull
    public TypeConstructor getTypeConstructor() {
        TypeConstructor typeConstructor = this.typeConstructor;
        if (typeConstructor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/impl/EnumEntrySyntheticClassDescriptor", "getTypeConstructor"));
        }
        return typeConstructor;
    }

    @Override
    @Nullable
    public ClassDescriptor getClassObjectDescriptor() {
        return this.classObjectDescriptor;
    }

    @Override
    @NotNull
    public ClassKind getKind() {
        ClassKind classKind = this.kind;
        if (classKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/impl/EnumEntrySyntheticClassDescriptor", "getKind"));
        }
        return classKind;
    }

    @Override
    @NotNull
    public Modality getModality() {
        Modality modality = Modality.FINAL;
        if (modality == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/impl/EnumEntrySyntheticClassDescriptor", "getModality"));
        }
        return modality;
    }

    @Override
    @NotNull
    public Visibility getVisibility() {
        Visibility visibility = Visibilities.PUBLIC;
        if (visibility == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/impl/EnumEntrySyntheticClassDescriptor", "getVisibility"));
        }
        return visibility;
    }

    @Override
    public boolean isInner() {
        return false;
    }

    @Override
    @Nullable
    public ConstructorDescriptor getUnsubstitutedPrimaryConstructor() {
        return this.primaryConstructor;
    }

    @Override
    @NotNull
    public List<AnnotationDescriptor> getAnnotations() {
        List<AnnotationDescriptor> list2 = Collections.emptyList();
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/impl/EnumEntrySyntheticClassDescriptor", "getAnnotations"));
        }
        return list2;
    }

    private class EnumEntryScope
    extends JetScopeImpl {
        private final MemoizedFunctionToNotNull<Name, Collection<FunctionDescriptor>> functions;
        private final MemoizedFunctionToNotNull<Name, Collection<PropertyDescriptor>> properties;
        private final NotNullLazyValue<Collection<DeclarationDescriptor>> allDescriptors;

        public EnumEntryScope(@NotNull StorageManager storageManager) {
            if (storageManager == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storageManager", "org/jetbrains/jet/lang/descriptors/impl/EnumEntrySyntheticClassDescriptor$EnumEntryScope", "<init>"));
            }
            this.functions = storageManager.createMemoizedFunction(new Function1<Name, Collection<FunctionDescriptor>>(){

                @Override
                public Collection<FunctionDescriptor> invoke(Name name) {
                    return EnumEntryScope.this.computeFunctions(name);
                }
            });
            this.properties = storageManager.createMemoizedFunction(new Function1<Name, Collection<PropertyDescriptor>>(){

                @Override
                public Collection<PropertyDescriptor> invoke(Name name) {
                    return EnumEntryScope.this.computeProperties(name);
                }
            });
            this.allDescriptors = storageManager.createLazyValue(new Function0<Collection<DeclarationDescriptor>>(){

                @Override
                public Collection<DeclarationDescriptor> invoke() {
                    return EnumEntryScope.this.computeAllDeclarations();
                }
            });
        }

        @Override
        @NotNull
        public Collection<VariableDescriptor> getProperties(@NotNull Name name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/descriptors/impl/EnumEntrySyntheticClassDescriptor$EnumEntryScope", "getProperties"));
            }
            Collection collection = (Collection)this.properties.invoke(name);
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/impl/EnumEntrySyntheticClassDescriptor$EnumEntryScope", "getProperties"));
            }
            return collection;
        }

        @NotNull
        private Collection<PropertyDescriptor> computeProperties(@NotNull Name name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/descriptors/impl/EnumEntrySyntheticClassDescriptor$EnumEntryScope", "computeProperties"));
            }
            Collection<VariableDescriptor> collection = this.resolveFakeOverrides(name, this.getSupertypeScope().getProperties(name));
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/impl/EnumEntrySyntheticClassDescriptor$EnumEntryScope", "computeProperties"));
            }
            return collection;
        }

        @Override
        @NotNull
        public Collection<FunctionDescriptor> getFunctions(@NotNull Name name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/descriptors/impl/EnumEntrySyntheticClassDescriptor$EnumEntryScope", "getFunctions"));
            }
            Collection collection = (Collection)this.functions.invoke(name);
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/impl/EnumEntrySyntheticClassDescriptor$EnumEntryScope", "getFunctions"));
            }
            return collection;
        }

        @NotNull
        private Collection<FunctionDescriptor> computeFunctions(@NotNull Name name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/descriptors/impl/EnumEntrySyntheticClassDescriptor$EnumEntryScope", "computeFunctions"));
            }
            Collection<FunctionDescriptor> collection = this.resolveFakeOverrides(name, this.getSupertypeScope().getFunctions(name));
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/impl/EnumEntrySyntheticClassDescriptor$EnumEntryScope", "computeFunctions"));
            }
            return collection;
        }

        @NotNull
        private JetScope getSupertypeScope() {
            Collection<JetType> supertype = EnumEntrySyntheticClassDescriptor.this.getTypeConstructor().getSupertypes();
            assert (supertype.size() == 1) : "Enum entry and its class object both should have exactly one supertype: " + supertype;
            JetScope jetScope = supertype.iterator().next().getMemberScope();
            if (jetScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/impl/EnumEntrySyntheticClassDescriptor$EnumEntryScope", "getSupertypeScope"));
            }
            return jetScope;
        }

        @NotNull
        private <D extends CallableMemberDescriptor> Collection<D> resolveFakeOverrides(@NotNull Name name, @NotNull Collection<D> fromSupertypes) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/descriptors/impl/EnumEntrySyntheticClassDescriptor$EnumEntryScope", "resolveFakeOverrides"));
            }
            if (fromSupertypes == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fromSupertypes", "org/jetbrains/jet/lang/descriptors/impl/EnumEntrySyntheticClassDescriptor$EnumEntryScope", "resolveFakeOverrides"));
            }
            final HashSet result = new HashSet();
            OverridingUtil.generateOverridesInFunctionGroup(name, fromSupertypes, Collections.emptySet(), EnumEntrySyntheticClassDescriptor.this, new OverridingUtil.DescriptorSink(){

                @Override
                public void addToScope(@NotNull CallableMemberDescriptor fakeOverride) {
                    if (fakeOverride == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fakeOverride", "org/jetbrains/jet/lang/descriptors/impl/EnumEntrySyntheticClassDescriptor$EnumEntryScope$4", "addToScope"));
                    }
                    OverridingUtil.resolveUnknownVisibilityForMember(fakeOverride, new OverridingUtil.NotInferredVisibilitySink(){

                        @Override
                        public void cannotInferVisibility(@NotNull CallableMemberDescriptor descriptor) {
                            if (descriptor == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/descriptors/impl/EnumEntrySyntheticClassDescriptor$EnumEntryScope$4$1", "cannotInferVisibility"));
                            }
                        }
                    });
                    result.add(fakeOverride);
                }

                @Override
                public void conflict(@NotNull CallableMemberDescriptor fromSuper, @NotNull CallableMemberDescriptor fromCurrent) {
                    if (fromSuper == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fromSuper", "org/jetbrains/jet/lang/descriptors/impl/EnumEntrySyntheticClassDescriptor$EnumEntryScope$4", "conflict"));
                    }
                    if (fromCurrent == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fromCurrent", "org/jetbrains/jet/lang/descriptors/impl/EnumEntrySyntheticClassDescriptor$EnumEntryScope$4", "conflict"));
                    }
                }
            });
            HashSet hashSet = result;
            if (hashSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/impl/EnumEntrySyntheticClassDescriptor$EnumEntryScope", "resolveFakeOverrides"));
            }
            return hashSet;
        }

        @Override
        @NotNull
        public DeclarationDescriptor getContainingDeclaration() {
            EnumEntrySyntheticClassDescriptor enumEntrySyntheticClassDescriptor = EnumEntrySyntheticClassDescriptor.this;
            if (enumEntrySyntheticClassDescriptor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/impl/EnumEntrySyntheticClassDescriptor$EnumEntryScope", "getContainingDeclaration"));
            }
            return enumEntrySyntheticClassDescriptor;
        }

        @Override
        @NotNull
        public Collection<DeclarationDescriptor> getAllDescriptors() {
            Collection collection = (Collection)this.allDescriptors.invoke();
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/impl/EnumEntrySyntheticClassDescriptor$EnumEntryScope", "getAllDescriptors"));
            }
            return collection;
        }

        @NotNull
        private Collection<DeclarationDescriptor> computeAllDeclarations() {
            HashSet<DeclarationDescriptor> result = new HashSet<DeclarationDescriptor>();
            for (Name name : (Collection)EnumEntrySyntheticClassDescriptor.this.enumMemberNames.invoke()) {
                result.addAll(this.getFunctions(name));
                result.addAll(this.getProperties(name));
            }
            HashSet<DeclarationDescriptor> hashSet = result;
            if (hashSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/impl/EnumEntrySyntheticClassDescriptor$EnumEntryScope", "computeAllDeclarations"));
            }
            return hashSet;
        }

        @Override
        public void printScopeStructure(@NotNull Printer p) {
            if (p == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "org/jetbrains/jet/lang/descriptors/impl/EnumEntrySyntheticClassDescriptor$EnumEntryScope", "printScopeStructure"));
            }
            p.println("enum entry scope for " + EnumEntrySyntheticClassDescriptor.this);
        }
    }
}

