/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen.state;

import com.google.common.collect.Lists;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.asm4.Type;
import org.jetbrains.jet.codegen.AccessorForFunctionDescriptor;
import org.jetbrains.jet.codegen.AccessorForPropertyDescriptor;
import org.jetbrains.jet.codegen.AsmUtil;
import org.jetbrains.jet.codegen.CallableMethod;
import org.jetbrains.jet.codegen.ClassBuilderMode;
import org.jetbrains.jet.codegen.CodegenUtil;
import org.jetbrains.jet.codegen.FunctionTypesUtil;
import org.jetbrains.jet.codegen.NamespaceCodegen;
import org.jetbrains.jet.codegen.OwnerKind;
import org.jetbrains.jet.codegen.PropertyCodegen;
import org.jetbrains.jet.codegen.StackValue;
import org.jetbrains.jet.codegen.binding.BindingTraceAware;
import org.jetbrains.jet.codegen.binding.CalculatedClosure;
import org.jetbrains.jet.codegen.binding.CodegenBinding;
import org.jetbrains.jet.codegen.signature.BothSignatureWriter;
import org.jetbrains.jet.codegen.signature.JvmMethodParameterKind;
import org.jetbrains.jet.codegen.signature.JvmMethodParameterSignature;
import org.jetbrains.jet.codegen.signature.JvmMethodSignature;
import org.jetbrains.jet.lang.descriptors.CallableMemberDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassKind;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.ConstructorDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyGetterDescriptor;
import org.jetbrains.jet.lang.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.ScriptDescriptor;
import org.jetbrains.jet.lang.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.descriptors.Visibilities;
import org.jetbrains.jet.lang.psi.JetDelegatorToSuperCall;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.psi.JetFunctionLiteralExpression;
import org.jetbrains.jet.lang.psi.JetPsiUtil;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingContextUtils;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.calls.util.ExpressionAsFunctionDescriptor;
import org.jetbrains.jet.lang.resolve.java.AsmTypeConstants;
import org.jetbrains.jet.lang.resolve.java.JavaBindingContext;
import org.jetbrains.jet.lang.resolve.java.JavaNamespaceKind;
import org.jetbrains.jet.lang.resolve.java.PackageClassUtils;
import org.jetbrains.jet.lang.resolve.java.mapping.KotlinToJavaTypesMap;
import org.jetbrains.jet.lang.resolve.name.FqNameUnsafe;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.types.CommonSupertypes;
import org.jetbrains.jet.lang.types.ErrorUtils;
import org.jetbrains.jet.lang.types.IntersectionTypeConstructor;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeConstructor;
import org.jetbrains.jet.lang.types.TypeProjection;
import org.jetbrains.jet.lang.types.Variance;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;

public class JetTypeMapper
extends BindingTraceAware {
    private final ClassBuilderMode classBuilderMode;

    public JetTypeMapper(BindingTrace bindingTrace, ClassBuilderMode mode) {
        super(bindingTrace);
        this.classBuilderMode = mode;
    }

    @NotNull
    public Type getOwner(@NotNull DeclarationDescriptor descriptor, @NotNull OwnerKind kind, boolean isInsideModule) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/codegen/state/JetTypeMapper", "getOwner"));
        }
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "org/jetbrains/jet/codegen/state/JetTypeMapper", "getOwner"));
        }
        DeclarationDescriptor containingDeclaration = descriptor.getContainingDeclaration();
        if (containingDeclaration instanceof NamespaceDescriptor) {
            Type type = this.asmTypeForNamespace((NamespaceDescriptor)containingDeclaration, descriptor, isInsideModule);
            if (type == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/state/JetTypeMapper", "getOwner"));
            }
            return type;
        }
        if (containingDeclaration instanceof ClassDescriptor) {
            ClassDescriptor classDescriptor = (ClassDescriptor)containingDeclaration;
            Type type = kind == OwnerKind.TRAIT_IMPL ? this.mapTraitImpl(classDescriptor) : this.mapClass(classDescriptor);
            if (type == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/state/JetTypeMapper", "getOwner"));
            }
            return type;
        }
        if (containingDeclaration instanceof ScriptDescriptor) {
            Type type = CodegenBinding.asmTypeForScriptDescriptor(this.bindingContext, (ScriptDescriptor)containingDeclaration);
            if (type == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/state/JetTypeMapper", "getOwner"));
            }
            return type;
        }
        throw new UnsupportedOperationException("don't know how to generate owner for parent " + containingDeclaration);
    }

    @NotNull
    private JavaNamespaceKind getNsKind(@NotNull NamespaceDescriptor ns) {
        if (ns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ns", "org/jetbrains/jet/codegen/state/JetTypeMapper", "getNsKind"));
        }
        JavaNamespaceKind javaNamespaceKind = this.bindingContext.get(JavaBindingContext.JAVA_NAMESPACE_KIND, ns);
        Boolean src = this.bindingContext.get(BindingContext.NAMESPACE_IS_SRC, ns);
        if (javaNamespaceKind == null && src == null) {
            throw new IllegalStateException("unknown namespace origin: " + ns);
        }
        if (javaNamespaceKind != null) {
            if (javaNamespaceKind == JavaNamespaceKind.CLASS_STATICS && src != null) {
                throw new IllegalStateException("conflicting namespace " + ns + ": it is both java statics and from src");
            }
            JavaNamespaceKind javaNamespaceKind2 = javaNamespaceKind;
            if (javaNamespaceKind2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/state/JetTypeMapper", "getNsKind"));
            }
            return javaNamespaceKind2;
        }
        JavaNamespaceKind javaNamespaceKind3 = JavaNamespaceKind.PROPER;
        if (javaNamespaceKind3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/state/JetTypeMapper", "getNsKind"));
        }
        return javaNamespaceKind3;
    }

    @NotNull
    private Type asmTypeForNamespace(@NotNull NamespaceDescriptor namespace, @NotNull DeclarationDescriptor descriptor, boolean insideModule) {
        if (namespace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namespace", "org/jetbrains/jet/codegen/state/JetTypeMapper", "asmTypeForNamespace"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/codegen/state/JetTypeMapper", "asmTypeForNamespace"));
        }
        StringBuilder r = new StringBuilder();
        List<DeclarationDescriptor> path = JetTypeMapper.getPathWithoutRootNsAndModule(namespace);
        for (DeclarationDescriptor pathElement : path) {
            NamespaceDescriptor ns = (NamespaceDescriptor)pathElement;
            if (r.length() > 0) {
                JavaNamespaceKind nsKind = this.getNsKind((NamespaceDescriptor)ns.getContainingDeclaration());
                if (nsKind == JavaNamespaceKind.PROPER) {
                    r.append("/");
                } else if (nsKind == JavaNamespaceKind.CLASS_STATICS) {
                    r.append("$");
                }
            }
            r.append(ns.getName());
        }
        if (this.getNsKind(namespace) == JavaNamespaceKind.PROPER) {
            if (r.length() > 0) {
                r.append("/");
            }
            JetFile file = BindingContextUtils.getContainingFile(this.bindingContext, descriptor);
            if (insideModule && file != null) {
                String internalName = NamespaceCodegen.getNamespacePartInternalName(file);
                r.append(internalName.substring(r.length()));
            } else {
                r.append(PackageClassUtils.getPackageClassName(namespace.getFqName()));
            }
        }
        if (r.length() == 0) {
            throw new IllegalStateException("internal error: failed to generate classname for " + namespace);
        }
        Type type = Type.getObjectType(r.toString());
        if (type == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/state/JetTypeMapper", "asmTypeForNamespace"));
        }
        return type;
    }

    @NotNull
    public static List<DeclarationDescriptor> getPathWithoutRootNsAndModule(@NotNull NamespaceDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/codegen/state/JetTypeMapper", "getPathWithoutRootNsAndModule"));
        }
        ArrayList<NamespaceDescriptor> path = new ArrayList<NamespaceDescriptor>();
        DeclarationDescriptor current = descriptor;
        while (true) {
            if (current instanceof NamespaceDescriptor && DescriptorUtils.isRootNamespace(current)) {
                List<DeclarationDescriptor> list2 = Lists.reverse(path);
                if (list2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/state/JetTypeMapper", "getPathWithoutRootNsAndModule"));
                }
                return list2;
            }
            path.add((NamespaceDescriptor)current);
            assert (current != null) : "Namespace must have a parent: " + descriptor;
            current = current.getContainingDeclaration();
        }
    }

    @NotNull
    public Type mapReturnType(@NotNull JetType jetType) {
        if (jetType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jetType", "org/jetbrains/jet/codegen/state/JetTypeMapper", "mapReturnType"));
        }
        Type type = this.mapReturnType(jetType, null);
        if (type == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/state/JetTypeMapper", "mapReturnType"));
        }
        return type;
    }

    @NotNull
    private Type mapReturnType(@NotNull JetType jetType, @Nullable BothSignatureWriter signatureVisitor) {
        if (jetType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jetType", "org/jetbrains/jet/codegen/state/JetTypeMapper", "mapReturnType"));
        }
        if (((Object)jetType).equals(KotlinBuiltIns.getInstance().getUnitType())) {
            if (signatureVisitor != null) {
                signatureVisitor.writeAsmType(Type.VOID_TYPE);
            }
            Type type = Type.VOID_TYPE;
            if (type == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/state/JetTypeMapper", "mapReturnType"));
            }
            return type;
        }
        Type type = this.mapType(jetType, signatureVisitor, JetTypeMapperMode.VALUE, Variance.OUT_VARIANCE, false);
        if (type == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/state/JetTypeMapper", "mapReturnType"));
        }
        return type;
    }

    @NotNull
    private Type mapType(@NotNull JetType jetType, @NotNull JetTypeMapperMode mode) {
        if (jetType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jetType", "org/jetbrains/jet/codegen/state/JetTypeMapper", "mapType"));
        }
        if (mode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mode", "org/jetbrains/jet/codegen/state/JetTypeMapper", "mapType"));
        }
        Type type = this.mapType(jetType, null, mode);
        if (type == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/state/JetTypeMapper", "mapType"));
        }
        return type;
    }

    @NotNull
    public Type mapSupertype(@NotNull JetType jetType, @Nullable BothSignatureWriter signatureVisitor) {
        if (jetType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jetType", "org/jetbrains/jet/codegen/state/JetTypeMapper", "mapSupertype"));
        }
        Type type = this.mapType(jetType, signatureVisitor, JetTypeMapperMode.SUPER_TYPE);
        if (type == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/state/JetTypeMapper", "mapSupertype"));
        }
        return type;
    }

    @NotNull
    public Type mapClass(@NotNull ClassifierDescriptor classifier) {
        if (classifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classifier", "org/jetbrains/jet/codegen/state/JetTypeMapper", "mapClass"));
        }
        Type type = this.mapType(classifier.getDefaultType(), null, JetTypeMapperMode.IMPL);
        if (type == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/state/JetTypeMapper", "mapClass"));
        }
        return type;
    }

    @NotNull
    public Type mapType(@NotNull JetType jetType) {
        if (jetType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jetType", "org/jetbrains/jet/codegen/state/JetTypeMapper", "mapType"));
        }
        Type type = this.mapType(jetType, null, JetTypeMapperMode.VALUE);
        if (type == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/state/JetTypeMapper", "mapType"));
        }
        return type;
    }

    @NotNull
    public Type mapType(@NotNull VariableDescriptor variableDescriptor) {
        if (variableDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variableDescriptor", "org/jetbrains/jet/codegen/state/JetTypeMapper", "mapType"));
        }
        Type type = this.mapType(variableDescriptor.getType(), null, JetTypeMapperMode.VALUE);
        if (type == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/state/JetTypeMapper", "mapType"));
        }
        return type;
    }

    @NotNull
    public Type mapType(@NotNull ClassifierDescriptor classifierDescriptor) {
        if (classifierDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classifierDescriptor", "org/jetbrains/jet/codegen/state/JetTypeMapper", "mapType"));
        }
        Type type = this.mapType(classifierDescriptor.getDefaultType(), null, JetTypeMapperMode.VALUE);
        if (type == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/state/JetTypeMapper", "mapType"));
        }
        return type;
    }

    @NotNull
    private Type mapType(@NotNull JetType jetType, @Nullable BothSignatureWriter signatureVisitor, @NotNull JetTypeMapperMode mode) {
        if (jetType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jetType", "org/jetbrains/jet/codegen/state/JetTypeMapper", "mapType"));
        }
        if (mode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mode", "org/jetbrains/jet/codegen/state/JetTypeMapper", "mapType"));
        }
        Type type = this.mapType(jetType, signatureVisitor, mode, Variance.INVARIANT, false);
        if (type == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/state/JetTypeMapper", "mapType"));
        }
        return type;
    }

    @NotNull
    public Type mapType(@NotNull JetType jetType, @Nullable BothSignatureWriter signatureVisitor, @NotNull JetTypeMapperMode kind, @NotNull Variance howThisTypeIsUsed, boolean arrayParameter) {
        boolean projectionsAllowed;
        FqNameUnsafe className;
        if (jetType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jetType", "org/jetbrains/jet/codegen/state/JetTypeMapper", "mapType"));
        }
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "org/jetbrains/jet/codegen/state/JetTypeMapper", "mapType"));
        }
        if (howThisTypeIsUsed == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "howThisTypeIsUsed", "org/jetbrains/jet/codegen/state/JetTypeMapper", "mapType"));
        }
        Type known = null;
        ClassifierDescriptor descriptor = jetType.getConstructor().getDeclarationDescriptor();
        if (descriptor instanceof ClassDescriptor && (className = DescriptorUtils.getFQName(descriptor)).isSafe()) {
            known = KotlinToJavaTypesMap.getInstance().getJavaAnalog(className.toSafe(), jetType.isNullable());
        }
        boolean bl = projectionsAllowed = kind != JetTypeMapperMode.SUPER_TYPE;
        if (known != null) {
            if (kind == JetTypeMapperMode.VALUE) {
                Type type = this.mapKnownAsmType(jetType, known, signatureVisitor, howThisTypeIsUsed);
                if (type == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/state/JetTypeMapper", "mapType"));
                }
                return type;
            }
            if (kind == JetTypeMapperMode.TYPE_PARAMETER || kind == JetTypeMapperMode.SUPER_TYPE) {
                Type type = this.mapKnownAsmType(jetType, AsmUtil.boxType(known), signatureVisitor, howThisTypeIsUsed, arrayParameter, projectionsAllowed);
                if (type == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/state/JetTypeMapper", "mapType"));
                }
                return type;
            }
            if (kind == JetTypeMapperMode.IMPL) {
                Type type = this.mapKnownAsmType(jetType, known, signatureVisitor, howThisTypeIsUsed);
                if (type == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/state/JetTypeMapper", "mapType"));
                }
                return type;
            }
            throw new IllegalStateException("unknown kind: " + (Object)((Object)kind));
        }
        TypeConstructor constructor = jetType.getConstructor();
        if (constructor instanceof IntersectionTypeConstructor) {
            jetType = CommonSupertypes.commonSupertype(new ArrayList<JetType>(constructor.getSupertypes()));
        }
        if (descriptor == null) {
            throw new UnsupportedOperationException("no descriptor for type constructor of " + jetType);
        }
        if (ErrorUtils.isError(descriptor)) {
            if (this.classBuilderMode != ClassBuilderMode.LIGHT_CLASSES) {
                throw new IllegalStateException(this.generateErrorMessageForErrorType(descriptor));
            }
            Type asmType = Type.getObjectType("error/NonExistentClass");
            if (signatureVisitor != null) {
                signatureVisitor.writeAsmType(asmType);
            }
            Type type = asmType;
            if (type == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/state/JetTypeMapper", "mapType"));
            }
            return type;
        }
        if (descriptor instanceof ClassDescriptor && KotlinBuiltIns.getInstance().isArray(jetType)) {
            if (jetType.getArguments().size() != 1) {
                throw new UnsupportedOperationException("arrays must have one type argument");
            }
            TypeProjection memberProjection = jetType.getArguments().get(0);
            JetType memberType = memberProjection.getType();
            if (signatureVisitor != null) {
                signatureVisitor.writeArrayType();
                this.mapType(memberType, signatureVisitor, JetTypeMapperMode.TYPE_PARAMETER, memberProjection.getProjectionKind(), true);
                signatureVisitor.writeArrayEnd();
            }
            Type r = !JetTypeMapper.isGenericsArray(jetType) ? Type.getType("[" + AsmUtil.boxType(this.mapType(memberType, kind)).getDescriptor()) : AsmTypeConstants.JAVA_ARRAY_GENERIC_TYPE;
            Type type = r;
            if (type == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/state/JetTypeMapper", "mapType"));
            }
            return type;
        }
        if (descriptor instanceof ClassDescriptor) {
            Type asmType = CodegenBinding.getAsmType(this.bindingTrace, descriptor);
            this.writeGenericType(signatureVisitor, asmType, jetType, howThisTypeIsUsed, projectionsAllowed);
            Type type = asmType;
            if (type == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/state/JetTypeMapper", "mapType"));
            }
            return type;
        }
        if (descriptor instanceof TypeParameterDescriptor) {
            TypeParameterDescriptor typeParameterDescriptor = (TypeParameterDescriptor)descriptor;
            Type type = this.mapType(typeParameterDescriptor.getUpperBoundsAsType(), kind);
            if (signatureVisitor != null) {
                signatureVisitor.writeTypeVariable(typeParameterDescriptor.getName(), type);
            }
            Type type2 = type;
            if (type2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/state/JetTypeMapper", "mapType"));
            }
            return type2;
        }
        throw new UnsupportedOperationException("Unknown type " + jetType);
    }

    @NotNull
    public Type mapTraitImpl(@NotNull ClassDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/codegen/state/JetTypeMapper", "mapTraitImpl"));
        }
        Type type = Type.getObjectType(CodegenBinding.getAsmType(this.bindingTrace, descriptor).getInternalName() + "$$TImpl");
        if (type == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/state/JetTypeMapper", "mapTraitImpl"));
        }
        return type;
    }

    private String generateErrorMessageForErrorType(@NotNull DeclarationDescriptor descriptor) {
        DeclarationDescriptor containingDeclaration;
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/codegen/state/JetTypeMapper", "generateErrorMessageForErrorType"));
        }
        PsiElement declarationElement = BindingContextUtils.descriptorToDeclaration(this.bindingContext, descriptor);
        PsiElement parentDeclarationElement = null;
        if (declarationElement != null && (containingDeclaration = descriptor.getContainingDeclaration()) != null) {
            parentDeclarationElement = BindingContextUtils.descriptorToDeclaration(this.bindingContext, containingDeclaration);
        }
        return String.format("Error types are not allowed when classBuilderMode = %s. Descriptor: %s. For declaration %s:%s in %s:%s", new Object[]{this.classBuilderMode, descriptor, declarationElement, declarationElement != null ? declarationElement.getText() : "null", parentDeclarationElement, parentDeclarationElement != null ? parentDeclarationElement.getText() : "null"});
    }

    private void writeGenericType(BothSignatureWriter signatureVisitor, Type asmType, JetType jetType, Variance howThisTypeIsUsed, boolean projectionsAllowed) {
        if (signatureVisitor != null) {
            signatureVisitor.writeClassBegin(asmType);
            List<TypeProjection> arguments2 = jetType.getArguments();
            for (TypeParameterDescriptor parameter : jetType.getConstructor().getParameters()) {
                TypeProjection argument = arguments2.get(parameter.getIndex());
                Variance projectionKind = projectionsAllowed ? JetTypeMapper.getEffectiveVariance(parameter.getVariance(), argument.getProjectionKind(), howThisTypeIsUsed) : Variance.INVARIANT;
                signatureVisitor.writeTypeArgument(projectionKind);
                this.mapType(argument.getType(), signatureVisitor, JetTypeMapperMode.TYPE_PARAMETER);
                signatureVisitor.writeTypeArgumentEnd();
            }
            signatureVisitor.writeClassEnd();
        }
    }

    private static Variance getEffectiveVariance(Variance parameterVariance, Variance projectionKind, Variance howThisTypeIsUsed) {
        if (howThisTypeIsUsed == Variance.OUT_VARIANCE) {
            return projectionKind;
        }
        if (parameterVariance == Variance.INVARIANT) {
            return projectionKind;
        }
        if (projectionKind == Variance.INVARIANT) {
            return parameterVariance;
        }
        if (parameterVariance == projectionKind) {
            return parameterVariance;
        }
        return Variance.OUT_VARIANCE;
    }

    private Type mapKnownAsmType(JetType jetType, Type asmType, @Nullable BothSignatureWriter signatureVisitor, @NotNull Variance howThisTypeIsUsed) {
        if (howThisTypeIsUsed == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "howThisTypeIsUsed", "org/jetbrains/jet/codegen/state/JetTypeMapper", "mapKnownAsmType"));
        }
        return this.mapKnownAsmType(jetType, asmType, signatureVisitor, howThisTypeIsUsed, false, true);
    }

    private Type mapKnownAsmType(JetType jetType, Type asmType, @Nullable BothSignatureWriter signatureVisitor, @NotNull Variance howThisTypeIsUsed, boolean arrayParameter, boolean allowProjections) {
        if (howThisTypeIsUsed == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "howThisTypeIsUsed", "org/jetbrains/jet/codegen/state/JetTypeMapper", "mapKnownAsmType"));
        }
        if (signatureVisitor != null) {
            if (jetType.getArguments().isEmpty()) {
                if (arrayParameter && howThisTypeIsUsed == Variance.IN_VARIANCE) {
                    asmType = AsmTypeConstants.OBJECT_TYPE;
                }
                signatureVisitor.writeAsmType(asmType);
            } else {
                this.writeGenericType(signatureVisitor, asmType, jetType, howThisTypeIsUsed, allowProjections);
            }
        }
        return asmType;
    }

    @NotNull
    public CallableMethod mapToCallableMethod(@NotNull FunctionDescriptor functionDescriptor, boolean superCall, boolean isInsideClass, boolean isInsideModule, OwnerKind kind) {
        int invokeOpcode;
        Type ownerForDefaultImpl;
        Type ownerForDefaultParam;
        Type owner;
        Type thisClass;
        if (functionDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/jet/codegen/state/JetTypeMapper", "mapToCallableMethod"));
        }
        DeclarationDescriptor functionParent = functionDescriptor.getOriginal().getContainingDeclaration();
        functionDescriptor = CodegenUtil.unwrapFakeOverride(functionDescriptor);
        JvmMethodSignature descriptor = this.mapSignature(functionDescriptor.getOriginal(), true, kind);
        Type calleeType = null;
        if (CodegenBinding.isLocalNamedFun(functionDescriptor) || functionDescriptor instanceof ExpressionAsFunctionDescriptor) {
            if (functionDescriptor instanceof ExpressionAsFunctionDescriptor) {
                JetExpression expression = JetPsiUtil.deparenthesize(((ExpressionAsFunctionDescriptor)functionDescriptor).getExpression());
                if (expression instanceof JetFunctionLiteralExpression) {
                    expression = ((JetFunctionLiteralExpression)expression).getFunctionLiteral();
                }
                functionDescriptor = this.bindingContext.get(BindingContext.FUNCTION, expression);
            }
            functionDescriptor = functionDescriptor.getOriginal();
            ownerForDefaultParam = thisClass = (owner = CodegenBinding.asmTypeForAnonymousClass(this.bindingContext, functionDescriptor));
            ownerForDefaultImpl = thisClass;
            invokeOpcode = 182;
            descriptor = this.mapSignature("invoke", functionDescriptor, true, kind);
            calleeType = owner;
        } else if (functionParent instanceof NamespaceDescriptor) {
            assert (!superCall);
            ownerForDefaultImpl = ownerForDefaultParam = (owner = this.asmTypeForNamespace((NamespaceDescriptor)functionParent, functionDescriptor, isInsideModule));
            invokeOpcode = 184;
            thisClass = null;
        } else if (functionDescriptor instanceof ConstructorDescriptor) {
            assert (!superCall);
            ownerForDefaultImpl = ownerForDefaultParam = (owner = this.mapClass((ClassDescriptor)functionParent));
            invokeOpcode = 183;
            thisClass = null;
        } else if (functionParent instanceof ScriptDescriptor) {
            ownerForDefaultParam = ownerForDefaultImpl = CodegenBinding.asmTypeForScriptDescriptor(this.bindingContext, (ScriptDescriptor)functionParent);
            owner = ownerForDefaultImpl;
            thisClass = ownerForDefaultImpl;
            invokeOpcode = 182;
        } else if (functionParent instanceof ClassDescriptor) {
            FunctionDescriptor declarationFunctionDescriptor = JetTypeMapper.findAnyDeclaration(functionDescriptor);
            ClassDescriptor currentOwner = (ClassDescriptor)functionParent;
            ClassDescriptor declarationOwner = (ClassDescriptor)declarationFunctionDescriptor.getContainingDeclaration();
            boolean originalIsInterface = CodegenUtil.isInterface(declarationOwner);
            boolean currentIsInterface = CodegenUtil.isInterface(currentOwner);
            boolean isAccessor = JetTypeMapper.isAccessor(functionDescriptor);
            ClassDescriptor receiver = currentIsInterface && !originalIsInterface ? declarationOwner : currentOwner;
            boolean isInterface = originalIsInterface && currentIsInterface;
            owner = this.mapType(receiver.getDefaultType(), JetTypeMapperMode.TYPE_PARAMETER);
            ClassDescriptor declarationOwnerForDefault = (ClassDescriptor)JetTypeMapper.findBaseDeclaration(functionDescriptor).getContainingDeclaration();
            ownerForDefaultParam = this.mapType(declarationOwnerForDefault.getDefaultType(), JetTypeMapperMode.TYPE_PARAMETER);
            ownerForDefaultImpl = Type.getObjectType(ownerForDefaultParam.getInternalName() + (CodegenUtil.isInterface(declarationOwnerForDefault) ? "$$TImpl" : ""));
            if (isInterface) {
                invokeOpcode = superCall ? 184 : 185;
            } else if (isAccessor) {
                invokeOpcode = 184;
            } else {
                boolean isPrivateFunInvocation = isInsideClass && functionDescriptor.getVisibility() == Visibilities.PRIVATE;
                int n = invokeOpcode = superCall || isPrivateFunInvocation ? 183 : 182;
            }
            if (isInterface && superCall) {
                descriptor = this.mapSignature(functionDescriptor, false, OwnerKind.TRAIT_IMPL);
                owner = Type.getObjectType(owner.getInternalName() + "$$TImpl");
            }
            thisClass = this.mapType(receiver.getDefaultType());
        } else {
            throw new UnsupportedOperationException("unknown function parent");
        }
        ReceiverParameterDescriptor receiverParameter = functionDescriptor.getOriginal().getReceiverParameter();
        Type receiverParameterType = receiverParameter != null ? this.mapType(receiverParameter.getType()) : null;
        CallableMethod callableMethod = new CallableMethod(owner, ownerForDefaultImpl, ownerForDefaultParam, descriptor, invokeOpcode, thisClass, receiverParameterType, calleeType);
        if (callableMethod == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/state/JetTypeMapper", "mapToCallableMethod"));
        }
        return callableMethod;
    }

    public static boolean isAccessor(@NotNull CallableMemberDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/codegen/state/JetTypeMapper", "isAccessor"));
        }
        return descriptor instanceof AccessorForFunctionDescriptor || descriptor instanceof AccessorForPropertyDescriptor || descriptor instanceof AccessorForPropertyDescriptor.Getter || descriptor instanceof AccessorForPropertyDescriptor.Setter;
    }

    @NotNull
    private static FunctionDescriptor findAnyDeclaration(@NotNull FunctionDescriptor function) {
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/jet/codegen/state/JetTypeMapper", "findAnyDeclaration"));
        }
        if (function.getKind() == CallableMemberDescriptor.Kind.DECLARATION) {
            FunctionDescriptor functionDescriptor = function;
            if (functionDescriptor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/state/JetTypeMapper", "findAnyDeclaration"));
            }
            return functionDescriptor;
        }
        FunctionDescriptor functionDescriptor = JetTypeMapper.findBaseDeclaration(function);
        if (functionDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/state/JetTypeMapper", "findAnyDeclaration"));
        }
        return functionDescriptor;
    }

    @NotNull
    private static FunctionDescriptor findBaseDeclaration(@NotNull FunctionDescriptor function) {
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/jet/codegen/state/JetTypeMapper", "findBaseDeclaration"));
        }
        if (function.getOverriddenDescriptors().isEmpty()) {
            FunctionDescriptor functionDescriptor = function;
            if (functionDescriptor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/state/JetTypeMapper", "findBaseDeclaration"));
            }
            return functionDescriptor;
        }
        FunctionDescriptor functionDescriptor = JetTypeMapper.findBaseDeclaration(function.getOverriddenDescriptors().iterator().next());
        if (functionDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/state/JetTypeMapper", "findBaseDeclaration"));
        }
        return functionDescriptor;
    }

    @NotNull
    public JvmMethodSignature mapSignature(@NotNull FunctionDescriptor f, boolean needGenericSignature, @NotNull OwnerKind kind) {
        if (f == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "f", "org/jetbrains/jet/codegen/state/JetTypeMapper", "mapSignature"));
        }
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "org/jetbrains/jet/codegen/state/JetTypeMapper", "mapSignature"));
        }
        String name = f.getName().asString();
        if (f instanceof PropertyAccessorDescriptor) {
            boolean isGetter = f instanceof PropertyGetterDescriptor;
            name = JetTypeMapper.getPropertyAccessorName(((PropertyAccessorDescriptor)f).getCorrespondingProperty(), isGetter);
        }
        JvmMethodSignature jvmMethodSignature = this.mapSignature(name, f, needGenericSignature, kind);
        if (jvmMethodSignature == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/state/JetTypeMapper", "mapSignature"));
        }
        return jvmMethodSignature;
    }

    @NotNull
    public JvmMethodSignature mapSignature(@NotNull Name functionName, @NotNull FunctionDescriptor f) {
        if (functionName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionName", "org/jetbrains/jet/codegen/state/JetTypeMapper", "mapSignature"));
        }
        if (f == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "f", "org/jetbrains/jet/codegen/state/JetTypeMapper", "mapSignature"));
        }
        JvmMethodSignature jvmMethodSignature = this.mapSignature(functionName.asString(), f, false, OwnerKind.IMPLEMENTATION);
        if (jvmMethodSignature == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/state/JetTypeMapper", "mapSignature"));
        }
        return jvmMethodSignature;
    }

    @NotNull
    public JvmMethodSignature mapSignature(@NotNull FunctionDescriptor f) {
        if (f == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "f", "org/jetbrains/jet/codegen/state/JetTypeMapper", "mapSignature"));
        }
        JvmMethodSignature jvmMethodSignature = this.mapSignature(f.getName(), f);
        if (jvmMethodSignature == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/state/JetTypeMapper", "mapSignature"));
        }
        return jvmMethodSignature;
    }

    @NotNull
    private JvmMethodSignature mapSignature(@NotNull String methodName, @NotNull FunctionDescriptor f, boolean needGenericSignature, @NotNull OwnerKind kind) {
        if (methodName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodName", "org/jetbrains/jet/codegen/state/JetTypeMapper", "mapSignature"));
        }
        if (f == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "f", "org/jetbrains/jet/codegen/state/JetTypeMapper", "mapSignature"));
        }
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "org/jetbrains/jet/codegen/state/JetTypeMapper", "mapSignature"));
        }
        if (kind == OwnerKind.TRAIT_IMPL) {
            needGenericSignature = false;
        }
        BothSignatureWriter signatureVisitor = new BothSignatureWriter(BothSignatureWriter.Mode.METHOD, needGenericSignature);
        this.writeFormalTypeParameters(f.getTypeParameters(), signatureVisitor);
        signatureVisitor.writeParametersStart();
        this.writeThisIfNeeded(f, kind, signatureVisitor);
        this.writeReceiverIfNeeded(f.getReceiverParameter(), signatureVisitor);
        for (ValueParameterDescriptor parameter : f.getValueParameters()) {
            this.writeParameter(signatureVisitor, parameter.getType());
        }
        if (f instanceof ConstructorDescriptor) {
            JetTypeMapper.writeVoidReturn(signatureVisitor);
        } else {
            signatureVisitor.writeReturnType();
            JetType returnType = f.getReturnType();
            assert (returnType != null) : "Function " + f + " has no return type";
            this.mapReturnType(returnType, signatureVisitor);
            signatureVisitor.writeReturnTypeEnd();
        }
        JvmMethodSignature jvmMethodSignature = signatureVisitor.makeJvmMethodSignature(methodName);
        if (jvmMethodSignature == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/state/JetTypeMapper", "mapSignature"));
        }
        return jvmMethodSignature;
    }

    private static void writeVoidReturn(@NotNull BothSignatureWriter signatureVisitor) {
        if (signatureVisitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signatureVisitor", "org/jetbrains/jet/codegen/state/JetTypeMapper", "writeVoidReturn"));
        }
        signatureVisitor.writeReturnType();
        signatureVisitor.writeAsmType(Type.VOID_TYPE);
        signatureVisitor.writeReturnTypeEnd();
    }

    @Nullable
    public String mapFieldSignature(@NotNull JetType backingFieldType) {
        if (backingFieldType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "backingFieldType", "org/jetbrains/jet/codegen/state/JetTypeMapper", "mapFieldSignature"));
        }
        BothSignatureWriter signatureVisitor = new BothSignatureWriter(BothSignatureWriter.Mode.TYPE, true);
        this.mapType(backingFieldType, signatureVisitor, JetTypeMapperMode.VALUE);
        return signatureVisitor.makeJavaGenericSignature();
    }

    private void writeThisIfNeeded(@NotNull CallableMemberDescriptor descriptor, @NotNull OwnerKind kind, @NotNull BothSignatureWriter signatureVisitor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/codegen/state/JetTypeMapper", "writeThisIfNeeded"));
        }
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "org/jetbrains/jet/codegen/state/JetTypeMapper", "writeThisIfNeeded"));
        }
        if (signatureVisitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signatureVisitor", "org/jetbrains/jet/codegen/state/JetTypeMapper", "writeThisIfNeeded"));
        }
        if (kind == OwnerKind.TRAIT_IMPL) {
            ClassDescriptor containingDeclaration = (ClassDescriptor)descriptor.getContainingDeclaration();
            Type type = AsmUtil.getTraitImplThisParameterType(containingDeclaration, this);
            signatureVisitor.writeParameterType(JvmMethodParameterKind.THIS);
            signatureVisitor.writeAsmType(type);
            signatureVisitor.writeParameterTypeEnd();
        } else {
            this.writeThisForAccessorIfNeeded(descriptor, signatureVisitor);
        }
    }

    private void writeThisForAccessorIfNeeded(@NotNull CallableMemberDescriptor descriptor, @NotNull BothSignatureWriter signatureVisitor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/codegen/state/JetTypeMapper", "writeThisForAccessorIfNeeded"));
        }
        if (signatureVisitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signatureVisitor", "org/jetbrains/jet/codegen/state/JetTypeMapper", "writeThisForAccessorIfNeeded"));
        }
        if (JetTypeMapper.isAccessor(descriptor) && descriptor.getExpectedThisObject() != null) {
            signatureVisitor.writeParameterType(JvmMethodParameterKind.THIS);
            this.mapType(((ClassifierDescriptor)descriptor.getContainingDeclaration()).getDefaultType(), signatureVisitor, JetTypeMapperMode.VALUE);
            signatureVisitor.writeParameterTypeEnd();
        }
    }

    public void writeFormalTypeParameters(List<TypeParameterDescriptor> typeParameters, BothSignatureWriter signatureVisitor) {
        if (signatureVisitor == null) {
            return;
        }
        for (TypeParameterDescriptor typeParameterDescriptor : typeParameters) {
            this.writeFormalTypeParameter(typeParameterDescriptor, signatureVisitor);
        }
    }

    private void writeFormalTypeParameter(TypeParameterDescriptor typeParameterDescriptor, BothSignatureWriter signatureVisitor) {
        signatureVisitor.writeFormalTypeParameter(typeParameterDescriptor.getName().asString());
        signatureVisitor.writeClassBound();
        for (JetType jetType : typeParameterDescriptor.getUpperBounds()) {
            if (!(jetType.getConstructor().getDeclarationDescriptor() instanceof ClassDescriptor) || CodegenUtil.isInterface(jetType)) continue;
            this.mapType(jetType, signatureVisitor, JetTypeMapperMode.TYPE_PARAMETER);
            break;
        }
        signatureVisitor.writeClassBoundEnd();
        for (JetType jetType : typeParameterDescriptor.getUpperBounds()) {
            if (jetType.getConstructor().getDeclarationDescriptor() instanceof ClassDescriptor && CodegenUtil.isInterface(jetType)) {
                signatureVisitor.writeInterfaceBound();
                this.mapType(jetType, signatureVisitor, JetTypeMapperMode.TYPE_PARAMETER);
                signatureVisitor.writeInterfaceBoundEnd();
            }
            if (!(jetType.getConstructor().getDeclarationDescriptor() instanceof TypeParameterDescriptor)) continue;
            signatureVisitor.writeInterfaceBound();
            this.mapType(jetType, signatureVisitor, JetTypeMapperMode.TYPE_PARAMETER);
            signatureVisitor.writeInterfaceBoundEnd();
        }
    }

    private void writeReceiverIfNeeded(@Nullable ReceiverParameterDescriptor receiver, BothSignatureWriter signatureWriter) {
        if (receiver != null) {
            signatureWriter.writeParameterType(JvmMethodParameterKind.RECEIVER);
            this.mapType(receiver.getType(), signatureWriter, JetTypeMapperMode.VALUE);
            signatureWriter.writeParameterTypeEnd();
        }
    }

    @NotNull
    public static String getPropertyAccessorName(@NotNull PropertyDescriptor descriptor, boolean isGetter) {
        boolean isAnnotation;
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/codegen/state/JetTypeMapper", "getPropertyAccessorName"));
        }
        DeclarationDescriptor parentDescriptor = descriptor.getContainingDeclaration();
        boolean bl = isAnnotation = parentDescriptor instanceof ClassDescriptor && ((ClassDescriptor)parentDescriptor).getKind() == ClassKind.ANNOTATION_CLASS;
        String string = isAnnotation ? descriptor.getName().asString() : (isGetter ? PropertyCodegen.getterName(descriptor.getName()) : PropertyCodegen.setterName(descriptor.getName()));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/state/JetTypeMapper", "getPropertyAccessorName"));
        }
        return string;
    }

    @NotNull
    public JvmMethodSignature mapGetterSignature(PropertyDescriptor descriptor, OwnerKind kind) {
        BothSignatureWriter signatureWriter = new BothSignatureWriter(BothSignatureWriter.Mode.METHOD, true);
        this.writeFormalTypeParameters(descriptor.getTypeParameters(), signatureWriter);
        signatureWriter.writeParametersStart();
        this.writeThisIfNeeded(descriptor, kind, signatureWriter);
        this.writeReceiverIfNeeded(descriptor.getReceiverParameter(), signatureWriter);
        signatureWriter.writeReturnType();
        this.mapType(descriptor.getType(), signatureWriter, JetTypeMapperMode.VALUE, Variance.OUT_VARIANCE, false);
        signatureWriter.writeReturnTypeEnd();
        String name = JetTypeMapper.getPropertyAccessorName(descriptor, true);
        JvmMethodSignature jvmMethodSignature = signatureWriter.makeJvmMethodSignature(name);
        if (jvmMethodSignature == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/state/JetTypeMapper", "mapGetterSignature"));
        }
        return jvmMethodSignature;
    }

    @NotNull
    public JvmMethodSignature mapSetterSignature(PropertyDescriptor descriptor, OwnerKind kind) {
        assert (descriptor.isVar());
        BothSignatureWriter signatureWriter = new BothSignatureWriter(BothSignatureWriter.Mode.METHOD, true);
        this.writeFormalTypeParameters(descriptor.getTypeParameters(), signatureWriter);
        signatureWriter.writeParametersStart();
        this.writeThisIfNeeded(descriptor, kind, signatureWriter);
        this.writeReceiverIfNeeded(descriptor.getReceiverParameter(), signatureWriter);
        this.writeParameter(signatureWriter, descriptor.getType());
        JetTypeMapper.writeVoidReturn(signatureWriter);
        String name = JetTypeMapper.getPropertyAccessorName(descriptor, false);
        JvmMethodSignature jvmMethodSignature = signatureWriter.makeJvmMethodSignature(name);
        if (jvmMethodSignature == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/state/JetTypeMapper", "mapSetterSignature"));
        }
        return jvmMethodSignature;
    }

    private void writeParameter(@NotNull BothSignatureWriter signatureWriter, @NotNull JetType outType) {
        if (signatureWriter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signatureWriter", "org/jetbrains/jet/codegen/state/JetTypeMapper", "writeParameter"));
        }
        if (outType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outType", "org/jetbrains/jet/codegen/state/JetTypeMapper", "writeParameter"));
        }
        signatureWriter.writeParameterType(JvmMethodParameterKind.VALUE);
        this.mapType(outType, signatureWriter, JetTypeMapperMode.VALUE);
        signatureWriter.writeParameterTypeEnd();
    }

    @NotNull
    public JvmMethodSignature mapConstructorSignature(@NotNull ConstructorDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/codegen/state/JetTypeMapper", "mapConstructorSignature"));
        }
        JvmMethodSignature jvmMethodSignature = this.mapConstructorSignature(descriptor, this.bindingContext.get(CodegenBinding.CLOSURE, descriptor.getContainingDeclaration()));
        if (jvmMethodSignature == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/state/JetTypeMapper", "mapConstructorSignature"));
        }
        return jvmMethodSignature;
    }

    @NotNull
    public JvmMethodSignature mapConstructorSignature(@NotNull ConstructorDescriptor descriptor, @Nullable CalculatedClosure closure) {
        JetType captureReceiverType;
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/codegen/state/JetTypeMapper", "mapConstructorSignature"));
        }
        BothSignatureWriter signatureWriter = new BothSignatureWriter(BothSignatureWriter.Mode.METHOD, true);
        this.writeFormalTypeParameters(Collections.<TypeParameterDescriptor>emptyList(), signatureWriter);
        signatureWriter.writeParametersStart();
        ClassDescriptor containingDeclaration = descriptor.getContainingDeclaration();
        ClassDescriptor captureThis = CodegenUtil.getExpectedThisObjectForConstructorCall(descriptor, closure);
        if (captureThis != null) {
            signatureWriter.writeParameterType(JvmMethodParameterKind.OUTER);
            this.mapType(captureThis.getDefaultType(), signatureWriter, JetTypeMapperMode.VALUE);
            signatureWriter.writeParameterTypeEnd();
        }
        JetType jetType = captureReceiverType = closure != null ? closure.getCaptureReceiverType() : null;
        if (captureReceiverType != null) {
            signatureWriter.writeParameterType(JvmMethodParameterKind.RECEIVER);
            this.mapType(captureReceiverType, signatureWriter, JetTypeMapperMode.VALUE);
            signatureWriter.writeParameterTypeEnd();
        }
        if (containingDeclaration.getKind() == ClassKind.ENUM_CLASS || containingDeclaration.getKind() == ClassKind.ENUM_ENTRY) {
            signatureWriter.writeParameterType(JvmMethodParameterKind.ENUM_NAME);
            this.mapType(KotlinBuiltIns.getInstance().getStringType(), signatureWriter, JetTypeMapperMode.VALUE);
            signatureWriter.writeParameterTypeEnd();
            signatureWriter.writeParameterType(JvmMethodParameterKind.ENUM_ORDINAL);
            this.mapType(KotlinBuiltIns.getInstance().getIntType(), signatureWriter, JetTypeMapperMode.VALUE);
            signatureWriter.writeParameterTypeEnd();
        }
        if (closure != null) {
            DeclarationDescriptor declarationDescriptor;
            for (Map.Entry entry : closure.getCaptureVariables().entrySet()) {
                DeclarationDescriptor variableDescriptor = (DeclarationDescriptor)entry.getKey();
                Type type = null;
                if (variableDescriptor instanceof VariableDescriptor && !(variableDescriptor instanceof PropertyDescriptor)) {
                    Type sharedVarType = this.getSharedVarType(variableDescriptor);
                    if (sharedVarType == null) {
                        sharedVarType = this.mapType(((VariableDescriptor)variableDescriptor).getType());
                    }
                    type = sharedVarType;
                } else if (CodegenBinding.isLocalNamedFun(variableDescriptor)) {
                    type = CodegenBinding.asmTypeForAnonymousClass(this.bindingContext, (FunctionDescriptor)variableDescriptor);
                }
                if (type == null) continue;
                signatureWriter.writeParameterType(JvmMethodParameterKind.SHARED_VAR);
                signatureWriter.writeAsmType(type);
                signatureWriter.writeParameterTypeEnd();
            }
            JetDelegatorToSuperCall superCall = closure.getSuperCall();
            if (superCall != null && (declarationDescriptor = this.bindingContext.get(BindingContext.REFERENCE_TARGET, superCall.getCalleeExpression().getConstructorReferenceExpression())) instanceof ConstructorDescriptor) {
                List<JvmMethodParameterSignature> types;
                ConstructorDescriptor superConstructor = (ConstructorDescriptor)declarationDescriptor;
                if (CodegenBinding.isObjectLiteral(this.bindingContext, descriptor.getContainingDeclaration()) && (types = this.mapConstructorSignature(superConstructor).getKotlinParameterTypes()) != null) {
                    for (JvmMethodParameterSignature type : types) {
                        signatureWriter.writeParameterType(JvmMethodParameterKind.SUPER_CALL_PARAM);
                        signatureWriter.writeAsmType(type.getAsmType());
                        signatureWriter.writeParameterTypeEnd();
                    }
                }
            }
        }
        for (ValueParameterDescriptor valueParameterDescriptor : descriptor.getOriginal().getValueParameters()) {
            this.writeParameter(signatureWriter, valueParameterDescriptor.getType());
        }
        JetTypeMapper.writeVoidReturn(signatureWriter);
        JvmMethodSignature jvmMethodSignature = signatureWriter.makeJvmMethodSignature("<init>");
        if (jvmMethodSignature == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/state/JetTypeMapper", "mapConstructorSignature"));
        }
        return jvmMethodSignature;
    }

    @NotNull
    public JvmMethodSignature mapScriptSignature(@NotNull ScriptDescriptor script, @NotNull List<ScriptDescriptor> importedScripts) {
        if (script == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "script", "org/jetbrains/jet/codegen/state/JetTypeMapper", "mapScriptSignature"));
        }
        if (importedScripts == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importedScripts", "org/jetbrains/jet/codegen/state/JetTypeMapper", "mapScriptSignature"));
        }
        BothSignatureWriter signatureWriter = new BothSignatureWriter(BothSignatureWriter.Mode.METHOD, false);
        this.writeFormalTypeParameters(Collections.<TypeParameterDescriptor>emptyList(), signatureWriter);
        signatureWriter.writeParametersStart();
        for (ScriptDescriptor importedScript : importedScripts) {
            signatureWriter.writeParameterType(JvmMethodParameterKind.VALUE);
            ClassDescriptor descriptor = this.bindingContext.get(CodegenBinding.CLASS_FOR_SCRIPT, importedScript);
            assert (descriptor != null);
            this.mapType(descriptor.getDefaultType(), signatureWriter, JetTypeMapperMode.VALUE);
            signatureWriter.writeParameterTypeEnd();
        }
        for (ValueParameterDescriptor valueParameter : script.getValueParameters()) {
            this.writeParameter(signatureWriter, valueParameter.getType());
        }
        JetTypeMapper.writeVoidReturn(signatureWriter);
        JvmMethodSignature jvmMethodSignature = signatureWriter.makeJvmMethodSignature("<init>");
        if (jvmMethodSignature == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/state/JetTypeMapper", "mapScriptSignature"));
        }
        return jvmMethodSignature;
    }

    @NotNull
    public CallableMethod mapToCallableMethod(@NotNull ConstructorDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/codegen/state/JetTypeMapper", "mapToCallableMethod"));
        }
        CallableMethod callableMethod = this.mapToCallableMethod(descriptor, this.bindingContext.get(CodegenBinding.CLOSURE, descriptor.getContainingDeclaration()));
        if (callableMethod == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/state/JetTypeMapper", "mapToCallableMethod"));
        }
        return callableMethod;
    }

    @NotNull
    public CallableMethod mapToCallableMethod(@NotNull ConstructorDescriptor descriptor, @Nullable CalculatedClosure closure) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/codegen/state/JetTypeMapper", "mapToCallableMethod"));
        }
        JvmMethodSignature method = this.mapConstructorSignature(descriptor, closure);
        ClassDescriptor container = descriptor.getContainingDeclaration();
        Type owner = this.mapClass(container);
        if (owner.getSort() != 10) {
            throw new IllegalStateException("type must have been mapped to object: " + container.getDefaultType() + ", actual: " + owner);
        }
        CallableMethod callableMethod = new CallableMethod(owner, owner, owner, method, 183, null, null, null);
        if (callableMethod == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/state/JetTypeMapper", "mapToCallableMethod"));
        }
        return callableMethod;
    }

    private static boolean isGenericsArray(JetType type) {
        return KotlinBuiltIns.getInstance().isArray(type) && type.getArguments().get(0).getType().getConstructor().getDeclarationDescriptor() instanceof TypeParameterDescriptor;
    }

    public Type getSharedVarType(DeclarationDescriptor descriptor) {
        if (descriptor instanceof PropertyDescriptor) {
            return StackValue.sharedTypeForType(this.mapType(((PropertyDescriptor)descriptor).getReceiverParameter().getType()));
        }
        if (descriptor instanceof SimpleFunctionDescriptor && descriptor.getContainingDeclaration() instanceof FunctionDescriptor) {
            return CodegenBinding.asmTypeForAnonymousClass(this.bindingContext, (FunctionDescriptor)descriptor);
        }
        if (descriptor instanceof FunctionDescriptor) {
            return StackValue.sharedTypeForType(this.mapType(((FunctionDescriptor)descriptor).getReceiverParameter().getType()));
        }
        if (descriptor instanceof VariableDescriptor && CodegenBinding.isVarCapturedInClosure(this.bindingContext, descriptor)) {
            JetType outType = ((VariableDescriptor)descriptor).getType();
            return StackValue.sharedTypeForType(this.mapType(outType));
        }
        return null;
    }

    @NotNull
    public CallableMethod mapToFunctionInvokeCallableMethod(@NotNull FunctionDescriptor fd) {
        if (fd == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fd", "org/jetbrains/jet/codegen/state/JetTypeMapper", "mapToFunctionInvokeCallableMethod"));
        }
        JvmMethodSignature descriptor = CodegenUtil.erasedInvokeSignature(fd);
        Type owner = FunctionTypesUtil.getFunctionTraitClassName(fd);
        ReceiverParameterDescriptor receiverParameter = fd.getOriginal().getReceiverParameter();
        Type receiverParameterType = receiverParameter != null ? this.mapType(receiverParameter.getType()) : null;
        CallableMethod callableMethod = new CallableMethod(owner, null, null, descriptor, 185, owner, receiverParameterType, owner);
        if (callableMethod == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/state/JetTypeMapper", "mapToFunctionInvokeCallableMethod"));
        }
        return callableMethod;
    }

    @NotNull
    public Type expressionType(JetExpression expr) {
        JetType type = this.bindingContext.get(BindingContext.EXPRESSION_TYPE, expr);
        Type type2 = this.asmTypeOrVoid(type);
        if (type2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/state/JetTypeMapper", "expressionType"));
        }
        return type2;
    }

    @NotNull
    private Type asmTypeOrVoid(@Nullable JetType type) {
        Type type2 = type == null ? Type.VOID_TYPE : this.mapType(type);
        if (type2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/state/JetTypeMapper", "asmTypeOrVoid"));
        }
        return type2;
    }

    private static enum JetTypeMapperMode {
        IMPL,
        VALUE,
        TYPE_PARAMETER,
        SUPER_TYPE;

    }
}

