/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.StripedLockIntObjectConcurrentHashMap;
import java.lang.ref.ReferenceQueue;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.jetbrains.annotations.NotNull;

abstract class ConcurrentRefValueIntObjectHashMap<V> {
    private final StripedLockIntObjectConcurrentHashMap<IntReference<V>> myMap = new StripedLockIntObjectConcurrentHashMap();
    private final ReferenceQueue<V> myQueue = new ReferenceQueue();

    ConcurrentRefValueIntObjectHashMap() {
    }

    protected abstract IntReference<V> createReference(int var1, @NotNull V var2, ReferenceQueue<V> var3);

    private void processQueue() {
        IntReference ref;
        while ((ref = (IntReference)((Object)this.myQueue.poll())) != null) {
            int key = ref.getKey();
            this.myMap.remove(key, ref);
        }
        return;
    }

    public V put(int key, @NotNull V value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/util/containers/ConcurrentRefValueIntObjectHashMap", "put"));
        }
        this.processQueue();
        IntReference<V> ref = this.myMap.put(key, this.createReference(key, value, this.myQueue));
        return ref == null ? null : (V)ref.get();
    }

    public V get(int key) {
        IntReference<V> ref = this.myMap.get(key);
        return ref == null ? null : (V)ref.get();
    }

    @NotNull
    public Iterable<StripedLockIntObjectConcurrentHashMap.IntEntry<V>> entries() {
        final Iterator<StripedLockIntObjectConcurrentHashMap.IntEntry<IntReference<V>>> entryIterator = this.myMap.entries().iterator();
        Iterable iterable = new Iterable<StripedLockIntObjectConcurrentHashMap.IntEntry<V>>(){

            @Override
            public Iterator<StripedLockIntObjectConcurrentHashMap.IntEntry<V>> iterator() {
                return new Iterator<StripedLockIntObjectConcurrentHashMap.IntEntry<V>>(){
                    StripedLockIntObjectConcurrentHashMap.IntEntry<V> next = this.nextAliveEntry();

                    @Override
                    public boolean hasNext() {
                        return this.next != null;
                    }

                    @Override
                    public StripedLockIntObjectConcurrentHashMap.IntEntry<V> next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        StripedLockIntObjectConcurrentHashMap.IntEntry result = this.next;
                        this.next = this.nextAliveEntry();
                        return result;
                    }

                    private StripedLockIntObjectConcurrentHashMap.IntEntry<V> nextAliveEntry() {
                        while (entryIterator.hasNext()) {
                            StripedLockIntObjectConcurrentHashMap.IntEntry entry = (StripedLockIntObjectConcurrentHashMap.IntEntry)entryIterator.next();
                            final Object v = ((IntReference)entry.getValue()).get();
                            if (v == null) continue;
                            final int key = entry.getKey();
                            return new StripedLockIntObjectConcurrentHashMap.IntEntry<V>(){

                                @Override
                                public int getKey() {
                                    return key;
                                }

                                @Override
                                @NotNull
                                public V getValue() {
                                    Object object2 = v;
                                    if (object2 == null) {
                                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ConcurrentRefValueIntObjectHashMap$1$1$1", "getValue"));
                                    }
                                    return object2;
                                }
                            };
                        }
                        return null;
                    }

                    @Override
                    public void remove() {
                        throw new IncorrectOperationException("not implemented");
                    }
                };
            }
        };
        if (iterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ConcurrentRefValueIntObjectHashMap", "entries"));
        }
        return iterable;
    }

    protected static interface IntReference<V> {
        public int getKey();

        public V get();
    }
}

