/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.util.containers.EmptyIterator;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.jetbrains.annotations.NotNull;

public class SmartList<E>
extends AbstractList<E> {
    private int mySize;
    private Object myElem;

    public SmartList() {
        this.mySize = 0;
        this.myElem = null;
    }

    public SmartList(E element) {
        this.mySize = 0;
        this.myElem = null;
        this.add(element);
    }

    public SmartList(@NotNull Collection<? extends E> elements) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/SmartList", "<init>"));
        }
        this.mySize = 0;
        this.myElem = null;
        int size = elements.size();
        if (size == 1) {
            E element = elements instanceof List ? ((List)elements).get(0) : elements.iterator().next();
            this.add(element);
        } else if (size > 0) {
            this.mySize = size;
            this.myElem = elements.toArray(new Object[size]);
        }
    }

    @Override
    public E get(int index) {
        if (index < 0 || index >= this.mySize) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.mySize);
        }
        if (this.mySize == 1) {
            return (E)this.myElem;
        }
        return (E)((Object[])this.myElem)[index];
    }

    @Override
    public boolean add(E e) {
        if (this.mySize == 0) {
            this.myElem = e;
        } else if (this.mySize == 1) {
            Object[] array = new Object[]{this.myElem, e};
            this.myElem = array;
        } else {
            Object[] array = (Object[])this.myElem;
            int oldCapacity = array.length;
            if (this.mySize >= oldCapacity) {
                int newCapacity = oldCapacity * 3 / 2 + 1;
                int minCapacity = this.mySize + 1;
                if (newCapacity < minCapacity) {
                    newCapacity = minCapacity;
                }
                Object[] oldArray = array;
                array = new Object[newCapacity];
                this.myElem = array;
                System.arraycopy(oldArray, 0, array, 0, oldCapacity);
            }
            array[this.mySize] = e;
        }
        ++this.mySize;
        ++this.modCount;
        return true;
    }

    @Override
    public void add(int index, E e) {
        if (index < 0 || index > this.mySize) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.mySize);
        }
        if (this.mySize == 0) {
            this.myElem = e;
        } else if (this.mySize == 1 && index == 0) {
            Object[] array = new Object[]{e, this.myElem};
            this.myElem = array;
        } else {
            Object[] array = new Object[this.mySize + 1];
            if (this.mySize == 1) {
                array[0] = this.myElem;
            } else {
                Object[] oldArray = (Object[])this.myElem;
                System.arraycopy(oldArray, 0, array, 0, index);
                System.arraycopy(oldArray, index, array, index + 1, this.mySize - index);
            }
            array[index] = e;
            this.myElem = array;
        }
        ++this.mySize;
        ++this.modCount;
    }

    @Override
    public int size() {
        return this.mySize;
    }

    @Override
    public void clear() {
        this.myElem = null;
        this.mySize = 0;
        ++this.modCount;
    }

    @Override
    public E set(int index, E element) {
        Object oldValue;
        if (index < 0 || index >= this.mySize) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.mySize);
        }
        if (this.mySize == 1) {
            oldValue = this.myElem;
            this.myElem = element;
        } else {
            Object[] array = (Object[])this.myElem;
            oldValue = array[index];
            array[index] = element;
        }
        return (E)oldValue;
    }

    @Override
    public E remove(int index) {
        Object oldValue;
        if (index < 0 || index >= this.mySize) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.mySize);
        }
        if (this.mySize == 1) {
            oldValue = this.myElem;
            this.myElem = null;
        } else {
            Object[] array = (Object[])this.myElem;
            oldValue = array[index];
            if (this.mySize == 2) {
                this.myElem = array[1 - index];
            } else {
                int numMoved = this.mySize - index - 1;
                if (numMoved > 0) {
                    System.arraycopy(array, index + 1, array, index, numMoved);
                }
                array[this.mySize - 1] = null;
            }
        }
        --this.mySize;
        ++this.modCount;
        return (E)oldValue;
    }

    @Override
    @NotNull
    public Iterator<E> iterator() {
        if (this.mySize == 0) {
            EmptyIterator emptyIterator = EmptyIterator.getInstance();
            if (emptyIterator == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/SmartList", "iterator"));
            }
            return emptyIterator;
        }
        if (this.mySize == 1) {
            SingletonIterator singletonIterator = new SingletonIterator();
            if (singletonIterator == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/SmartList", "iterator"));
            }
            return singletonIterator;
        }
        Iterator iterator2 = super.iterator();
        if (iterator2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/SmartList", "iterator"));
        }
        return iterator2;
    }

    @Override
    @NotNull
    public <T> T[] toArray(@NotNull T[] a) {
        int length;
        if (a == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/SmartList", "toArray"));
        }
        if (this.mySize == 1 && (length = a.length) != 0) {
            a[0] = this.myElem;
            if (length > 1) {
                a[1] = null;
            }
            if (a == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/SmartList", "toArray"));
            }
            return a;
        }
        T[] TArray = super.toArray(a);
        if (TArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/SmartList", "toArray"));
        }
        return TArray;
    }

    public void trimToSize() {
        if (this.mySize < 2) {
            return;
        }
        Object[] array = (Object[])this.myElem;
        int oldCapacity = array.length;
        if (this.mySize < oldCapacity) {
            ++this.modCount;
            this.myElem = Arrays.copyOf(array, this.mySize);
        }
    }

    private class SingletonIterator
    implements Iterator<E> {
        private boolean myVisited;
        private final int myInitialModCount;

        public SingletonIterator() {
            this.myInitialModCount = SmartList.this.modCount;
        }

        @Override
        public boolean hasNext() {
            return !this.myVisited;
        }

        @Override
        public E next() {
            if (this.myVisited) {
                throw new NoSuchElementException();
            }
            this.myVisited = true;
            if (SmartList.this.modCount != this.myInitialModCount) {
                throw new ConcurrentModificationException("ModCount: " + SmartList.this.modCount + "; expected: " + this.myInitialModCount);
            }
            return SmartList.this.myElem;
        }

        @Override
        public void remove() {
            if (SmartList.this.modCount != this.myInitialModCount) {
                throw new ConcurrentModificationException("ModCount: " + SmartList.this.modCount + "; expected: " + this.myInitialModCount);
            }
            SmartList.this.clear();
        }
    }
}

