/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.compiled;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.impl.compiled.ClsStubBuilderFactory;
import com.intellij.psi.impl.compiled.InnerClassSourceStrategy;
import com.intellij.psi.impl.compiled.OutOfOrderInnerClassException;
import com.intellij.psi.impl.compiled.StubBuildingVisitor;
import com.intellij.psi.impl.java.stubs.PsiClassStub;
import com.intellij.psi.impl.java.stubs.impl.PsiJavaFileStubImpl;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.util.cls.ClsFormatException;
import java.io.IOException;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.asm4.ClassReader;

public class DefaultClsStubBuilderFactory
extends ClsStubBuilderFactory {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.compiled.DefaultClsStubBuilderFactory");

    public PsiFileStub buildFileStub(VirtualFile vFile, byte[] bytes) throws ClsFormatException {
        PsiJavaFileStubImpl file = new PsiJavaFileStubImpl("do.not.know.yet", true);
        try {
            ClassReader reader = new ClassReader(bytes);
            StubBuildingVisitor<VirtualFile> classVisitor = new StubBuildingVisitor<VirtualFile>(vFile, VirtualFileInnerClassStrategy.INSTANCE, file, 0, null);
            try {
                reader.accept(classVisitor, 4);
            }
            catch (OutOfOrderInnerClassException e) {
                return null;
            }
            PsiClassStub<PsiClass> result = classVisitor.getResult();
            if (result == null) {
                return null;
            }
            file.setPackageName(DefaultClsStubBuilderFactory.getPackageName(result));
            return file;
        }
        catch (Exception e) {
            LOG.debug(vFile.getPath(), e);
            throw new ClsFormatException();
        }
    }

    @Override
    public boolean canBeProcessed(VirtualFile file, byte[] bytes) {
        return true;
    }

    @Override
    public boolean isInnerClass(VirtualFile file) {
        String name = file.getNameWithoutExtension();
        int len = name.length();
        int idx = name.indexOf(36);
        while (idx > 0) {
            if (idx + 1 < len && Character.isDigit(name.charAt(idx + 1))) {
                return true;
            }
            idx = name.indexOf(36, idx + 1);
        }
        return false;
    }

    private static String getPackageName(PsiClassStub<PsiClass> result) {
        String fqn = result.getQualifiedName();
        String shortName = result.getName();
        if (fqn == null || Comparing.equal(shortName, fqn)) {
            return "";
        }
        return fqn.substring(0, fqn.lastIndexOf(46));
    }

    private static class VirtualFileInnerClassStrategy
    implements InnerClassSourceStrategy<VirtualFile> {
        public static VirtualFileInnerClassStrategy INSTANCE = new VirtualFileInnerClassStrategy();

        private VirtualFileInnerClassStrategy() {
        }

        @Override
        @Nullable
        public VirtualFile findInnerClass(String innerName, VirtualFile outerClass) {
            String baseName = outerClass.getNameWithoutExtension();
            VirtualFile dir = outerClass.getParent();
            assert (dir != null);
            return dir.findChild(baseName + "$" + innerName + ".class");
        }

        @Override
        @Nullable
        public ClassReader readerForInnerClass(VirtualFile innerClass) {
            try {
                return new ClassReader(innerClass.contentsToByteArray());
            }
            catch (IOException e) {
                return null;
            }
        }
    }
}

