/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.util;

import jet.Function0;
import jet.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.storage.LockBasedStorageManager;
import org.jetbrains.jet.storage.NotNullLazyValue;
import org.jetbrains.jet.util.ReenteringLazyValueComputationException;

public class StorageUtil {
    private static final Function1 EMPTY_CONSUMER = new Function1<Object, Void>(){

        @Override
        public Void invoke(Object t) {
            return null;
        }
    };

    public static <T> NotNullLazyValue<T> createRecursionIntolerantLazyValueWithDefault(final @NotNull T defaultValue, @NotNull Function0<T> compute) {
        if (defaultValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultValue", "org/jetbrains/jet/util/StorageUtil", "createRecursionIntolerantLazyValueWithDefault"));
        }
        if (compute == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compute", "org/jetbrains/jet/util/StorageUtil", "createRecursionIntolerantLazyValueWithDefault"));
        }
        return LockBasedStorageManager.NO_LOCKS.createLazyValueWithPostCompute(compute, new Function1<Boolean, T>(){

            @Override
            public T invoke(Boolean firstTime) {
                if (firstTime.booleanValue()) {
                    throw new ReenteringLazyValueComputationException();
                }
                return defaultValue;
            }
        }, EMPTY_CONSUMER);
    }
}

