/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.types.checker;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeConstructor;
import org.jetbrains.jet.lang.types.checker.TypeCheckingProcedure;
import org.jetbrains.jet.lang.types.checker.TypingConstraints;

public class JetTypeChecker {
    public static final JetTypeChecker INSTANCE = new JetTypeChecker();
    public static final HashBiMap<TypeConstructor, TypeConstructor> EMPTY_AXIOMS = HashBiMap.create();
    private static final TypeCheckingProcedure TYPE_CHECKER = new TypeCheckingProcedure(new TypeCheckerTypingConstraints());

    private JetTypeChecker() {
    }

    public boolean isSubtypeOf(@NotNull JetType subtype, @NotNull JetType supertype) {
        if (subtype == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subtype", "org/jetbrains/jet/lang/types/checker/JetTypeChecker", "isSubtypeOf"));
        }
        if (supertype == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "supertype", "org/jetbrains/jet/lang/types/checker/JetTypeChecker", "isSubtypeOf"));
        }
        return TYPE_CHECKER.isSubtypeOf(subtype, supertype);
    }

    public boolean equalTypes(@NotNull JetType a, @NotNull JetType b) {
        if (a == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "a", "org/jetbrains/jet/lang/types/checker/JetTypeChecker", "equalTypes"));
        }
        if (b == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "b", "org/jetbrains/jet/lang/types/checker/JetTypeChecker", "equalTypes"));
        }
        return TYPE_CHECKER.equalTypes(a, b);
    }

    public boolean equalTypes(@NotNull JetType a, @NotNull JetType b, final @NotNull BiMap<TypeConstructor, TypeConstructor> equalityAxioms) {
        if (a == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "a", "org/jetbrains/jet/lang/types/checker/JetTypeChecker", "equalTypes"));
        }
        if (b == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "b", "org/jetbrains/jet/lang/types/checker/JetTypeChecker", "equalTypes"));
        }
        if (equalityAxioms == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "equalityAxioms", "org/jetbrains/jet/lang/types/checker/JetTypeChecker", "equalTypes"));
        }
        return new TypeCheckingProcedure(new TypeCheckerTypingConstraints(){

            @Override
            public boolean assertEqualTypeConstructors(@NotNull TypeConstructor constructor1, @NotNull TypeConstructor constructor2) {
                if (constructor1 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructor1", "org/jetbrains/jet/lang/types/checker/JetTypeChecker$1", "assertEqualTypeConstructors"));
                }
                if (constructor2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructor2", "org/jetbrains/jet/lang/types/checker/JetTypeChecker$1", "assertEqualTypeConstructors"));
                }
                if (!constructor1.equals(constructor2)) {
                    TypeConstructor img1 = (TypeConstructor)equalityAxioms.get(constructor1);
                    TypeConstructor img2 = (TypeConstructor)equalityAxioms.get(constructor2);
                    if (!(img1 != null && img1.equals(constructor2) || img2 != null && img2.equals(constructor1))) {
                        return false;
                    }
                }
                return true;
            }
        }).equalTypes(a, b);
    }

    private static class TypeCheckerTypingConstraints
    implements TypingConstraints {
        private TypeCheckerTypingConstraints() {
        }

        @Override
        public boolean assertEqualTypes(@NotNull JetType a, @NotNull JetType b, @NotNull TypeCheckingProcedure typeCheckingProcedure) {
            if (a == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "a", "org/jetbrains/jet/lang/types/checker/JetTypeChecker$TypeCheckerTypingConstraints", "assertEqualTypes"));
            }
            if (b == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "b", "org/jetbrains/jet/lang/types/checker/JetTypeChecker$TypeCheckerTypingConstraints", "assertEqualTypes"));
            }
            if (typeCheckingProcedure == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeCheckingProcedure", "org/jetbrains/jet/lang/types/checker/JetTypeChecker$TypeCheckerTypingConstraints", "assertEqualTypes"));
            }
            return typeCheckingProcedure.equalTypes(a, b);
        }

        @Override
        public boolean assertEqualTypeConstructors(@NotNull TypeConstructor a, @NotNull TypeConstructor b) {
            if (a == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "a", "org/jetbrains/jet/lang/types/checker/JetTypeChecker$TypeCheckerTypingConstraints", "assertEqualTypeConstructors"));
            }
            if (b == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "b", "org/jetbrains/jet/lang/types/checker/JetTypeChecker$TypeCheckerTypingConstraints", "assertEqualTypeConstructors"));
            }
            return a.equals(b);
        }

        @Override
        public boolean assertSubtype(@NotNull JetType subtype, @NotNull JetType supertype, @NotNull TypeCheckingProcedure typeCheckingProcedure) {
            if (subtype == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subtype", "org/jetbrains/jet/lang/types/checker/JetTypeChecker$TypeCheckerTypingConstraints", "assertSubtype"));
            }
            if (supertype == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "supertype", "org/jetbrains/jet/lang/types/checker/JetTypeChecker$TypeCheckerTypingConstraints", "assertSubtype"));
            }
            if (typeCheckingProcedure == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeCheckingProcedure", "org/jetbrains/jet/lang/types/checker/JetTypeChecker$TypeCheckerTypingConstraints", "assertSubtype"));
            }
            return typeCheckingProcedure.isSubtypeOf(subtype, supertype);
        }

        @Override
        public boolean noCorrespondingSupertype(@NotNull JetType subtype, @NotNull JetType supertype) {
            if (subtype == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subtype", "org/jetbrains/jet/lang/types/checker/JetTypeChecker$TypeCheckerTypingConstraints", "noCorrespondingSupertype"));
            }
            if (supertype == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "supertype", "org/jetbrains/jet/lang/types/checker/JetTypeChecker$TypeCheckerTypingConstraints", "noCorrespondingSupertype"));
            }
            return false;
        }
    }
}

