/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.lazy;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.resolve.lazy.LazyDescriptor;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.types.TypeConstructor;

public class ForceResolveUtil {
    private ForceResolveUtil() {
    }

    public static void forceResolveAllContents(@NotNull DeclarationDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/resolve/lazy/ForceResolveUtil", "forceResolveAllContents"));
        }
        if (descriptor instanceof LazyDescriptor) {
            LazyDescriptor lazyDescriptor = (LazyDescriptor)((Object)descriptor);
            lazyDescriptor.forceResolveAllContents();
        }
    }

    public static void forceResolveAllContents(@NotNull JetScope scope) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/jet/lang/resolve/lazy/ForceResolveUtil", "forceResolveAllContents"));
        }
        for (DeclarationDescriptor descriptor : scope.getAllDescriptors()) {
            ForceResolveUtil.forceResolveAllContents(descriptor);
        }
    }

    public static void forceResolveAllContents(@NotNull TypeConstructor typeConstructor) {
        if (typeConstructor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeConstructor", "org/jetbrains/jet/lang/resolve/lazy/ForceResolveUtil", "forceResolveAllContents"));
        }
        if (typeConstructor instanceof LazyDescriptor) {
            LazyDescriptor lazyConstructor = (LazyDescriptor)((Object)typeConstructor);
            lazyConstructor.forceResolveAllContents();
        }
    }
}

