/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.kotlin;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jet.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.descriptors.serialization.JavaProtoBuf;
import org.jetbrains.jet.descriptors.serialization.NameResolver;
import org.jetbrains.jet.descriptors.serialization.ProtoBuf;
import org.jetbrains.jet.descriptors.serialization.descriptors.AnnotationDeserializer;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassKind;
import org.jetbrains.jet.lang.descriptors.ClassOrNamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptorImpl;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.constants.CompileTimeConstant;
import org.jetbrains.jet.lang.resolve.constants.EnumValue;
import org.jetbrains.jet.lang.resolve.constants.ErrorValue;
import org.jetbrains.jet.lang.resolve.java.DescriptorSearchRule;
import org.jetbrains.jet.lang.resolve.java.JvmAnnotationNames;
import org.jetbrains.jet.lang.resolve.java.JvmClassName;
import org.jetbrains.jet.lang.resolve.java.PackageClassUtils;
import org.jetbrains.jet.lang.resolve.java.resolver.DescriptorResolverUtils;
import org.jetbrains.jet.lang.resolve.java.resolver.ErrorReporter;
import org.jetbrains.jet.lang.resolve.java.resolver.JavaAnnotationArgumentResolver;
import org.jetbrains.jet.lang.resolve.java.resolver.JavaAnnotationResolver;
import org.jetbrains.jet.lang.resolve.java.resolver.JavaClassResolver;
import org.jetbrains.jet.lang.resolve.kotlin.DeserializedResolverUtils;
import org.jetbrains.jet.lang.resolve.kotlin.KotlinClassFinder;
import org.jetbrains.jet.lang.resolve.kotlin.KotlinJvmBinaryClass;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.types.ErrorUtils;
import org.jetbrains.jet.storage.LockBasedStorageManager;
import org.jetbrains.jet.storage.MemoizedFunctionToNotNull;

public class AnnotationDescriptorDeserializer
implements AnnotationDeserializer {
    private JavaClassResolver javaClassResolver;
    private KotlinClassFinder kotlinClassFinder;
    private ErrorReporter errorReporter;
    private final LockBasedStorageManager storageManager = new LockBasedStorageManager();
    private final MemoizedFunctionToNotNull<KotlinJvmBinaryClass, Map<MemberSignature, List<AnnotationDescriptor>>> memberAnnotations = this.storageManager.createMemoizedFunction(new Function1<KotlinJvmBinaryClass, Map<MemberSignature, List<AnnotationDescriptor>>>(){

        @Override
        @NotNull
        public Map<MemberSignature, List<AnnotationDescriptor>> invoke(@NotNull KotlinJvmBinaryClass kotlinClass) {
            Map map;
            if (kotlinClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kotlinClass", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer$1", "invoke"));
            }
            try {
                map = AnnotationDescriptorDeserializer.this.loadMemberAnnotationsFromClass(kotlinClass);
            }
            catch (IOException e) {
                AnnotationDescriptorDeserializer.this.errorReporter.reportAnnotationLoadingError("Error loading member annotations from Kotlin class: " + kotlinClass, e);
                Map<MemberSignature, List<AnnotationDescriptor>> map2 = Collections.emptyMap();
                if (map2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer$1", "invoke"));
                }
                return map2;
            }
            if (map == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer$1", "invoke"));
            }
            return map;
        }
    });

    public void setJavaClassResolver(JavaClassResolver javaClassResolver) {
        this.javaClassResolver = javaClassResolver;
    }

    public void setKotlinClassFinder(KotlinClassFinder kotlinClassFinder) {
        this.kotlinClassFinder = kotlinClassFinder;
    }

    public void setErrorReporter(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
    }

    @Override
    @NotNull
    public List<AnnotationDescriptor> loadClassAnnotations(@NotNull ClassDescriptor descriptor, @NotNull ProtoBuf.Class classProto) {
        List<AnnotationDescriptor> list2;
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer", "loadClassAnnotations"));
        }
        if (classProto == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classProto", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer", "loadClassAnnotations"));
        }
        KotlinJvmBinaryClass kotlinClass = this.findKotlinClassByDescriptor(descriptor);
        if (kotlinClass == null) {
            this.errorReporter.reportAnnotationLoadingError("Kotlin class for loading class annotations is not found: " + descriptor, null);
            List<AnnotationDescriptor> list3 = Collections.emptyList();
            if (list3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer", "loadClassAnnotations"));
            }
            return list3;
        }
        try {
            list2 = this.loadClassAnnotationsFromClass(kotlinClass);
        }
        catch (IOException e) {
            this.errorReporter.reportAnnotationLoadingError("Error loading member annotations from Kotlin class: " + kotlinClass, e);
            List<AnnotationDescriptor> list4 = Collections.emptyList();
            if (list4 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer", "loadClassAnnotations"));
            }
            return list4;
        }
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer", "loadClassAnnotations"));
        }
        return list2;
    }

    @Nullable
    private KotlinJvmBinaryClass findKotlinClassByDescriptor(@NotNull ClassOrNamespaceDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer", "findKotlinClassByDescriptor"));
        }
        if (descriptor instanceof ClassDescriptor) {
            return this.kotlinClassFinder.find(DeserializedResolverUtils.kotlinFqNameToJavaFqName(DeserializedResolverUtils.naiveKotlinFqName((ClassDescriptor)descriptor)));
        }
        if (descriptor instanceof NamespaceDescriptor) {
            return this.kotlinClassFinder.find(PackageClassUtils.getPackageClassFqName(DescriptorUtils.getFQName(descriptor).toSafe()));
        }
        throw new IllegalStateException("Unrecognized descriptor: " + descriptor);
    }

    @NotNull
    private List<AnnotationDescriptor> loadClassAnnotationsFromClass(@NotNull KotlinJvmBinaryClass kotlinClass) throws IOException {
        if (kotlinClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kotlinClass", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer", "loadClassAnnotationsFromClass"));
        }
        final ArrayList<AnnotationDescriptor> result = new ArrayList<AnnotationDescriptor>();
        kotlinClass.loadClassAnnotations(new KotlinJvmBinaryClass.AnnotationVisitor(){

            @Override
            @Nullable
            public KotlinJvmBinaryClass.AnnotationArgumentVisitor visitAnnotation(@NotNull JvmClassName className) {
                if (className == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer$2", "visitAnnotation"));
                }
                return AnnotationDescriptorDeserializer.this.resolveAnnotation(className, result);
            }

            @Override
            public void visitEnd() {
            }
        });
        ArrayList<AnnotationDescriptor> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer", "loadClassAnnotationsFromClass"));
        }
        return arrayList;
    }

    private static boolean ignoreAnnotation(@NotNull JvmClassName className) {
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer", "ignoreAnnotation"));
        }
        return className.equals(JvmClassName.byFqNameWithoutInnerClasses(JvmAnnotationNames.KOTLIN_CLASS)) || className.equals(JvmClassName.byFqNameWithoutInnerClasses(JvmAnnotationNames.KOTLIN_PACKAGE)) || className.equals(JvmClassName.byFqNameWithoutInnerClasses(JavaAnnotationResolver.JETBRAINS_NOT_NULL_ANNOTATION)) || className.equals(JvmClassName.byFqNameWithoutInnerClasses(JavaAnnotationResolver.JETBRAINS_NULLABLE_ANNOTATION)) || className.getInternalName().startsWith("jet/runtime/typeinfo/");
    }

    @Nullable
    private KotlinJvmBinaryClass.AnnotationArgumentVisitor resolveAnnotation(@NotNull JvmClassName className, final @NotNull List<AnnotationDescriptor> result) {
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer", "resolveAnnotation"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer", "resolveAnnotation"));
        }
        if (AnnotationDescriptorDeserializer.ignoreAnnotation(className)) {
            return null;
        }
        final ClassDescriptor annotationClass = this.resolveClass(className);
        final AnnotationDescriptorImpl annotation = new AnnotationDescriptorImpl();
        annotation.setAnnotationType(annotationClass.getDefaultType());
        return new KotlinJvmBinaryClass.AnnotationArgumentVisitor(){

            @Override
            public void visit(@Nullable Name name, @Nullable Object value) {
                if (name != null) {
                    ErrorValue argument = JavaAnnotationArgumentResolver.resolveCompileTimeConstantValue(value, null);
                    this.setArgumentValueByName(name, argument != null ? argument : ErrorValue.create("Unsupported annotation argument: " + name));
                }
            }

            @Override
            public void visitEnum(@NotNull Name name, @NotNull JvmClassName enumClassName, @NotNull Name enumEntryName) {
                if (name == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer$3", "visitEnum"));
                }
                if (enumClassName == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "enumClassName", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer$3", "visitEnum"));
                }
                if (enumEntryName == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "enumEntryName", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer$3", "visitEnum"));
                }
                this.setArgumentValueByName(name, this.enumEntryValue(enumClassName, enumEntryName));
            }

            @Override
            @Nullable
            public KotlinJvmBinaryClass.AnnotationArgumentVisitor visitArray(@NotNull Name name) {
                if (name == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer$3", "visitArray"));
                }
                return null;
            }

            @NotNull
            private CompileTimeConstant<?> enumEntryValue(@NotNull JvmClassName enumClassName, @NotNull Name name) {
                ClassifierDescriptor classifier;
                if (enumClassName == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "enumClassName", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer$3", "enumEntryValue"));
                }
                if (name == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer$3", "enumEntryValue"));
                }
                ClassDescriptor enumClass = AnnotationDescriptorDeserializer.this.resolveClass(enumClassName);
                if (enumClass.getKind() == ClassKind.ENUM_CLASS && (classifier = enumClass.getUnsubstitutedInnerClassesScope().getClassifier(name)) instanceof ClassDescriptor) {
                    EnumValue enumValue = new EnumValue((ClassDescriptor)classifier);
                    if (enumValue == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer$3", "enumEntryValue"));
                    }
                    return enumValue;
                }
                ErrorValue errorValue = ErrorValue.create("Unresolved enum entry: " + enumClassName.getInternalName() + "." + name);
                if (errorValue == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer$3", "enumEntryValue"));
                }
                return errorValue;
            }

            @Override
            public void visitEnd() {
                result.add(annotation);
            }

            private void setArgumentValueByName(@NotNull Name name, @NotNull CompileTimeConstant<?> argumentValue) {
                if (name == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer$3", "setArgumentValueByName"));
                }
                if (argumentValue == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argumentValue", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer$3", "setArgumentValueByName"));
                }
                ValueParameterDescriptor parameter = DescriptorResolverUtils.getAnnotationParameterByName(name, annotationClass);
                if (parameter != null) {
                    annotation.setValueArgument(parameter, argumentValue);
                }
            }
        };
    }

    @NotNull
    private ClassDescriptor resolveClass(@NotNull JvmClassName className) {
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer", "resolveClass"));
        }
        ClassDescriptor annotationClass = this.javaClassResolver.resolveClass(className.getFqNameForClassNameWithoutDollars(), DescriptorSearchRule.IGNORE_KOTLIN_SOURCES);
        ClassDescriptor classDescriptor = annotationClass != null ? annotationClass : ErrorUtils.getErrorClass();
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer", "resolveClass"));
        }
        return classDescriptor;
    }

    @Override
    @NotNull
    public List<AnnotationDescriptor> loadCallableAnnotations(@NotNull ClassOrNamespaceDescriptor container, @NotNull ProtoBuf.Callable proto, @NotNull NameResolver nameResolver, @NotNull AnnotationDeserializer.AnnotatedCallableKind kind) {
        if (container == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "container", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer", "loadCallableAnnotations"));
        }
        if (proto == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "proto", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer", "loadCallableAnnotations"));
        }
        if (nameResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameResolver", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer", "loadCallableAnnotations"));
        }
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer", "loadCallableAnnotations"));
        }
        MemberSignature signature = AnnotationDescriptorDeserializer.getCallableSignature(proto, nameResolver, kind);
        if (signature == null) {
            List<AnnotationDescriptor> list2 = Collections.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer", "loadCallableAnnotations"));
            }
            return list2;
        }
        List<AnnotationDescriptor> list3 = this.findClassAndLoadMemberAnnotations(container, proto, nameResolver, kind, signature);
        if (list3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer", "loadCallableAnnotations"));
        }
        return list3;
    }

    @NotNull
    private List<AnnotationDescriptor> findClassAndLoadMemberAnnotations(@NotNull ClassOrNamespaceDescriptor container, @NotNull ProtoBuf.Callable proto, @NotNull NameResolver nameResolver, @NotNull AnnotationDeserializer.AnnotatedCallableKind kind, @NotNull MemberSignature signature) {
        if (container == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "container", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer", "findClassAndLoadMemberAnnotations"));
        }
        if (proto == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "proto", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer", "findClassAndLoadMemberAnnotations"));
        }
        if (nameResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameResolver", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer", "findClassAndLoadMemberAnnotations"));
        }
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer", "findClassAndLoadMemberAnnotations"));
        }
        if (signature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signature", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer", "findClassAndLoadMemberAnnotations"));
        }
        KotlinJvmBinaryClass kotlinClass = this.findClassWithMemberAnnotations(container, proto, nameResolver, kind);
        if (kotlinClass == null) {
            this.errorReporter.reportAnnotationLoadingError("Kotlin class for loading member annotations is not found: " + container, null);
            List<AnnotationDescriptor> list2 = Collections.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer", "findClassAndLoadMemberAnnotations"));
            }
            return list2;
        }
        List annotations = (List)((Map)this.memberAnnotations.invoke(kotlinClass)).get(signature);
        List list3 = annotations == null ? Collections.emptyList() : annotations;
        if (list3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer", "findClassAndLoadMemberAnnotations"));
        }
        return list3;
    }

    @Nullable
    private KotlinJvmBinaryClass findClassWithMemberAnnotations(@NotNull ClassOrNamespaceDescriptor container, @NotNull ProtoBuf.Callable proto, @NotNull NameResolver nameResolver, @NotNull AnnotationDeserializer.AnnotatedCallableKind kind) {
        if (container == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "container", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer", "findClassWithMemberAnnotations"));
        }
        if (proto == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "proto", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer", "findClassWithMemberAnnotations"));
        }
        if (nameResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameResolver", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer", "findClassWithMemberAnnotations"));
        }
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer", "findClassWithMemberAnnotations"));
        }
        if (container instanceof NamespaceDescriptor) {
            return this.loadPackageFragmentClassFqName((NamespaceDescriptor)container, proto, nameResolver);
        }
        if (DescriptorUtils.isClassObject(container) && AnnotationDescriptorDeserializer.isStaticFieldInOuter(proto)) {
            return this.findKotlinClassByDescriptor((ClassOrNamespaceDescriptor)container.getContainingDeclaration());
        }
        if (DescriptorUtils.isTrait(container) && kind == AnnotationDeserializer.AnnotatedCallableKind.PROPERTY) {
            NamespaceDescriptor containingPackage = DescriptorUtils.getParentOfType(container, NamespaceDescriptor.class);
            assert (containingPackage != null) : "Trait must have a namespace among his parents: " + container;
            if (proto.hasExtension(JavaProtoBuf.implClassName)) {
                Name tImplName = nameResolver.getName(proto.getExtension(JavaProtoBuf.implClassName));
                return this.kotlinClassFinder.find(containingPackage.getFqName().child(tImplName));
            }
            return null;
        }
        return this.findKotlinClassByDescriptor(container);
    }

    @Nullable
    private KotlinJvmBinaryClass loadPackageFragmentClassFqName(@NotNull NamespaceDescriptor container, @NotNull ProtoBuf.Callable proto, @NotNull NameResolver nameResolver) {
        if (container == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "container", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer", "loadPackageFragmentClassFqName"));
        }
        if (proto == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "proto", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer", "loadPackageFragmentClassFqName"));
        }
        if (nameResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameResolver", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer", "loadPackageFragmentClassFqName"));
        }
        if (proto.hasExtension(JavaProtoBuf.implClassName)) {
            Name name = nameResolver.getName(proto.getExtension(JavaProtoBuf.implClassName));
            FqName fqName = PackageClassUtils.getPackageClassFqName(container.getFqName()).parent().child(name);
            return this.kotlinClassFinder.find(fqName);
        }
        return null;
    }

    private static boolean isStaticFieldInOuter(@NotNull ProtoBuf.Callable proto) {
        if (proto == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "proto", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer", "isStaticFieldInOuter"));
        }
        if (!proto.hasExtension(JavaProtoBuf.propertySignature)) {
            return false;
        }
        JavaProtoBuf.JavaPropertySignature propertySignature = proto.getExtension(JavaProtoBuf.propertySignature);
        return propertySignature.hasField() && propertySignature.getField().getIsStaticInOuter();
    }

    @Nullable
    private static MemberSignature getCallableSignature(@NotNull ProtoBuf.Callable proto, @NotNull NameResolver nameResolver, @NotNull AnnotationDeserializer.AnnotatedCallableKind kind) {
        if (proto == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "proto", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer", "getCallableSignature"));
        }
        if (nameResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameResolver", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer", "getCallableSignature"));
        }
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer", "getCallableSignature"));
        }
        SignatureDeserializer deserializer = new SignatureDeserializer(nameResolver);
        switch (kind) {
            case FUNCTION: {
                if (!proto.hasExtension(JavaProtoBuf.methodSignature)) break;
                return deserializer.methodSignature(proto.getExtension(JavaProtoBuf.methodSignature));
            }
            case PROPERTY_GETTER: {
                if (!proto.hasExtension(JavaProtoBuf.propertySignature)) break;
                return deserializer.methodSignature(proto.getExtension(JavaProtoBuf.propertySignature).getGetter());
            }
            case PROPERTY_SETTER: {
                if (!proto.hasExtension(JavaProtoBuf.propertySignature)) break;
                return deserializer.methodSignature(proto.getExtension(JavaProtoBuf.propertySignature).getSetter());
            }
            case PROPERTY: {
                if (!proto.hasExtension(JavaProtoBuf.propertySignature)) break;
                JavaProtoBuf.JavaPropertySignature propertySignature = proto.getExtension(JavaProtoBuf.propertySignature);
                if (propertySignature.hasField()) {
                    JavaProtoBuf.JavaFieldSignature field = propertySignature.getField();
                    String type = deserializer.typeDescriptor(field.getType());
                    Name name = nameResolver.getName(field.getName());
                    return MemberSignature.fromFieldNameAndDesc(name, type);
                }
                if (!propertySignature.hasSyntheticMethod()) break;
                return deserializer.methodSignature(propertySignature.getSyntheticMethod());
            }
        }
        return null;
    }

    @NotNull
    private Map<MemberSignature, List<AnnotationDescriptor>> loadMemberAnnotationsFromClass(@NotNull KotlinJvmBinaryClass kotlinClass) throws IOException {
        if (kotlinClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kotlinClass", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer", "loadMemberAnnotationsFromClass"));
        }
        final HashMap<MemberSignature, List<AnnotationDescriptor>> memberAnnotations = new HashMap<MemberSignature, List<AnnotationDescriptor>>();
        kotlinClass.loadMemberAnnotations(new KotlinJvmBinaryClass.MemberVisitor(){

            @Override
            @Nullable
            public KotlinJvmBinaryClass.MethodAnnotationVisitor visitMethod(@NotNull Name name, @NotNull String desc) {
                if (name == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer$4", "visitMethod"));
                }
                if (desc == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "desc", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer$4", "visitMethod"));
                }
                return new AnnotationVisitorForMethod(MemberSignature.fromMethodNameAndDesc(name, desc));
            }

            @Override
            @Nullable
            public KotlinJvmBinaryClass.AnnotationVisitor visitField(@NotNull Name name, @NotNull String desc) {
                if (name == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer$4", "visitField"));
                }
                if (desc == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "desc", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer$4", "visitField"));
                }
                return new MemberAnnotationVisitor(MemberSignature.fromFieldNameAndDesc(name, desc));
            }

            class MemberAnnotationVisitor
            implements KotlinJvmBinaryClass.AnnotationVisitor {
                private final List<AnnotationDescriptor> result;
                protected final MemberSignature signature;

                public MemberAnnotationVisitor(@NotNull MemberSignature signature) {
                    if (signature == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signature", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer$4$MemberAnnotationVisitor", "<init>"));
                    }
                    this.result = new ArrayList<AnnotationDescriptor>();
                    this.signature = signature;
                }

                @Override
                @Nullable
                public KotlinJvmBinaryClass.AnnotationArgumentVisitor visitAnnotation(@NotNull JvmClassName className) {
                    if (className == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer$4$MemberAnnotationVisitor", "visitAnnotation"));
                    }
                    return AnnotationDescriptorDeserializer.this.resolveAnnotation(className, this.result);
                }

                @Override
                public void visitEnd() {
                    if (!this.result.isEmpty()) {
                        memberAnnotations.put(this.signature, this.result);
                    }
                }
            }

            class AnnotationVisitorForMethod
            extends MemberAnnotationVisitor
            implements KotlinJvmBinaryClass.MethodAnnotationVisitor {
                public AnnotationVisitorForMethod(@NotNull MemberSignature signature) {
                    if (signature == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signature", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer$4$AnnotationVisitorForMethod", "<init>"));
                    }
                    super(signature);
                }

                @Override
                @Nullable
                public KotlinJvmBinaryClass.AnnotationArgumentVisitor visitParameterAnnotation(int index, @NotNull JvmClassName className) {
                    if (className == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer$4$AnnotationVisitorForMethod", "visitParameterAnnotation"));
                    }
                    MemberSignature paramSignature = MemberSignature.fromMethodSignatureAndParameterIndex(this.signature, index);
                    ArrayList result = (ArrayList)memberAnnotations.get(paramSignature);
                    if (result == null) {
                        result = new ArrayList();
                        memberAnnotations.put(paramSignature, result);
                    }
                    return AnnotationDescriptorDeserializer.this.resolveAnnotation(className, result);
                }
            }
        });
        HashMap<MemberSignature, List<AnnotationDescriptor>> hashMap = memberAnnotations;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer", "loadMemberAnnotationsFromClass"));
        }
        return hashMap;
    }

    @Override
    @NotNull
    public List<AnnotationDescriptor> loadValueParameterAnnotations(@NotNull ClassOrNamespaceDescriptor container, @NotNull ProtoBuf.Callable callable2, @NotNull NameResolver nameResolver, @NotNull AnnotationDeserializer.AnnotatedCallableKind kind, @NotNull ProtoBuf.Callable.ValueParameter proto) {
        if (container == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "container", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer", "loadValueParameterAnnotations"));
        }
        if (callable2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callable", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer", "loadValueParameterAnnotations"));
        }
        if (nameResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameResolver", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer", "loadValueParameterAnnotations"));
        }
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer", "loadValueParameterAnnotations"));
        }
        if (proto == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "proto", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer", "loadValueParameterAnnotations"));
        }
        MemberSignature methodSignature = AnnotationDescriptorDeserializer.getCallableSignature(callable2, nameResolver, kind);
        if (methodSignature != null && proto.hasExtension(JavaProtoBuf.index)) {
            MemberSignature paramSignature = MemberSignature.fromMethodSignatureAndParameterIndex(methodSignature, proto.getExtension(JavaProtoBuf.index));
            List<AnnotationDescriptor> list2 = this.findClassAndLoadMemberAnnotations(container, callable2, nameResolver, kind, paramSignature);
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer", "loadValueParameterAnnotations"));
            }
            return list2;
        }
        List<AnnotationDescriptor> list3 = Collections.emptyList();
        if (list3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer", "loadValueParameterAnnotations"));
        }
        return list3;
    }

    private static class SignatureDeserializer {
        private static final char[] PRIMITIVE_TYPES = new char[]{'V', 'Z', 'C', 'B', 'S', 'I', 'F', 'J', 'D'};
        private final NameResolver nameResolver;

        public SignatureDeserializer(@NotNull NameResolver nameResolver) {
            if (nameResolver == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameResolver", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer$SignatureDeserializer", "<init>"));
            }
            this.nameResolver = nameResolver;
        }

        @NotNull
        public MemberSignature methodSignature(@NotNull JavaProtoBuf.JavaMethodSignature signature) {
            if (signature == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signature", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer$SignatureDeserializer", "methodSignature"));
            }
            Name name = this.nameResolver.getName(signature.getName());
            StringBuilder sb = new StringBuilder();
            sb.append('(');
            int length = signature.getParameterTypeCount();
            for (int i = 0; i < length; ++i) {
                this.typeDescriptor(signature.getParameterType(i), sb);
            }
            sb.append(')');
            this.typeDescriptor(signature.getReturnType(), sb);
            MemberSignature memberSignature = MemberSignature.fromMethodNameAndDesc(name, sb.toString());
            if (memberSignature == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer$SignatureDeserializer", "methodSignature"));
            }
            return memberSignature;
        }

        @NotNull
        public String typeDescriptor(@NotNull JavaProtoBuf.JavaType type) {
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer$SignatureDeserializer", "typeDescriptor"));
            }
            String string = this.typeDescriptor(type, new StringBuilder()).toString();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer$SignatureDeserializer", "typeDescriptor"));
            }
            return string;
        }

        @NotNull
        private StringBuilder typeDescriptor(@NotNull JavaProtoBuf.JavaType type, @NotNull StringBuilder sb) {
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer$SignatureDeserializer", "typeDescriptor"));
            }
            if (sb == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sb", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer$SignatureDeserializer", "typeDescriptor"));
            }
            for (int i = 0; i < type.getArrayDimension(); ++i) {
                sb.append('[');
            }
            if (type.hasPrimitiveType()) {
                sb.append(PRIMITIVE_TYPES[type.getPrimitiveType().ordinal()]);
            } else {
                sb.append("L");
                sb.append(SignatureDeserializer.fqNameToInternalName(this.nameResolver.getFqName(type.getClassFqName())));
                sb.append(";");
            }
            StringBuilder stringBuilder = sb;
            if (stringBuilder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer$SignatureDeserializer", "typeDescriptor"));
            }
            return stringBuilder;
        }

        @NotNull
        private static String fqNameToInternalName(@NotNull FqName fqName) {
            if (fqName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer$SignatureDeserializer", "fqNameToInternalName"));
            }
            String string = fqName.asString().replace('.', '/');
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer$SignatureDeserializer", "fqNameToInternalName"));
            }
            return string;
        }
    }

    private static final class MemberSignature {
        private final String signature;

        private MemberSignature(@NotNull String signature) {
            if (signature == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signature", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer$MemberSignature", "<init>"));
            }
            this.signature = signature;
        }

        @NotNull
        public static MemberSignature fromMethodNameAndDesc(@NotNull Name name, @NotNull String desc) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer$MemberSignature", "fromMethodNameAndDesc"));
            }
            if (desc == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "desc", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer$MemberSignature", "fromMethodNameAndDesc"));
            }
            MemberSignature memberSignature = new MemberSignature(name.asString() + desc);
            if (memberSignature == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer$MemberSignature", "fromMethodNameAndDesc"));
            }
            return memberSignature;
        }

        @NotNull
        public static MemberSignature fromFieldNameAndDesc(@NotNull Name name, @NotNull String desc) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer$MemberSignature", "fromFieldNameAndDesc"));
            }
            if (desc == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "desc", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer$MemberSignature", "fromFieldNameAndDesc"));
            }
            MemberSignature memberSignature = new MemberSignature(name.asString() + "#" + desc);
            if (memberSignature == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer$MemberSignature", "fromFieldNameAndDesc"));
            }
            return memberSignature;
        }

        @NotNull
        public static MemberSignature fromMethodSignatureAndParameterIndex(@NotNull MemberSignature signature, int index) {
            if (signature == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signature", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer$MemberSignature", "fromMethodSignatureAndParameterIndex"));
            }
            MemberSignature memberSignature = new MemberSignature(signature.signature + "@" + index);
            if (memberSignature == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer$MemberSignature", "fromMethodSignatureAndParameterIndex"));
            }
            return memberSignature;
        }

        public int hashCode() {
            return this.signature.hashCode();
        }

        public boolean equals(Object o) {
            return o instanceof MemberSignature && this.signature.equals(((MemberSignature)o).signature);
        }

        public String toString() {
            return this.signature;
        }
    }
}

