/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve;

import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.cfg.JetFlowInformationProvider;
import org.jetbrains.jet.lang.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.jet.lang.psi.JetClassOrObject;
import org.jetbrains.jet.lang.psi.JetDeclarationContainer;
import org.jetbrains.jet.lang.psi.JetDeclarationWithBody;
import org.jetbrains.jet.lang.psi.JetElement;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.psi.JetNamedFunction;
import org.jetbrains.jet.lang.psi.JetProperty;
import org.jetbrains.jet.lang.psi.JetPropertyAccessor;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.BodiesResolveContext;
import org.jetbrains.jet.lang.resolve.TopDownAnalysisParameters;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeUtils;

public class ControlFlowAnalyzer {
    private TopDownAnalysisParameters topDownAnalysisParameters;
    private BindingTrace trace;

    public void setTopDownAnalysisParameters(TopDownAnalysisParameters topDownAnalysisParameters) {
        this.topDownAnalysisParameters = topDownAnalysisParameters;
    }

    public void setTrace(BindingTrace trace) {
        this.trace = trace;
    }

    public void process(@NotNull BodiesResolveContext bodiesResolveContext) {
        if (bodiesResolveContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bodiesResolveContext", "org/jetbrains/jet/lang/resolve/ControlFlowAnalyzer", "process"));
        }
        for (JetFile jetFile : bodiesResolveContext.getFiles()) {
            if (!bodiesResolveContext.completeAnalysisNeeded(jetFile)) continue;
            this.checkDeclarationContainer(jetFile);
        }
        for (JetClassOrObject jetClassOrObject : bodiesResolveContext.getClasses().keySet()) {
            if (!bodiesResolveContext.completeAnalysisNeeded(jetClassOrObject)) continue;
            this.checkDeclarationContainer(jetClassOrObject);
        }
        for (Map.Entry entry : bodiesResolveContext.getFunctions().entrySet()) {
            JetType expectedReturnType;
            JetNamedFunction function = (JetNamedFunction)entry.getKey();
            SimpleFunctionDescriptor functionDescriptor = (SimpleFunctionDescriptor)entry.getValue();
            if (!bodiesResolveContext.completeAnalysisNeeded(function)) continue;
            JetType jetType = expectedReturnType = !function.hasBlockBody() && !function.hasDeclaredReturnType() ? TypeUtils.NO_EXPECTED_TYPE : functionDescriptor.getReturnType();
            assert (expectedReturnType != null) : "functionDescriptor is not yet fully initialized or broken so return type is null " + functionDescriptor;
            this.checkFunction(function, expectedReturnType);
        }
        for (Map.Entry entry : bodiesResolveContext.getProperties().entrySet()) {
            JetProperty property2 = (JetProperty)entry.getKey();
            if (!bodiesResolveContext.completeAnalysisNeeded(property2)) continue;
            PropertyDescriptor propertyDescriptor = (PropertyDescriptor)entry.getValue();
            this.checkProperty(property2, propertyDescriptor);
        }
    }

    private void checkDeclarationContainer(JetDeclarationContainer declarationContainer) {
        JetFlowInformationProvider flowInformationProvider = new JetFlowInformationProvider((JetElement)((Object)declarationContainer), this.trace);
        flowInformationProvider.recordInitializedVariables();
        if (this.topDownAnalysisParameters.isDeclaredLocally()) {
            return;
        }
        flowInformationProvider.markUninitializedVariables();
    }

    private void checkProperty(JetProperty property2, PropertyDescriptor propertyDescriptor) {
        for (JetPropertyAccessor accessor : property2.getAccessors()) {
            PropertyAccessorDescriptor accessorDescriptor;
            PropertyAccessorDescriptor propertyAccessorDescriptor = accessorDescriptor = accessor.isGetter() ? propertyDescriptor.getGetter() : propertyDescriptor.getSetter();
            assert (accessorDescriptor != null) : "no property accessor descriptor " + accessor.getText();
            JetType returnType = accessorDescriptor.getReturnType();
            assert (returnType != null) : "property accessor has no return type " + accessorDescriptor;
            this.checkFunction(accessor, returnType);
        }
    }

    private void checkFunction(@NotNull JetDeclarationWithBody function, @NotNull JetType expectedReturnType) {
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/jet/lang/resolve/ControlFlowAnalyzer", "checkFunction"));
        }
        if (expectedReturnType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expectedReturnType", "org/jetbrains/jet/lang/resolve/ControlFlowAnalyzer", "checkFunction"));
        }
        JetExpression bodyExpression = function.getBodyExpression();
        if (bodyExpression == null) {
            return;
        }
        JetFlowInformationProvider flowInformationProvider = new JetFlowInformationProvider(function, this.trace);
        flowInformationProvider.checkFunction(function, expectedReturnType, this.topDownAnalysisParameters.isDeclaredLocally());
    }
}

