/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.descriptors.impl;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.CallableMemberDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassKind;
import org.jetbrains.jet.lang.descriptors.ConstructorDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.ConstructorDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.impl.MutableClassDescriptorLite;
import org.jetbrains.jet.lang.descriptors.impl.NamespaceLikeBuilder;
import org.jetbrains.jet.lang.descriptors.impl.NamespaceLikeBuilderDummy;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.ClassObjectMixinScope;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.resolve.scopes.RedeclarationHandler;
import org.jetbrains.jet.lang.resolve.scopes.WritableScope;
import org.jetbrains.jet.lang.resolve.scopes.WritableScopeImpl;

public class MutableClassDescriptor
extends MutableClassDescriptorLite {
    private final Set<ConstructorDescriptor> constructors;
    private ConstructorDescriptor primaryConstructor;
    private final Set<CallableMemberDescriptor> declaredCallableMembers;
    private final Set<CallableMemberDescriptor> allCallableMembers;
    private final Set<PropertyDescriptor> properties;
    private final Set<SimpleFunctionDescriptor> functions;
    private final WritableScope scopeForMemberResolution;
    private final WritableScope scopeForSupertypeResolution;
    private WritableScope scopeForInitializers;
    private NamespaceLikeBuilder builder;

    public MutableClassDescriptor(@NotNull DeclarationDescriptor containingDeclaration, @NotNull JetScope outerScope, ClassKind kind, boolean isInner, Name name) {
        if (containingDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingDeclaration", "org/jetbrains/jet/lang/descriptors/impl/MutableClassDescriptor", "<init>"));
        }
        if (outerScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outerScope", "org/jetbrains/jet/lang/descriptors/impl/MutableClassDescriptor", "<init>"));
        }
        super(containingDeclaration, name, kind, isInner);
        this.constructors = Sets.newLinkedHashSet();
        this.declaredCallableMembers = Sets.newLinkedHashSet();
        this.allCallableMembers = Sets.newLinkedHashSet();
        this.properties = Sets.newLinkedHashSet();
        this.functions = Sets.newLinkedHashSet();
        this.scopeForInitializers = null;
        this.builder = null;
        RedeclarationHandler redeclarationHandler = RedeclarationHandler.DO_NOTHING;
        this.setScopeForMemberLookup(new WritableScopeImpl(JetScope.EMPTY, this, redeclarationHandler, "MemberLookup").changeLockLevel(WritableScope.LockLevel.BOTH));
        this.scopeForSupertypeResolution = new WritableScopeImpl(outerScope, this, redeclarationHandler, "SupertypeResolution").changeLockLevel(WritableScope.LockLevel.BOTH);
        this.scopeForMemberResolution = new WritableScopeImpl(this.scopeForSupertypeResolution, this, redeclarationHandler, "MemberResolution").changeLockLevel(WritableScope.LockLevel.BOTH);
        if (this.getKind() == ClassKind.TRAIT) {
            this.setUpScopeForInitializers(this);
        }
        this.scopeForMemberResolution.addLabeledDeclaration(this);
    }

    public void setPrimaryConstructor(@NotNull ConstructorDescriptor constructorDescriptor) {
        if (constructorDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructorDescriptor", "org/jetbrains/jet/lang/descriptors/impl/MutableClassDescriptor", "setPrimaryConstructor"));
        }
        assert (this.primaryConstructor == null) : "Primary constructor assigned twice " + this;
        this.primaryConstructor = constructorDescriptor;
        this.constructors.add(constructorDescriptor);
        if (this.defaultType.isComputed()) {
            ((ConstructorDescriptorImpl)constructorDescriptor).setReturnType(this.getDefaultType());
        }
        if (constructorDescriptor.isPrimary()) {
            this.setUpScopeForInitializers(constructorDescriptor);
        }
    }

    public void addConstructorParametersToInitializersScope(@NotNull Collection<? extends VariableDescriptor> variables) {
        if (variables == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variables", "org/jetbrains/jet/lang/descriptors/impl/MutableClassDescriptor", "addConstructorParametersToInitializersScope"));
        }
        WritableScope scope = this.getWritableScopeForInitializers();
        for (VariableDescriptor variableDescriptor : variables) {
            scope.addVariableDescriptor(variableDescriptor);
        }
    }

    @NotNull
    public Set<ConstructorDescriptor> getConstructors() {
        Set<ConstructorDescriptor> set = this.constructors;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/impl/MutableClassDescriptor", "getConstructors"));
        }
        return set;
    }

    @Override
    @Nullable
    public ConstructorDescriptor getUnsubstitutedPrimaryConstructor() {
        return this.primaryConstructor;
    }

    @NotNull
    public Set<SimpleFunctionDescriptor> getFunctions() {
        Set<SimpleFunctionDescriptor> set = this.functions;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/impl/MutableClassDescriptor", "getFunctions"));
        }
        return set;
    }

    @NotNull
    public Set<PropertyDescriptor> getProperties() {
        Set<PropertyDescriptor> set = this.properties;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/impl/MutableClassDescriptor", "getProperties"));
        }
        return set;
    }

    @NotNull
    public Set<CallableMemberDescriptor> getDeclaredCallableMembers() {
        Set<CallableMemberDescriptor> set = this.declaredCallableMembers;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/impl/MutableClassDescriptor", "getDeclaredCallableMembers"));
        }
        return set;
    }

    @NotNull
    public Set<CallableMemberDescriptor> getAllCallableMembers() {
        Set<CallableMemberDescriptor> set = this.allCallableMembers;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/impl/MutableClassDescriptor", "getAllCallableMembers"));
        }
        return set;
    }

    @Override
    public void setTypeParameterDescriptors(List<TypeParameterDescriptor> typeParameters) {
        super.setTypeParameterDescriptors(typeParameters);
        for (TypeParameterDescriptor typeParameterDescriptor : typeParameters) {
            this.scopeForSupertypeResolution.addTypeParameterDescriptor(typeParameterDescriptor);
        }
        this.scopeForSupertypeResolution.changeLockLevel(WritableScope.LockLevel.READING);
    }

    @Override
    public void createTypeConstructor() {
        super.createTypeConstructor();
        for (ConstructorDescriptor functionDescriptor : this.getConstructors()) {
            ((ConstructorDescriptorImpl)functionDescriptor).setReturnType(this.getDefaultType());
        }
        this.scopeForMemberResolution.setImplicitReceiver(this.getThisAsReceiverParameter());
    }

    @NotNull
    public JetScope getScopeForSupertypeResolution() {
        WritableScope writableScope = this.scopeForSupertypeResolution;
        if (writableScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/impl/MutableClassDescriptor", "getScopeForSupertypeResolution"));
        }
        return writableScope;
    }

    @NotNull
    public JetScope getScopeForMemberResolution() {
        WritableScope writableScope = this.scopeForMemberResolution;
        if (writableScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/impl/MutableClassDescriptor", "getScopeForMemberResolution"));
        }
        return writableScope;
    }

    private WritableScope getWritableScopeForInitializers() {
        if (this.scopeForInitializers == null) {
            throw new IllegalStateException("Scope for initializers queried before the primary constructor is set");
        }
        return this.scopeForInitializers;
    }

    @NotNull
    public JetScope getScopeForInitializers() {
        WritableScope writableScope = this.getWritableScopeForInitializers();
        if (writableScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/impl/MutableClassDescriptor", "getScopeForInitializers"));
        }
        return writableScope;
    }

    private void setUpScopeForInitializers(@NotNull DeclarationDescriptor containingDeclaration) {
        if (containingDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingDeclaration", "org/jetbrains/jet/lang/descriptors/impl/MutableClassDescriptor", "setUpScopeForInitializers"));
        }
        this.scopeForInitializers = new WritableScopeImpl(this.scopeForMemberResolution, containingDeclaration, RedeclarationHandler.DO_NOTHING, "Initializers").changeLockLevel(WritableScope.LockLevel.BOTH);
    }

    @Override
    public void lockScopes() {
        super.lockScopes();
        this.scopeForSupertypeResolution.changeLockLevel(WritableScope.LockLevel.READING);
        this.scopeForMemberResolution.changeLockLevel(WritableScope.LockLevel.READING);
        this.getWritableScopeForInitializers().changeLockLevel(WritableScope.LockLevel.READING);
    }

    @Override
    public NamespaceLikeBuilder getBuilder() {
        if (this.builder == null) {
            final NamespaceLikeBuilder superBuilder = super.getBuilder();
            this.builder = new NamespaceLikeBuilderDummy(){

                @Override
                @NotNull
                public DeclarationDescriptor getOwnerForChildren() {
                    DeclarationDescriptor declarationDescriptor = superBuilder.getOwnerForChildren();
                    if (declarationDescriptor == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/impl/MutableClassDescriptor$1", "getOwnerForChildren"));
                    }
                    return declarationDescriptor;
                }

                @Override
                public void addClassifierDescriptor(@NotNull MutableClassDescriptorLite classDescriptor) {
                    if (classDescriptor == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/jet/lang/descriptors/impl/MutableClassDescriptor$1", "addClassifierDescriptor"));
                    }
                    superBuilder.addClassifierDescriptor(classDescriptor);
                    MutableClassDescriptor.this.scopeForMemberResolution.addClassifierDescriptor(classDescriptor);
                }

                @Override
                public void addFunctionDescriptor(@NotNull SimpleFunctionDescriptor functionDescriptor) {
                    if (functionDescriptor == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/jet/lang/descriptors/impl/MutableClassDescriptor$1", "addFunctionDescriptor"));
                    }
                    superBuilder.addFunctionDescriptor(functionDescriptor);
                    MutableClassDescriptor.this.functions.add(functionDescriptor);
                    if (functionDescriptor.getKind().isReal()) {
                        MutableClassDescriptor.this.declaredCallableMembers.add(functionDescriptor);
                    }
                    MutableClassDescriptor.this.allCallableMembers.add(functionDescriptor);
                    MutableClassDescriptor.this.scopeForMemberResolution.addFunctionDescriptor(functionDescriptor);
                }

                @Override
                public NamespaceLikeBuilder.ClassObjectStatus setClassObjectDescriptor(@NotNull MutableClassDescriptorLite classObjectDescriptor) {
                    if (classObjectDescriptor == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classObjectDescriptor", "org/jetbrains/jet/lang/descriptors/impl/MutableClassDescriptor$1", "setClassObjectDescriptor"));
                    }
                    NamespaceLikeBuilder.ClassObjectStatus r = superBuilder.setClassObjectDescriptor(classObjectDescriptor);
                    if (r != NamespaceLikeBuilder.ClassObjectStatus.OK) {
                        return r;
                    }
                    MutableClassDescriptor.this.scopeForMemberResolution.importScope(new ClassObjectMixinScope(classObjectDescriptor));
                    return NamespaceLikeBuilder.ClassObjectStatus.OK;
                }

                @Override
                public void addPropertyDescriptor(@NotNull PropertyDescriptor propertyDescriptor) {
                    if (propertyDescriptor == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyDescriptor", "org/jetbrains/jet/lang/descriptors/impl/MutableClassDescriptor$1", "addPropertyDescriptor"));
                    }
                    superBuilder.addPropertyDescriptor(propertyDescriptor);
                    MutableClassDescriptor.this.properties.add(propertyDescriptor);
                    if (propertyDescriptor.getKind().isReal()) {
                        MutableClassDescriptor.this.declaredCallableMembers.add(propertyDescriptor);
                    }
                    MutableClassDescriptor.this.allCallableMembers.add(propertyDescriptor);
                    MutableClassDescriptor.this.scopeForMemberResolution.addPropertyDescriptor(propertyDescriptor);
                }
            };
        }
        return this.builder;
    }
}

