/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.cfg;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.JetNodeTypes;
import org.jetbrains.jet.lang.cfg.GenerationTrigger;
import org.jetbrains.jet.lang.cfg.JetControlFlowBuilder;
import org.jetbrains.jet.lang.cfg.JetControlFlowBuilderAdapter;
import org.jetbrains.jet.lang.cfg.Label;
import org.jetbrains.jet.lang.cfg.LoopInfo;
import org.jetbrains.jet.lang.cfg.WhenChecker;
import org.jetbrains.jet.lang.cfg.pseudocode.JetControlFlowInstructionsGenerator;
import org.jetbrains.jet.lang.cfg.pseudocode.LocalFunctionDeclarationInstruction;
import org.jetbrains.jet.lang.cfg.pseudocode.Pseudocode;
import org.jetbrains.jet.lang.cfg.pseudocode.PseudocodeImpl;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.diagnostics.Errors;
import org.jetbrains.jet.lang.evaluate.ConstantExpressionEvaluator;
import org.jetbrains.jet.lang.psi.JetAnnotatedExpression;
import org.jetbrains.jet.lang.psi.JetArrayAccessExpression;
import org.jetbrains.jet.lang.psi.JetBinaryExpression;
import org.jetbrains.jet.lang.psi.JetBinaryExpressionWithTypeRHS;
import org.jetbrains.jet.lang.psi.JetBlockExpression;
import org.jetbrains.jet.lang.psi.JetBreakExpression;
import org.jetbrains.jet.lang.psi.JetCallExpression;
import org.jetbrains.jet.lang.psi.JetCatchClause;
import org.jetbrains.jet.lang.psi.JetClass;
import org.jetbrains.jet.lang.psi.JetClassInitializer;
import org.jetbrains.jet.lang.psi.JetClassOrObject;
import org.jetbrains.jet.lang.psi.JetConstantExpression;
import org.jetbrains.jet.lang.psi.JetContinueExpression;
import org.jetbrains.jet.lang.psi.JetDeclaration;
import org.jetbrains.jet.lang.psi.JetDeclarationWithBody;
import org.jetbrains.jet.lang.psi.JetDelegationSpecifier;
import org.jetbrains.jet.lang.psi.JetDelegatorByExpressionSpecifier;
import org.jetbrains.jet.lang.psi.JetDelegatorToSuperCall;
import org.jetbrains.jet.lang.psi.JetDoWhileExpression;
import org.jetbrains.jet.lang.psi.JetElement;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.psi.JetFinallySection;
import org.jetbrains.jet.lang.psi.JetForExpression;
import org.jetbrains.jet.lang.psi.JetFunction;
import org.jetbrains.jet.lang.psi.JetFunctionLiteral;
import org.jetbrains.jet.lang.psi.JetFunctionLiteralExpression;
import org.jetbrains.jet.lang.psi.JetIfExpression;
import org.jetbrains.jet.lang.psi.JetIsExpression;
import org.jetbrains.jet.lang.psi.JetLabelQualifiedExpression;
import org.jetbrains.jet.lang.psi.JetLoopExpression;
import org.jetbrains.jet.lang.psi.JetMultiDeclaration;
import org.jetbrains.jet.lang.psi.JetMultiDeclarationEntry;
import org.jetbrains.jet.lang.psi.JetNamedFunction;
import org.jetbrains.jet.lang.psi.JetObjectDeclaration;
import org.jetbrains.jet.lang.psi.JetObjectLiteralExpression;
import org.jetbrains.jet.lang.psi.JetParameter;
import org.jetbrains.jet.lang.psi.JetParenthesizedExpression;
import org.jetbrains.jet.lang.psi.JetProperty;
import org.jetbrains.jet.lang.psi.JetPropertyAccessor;
import org.jetbrains.jet.lang.psi.JetPsiUtil;
import org.jetbrains.jet.lang.psi.JetQualifiedExpression;
import org.jetbrains.jet.lang.psi.JetReturnExpression;
import org.jetbrains.jet.lang.psi.JetSimpleNameExpression;
import org.jetbrains.jet.lang.psi.JetStatementExpression;
import org.jetbrains.jet.lang.psi.JetStringTemplateEntry;
import org.jetbrains.jet.lang.psi.JetStringTemplateEntryWithExpression;
import org.jetbrains.jet.lang.psi.JetStringTemplateExpression;
import org.jetbrains.jet.lang.psi.JetThisExpression;
import org.jetbrains.jet.lang.psi.JetThrowExpression;
import org.jetbrains.jet.lang.psi.JetTryExpression;
import org.jetbrains.jet.lang.psi.JetTypeProjection;
import org.jetbrains.jet.lang.psi.JetUnaryExpression;
import org.jetbrains.jet.lang.psi.JetVisitorVoid;
import org.jetbrains.jet.lang.psi.JetWhenCondition;
import org.jetbrains.jet.lang.psi.JetWhenConditionInRange;
import org.jetbrains.jet.lang.psi.JetWhenConditionIsPattern;
import org.jetbrains.jet.lang.psi.JetWhenConditionWithExpression;
import org.jetbrains.jet.lang.psi.JetWhenEntry;
import org.jetbrains.jet.lang.psi.JetWhenExpression;
import org.jetbrains.jet.lang.psi.JetWhileExpression;
import org.jetbrains.jet.lang.psi.ValueArgument;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingContextUtils;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.DelegatingBindingTrace;
import org.jetbrains.jet.lang.resolve.calls.autocasts.AutoCastReceiver;
import org.jetbrains.jet.lang.resolve.calls.model.ExpressionValueArgument;
import org.jetbrains.jet.lang.resolve.calls.model.MutableDataFlowInfoForArguments;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedCall;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedCallImpl;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.jet.lang.resolve.calls.model.VariableAsFunctionResolvedCall;
import org.jetbrains.jet.lang.resolve.calls.tasks.ResolutionCandidate;
import org.jetbrains.jet.lang.resolve.calls.tasks.TracingStrategy;
import org.jetbrains.jet.lang.resolve.calls.util.CallMaker;
import org.jetbrains.jet.lang.resolve.calls.util.ExpressionAsFunctionDescriptor;
import org.jetbrains.jet.lang.resolve.constants.BooleanValue;
import org.jetbrains.jet.lang.resolve.constants.CompileTimeConstant;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ThisReceiver;
import org.jetbrains.jet.lang.resolve.scopes.receivers.TransientReceiver;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.expressions.OperatorConventions;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;
import org.jetbrains.jet.lexer.JetToken;
import org.jetbrains.jet.lexer.JetTokens;

public class JetControlFlowProcessor {
    private final JetControlFlowBuilder builder = new JetControlFlowInstructionsGenerator();
    private final BindingTrace trace;

    public JetControlFlowProcessor(BindingTrace trace) {
        this.trace = trace;
    }

    public Pseudocode generatePseudocode(@NotNull JetElement subroutine) {
        if (subroutine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subroutine", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor", "generatePseudocode"));
        }
        Pseudocode pseudocode = this.generate(subroutine);
        ((PseudocodeImpl)pseudocode).postProcess();
        for (LocalFunctionDeclarationInstruction localFunctionDeclarationInstruction : pseudocode.getLocalDeclarations()) {
            ((PseudocodeImpl)localFunctionDeclarationInstruction.getBody()).postProcess();
        }
        return pseudocode;
    }

    private Pseudocode generate(@NotNull JetElement subroutine) {
        if (subroutine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subroutine", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor", "generate"));
        }
        this.builder.enterSubroutine(subroutine);
        CFPVisitor cfpVisitor = new CFPVisitor(this.builder, false);
        if (subroutine instanceof JetDeclarationWithBody) {
            JetDeclarationWithBody declarationWithBody = (JetDeclarationWithBody)subroutine;
            List<JetParameter> valueParameters = declarationWithBody.getValueParameters();
            for (JetParameter valueParameter : valueParameters) {
                cfpVisitor.generateInstructions(valueParameter);
            }
            JetExpression bodyExpression = declarationWithBody.getBodyExpression();
            if (bodyExpression != null) {
                cfpVisitor.generateInstructions(bodyExpression);
            }
        } else {
            cfpVisitor.generateInstructions(subroutine);
        }
        return this.builder.exitSubroutine(subroutine);
    }

    private void processLocalDeclaration(@NotNull JetDeclaration subroutine) {
        if (subroutine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subroutine", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor", "processLocalDeclaration"));
        }
        Label afterDeclaration = this.builder.createUnboundLabel();
        this.builder.nondeterministicJump(afterDeclaration);
        this.generate(subroutine);
        this.builder.bindLabel(afterDeclaration);
    }

    private class CFPVisitor
    extends JetVisitorVoid {
        private final JetControlFlowBuilder builder;
        private final boolean inCondition;
        private final JetVisitorVoid conditionVisitor;

        private CFPVisitor(@NotNull JetControlFlowBuilder builder, boolean inCondition) {
            if (builder == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "<init>"));
            }
            this.conditionVisitor = new JetVisitorVoid(){

                @Override
                public void visitWhenConditionInRange(@NotNull JetWhenConditionInRange condition) {
                    if (condition == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor$1", "visitWhenConditionInRange"));
                    }
                    CFPVisitor.this.generateInstructions(condition.getRangeExpression(), CFPVisitor.this.inCondition);
                    CFPVisitor.this.generateInstructions(condition.getOperationReference(), CFPVisitor.this.inCondition);
                }

                @Override
                public void visitWhenConditionIsPattern(@NotNull JetWhenConditionIsPattern condition) {
                    if (condition == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor$1", "visitWhenConditionIsPattern"));
                    }
                }

                @Override
                public void visitWhenConditionWithExpression(@NotNull JetWhenConditionWithExpression condition) {
                    if (condition == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor$1", "visitWhenConditionWithExpression"));
                    }
                    CFPVisitor.this.generateInstructions(condition.getExpression(), CFPVisitor.this.inCondition);
                }

                @Override
                public void visitJetElement(@NotNull JetElement element) {
                    if (element == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor$1", "visitJetElement"));
                    }
                    throw new UnsupportedOperationException("[JetControlFlowProcessor] " + element.toString());
                }
            };
            this.builder = builder;
            this.inCondition = inCondition;
        }

        private void mark(JetElement element) {
            this.builder.mark(element);
        }

        public void generateInstructions(@Nullable JetElement element) {
            this.generateInstructions(element, this.inCondition);
        }

        private void generateInstructions(@Nullable JetElement element, boolean inCondition) {
            if (element == null) {
                return;
            }
            CFPVisitor visitor = this.inCondition == inCondition ? this : new CFPVisitor(this.builder, inCondition);
            element.accept(visitor);
            this.checkNothingType(element);
        }

        private void checkNothingType(JetElement element) {
            if (!(element instanceof JetExpression)) {
                return;
            }
            JetExpression expression = JetPsiUtil.deparenthesize((JetExpression)element);
            if (expression instanceof JetStatementExpression || expression instanceof JetTryExpression || expression instanceof JetIfExpression || expression instanceof JetWhenExpression) {
                return;
            }
            JetType type = JetControlFlowProcessor.this.trace.getBindingContext().get(BindingContext.EXPRESSION_TYPE, expression);
            if (type != null && KotlinBuiltIns.getInstance().isNothing(type)) {
                this.builder.jumpToError();
            }
        }

        @Override
        public void visitParenthesizedExpression(@NotNull JetParenthesizedExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitParenthesizedExpression"));
            }
            this.mark(expression);
            JetExpression innerExpression = expression.getExpression();
            if (innerExpression != null) {
                this.generateInstructions(innerExpression, this.inCondition);
            }
        }

        @Override
        public void visitAnnotatedExpression(@NotNull JetAnnotatedExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitAnnotatedExpression"));
            }
            JetExpression baseExpression = expression.getBaseExpression();
            if (baseExpression != null) {
                this.generateInstructions(baseExpression, this.inCondition);
            }
        }

        @Override
        public void visitThisExpression(@NotNull JetThisExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitThisExpression"));
            }
            ResolvedCall<?> resolvedCall = this.getResolvedCall(expression);
            if (resolvedCall == null) {
                this.builder.readThis(expression, null);
                return;
            }
            Object resultingDescriptor = resolvedCall.getResultingDescriptor();
            if (resultingDescriptor instanceof ReceiverParameterDescriptor) {
                this.builder.readThis(expression, (ReceiverParameterDescriptor)resultingDescriptor);
            } else if (resultingDescriptor instanceof ExpressionAsFunctionDescriptor) {
                this.builder.readThis(expression, null);
            }
        }

        @Override
        public void visitConstantExpression(@NotNull JetConstantExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitConstantExpression"));
            }
            CompileTimeConstant<?> constant = JetControlFlowProcessor.this.trace.get(BindingContext.COMPILE_TIME_VALUE, expression);
            this.builder.loadConstant(expression, constant);
        }

        @Override
        public void visitSimpleNameExpression(@NotNull JetSimpleNameExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitSimpleNameExpression"));
            }
            ResolvedCall<?> resolvedCall = this.getResolvedCall(expression);
            if (resolvedCall instanceof VariableAsFunctionResolvedCall) {
                VariableAsFunctionResolvedCall variableAsFunctionResolvedCall = (VariableAsFunctionResolvedCall)resolvedCall;
                this.generateCall(expression, variableAsFunctionResolvedCall.getVariableCall());
            } else {
                this.generateCall(expression);
            }
        }

        @Override
        public void visitLabelQualifiedExpression(@NotNull JetLabelQualifiedExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitLabelQualifiedExpression"));
            }
            String labelName = expression.getLabelName();
            JetExpression labeledExpression = expression.getLabeledExpression();
            if (labelName != null && labeledExpression != null) {
                this.visitLabeledExpression(labelName, labeledExpression);
            }
        }

        private void visitLabeledExpression(@NotNull String labelName, @NotNull JetExpression labeledExpression) {
            if (labelName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "labelName", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitLabeledExpression"));
            }
            if (labeledExpression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "labeledExpression", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitLabeledExpression"));
            }
            JetExpression deparenthesized = JetPsiUtil.deparenthesize(labeledExpression);
            if (deparenthesized != null) {
                this.generateInstructions(labeledExpression, this.inCondition);
            }
        }

        @Override
        public void visitBinaryExpression(@NotNull JetBinaryExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitBinaryExpression"));
            }
            JetSimpleNameExpression operationReference = expression.getOperationReference();
            IElementType operationType = operationReference.getReferencedNameElementType();
            if (!ImmutableSet.of(JetTokens.ANDAND, JetTokens.OROR, JetTokens.EQ, JetTokens.ELVIS).contains(operationType)) {
                this.mark(expression);
            }
            JetExpression right = expression.getRight();
            if (operationType == JetTokens.ANDAND) {
                this.generateInstructions(expression.getLeft(), true);
                Label resultLabel = this.builder.createUnboundLabel();
                this.builder.jumpOnFalse(resultLabel);
                if (right != null) {
                    this.generateInstructions(right, true);
                }
                this.builder.bindLabel(resultLabel);
                if (!this.inCondition) {
                    this.builder.predefinedOperation(expression, JetControlFlowBuilder.PredefinedOperation.AND);
                }
            } else if (operationType == JetTokens.OROR) {
                this.generateInstructions(expression.getLeft(), true);
                Label resultLabel = this.builder.createUnboundLabel();
                this.builder.jumpOnTrue(resultLabel);
                if (right != null) {
                    this.generateInstructions(right, true);
                }
                this.builder.bindLabel(resultLabel);
                if (!this.inCondition) {
                    this.builder.predefinedOperation(expression, JetControlFlowBuilder.PredefinedOperation.OR);
                }
            } else if (operationType == JetTokens.EQ) {
                this.visitAssignment(expression.getLeft(), right, expression);
            } else if (OperatorConventions.ASSIGNMENT_OPERATIONS.containsKey(operationType)) {
                if (this.generateCall(operationReference)) {
                    ResolvedCall<?> resolvedCall = this.getResolvedCall(operationReference);
                    assert (resolvedCall != null) : "Generation succeeded, but no call is found: " + expression.getText();
                    Object descriptor = resolvedCall.getResultingDescriptor();
                    Name assignMethodName = OperatorConventions.getNameForOperationSymbol((JetToken)expression.getOperationToken());
                    if (!descriptor.getName().equals(assignMethodName)) {
                        this.visitAssignment(expression.getLeft(), null, expression);
                    }
                } else {
                    this.generateBothArguments(expression);
                }
            } else if (operationType == JetTokens.ELVIS) {
                this.generateInstructions(expression.getLeft(), false);
                Label afterElvis = this.builder.createUnboundLabel();
                this.builder.jumpOnTrue(afterElvis);
                if (right != null) {
                    this.generateInstructions(right, false);
                }
                this.builder.bindLabel(afterElvis);
            } else if (operationType == JetTokens.EQEQ || operationType == JetTokens.EXCLEQ) {
                ResolvedCall<?> resolvedCall = this.getResolvedCall(operationReference);
                if (resolvedCall != null && !resolvedCall.getValueArguments().isEmpty() && right != null) {
                    ResolvedCallImpl<?> fakeCall = ResolvedCallImpl.create(ResolutionCandidate.create(resolvedCall.getCandidateDescriptor(), resolvedCall.getThisObject(), resolvedCall.getReceiverArgument(), resolvedCall.getExplicitReceiverKind(), resolvedCall.isSafeCall()), new DelegatingBindingTrace(BindingContext.EMPTY, "Fake call for =="), TracingStrategy.EMPTY, MutableDataFlowInfoForArguments.WITHOUT_ARGUMENTS_CHECK);
                    ValueParameterDescriptor parameterDescriptor = resolvedCall.getValueArguments().keySet().iterator().next();
                    fakeCall.recordValueArgument(parameterDescriptor, new ExpressionValueArgument(CallMaker.makeValueArgument(right)));
                    fakeCall.setStatusToSuccess();
                    this.generateCall(expression, fakeCall);
                } else {
                    this.generateBothArguments(expression);
                }
            } else if (!this.generateCall(operationReference)) {
                this.generateBothArguments(expression);
            }
        }

        private void generateBothArguments(JetBinaryExpression expression) {
            JetExpression right;
            JetExpression left = JetPsiUtil.deparenthesize(expression.getLeft());
            if (left != null) {
                this.generateInstructions(left, false);
            }
            if ((right = expression.getRight()) != null) {
                this.generateInstructions(right, false);
            }
        }

        private void visitAssignment(JetExpression lhs, @Nullable JetExpression rhs, JetExpression parentExpression) {
            JetExpression left = JetPsiUtil.deparenthesize(lhs);
            if (left == null) {
                this.builder.compilationError(lhs, "No lValue in assignment");
                return;
            }
            if (left instanceof JetArrayAccessExpression) {
                ResolvedCall<FunctionDescriptor> setResolvedCall = JetControlFlowProcessor.this.trace.get(BindingContext.INDEXED_LVALUE_SET, left);
                this.generateArrayAccess((JetArrayAccessExpression)left, setResolvedCall);
                this.recordWrite(left, parentExpression);
                return;
            }
            this.generateInstructions(rhs, false);
            if (!(left instanceof JetSimpleNameExpression) && !(left instanceof JetProperty)) {
                if (left instanceof JetQualifiedExpression) {
                    this.generateInstructions(((JetQualifiedExpression)left).getReceiverExpression(), false);
                } else {
                    this.builder.unsupported(parentExpression);
                }
            }
            this.recordWrite(left, parentExpression);
        }

        private void recordWrite(JetExpression left, JetExpression parentExpression) {
            VariableDescriptor descriptor = BindingContextUtils.extractVariableDescriptorIfAny(JetControlFlowProcessor.this.trace.getBindingContext(), left, false);
            if (descriptor != null) {
                this.builder.write(parentExpression, left);
            }
        }

        private void generateArrayAccess(JetArrayAccessExpression arrayAccessExpression, @Nullable ResolvedCall<?> resolvedCall) {
            this.mark(arrayAccessExpression);
            if (!this.checkAndGenerateCall(arrayAccessExpression, resolvedCall)) {
                for (JetExpression index : arrayAccessExpression.getIndexExpressions()) {
                    this.generateInstructions(index, false);
                }
                this.generateInstructions(arrayAccessExpression.getArrayExpression(), false);
            }
        }

        @Override
        public void visitUnaryExpression(@NotNull JetUnaryExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitUnaryExpression"));
            }
            this.mark(expression);
            JetSimpleNameExpression operationSign = expression.getOperationReference();
            IElementType operationType = operationSign.getReferencedNameElementType();
            JetExpression baseExpression = expression.getBaseExpression();
            if (baseExpression == null) {
                return;
            }
            if (JetTokens.LABELS.contains(operationType)) {
                String referencedName = operationSign.getReferencedName();
                this.visitLabeledExpression(referencedName.substring(1), baseExpression);
            } else if (JetTokens.EXCLEXCL == operationType) {
                this.generateInstructions(baseExpression, false);
                this.builder.predefinedOperation(expression, JetControlFlowBuilder.PredefinedOperation.NOT_NULL_ASSERTION);
            } else {
                boolean incrementOrDecrement;
                if (!this.generateCall(expression.getOperationReference())) {
                    this.generateInstructions(baseExpression, false);
                }
                if (incrementOrDecrement = this.isIncrementOrDecrement(operationType)) {
                    this.visitAssignment(baseExpression, null, expression);
                }
            }
        }

        private boolean isIncrementOrDecrement(IElementType operationType) {
            return operationType == JetTokens.PLUSPLUS || operationType == JetTokens.MINUSMINUS;
        }

        @Override
        public void visitIfExpression(@NotNull JetIfExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitIfExpression"));
            }
            this.mark(expression);
            JetExpression condition = expression.getCondition();
            if (condition != null) {
                this.generateInstructions(condition, true);
            }
            Label elseLabel = this.builder.createUnboundLabel();
            this.builder.jumpOnFalse(elseLabel);
            JetExpression thenBranch = expression.getThen();
            if (thenBranch != null) {
                this.generateInstructions(thenBranch, this.inCondition);
            } else {
                this.builder.loadUnit(expression);
            }
            Label resultLabel = this.builder.createUnboundLabel();
            this.builder.jump(resultLabel);
            this.builder.bindLabel(elseLabel);
            JetExpression elseBranch = expression.getElse();
            if (elseBranch != null) {
                this.generateInstructions(elseBranch, this.inCondition);
            } else {
                this.builder.loadUnit(expression);
            }
            this.builder.bindLabel(resultLabel);
        }

        @Override
        public void visitTryExpression(@NotNull JetTryExpression expression) {
            List<JetCatchClause> catchClauses;
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitTryExpression"));
            }
            this.mark(expression);
            JetFinallySection finallyBlock = expression.getFinallyBlock();
            final FinallyBlockGenerator finallyBlockGenerator = new FinallyBlockGenerator(finallyBlock);
            if (finallyBlock != null) {
                this.builder.enterTryFinally(new GenerationTrigger(){
                    private boolean working = false;

                    @Override
                    public void generate() {
                        if (this.working) {
                            return;
                        }
                        this.working = true;
                        finallyBlockGenerator.generate();
                        this.working = false;
                    }
                });
            }
            boolean hasCatches = !(catchClauses = expression.getCatchClauses()).isEmpty();
            Label onException = null;
            if (hasCatches) {
                onException = this.builder.createUnboundLabel("onException");
                this.builder.nondeterministicJump(onException);
            }
            Label onExceptionToFinallyBlock = null;
            if (finallyBlock != null) {
                onExceptionToFinallyBlock = this.builder.createUnboundLabel("onExceptionToFinallyBlock");
                this.builder.nondeterministicJump(onExceptionToFinallyBlock);
            }
            this.generateInstructions(expression.getTryBlock(), this.inCondition);
            if (hasCatches) {
                Label afterCatches = this.builder.createUnboundLabel("afterCatches");
                this.builder.jump(afterCatches);
                this.builder.bindLabel(onException);
                LinkedList<Label> catchLabels = Lists.newLinkedList();
                int catchClausesSize = catchClauses.size();
                for (int i = 0; i < catchClausesSize - 1; ++i) {
                    catchLabels.add(this.builder.createUnboundLabel("catch " + i));
                }
                if (!catchLabels.isEmpty()) {
                    this.builder.nondeterministicJump(catchLabels);
                }
                boolean isFirst = true;
                for (JetCatchClause catchClause : catchClauses) {
                    JetExpression catchBody;
                    if (!isFirst) {
                        this.builder.bindLabel(catchLabels.remove());
                    } else {
                        isFirst = false;
                    }
                    JetParameter catchParameter = catchClause.getCatchParameter();
                    if (catchParameter != null) {
                        this.builder.declareParameter(catchParameter);
                        this.builder.write(catchParameter, catchParameter);
                    }
                    if ((catchBody = catchClause.getCatchBody()) != null) {
                        this.generateInstructions(catchBody, false);
                    }
                    this.builder.jump(afterCatches);
                }
                this.builder.bindLabel(afterCatches);
            }
            if (finallyBlock != null) {
                this.builder.exitTryFinally();
                Label skipFinallyToErrorBlock = this.builder.createUnboundLabel("skipFinallyToErrorBlock");
                this.builder.jump(skipFinallyToErrorBlock);
                this.builder.bindLabel(onExceptionToFinallyBlock);
                finallyBlockGenerator.generate();
                this.builder.jumpToError();
                this.builder.bindLabel(skipFinallyToErrorBlock);
                finallyBlockGenerator.generate();
            }
        }

        @Override
        public void visitWhileExpression(@NotNull JetWhileExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitWhileExpression"));
            }
            this.mark(expression);
            LoopInfo loopInfo = this.builder.enterLoop(expression, null, null);
            this.builder.bindLabel(loopInfo.getConditionEntryPoint());
            JetExpression condition = expression.getCondition();
            if (condition != null) {
                this.generateInstructions(condition, true);
            }
            boolean conditionIsTrueConstant = false;
            if (condition instanceof JetConstantExpression && condition.getNode().getElementType() == JetNodeTypes.BOOLEAN_CONSTANT && BooleanValue.TRUE == ConstantExpressionEvaluator.object$.evaluate(condition, JetControlFlowProcessor.this.trace, KotlinBuiltIns.getInstance().getBooleanType())) {
                conditionIsTrueConstant = true;
            }
            if (!conditionIsTrueConstant) {
                this.builder.jumpOnFalse(loopInfo.getExitPoint());
            }
            this.builder.bindLabel(loopInfo.getBodyEntryPoint());
            JetExpression body = expression.getBody();
            if (body != null) {
                this.generateInstructions(body, false);
            }
            this.builder.jump(loopInfo.getEntryPoint());
            this.builder.exitLoop(expression);
            this.builder.loadUnit(expression);
        }

        @Override
        public void visitDoWhileExpression(@NotNull JetDoWhileExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitDoWhileExpression"));
            }
            this.mark(expression);
            LoopInfo loopInfo = this.builder.enterLoop(expression, null, null);
            this.builder.bindLabel(loopInfo.getBodyEntryPoint());
            JetExpression body = expression.getBody();
            if (body != null) {
                this.generateInstructions(body, false);
            }
            this.builder.bindLabel(loopInfo.getConditionEntryPoint());
            JetExpression condition = expression.getCondition();
            if (condition != null) {
                this.generateInstructions(condition, true);
            }
            this.builder.jumpOnTrue(loopInfo.getEntryPoint());
            this.builder.exitLoop(expression);
            this.builder.loadUnit(expression);
        }

        @Override
        public void visitForExpression(@NotNull JetForExpression expression) {
            JetParameter loopParameter;
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitForExpression"));
            }
            this.mark(expression);
            JetExpression loopRange = expression.getLoopRange();
            if (loopRange != null) {
                this.generateInstructions(loopRange, false);
            }
            if ((loopParameter = expression.getLoopParameter()) != null) {
                this.generateInstructions(loopParameter, this.inCondition);
            } else {
                JetMultiDeclaration multiParameter = expression.getMultiParameter();
                this.generateInstructions(multiParameter, this.inCondition);
            }
            Label loopExitPoint = this.builder.createUnboundLabel();
            Label conditionEntryPoint = this.builder.createUnboundLabel();
            this.builder.bindLabel(conditionEntryPoint);
            this.builder.nondeterministicJump(loopExitPoint);
            LoopInfo loopInfo = this.builder.enterLoop(expression, loopExitPoint, conditionEntryPoint);
            this.builder.bindLabel(loopInfo.getBodyEntryPoint());
            JetExpression body = expression.getBody();
            if (body != null) {
                this.generateInstructions(body, false);
            }
            this.builder.nondeterministicJump(loopInfo.getEntryPoint());
            this.builder.exitLoop(expression);
            this.builder.loadUnit(expression);
        }

        @Override
        public void visitBreakExpression(@NotNull JetBreakExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitBreakExpression"));
            }
            JetElement loop = this.getCorrespondingLoop(expression);
            if (loop != null) {
                this.builder.jump(this.builder.getExitPoint(loop));
            }
        }

        @Override
        public void visitContinueExpression(@NotNull JetContinueExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitContinueExpression"));
            }
            JetElement loop = this.getCorrespondingLoop(expression);
            if (loop != null) {
                this.builder.jump(this.builder.getEntryPoint(loop));
            }
        }

        private JetElement getCorrespondingLoop(JetLabelQualifiedExpression expression) {
            JetElement loop;
            String labelName = expression.getLabelName();
            if (labelName != null) {
                JetSimpleNameExpression targetLabel = expression.getTargetLabel();
                assert (targetLabel != null);
                PsiElement labeledElement = JetControlFlowProcessor.this.trace.get(BindingContext.LABEL_TARGET, targetLabel);
                if (labeledElement instanceof JetLoopExpression) {
                    loop = (JetLoopExpression)labeledElement;
                } else {
                    JetControlFlowProcessor.this.trace.report(Errors.NOT_A_LOOP_LABEL.on(expression, targetLabel.getText()));
                    loop = null;
                }
            } else {
                loop = this.builder.getCurrentLoop();
                if (loop == null) {
                    JetControlFlowProcessor.this.trace.report(Errors.BREAK_OR_CONTINUE_OUTSIDE_A_LOOP.on(expression));
                }
            }
            return loop;
        }

        @Override
        public void visitReturnExpression(@NotNull JetReturnExpression expression) {
            JetElement subroutine;
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitReturnExpression"));
            }
            JetExpression returnedExpression = expression.getReturnedExpression();
            if (returnedExpression != null) {
                this.generateInstructions(returnedExpression, false);
            }
            JetSimpleNameExpression labelElement = expression.getTargetLabel();
            String labelName = expression.getLabelName();
            if (labelElement != null) {
                assert (labelName != null);
                PsiElement labeledElement = JetControlFlowProcessor.this.trace.get(BindingContext.LABEL_TARGET, labelElement);
                if (labeledElement != null) {
                    assert (labeledElement instanceof JetElement);
                    subroutine = (JetElement)labeledElement;
                } else {
                    subroutine = null;
                }
            } else {
                subroutine = this.builder.getReturnSubroutine();
            }
            if (subroutine instanceof JetFunction || subroutine instanceof JetPropertyAccessor) {
                if (returnedExpression == null) {
                    this.builder.returnNoValue(expression, subroutine);
                } else {
                    this.builder.returnValue(expression, subroutine);
                }
            }
        }

        @Override
        public void visitParameter(@NotNull JetParameter parameter) {
            if (parameter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitParameter"));
            }
            this.builder.declareParameter(parameter);
            JetExpression defaultValue = parameter.getDefaultValue();
            if (defaultValue != null) {
                this.generateInstructions(defaultValue, this.inCondition);
            }
            this.builder.write(parameter, parameter);
        }

        @Override
        public void visitBlockExpression(@NotNull JetBlockExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitBlockExpression"));
            }
            this.mark(expression);
            List<JetElement> statements = expression.getStatements();
            for (JetElement statement : statements) {
                this.generateInstructions(statement, false);
            }
            if (statements.isEmpty()) {
                this.builder.loadUnit(expression);
            }
        }

        @Override
        public void visitNamedFunction(@NotNull JetNamedFunction function) {
            if (function == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitNamedFunction"));
            }
            JetControlFlowProcessor.this.processLocalDeclaration(function);
        }

        @Override
        public void visitFunctionLiteralExpression(@NotNull JetFunctionLiteralExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitFunctionLiteralExpression"));
            }
            this.mark(expression);
            JetFunctionLiteral functionLiteral = expression.getFunctionLiteral();
            JetControlFlowProcessor.this.processLocalDeclaration(functionLiteral);
            this.builder.createFunctionLiteral(expression);
        }

        @Override
        public void visitQualifiedExpression(@NotNull JetQualifiedExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitQualifiedExpression"));
            }
            this.mark(expression);
            JetExpression selectorExpression = expression.getSelectorExpression();
            if (selectorExpression != null) {
                final Ref<Boolean> error = new Ref<Boolean>(false);
                JetControlFlowBuilderAdapter adapter = new JetControlFlowBuilderAdapter(){

                    @Override
                    @NotNull
                    protected JetControlFlowBuilder getDelegateBuilder() {
                        JetControlFlowBuilder jetControlFlowBuilder = CFPVisitor.this.builder;
                        if (jetControlFlowBuilder == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor$3", "getDelegateBuilder"));
                        }
                        return jetControlFlowBuilder;
                    }

                    @Override
                    public void compilationError(@NotNull JetElement element, @NotNull String message) {
                        if (element == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor$3", "compilationError"));
                        }
                        if (message == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor$3", "compilationError"));
                        }
                        error.set(true);
                        super.compilationError(element, message);
                    }
                };
                new CFPVisitor(adapter, this.inCondition).generateInstructions(selectorExpression, false);
                if (error.get().booleanValue()) {
                    this.generateInstructions(expression.getReceiverExpression(), false);
                }
            }
        }

        @Override
        public void visitCallExpression(@NotNull JetCallExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitCallExpression"));
            }
            this.mark(expression);
            if (!this.generateCall(expression.getCalleeExpression())) {
                for (ValueArgument valueArgument : expression.getValueArguments()) {
                    JetExpression argumentExpression = valueArgument.getArgumentExpression();
                    if (argumentExpression == null) continue;
                    this.generateInstructions(argumentExpression, false);
                }
                for (JetExpression jetExpression : expression.getFunctionLiteralArguments()) {
                    this.generateInstructions(jetExpression, false);
                }
                this.generateInstructions(expression.getCalleeExpression(), false);
            }
        }

        @Override
        public void visitProperty(@NotNull JetProperty property2) {
            JetExpression delegate;
            if (property2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitProperty"));
            }
            this.builder.declareVariable(property2);
            JetExpression initializer = property2.getInitializer();
            if (initializer != null) {
                this.generateInstructions(initializer, false);
                this.visitAssignment(property2, null, property2);
            }
            if ((delegate = property2.getDelegateExpression()) != null) {
                this.generateInstructions(delegate, false);
            }
            for (JetPropertyAccessor accessor : property2.getAccessors()) {
                this.generateInstructions(accessor, false);
            }
        }

        @Override
        public void visitMultiDeclaration(@NotNull JetMultiDeclaration declaration) {
            if (declaration == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitMultiDeclaration"));
            }
            JetExpression initializer = declaration.getInitializer();
            if (initializer != null) {
                this.generateInstructions(initializer, false);
            }
            List<JetMultiDeclarationEntry> entries = declaration.getEntries();
            for (JetMultiDeclarationEntry entry : entries) {
                this.builder.declareVariable(entry);
                ResolvedCall<FunctionDescriptor> resolvedCall = JetControlFlowProcessor.this.trace.get(BindingContext.COMPONENT_RESOLVED_CALL, entry);
                if (resolvedCall != null) {
                    this.builder.call(entry, resolvedCall);
                }
                this.builder.write(entry, entry);
            }
        }

        @Override
        public void visitPropertyAccessor(@NotNull JetPropertyAccessor accessor) {
            if (accessor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "accessor", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitPropertyAccessor"));
            }
            JetControlFlowProcessor.this.processLocalDeclaration(accessor);
        }

        @Override
        public void visitBinaryWithTypeRHSExpression(@NotNull JetBinaryExpressionWithTypeRHS expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitBinaryWithTypeRHSExpression"));
            }
            this.mark(expression);
            IElementType operationType = expression.getOperationReference().getReferencedNameElementType();
            if (operationType == JetTokens.COLON || operationType == JetTokens.AS_KEYWORD || operationType == JetTokens.AS_SAFE) {
                this.generateInstructions(expression.getLeft(), false);
            } else {
                this.visitJetElement(expression);
            }
        }

        @Override
        public void visitThrowExpression(@NotNull JetThrowExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitThrowExpression"));
            }
            this.mark(expression);
            JetExpression thrownExpression = expression.getThrownExpression();
            if (thrownExpression != null) {
                this.generateInstructions(thrownExpression, false);
            }
            this.builder.throwException(expression);
        }

        @Override
        public void visitArrayAccessExpression(@NotNull JetArrayAccessExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitArrayAccessExpression"));
            }
            this.mark(expression);
            ResolvedCall<FunctionDescriptor> getMethodResolvedCall = JetControlFlowProcessor.this.trace.get(BindingContext.INDEXED_LVALUE_GET, expression);
            if (!this.checkAndGenerateCall(expression, getMethodResolvedCall)) {
                this.generateArrayAccess(expression, getMethodResolvedCall);
            }
        }

        @Override
        public void visitIsExpression(@NotNull JetIsExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitIsExpression"));
            }
            this.mark(expression);
            this.generateInstructions(expression.getLeftHandSide(), this.inCondition);
        }

        @Override
        public void visitWhenExpression(@NotNull JetWhenExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitWhenExpression"));
            }
            this.mark(expression);
            JetExpression subjectExpression = expression.getSubjectExpression();
            if (subjectExpression != null) {
                this.generateInstructions(subjectExpression, this.inCondition);
            }
            boolean hasElse = false;
            Label doneLabel = this.builder.createUnboundLabel();
            Label nextLabel = null;
            Iterator<JetWhenEntry> iterator2 = expression.getEntries().iterator();
            while (iterator2.hasNext()) {
                JetWhenEntry whenEntry = iterator2.next();
                this.mark(whenEntry);
                boolean isElse = whenEntry.isElse();
                if (isElse) {
                    hasElse = true;
                    if (iterator2.hasNext()) {
                        JetControlFlowProcessor.this.trace.report(Errors.ELSE_MISPLACED_IN_WHEN.on(whenEntry));
                    }
                }
                Label bodyLabel = this.builder.createUnboundLabel();
                JetWhenCondition[] conditions = whenEntry.getConditions();
                for (int i = 0; i < conditions.length; ++i) {
                    JetWhenCondition condition = conditions[i];
                    condition.accept(this.conditionVisitor);
                    if (i + 1 >= conditions.length) continue;
                    this.builder.nondeterministicJump(bodyLabel);
                }
                if (!isElse) {
                    nextLabel = this.builder.createUnboundLabel();
                    this.builder.nondeterministicJump(nextLabel);
                }
                this.builder.bindLabel(bodyLabel);
                this.generateInstructions(whenEntry.getExpression(), this.inCondition);
                this.builder.jump(doneLabel);
                if (isElse) continue;
                this.builder.bindLabel(nextLabel);
            }
            this.builder.bindLabel(doneLabel);
            if (!hasElse && WhenChecker.mustHaveElse(expression, JetControlFlowProcessor.this.trace)) {
                JetControlFlowProcessor.this.trace.report(Errors.NO_ELSE_IN_WHEN.on(expression));
            }
        }

        @Override
        public void visitObjectLiteralExpression(@NotNull JetObjectLiteralExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitObjectLiteralExpression"));
            }
            this.mark(expression);
            JetObjectDeclaration declaration = expression.getObjectDeclaration();
            this.generateInstructions(declaration, this.inCondition);
            List<JetDeclaration> declarations = declaration.getDeclarations();
            ArrayList<JetDeclaration> functions = Lists.newArrayList();
            for (JetDeclaration localDeclaration : declarations) {
                if (localDeclaration instanceof JetProperty || localDeclaration instanceof JetClassInitializer) continue;
                functions.add(localDeclaration);
            }
            for (JetDeclaration function : functions) {
                this.generateInstructions(function, this.inCondition);
            }
            this.builder.createAnonymousObject(expression);
        }

        @Override
        public void visitObjectDeclaration(@NotNull JetObjectDeclaration objectDeclaration) {
            if (objectDeclaration == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "objectDeclaration", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitObjectDeclaration"));
            }
            this.visitClassOrObject(objectDeclaration);
        }

        @Override
        public void visitStringTemplateExpression(@NotNull JetStringTemplateExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitStringTemplateExpression"));
            }
            this.mark(expression);
            for (JetStringTemplateEntry entry : expression.getEntries()) {
                if (!(entry instanceof JetStringTemplateEntryWithExpression)) continue;
                JetStringTemplateEntryWithExpression entryWithExpression = (JetStringTemplateEntryWithExpression)entry;
                this.generateInstructions(entryWithExpression.getExpression(), false);
            }
            this.builder.loadStringTemplate(expression);
        }

        @Override
        public void visitTypeProjection(@NotNull JetTypeProjection typeProjection) {
            if (typeProjection == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeProjection", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitTypeProjection"));
            }
        }

        @Override
        public void visitAnonymousInitializer(@NotNull JetClassInitializer classInitializer) {
            if (classInitializer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classInitializer", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitAnonymousInitializer"));
            }
            this.generateInstructions(classInitializer.getBody(), this.inCondition);
        }

        private void visitClassOrObject(JetClassOrObject classOrObject) {
            for (JetDelegationSpecifier specifier : classOrObject.getDelegationSpecifiers()) {
                this.generateInstructions(specifier, this.inCondition);
            }
            List<JetDeclaration> declarations = classOrObject.getDeclarations();
            for (JetDeclaration declaration : declarations) {
                if (!(declaration instanceof JetProperty) && !(declaration instanceof JetClassInitializer)) continue;
                this.generateInstructions(declaration, this.inCondition);
            }
        }

        @Override
        public void visitClass(@NotNull JetClass klass) {
            if (klass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "klass", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitClass"));
            }
            List<JetParameter> parameters = klass.getPrimaryConstructorParameters();
            for (JetParameter parameter : parameters) {
                this.generateInstructions(parameter, this.inCondition);
            }
            this.visitClassOrObject(klass);
        }

        @Override
        public void visitDelegationToSuperCallSpecifier(@NotNull JetDelegatorToSuperCall call) {
            if (call == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitDelegationToSuperCallSpecifier"));
            }
            List<? extends ValueArgument> valueArguments = call.getValueArguments();
            for (ValueArgument valueArgument : valueArguments) {
                this.generateInstructions(valueArgument.getArgumentExpression(), this.inCondition);
            }
        }

        @Override
        public void visitDelegationByExpressionSpecifier(@NotNull JetDelegatorByExpressionSpecifier specifier) {
            if (specifier == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "specifier", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitDelegationByExpressionSpecifier"));
            }
            this.generateInstructions(specifier.getDelegateExpression(), this.inCondition);
        }

        @Override
        public void visitJetFile(@NotNull JetFile file) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitJetFile"));
            }
            for (JetDeclaration declaration : file.getDeclarations()) {
                if (!(declaration instanceof JetProperty)) continue;
                this.generateInstructions(declaration, this.inCondition);
            }
        }

        @Override
        public void visitJetElement(@NotNull JetElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitJetElement"));
            }
            this.builder.unsupported(element);
        }

        @Nullable
        private ResolvedCall<?> getResolvedCall(@NotNull JetElement expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "getResolvedCall"));
            }
            return JetControlFlowProcessor.this.trace.get(BindingContext.RESOLVED_CALL, expression);
        }

        private boolean generateCall(JetExpression calleeExpression) {
            return this.checkAndGenerateCall(calleeExpression, this.getResolvedCall(calleeExpression));
        }

        private boolean checkAndGenerateCall(JetExpression calleeExpression, @Nullable ResolvedCall<?> resolvedCall) {
            if (resolvedCall == null) {
                this.builder.compilationError(calleeExpression, "No resolved call");
                return false;
            }
            this.generateCall(calleeExpression, resolvedCall);
            return true;
        }

        private void generateCall(JetExpression calleeExpression, ResolvedCall<?> resolvedCall) {
            if (resolvedCall instanceof VariableAsFunctionResolvedCall) {
                VariableAsFunctionResolvedCall variableAsFunctionResolvedCall = (VariableAsFunctionResolvedCall)resolvedCall;
                this.generateCall(calleeExpression, variableAsFunctionResolvedCall.getFunctionCall());
                return;
            }
            Object resultingDescriptor = resolvedCall.getResultingDescriptor();
            if (resultingDescriptor instanceof ExpressionAsFunctionDescriptor) {
                this.generateInstructions(((ExpressionAsFunctionDescriptor)resultingDescriptor).getExpression(), false);
            }
            this.generateReceiver(resolvedCall.getThisObject());
            this.generateReceiver(resolvedCall.getReceiverArgument());
            for (ValueParameterDescriptor parameterDescriptor : resultingDescriptor.getValueParameters()) {
                ResolvedValueArgument argument = resolvedCall.getValueArguments().get(parameterDescriptor);
                if (argument == null) continue;
                this.generateValueArgument(argument);
            }
            if (resultingDescriptor instanceof VariableDescriptor) {
                this.builder.readVariable(calleeExpression, (VariableDescriptor)resultingDescriptor);
            } else {
                this.builder.call(calleeExpression, resolvedCall);
            }
        }

        private void generateReceiver(ReceiverValue receiver) {
            if (!receiver.exists()) {
                return;
            }
            if (!(receiver instanceof ThisReceiver)) {
                if (receiver instanceof ExpressionReceiver) {
                    this.generateInstructions(((ExpressionReceiver)receiver).getExpression(), false);
                } else if (!(receiver instanceof TransientReceiver)) {
                    if (receiver instanceof AutoCastReceiver) {
                        this.generateReceiver(((AutoCastReceiver)receiver).getOriginal());
                    } else {
                        throw new IllegalArgumentException("Unknown receiver kind: " + receiver);
                    }
                }
            }
        }

        private void generateValueArgument(ResolvedValueArgument argument) {
            for (ValueArgument valueArgument : argument.getArguments()) {
                JetExpression expression = valueArgument.getArgumentExpression();
                if (expression == null) continue;
                this.generateInstructions(expression, false);
            }
        }

        private class FinallyBlockGenerator {
            private final JetFinallySection finallyBlock;
            private Label startFinally = null;
            private Label finishFinally = null;

            private FinallyBlockGenerator(JetFinallySection block) {
                this.finallyBlock = block;
            }

            public void generate() {
                JetBlockExpression finalExpression = this.finallyBlock.getFinalExpression();
                if (finalExpression == null) {
                    return;
                }
                if (this.startFinally != null) {
                    assert (this.finishFinally != null);
                    CFPVisitor.this.builder.repeatPseudocode(this.startFinally, this.finishFinally);
                    return;
                }
                this.startFinally = CFPVisitor.this.builder.createUnboundLabel("start finally");
                CFPVisitor.this.builder.bindLabel(this.startFinally);
                CFPVisitor.this.generateInstructions(finalExpression, CFPVisitor.this.inCondition);
                this.finishFinally = CFPVisitor.this.builder.createUnboundLabel("finish finally");
                CFPVisitor.this.builder.bindLabel(this.finishFinally);
            }
        }
    }
}

