/*
 * Decompiled with CFR 0.152.
 */
package jet;

import jet.CharIterator;
import jet.CharProgressionIterator;
import jet.Progression;
import jet.Range;
import org.jetbrains.jet.rt.annotation.AssertInvisibleInResolver;

@AssertInvisibleInResolver
public final class CharRange
implements Range<Character>,
Progression<Character> {
    public static final CharRange EMPTY = new CharRange('\u0001', '\u0000');
    private final char start;
    private final char end;

    public CharRange(char start, char end) {
        this.start = start;
        this.end = end;
    }

    @Override
    public boolean contains(Character item) {
        return this.start <= item.charValue() && item.charValue() <= this.end;
    }

    @Override
    public boolean contains(char item) {
        return this.start <= item && item <= this.end;
    }

    @Override
    public Character getStart() {
        return Character.valueOf(this.start);
    }

    @Override
    public Character getEnd() {
        return Character.valueOf(this.end);
    }

    @Override
    public Integer getIncrement() {
        return 1;
    }

    public CharIterator iterator() {
        return new CharProgressionIterator(this.start, this.end, 1);
    }

    public String toString() {
        return this.start + ".." + this.end;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CharRange range = (CharRange)o;
        return this.end == range.end && this.start == range.start;
    }

    public int hashCode() {
        int result = this.start;
        result = 31 * result + this.end;
        return result;
    }
}

