/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.messages.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.messages.impl.Message;
import com.intellij.util.messages.impl.MessageBusConnectionImpl;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class MessageBusImpl
implements MessageBus {
    private static final Logger LOG = Logger.getInstance("#com.intellij.util.messages.impl.MessageBusImpl");
    private final ThreadLocal<Queue<DeliveryJob>> myMessageQueue;
    private final ConcurrentMap<Topic, Object> mySyncPublishers;
    private final ConcurrentMap<Topic, Object> myAsyncPublishers;
    private final ConcurrentMap<Topic, List<MessageBusConnectionImpl>> mySubscribers;
    private final List<MessageBusImpl> myChildBuses;
    private static final Object NA = new Object();
    private MessageBusImpl myParentBus;
    private final Object myOwner;
    private boolean myDisposed;

    public MessageBusImpl() {
        this("?", null);
    }

    public MessageBusImpl(@NotNull Object owner, MessageBus parentBus) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/messages/impl/MessageBusImpl", "<init>"));
        }
        this.myMessageQueue = MessageBusImpl.createThreadLocalQueue();
        this.mySyncPublishers = new ConcurrentHashMap<Topic, Object>();
        this.myAsyncPublishers = new ConcurrentHashMap<Topic, Object>();
        this.mySubscribers = new ConcurrentHashMap<Topic, List<MessageBusConnectionImpl>>();
        this.myChildBuses = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myOwner = owner.toString();
        this.myParentBus = (MessageBusImpl)parentBus;
        if (this.myParentBus != null) {
            this.myParentBus.notifyChildBusCreated(this);
            LOG.assertTrue(this.myParentBus.myChildBuses.contains(this));
        }
    }

    private void notifyChildBusCreated(MessageBusImpl childBus) {
        this.myChildBuses.add(childBus);
        LOG.assertTrue(childBus.myParentBus == this);
    }

    private void notifyChildBusDisposed(MessageBusImpl childBus) {
        boolean removed = this.myChildBuses.remove(childBus);
        LOG.assertTrue(removed);
    }

    @Override
    @NotNull
    public MessageBusConnection connect() {
        this.checkNotDisposed();
        MessageBusConnectionImpl messageBusConnectionImpl = new MessageBusConnectionImpl(this);
        if (messageBusConnectionImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/messages/impl/MessageBusImpl", "connect"));
        }
        return messageBusConnectionImpl;
    }

    @Override
    @NotNull
    public <L> L syncPublisher(final @NotNull Topic<L> topic) {
        if (topic == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/messages/impl/MessageBusImpl", "syncPublisher"));
        }
        this.checkNotDisposed();
        Object publisher = this.mySyncPublishers.get(topic);
        if (publisher == null) {
            Class<L> listenerClass = topic.getListenerClass();
            InvocationHandler handler = new InvocationHandler(){

                @Override
                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    MessageBusImpl.this.sendMessage(new Message(topic, method, args));
                    return NA;
                }
            };
            publisher = Proxy.newProxyInstance(listenerClass.getClassLoader(), new Class[]{listenerClass}, handler);
            publisher = ConcurrencyUtil.cacheOrGet(this.mySyncPublishers, topic, publisher);
        }
        Object v = publisher;
        if (v == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/messages/impl/MessageBusImpl", "syncPublisher"));
        }
        return (L)v;
    }

    @Override
    public void dispose() {
        this.checkNotDisposed();
        Queue<DeliveryJob> jobs = this.myMessageQueue.get();
        if (!jobs.isEmpty()) {
            LOG.error("Not delivered events in the queue: " + jobs);
        }
        this.myMessageQueue.remove();
        if (this.myParentBus != null) {
            this.myParentBus.notifyChildBusDisposed(this);
            this.myParentBus = null;
        }
        this.myDisposed = true;
    }

    private void checkNotDisposed() {
        LOG.assertTrue(!this.myDisposed, "Already disposed");
    }

    private void postMessage(Message message) {
        Topic.BroadcastDirection direction;
        this.checkNotDisposed();
        Topic topic = message.getTopic();
        List topicSubscribers = (List)this.mySubscribers.get(topic);
        if (topicSubscribers != null) {
            Queue<DeliveryJob> queue = this.myMessageQueue.get();
            for (MessageBusConnectionImpl subscriber : topicSubscribers) {
                queue.offer(new DeliveryJob(subscriber, message));
                subscriber.scheduleMessageDelivery(message);
            }
        }
        if ((direction = topic.getBroadcastDirection()) == Topic.BroadcastDirection.TO_CHILDREN) {
            for (MessageBusImpl childBus : this.myChildBuses) {
                childBus.postMessage(message);
            }
        }
        if (direction == Topic.BroadcastDirection.TO_PARENT && this.myParentBus != null) {
            this.myParentBus.postMessage(message);
        }
    }

    private void sendMessage(Message message) {
        this.pumpMessages();
        this.postMessage(message);
        this.pumpMessages();
    }

    private void pumpMessages() {
        this.checkNotDisposed();
        if (this.myParentBus != null) {
            LOG.assertTrue(this.myParentBus.myChildBuses.contains(this));
            this.myParentBus.pumpMessages();
        } else {
            this.doPumpMessages();
        }
    }

    private void doPumpMessages() {
        DeliveryJob job;
        Queue<DeliveryJob> queue = this.myMessageQueue.get();
        while ((job = queue.poll()) != null) {
            job.connection.deliverMessage(job.message);
        }
        for (MessageBusImpl childBus : this.myChildBuses) {
            LOG.assertTrue(childBus.myParentBus == this);
            childBus.doPumpMessages();
        }
    }

    void notifyOnSubscription(MessageBusConnectionImpl connection, Topic topic) {
        this.checkNotDisposed();
        List topicSubscribers = (List)this.mySubscribers.get(topic);
        if (topicSubscribers == null) {
            topicSubscribers = ContainerUtil.createLockFreeCopyOnWriteList();
            topicSubscribers = ConcurrencyUtil.cacheOrGet(this.mySubscribers, topic, topicSubscribers);
        }
        topicSubscribers.add(connection);
    }

    void notifyConnectionTerminated(MessageBusConnectionImpl connection) {
        for (List topicSubscribers : this.mySubscribers.values()) {
            topicSubscribers.remove(connection);
        }
        if (this.myDisposed) {
            return;
        }
        Iterator i = this.myMessageQueue.get().iterator();
        while (i.hasNext()) {
            DeliveryJob job = (DeliveryJob)i.next();
            if (job.connection != connection) continue;
            i.remove();
        }
    }

    void deliverSingleMessage() {
        this.checkNotDisposed();
        DeliveryJob job = this.myMessageQueue.get().poll();
        if (job == null) {
            return;
        }
        job.connection.deliverMessage(job.message);
    }

    @NotNull
    static <T> ThreadLocal<Queue<T>> createThreadLocalQueue() {
        ThreadLocal threadLocal = new ThreadLocal<Queue<T>>(){

            @Override
            protected Queue<T> initialValue() {
                return new ConcurrentLinkedQueue();
            }
        };
        if (threadLocal == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/messages/impl/MessageBusImpl", "createThreadLocalQueue"));
        }
        return threadLocal;
    }

    private static class DeliveryJob {
        public final MessageBusConnectionImpl connection;
        public final Message message;

        public DeliveryJob(MessageBusConnectionImpl connection, Message message) {
            this.connection = connection;
            this.message = message;
        }

        @NonNls
        public String toString() {
            return "{ DJob connection:" + this.connection.toString() + "; message: " + this.message + " }";
        }
    }
}

