/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.ArrayUtil;
import java.util.Arrays;
import java.util.List;

public class Queue<T> {
    private Object[] myArray;
    private int myFirst;
    private int myLast;
    private boolean isWrapped;

    public Queue(int initialCapacity) {
        this.myArray = initialCapacity > 0 ? new Object[initialCapacity] : ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    public void addLast(T object2) {
        int currentSize = this.size();
        if (currentSize == this.myArray.length) {
            this.myArray = this.normalize(Math.max(currentSize * 2, 5));
            this.myFirst = 0;
            this.myLast = currentSize;
            this.isWrapped = false;
        }
        this.myArray[this.myLast] = object2;
        ++this.myLast;
        if (this.myLast == this.myArray.length) {
            this.isWrapped = !this.isWrapped;
            this.myLast = 0;
        }
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public int size() {
        return this.isWrapped ? this.myArray.length - this.myFirst + this.myLast : this.myLast - this.myFirst;
    }

    public T pullFirst() {
        T result = this.peekFirst();
        this.myArray[this.myFirst] = null;
        ++this.myFirst;
        if (this.myFirst == this.myArray.length) {
            this.myFirst = 0;
            this.isWrapped = !this.isWrapped;
        }
        return result;
    }

    public T peekFirst() {
        if (this.isEmpty()) {
            throw new IndexOutOfBoundsException("queue is empty");
        }
        Object t = this.myArray[this.myFirst];
        return (T)t;
    }

    private int copyFromTo(int first, int last, Object[] result, int destinationPos) {
        int length = last - first;
        System.arraycopy(this.myArray, first, result, destinationPos, length);
        return length;
    }

    private T[] normalize(int capacity) {
        Object[] result = new Object[capacity];
        if (this.isWrapped) {
            int tailLength = this.copyFromTo(this.myFirst, this.myArray.length, result, 0);
            this.copyFromTo(0, this.myLast, result, tailLength);
        } else {
            this.copyFromTo(this.myFirst, this.myLast, result, 0);
        }
        return result;
    }

    public String toString() {
        if (this.isEmpty()) {
            return "<empty>";
        }
        List<Object> list2 = Arrays.asList(this.myArray);
        if (this.isWrapped) {
            return "[[[ " + list2.subList(0, this.myLast) + " ||| ... " + list2.subList(this.myLast, this.myFirst) + " ... ||| " + list2.subList(this.myFirst, this.myArray.length) + " ]]]";
        }
        return "[[[ ... " + list2.subList(0, this.myFirst) + " ... ||| " + list2.subList(this.myFirst, this.myLast) + " ||| ... " + list2.subList(this.myFirst, this.myArray.length) + " ... ]]]";
    }
}

