/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve;

import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.resolve.ProcessCandidateParameterTypeInferencePolicy;
import com.intellij.psi.scope.MethodProcessorSetupFailedException;
import com.intellij.psi.scope.processor.MethodCandidatesProcessor;
import com.intellij.psi.scope.util.PsiScopesUtil;
import com.intellij.psi.util.PsiUtil;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.jetbrains.annotations.NotNull;

public class GraphInferencePolicy
extends ProcessCandidateParameterTypeInferencePolicy {
    private static final ThreadLocal<Map<PsiExpression, Map<JavaResolveResult, PsiSubstitutor>>> ourResults = new ThreadLocal<Map<PsiExpression, Map<JavaResolveResult, PsiSubstitutor>>>(){

        @Override
        protected Map<PsiExpression, Map<JavaResolveResult, PsiSubstitutor>> initialValue() {
            return new WeakHashMap<PsiExpression, Map<JavaResolveResult, PsiSubstitutor>>();
        }
    };

    @Override
    protected List<PsiExpression> getExpressions(PsiExpression[] expressions, int i) {
        List<PsiExpression> list2 = Arrays.asList(expressions);
        list2.set(i, null);
        return list2;
    }

    @Override
    protected PsiSubstitutor getSubstitutor(PsiCallExpression contextCall, PsiExpression[] expressions, int i, JavaResolveResult result) {
        PsiSubstitutor substitutor;
        Map<JavaResolveResult, PsiSubstitutor> map = ourResults.get().get(contextCall);
        if (map != null && (substitutor = map.get(result)) != PsiSubstitutor.UNKNOWN && substitutor != null && substitutor.isValid()) {
            return substitutor;
        }
        substitutor = super.getSubstitutor(contextCall, expressions, i, result);
        if (map != null) {
            map.put(result, substitutor);
        }
        return substitutor;
    }

    @Override
    @NotNull
    protected JavaResolveResult[] getResults(@NotNull PsiCallExpression contextCall, final int exprIdx) throws MethodProcessorSetupFailedException {
        if (contextCall == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/resolve/GraphInferencePolicy", "getResults"));
        }
        Map<JavaResolveResult, PsiSubstitutor> map = ourResults.get().get(contextCall);
        if (map != null) {
            Set<JavaResolveResult> results = map.keySet();
            JavaResolveResult[] javaResolveResultArray = results.toArray(new JavaResolveResult[results.size()]);
            if (javaResolveResultArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/GraphInferencePolicy", "getResults"));
            }
            return javaResolveResultArray;
        }
        PsiFile containingFile = contextCall.getContainingFile();
        MethodCandidatesProcessor processor = new MethodCandidatesProcessor(contextCall, containingFile){

            @Override
            protected PsiType[] getExpressionTypes(PsiExpressionList argumentList) {
                if (argumentList != null) {
                    PsiExpression[] expressions = argumentList.getExpressions();
                    PsiType[] types = new PsiType[expressions.length];
                    for (int i = 0; i < expressions.length; ++i) {
                        types[i] = i != exprIdx ? expressions[i].getType() : PsiType.NULL;
                    }
                    return types;
                }
                return null;
            }
        };
        PsiScopesUtil.setupAndRunProcessor(processor, contextCall, false);
        JavaResolveResult[] results = processor.getResult();
        map = new WeakHashMap<JavaResolveResult, PsiSubstitutor>();
        ourResults.get().put(contextCall, map);
        for (JavaResolveResult result : results) {
            map.put(result, PsiSubstitutor.UNKNOWN);
        }
        if (results == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/GraphInferencePolicy", "getResults"));
        }
        return results;
    }

    public static void forget(PsiElement parent) {
        PsiElement ggParent;
        PsiElement gParent;
        if (parent instanceof PsiExpression && (gParent = PsiUtil.skipParenthesizedExprUp(parent.getParent())) instanceof PsiExpressionList && (ggParent = gParent.getParent()) instanceof PsiCallExpression) {
            ourResults.get().remove(ggParent);
        }
    }
}

