/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.compiled;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationParameterList;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.compiled.ClsAnnotationImpl;
import com.intellij.psi.impl.compiled.ClsElementImpl;
import com.intellij.psi.impl.compiled.ClsLiteralExpressionImpl;
import com.intellij.psi.impl.compiled.ClsNameValuePairImpl;
import com.intellij.psi.impl.java.stubs.PsiAnnotationStub;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.tree.TreeElement;
import org.jetbrains.annotations.NotNull;

public class ClsAnnotationParameterListImpl
extends ClsElementImpl
implements PsiAnnotationParameterList {
    private final PsiAnnotation myParent;
    private final ClsNameValuePairImpl[] myAttributes;

    public ClsAnnotationParameterListImpl(@NotNull PsiAnnotation parent, @NotNull PsiNameValuePair[] psiAttributes) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/compiled/ClsAnnotationParameterListImpl", "<init>"));
        }
        if (psiAttributes == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/compiled/ClsAnnotationParameterListImpl", "<init>"));
        }
        this.myParent = parent;
        this.myAttributes = new ClsNameValuePairImpl[psiAttributes.length];
        for (int i = 0; i < psiAttributes.length; ++i) {
            String name = psiAttributes[i].getName();
            PsiAnnotationMemberValue value = psiAttributes[i].getValue();
            if (value == null) {
                String anno = parent instanceof ClsAnnotationImpl ? ((PsiAnnotationStub)((ClsAnnotationImpl)parent).getStub()).getText() : parent.getText();
                Logger.getInstance(this.getClass()).error("name=" + name + " anno=[" + anno + "] file=" + parent.getContainingFile());
                value = new ClsLiteralExpressionImpl(this, "null", PsiType.NULL, null);
            }
            if (psiAttributes.length == 1 && "value".equals(name)) {
                name = null;
            }
            this.myAttributes[i] = new ClsNameValuePairImpl(this, name, value);
        }
    }

    @Override
    public void appendMirrorText(int indentLevel, @NotNull StringBuilder buffer) {
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/compiled/ClsAnnotationParameterListImpl", "appendMirrorText"));
        }
        if (this.myAttributes.length != 0) {
            buffer.append("(");
            for (int i = 0; i < this.myAttributes.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                this.myAttributes[i].appendMirrorText(indentLevel, buffer);
            }
            buffer.append(")");
        }
    }

    @Override
    public void setMirror(@NotNull TreeElement element) throws ClsElementImpl.InvalidMirrorException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/compiled/ClsAnnotationParameterListImpl", "setMirror"));
        }
        this.setMirrorCheckingType(element, null);
        ClsAnnotationParameterListImpl.setMirrors((PsiElement[])this.myAttributes, (PsiElement[])((PsiAnnotationParameterList)SourceTreeToPsiMap.treeToPsiNotNull(element)).getAttributes());
    }

    @Override
    @NotNull
    public PsiElement[] getChildren() {
        if (this.myAttributes == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsAnnotationParameterListImpl", "getChildren"));
        }
        return this.myAttributes;
    }

    @Override
    public PsiElement getParent() {
        return this.myParent;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/compiled/ClsAnnotationParameterListImpl", "accept"));
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitAnnotationParameterList(this);
        } else {
            visitor.visitElement(this);
        }
    }

    @Override
    @NotNull
    public PsiNameValuePair[] getAttributes() {
        if (this.myAttributes == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsAnnotationParameterListImpl", "getAttributes"));
        }
        return this.myAttributes;
    }
}

