/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.CommonBundle;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.ResourceBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.PropertyKey;

public class PsiBundle {
    private static Reference<ResourceBundle> ourBundle;

    private PsiBundle() {
    }

    public static String message(@PropertyKey(resourceBundle="messages.PsiBundle") String key, Object ... params) {
        return CommonBundle.message(PsiBundle.getBundle(), key, params);
    }

    private static ResourceBundle getBundle() {
        ResourceBundle bundle = null;
        if (ourBundle != null) {
            bundle = ourBundle.get();
        }
        if (bundle == null) {
            bundle = ResourceBundle.getBundle("messages.PsiBundle");
            ourBundle = new SoftReference<ResourceBundle>(bundle);
        }
        return bundle;
    }

    @NotNull
    public static String visibilityPresentation(@NotNull String modifier) {
        if (modifier == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/PsiBundle", "visibilityPresentation"));
        }
        String string = PsiBundle.message(modifier + ".visibility.presentation", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiBundle", "visibilityPresentation"));
        }
        return string;
    }
}

