/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.core;

import com.intellij.core.CoreApplicationEnvironment;
import com.intellij.core.CoreProjectScopeBuilder;
import com.intellij.mock.MockDumbService;
import com.intellij.mock.MockFileIndexFacade;
import com.intellij.mock.MockProject;
import com.intellij.mock.MockResolveScopeManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.PsiCachedValuesFactory;
import com.intellij.psi.impl.PsiFileFactoryImpl;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.PsiModificationTrackerImpl;
import com.intellij.psi.impl.PsiTreeChangePreprocessor;
import com.intellij.psi.impl.ResolveScopeManager;
import com.intellij.psi.impl.file.PsiDirectoryFactory;
import com.intellij.psi.impl.file.PsiDirectoryFactoryImpl;
import com.intellij.psi.impl.file.impl.FileManagerImpl;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.search.ProjectScopeBuilder;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.CachedValuesManagerImpl;
import com.intellij.util.messages.impl.MessageBusImpl;

public class CoreProjectEnvironment {
    private final Disposable myParentDisposable;
    private final CoreApplicationEnvironment myEnvironment;
    protected final FileIndexFacade myFileIndexFacade;
    protected final PsiManagerImpl myPsiManager;
    protected final MockProject myProject;
    protected final MessageBusImpl myMessageBus;

    public CoreProjectEnvironment(Disposable parentDisposable, CoreApplicationEnvironment applicationEnvironment) {
        this.myParentDisposable = parentDisposable;
        this.myEnvironment = applicationEnvironment;
        this.myProject = new MockProject(this.myEnvironment.getApplication().getPicoContainer(), this.myParentDisposable);
        this.preregisterServices();
        this.myFileIndexFacade = this.createFileIndexFacade();
        this.myMessageBus = new MessageBusImpl("CoreProjectEnvironment", null);
        PsiModificationTrackerImpl modificationTracker = new PsiModificationTrackerImpl(this.myProject);
        this.myProject.registerService(PsiModificationTracker.class, modificationTracker);
        this.myProject.registerService(FileIndexFacade.class, this.myFileIndexFacade);
        this.myProject.registerService(ResolveCache.class, new ResolveCache(this.myMessageBus));
        this.registerProjectExtensionPoint(PsiTreeChangePreprocessor.EP_NAME, PsiTreeChangePreprocessor.class);
        this.myPsiManager = new PsiManagerImpl(this.myProject, null, null, this.myFileIndexFacade, this.myMessageBus, modificationTracker);
        ((FileManagerImpl)this.myPsiManager.getFileManager()).markInitialized();
        this.registerProjectComponent(PsiManager.class, this.myPsiManager);
        this.myProject.registerService(ResolveScopeManager.class, this.createResolveScopeManager(this.myPsiManager));
        this.myProject.registerService(PsiFileFactory.class, new PsiFileFactoryImpl(this.myPsiManager));
        this.myProject.registerService(CachedValuesManager.class, new CachedValuesManagerImpl(this.myProject, new PsiCachedValuesFactory(this.myPsiManager)));
        this.myProject.registerService(PsiDirectoryFactory.class, new PsiDirectoryFactoryImpl(this.myPsiManager));
        this.myProject.registerService(ProjectScopeBuilder.class, this.createProjectScopeBuilder());
        this.myProject.registerService(DumbService.class, new MockDumbService(this.myProject));
    }

    protected ProjectScopeBuilder createProjectScopeBuilder() {
        return new CoreProjectScopeBuilder(this.myProject, this.myFileIndexFacade);
    }

    protected void preregisterServices() {
    }

    protected FileIndexFacade createFileIndexFacade() {
        return new MockFileIndexFacade(this.myProject);
    }

    protected ResolveScopeManager createResolveScopeManager(PsiManager psiManager) {
        return new MockResolveScopeManager(this.myProject);
    }

    public <T> void registerProjectExtensionPoint(ExtensionPointName<T> extensionPointName, Class<? extends T> aClass) {
        CoreApplicationEnvironment.registerExtensionPoint(Extensions.getArea(this.myProject), extensionPointName, aClass);
    }

    public <T> void registerProjectComponent(Class<T> interfaceClass, T implementation) {
        CoreApplicationEnvironment.registerComponentInstance(this.myProject.getPicoContainer(), interfaceClass, implementation);
    }

    public CoreApplicationEnvironment getEnvironment() {
        return this.myEnvironment;
    }

    public MockProject getProject() {
        return this.myProject;
    }
}

