/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.utils.mutator;

import com.google.dart.compiler.backend.js.ast.JsBlock;
import com.google.dart.compiler.backend.js.ast.JsExpressionStatement;
import com.google.dart.compiler.backend.js.ast.JsIf;
import com.google.dart.compiler.backend.js.ast.JsNode;
import com.google.dart.compiler.backend.js.ast.JsStatement;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.k2js.translate.utils.JsAstUtils;
import org.jetbrains.k2js.translate.utils.mutator.Mutator;

public final class LastExpressionMutator {
    @NotNull
    private final Mutator mutator;

    public static JsStatement mutateLastExpression(@NotNull JsNode node, @NotNull Mutator mutator) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/k2js/translate/utils/mutator/LastExpressionMutator", "mutateLastExpression"));
        }
        if (mutator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mutator", "org/jetbrains/k2js/translate/utils/mutator/LastExpressionMutator", "mutateLastExpression"));
        }
        return JsAstUtils.convertToStatement(new LastExpressionMutator(mutator).apply(node));
    }

    private LastExpressionMutator(@NotNull Mutator mutator) {
        if (mutator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mutator", "org/jetbrains/k2js/translate/utils/mutator/LastExpressionMutator", "<init>"));
        }
        this.mutator = mutator;
    }

    @NotNull
    private JsNode apply(@NotNull JsNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/k2js/translate/utils/mutator/LastExpressionMutator", "apply"));
        }
        if (node instanceof JsBlock) {
            JsNode jsNode = this.applyToBlock((JsBlock)node);
            if (jsNode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/utils/mutator/LastExpressionMutator", "apply"));
            }
            return jsNode;
        }
        if (node instanceof JsIf) {
            JsNode jsNode = this.applyToIf((JsIf)node);
            if (jsNode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/utils/mutator/LastExpressionMutator", "apply"));
            }
            return jsNode;
        }
        if (node instanceof JsExpressionStatement) {
            JsNode jsNode = this.applyToStatement((JsExpressionStatement)node);
            if (jsNode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/utils/mutator/LastExpressionMutator", "apply"));
            }
            return jsNode;
        }
        JsNode jsNode = this.mutator.mutate(node);
        if (jsNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/utils/mutator/LastExpressionMutator", "apply"));
        }
        return jsNode;
    }

    @NotNull
    private JsNode applyToStatement(@NotNull JsExpressionStatement node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/k2js/translate/utils/mutator/LastExpressionMutator", "applyToStatement"));
        }
        JsStatement jsStatement = JsAstUtils.convertToStatement(this.apply(node.getExpression()));
        if (jsStatement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/utils/mutator/LastExpressionMutator", "applyToStatement"));
        }
        return jsStatement;
    }

    @NotNull
    private JsNode applyToIf(@NotNull JsIf node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/k2js/translate/utils/mutator/LastExpressionMutator", "applyToIf"));
        }
        node.setThenStatement(JsAstUtils.convertToStatement(this.apply(node.getThenStatement())));
        JsStatement elseStmt = node.getElseStatement();
        if (elseStmt != null) {
            node.setElseStatement(JsAstUtils.convertToStatement(this.apply(elseStmt)));
        }
        JsIf jsIf = node;
        if (jsIf == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/utils/mutator/LastExpressionMutator", "applyToIf"));
        }
        return jsIf;
    }

    @NotNull
    private JsNode applyToBlock(@NotNull JsBlock node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/k2js/translate/utils/mutator/LastExpressionMutator", "applyToBlock"));
        }
        List<JsStatement> statements = node.getStatements();
        if (statements.isEmpty()) {
            JsBlock jsBlock = node;
            if (jsBlock == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/utils/mutator/LastExpressionMutator", "applyToBlock"));
            }
            return jsBlock;
        }
        int size = statements.size();
        statements.set(size - 1, JsAstUtils.convertToStatement(this.apply(statements.get(size - 1))));
        JsBlock jsBlock = node;
        if (jsBlock == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/utils/mutator/LastExpressionMutator", "applyToBlock"));
        }
        return jsBlock;
    }
}

