/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.reference;

import com.google.dart.compiler.backend.js.ast.JsExpression;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CallParameters {
    @Nullable
    private final JsExpression receiver;
    @NotNull
    private final JsExpression functionReference;
    @Nullable
    private final JsExpression thisObject;

    public CallParameters(@Nullable JsExpression receiver, @NotNull JsExpression functionReference, @Nullable JsExpression thisObject) {
        if (functionReference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionReference", "org/jetbrains/k2js/translate/reference/CallParameters", "<init>"));
        }
        this.receiver = receiver;
        this.functionReference = functionReference;
        this.thisObject = thisObject;
    }

    @NotNull
    public JsExpression getFunctionReference() {
        JsExpression jsExpression = this.functionReference;
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/reference/CallParameters", "getFunctionReference"));
        }
        return jsExpression;
    }

    @Nullable
    public JsExpression getThisObject() {
        return this.thisObject;
    }

    @Nullable
    public JsExpression getReceiver() {
        return this.receiver;
    }

    @Nullable
    public JsExpression getThisOrReceiverOrNull() {
        if (this.thisObject == null) {
            return this.receiver;
        }
        assert (this.receiver == null);
        return this.thisObject;
    }
}

