/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java.resolver;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassOrNamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.java.descriptor.JavaPropertyDescriptor;
import org.jetbrains.jet.lang.resolve.java.resolver.DescriptorResolverUtils;
import org.jetbrains.jet.lang.resolve.java.resolver.ErrorReporter;
import org.jetbrains.jet.lang.resolve.java.resolver.ExternalSignatureResolver;
import org.jetbrains.jet.lang.resolve.java.resolver.JavaAnnotationResolver;
import org.jetbrains.jet.lang.resolve.java.resolver.JavaResolverCache;
import org.jetbrains.jet.lang.resolve.java.resolver.JavaTypeTransformer;
import org.jetbrains.jet.lang.resolve.java.resolver.TypeVariableResolver;
import org.jetbrains.jet.lang.resolve.java.resolver.TypeVariableResolverImpl;
import org.jetbrains.jet.lang.resolve.java.scope.NamedMembers;
import org.jetbrains.jet.lang.resolve.java.structure.JavaField;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeUtils;

public final class JavaPropertyResolver {
    private JavaTypeTransformer typeTransformer;
    private JavaResolverCache cache;
    private JavaAnnotationResolver annotationResolver;
    private ExternalSignatureResolver externalSignatureResolver;
    private ErrorReporter errorReporter;

    public void setTypeTransformer(@NotNull JavaTypeTransformer javaTypeTransformer) {
        if (javaTypeTransformer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javaTypeTransformer", "org/jetbrains/jet/lang/resolve/java/resolver/JavaPropertyResolver", "setTypeTransformer"));
        }
        this.typeTransformer = javaTypeTransformer;
    }

    public void setCache(JavaResolverCache cache) {
        this.cache = cache;
    }

    public void setAnnotationResolver(JavaAnnotationResolver annotationResolver) {
        this.annotationResolver = annotationResolver;
    }

    public void setExternalSignatureResolver(ExternalSignatureResolver externalSignatureResolver) {
        this.externalSignatureResolver = externalSignatureResolver;
    }

    public void setErrorReporter(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
    }

    @NotNull
    public Set<VariableDescriptor> resolveFieldGroup(@NotNull NamedMembers members, @NotNull ClassOrNamespaceDescriptor owner) {
        JavaField field;
        if (members == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "members", "org/jetbrains/jet/lang/resolve/java/resolver/JavaPropertyResolver", "resolveFieldGroup"));
        }
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "org/jetbrains/jet/lang/resolve/java/resolver/JavaPropertyResolver", "resolveFieldGroup"));
        }
        if (DescriptorUtils.isEnumClassObject(owner)) {
            Set<VariableDescriptor> set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/resolver/JavaPropertyResolver", "resolveFieldGroup"));
            }
            return set;
        }
        Name propertyName = members.getName();
        List<JavaField> fields = members.getFields();
        HashSet<PropertyDescriptor> propertiesFromCurrent = new HashSet<PropertyDescriptor>(1);
        assert (fields.size() <= 1);
        if (fields.size() == 1 && !(field = fields.iterator().next()).isEnumEntry()) {
            propertiesFromCurrent.add(this.resolveProperty(owner, propertyName, field));
        }
        HashSet<PropertyDescriptor> properties = new HashSet<PropertyDescriptor>();
        if (owner instanceof ClassDescriptor) {
            ClassDescriptor classDescriptor = (ClassDescriptor)owner;
            Set<PropertyDescriptor> propertiesFromSupertypes = JavaPropertyResolver.getPropertiesFromSupertypes(propertyName, classDescriptor);
            properties.addAll(DescriptorResolverUtils.resolveOverrides(propertyName, propertiesFromSupertypes, propertiesFromCurrent, classDescriptor, this.errorReporter));
        }
        properties.addAll(propertiesFromCurrent);
        HashSet<VariableDescriptor> hashSet = new HashSet<VariableDescriptor>(properties);
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/resolver/JavaPropertyResolver", "resolveFieldGroup"));
        }
        return hashSet;
    }

    @NotNull
    private PropertyDescriptor resolveProperty(@NotNull ClassOrNamespaceDescriptor owner, @NotNull Name name, @NotNull JavaField field) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "org/jetbrains/jet/lang/resolve/java/resolver/JavaPropertyResolver", "resolveProperty"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/resolve/java/resolver/JavaPropertyResolver", "resolveProperty"));
        }
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "org/jetbrains/jet/lang/resolve/java/resolver/JavaPropertyResolver", "resolveProperty"));
        }
        assert (!field.isEnumEntry()) : "Enum entries are resolved into classes, not into properties: " + name;
        boolean isVar = !field.isFinal();
        JavaPropertyDescriptor propertyDescriptor = new JavaPropertyDescriptor(owner, this.annotationResolver.resolveAnnotations(field), field.getVisibility(), isVar, name);
        propertyDescriptor.initialize(null, null);
        TypeVariableResolverImpl typeVariableResolver = new TypeVariableResolverImpl(Collections.<TypeParameterDescriptor>emptyList(), propertyDescriptor);
        JetType propertyType = this.getPropertyType(field, typeVariableResolver);
        ExternalSignatureResolver.AlternativeFieldSignature effectiveSignature = this.externalSignatureResolver.resolveAlternativeFieldSignature(field, propertyType, isVar);
        List<String> signatureErrors = effectiveSignature.getErrors();
        if (!signatureErrors.isEmpty()) {
            this.externalSignatureResolver.reportSignatureErrors(propertyDescriptor, signatureErrors);
        }
        propertyDescriptor.setType(effectiveSignature.getReturnType(), Collections.emptyList(), DescriptorUtils.getExpectedThisObjectIfNeeded(owner), (JetType)null);
        this.cache.recordField(field, propertyDescriptor);
        JavaPropertyDescriptor javaPropertyDescriptor = propertyDescriptor;
        if (javaPropertyDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/resolver/JavaPropertyResolver", "resolveProperty"));
        }
        return javaPropertyDescriptor;
    }

    @NotNull
    private JetType getPropertyType(@NotNull JavaField field, @NotNull TypeVariableResolver typeVariableResolver) {
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "org/jetbrains/jet/lang/resolve/java/resolver/JavaPropertyResolver", "getPropertyType"));
        }
        if (typeVariableResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeVariableResolver", "org/jetbrains/jet/lang/resolve/java/resolver/JavaPropertyResolver", "getPropertyType"));
        }
        JetType propertyType = this.typeTransformer.transformToType(field.getType(), typeVariableResolver);
        if (this.annotationResolver.hasNotNullAnnotation(field) || JavaPropertyResolver.isStaticFinalField(field)) {
            JetType jetType = TypeUtils.makeNotNullable(propertyType);
            if (jetType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/resolver/JavaPropertyResolver", "getPropertyType"));
            }
            return jetType;
        }
        JetType jetType = propertyType;
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/resolver/JavaPropertyResolver", "getPropertyType"));
        }
        return jetType;
    }

    @NotNull
    private static Set<PropertyDescriptor> getPropertiesFromSupertypes(@NotNull Name name, @NotNull ClassDescriptor descriptor) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/resolve/java/resolver/JavaPropertyResolver", "getPropertiesFromSupertypes"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/resolve/java/resolver/JavaPropertyResolver", "getPropertiesFromSupertypes"));
        }
        HashSet<PropertyDescriptor> result = new HashSet<PropertyDescriptor>();
        for (JetType supertype : descriptor.getTypeConstructor().getSupertypes()) {
            for (VariableDescriptor property2 : supertype.getMemberScope().getProperties(name)) {
                result.add((PropertyDescriptor)property2);
            }
        }
        HashSet<PropertyDescriptor> hashSet = result;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/resolver/JavaPropertyResolver", "getPropertiesFromSupertypes"));
        }
        return hashSet;
    }

    private static boolean isStaticFinalField(@NotNull JavaField field) {
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "org/jetbrains/jet/lang/resolve/java/resolver/JavaPropertyResolver", "isStaticFinalField"));
        }
        return field.isFinal() && field.isStatic();
    }
}

