/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java.resolver;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.jet.lang.resolve.constants.AnnotationValue;
import org.jetbrains.jet.lang.resolve.constants.ArrayValue;
import org.jetbrains.jet.lang.resolve.constants.BooleanValue;
import org.jetbrains.jet.lang.resolve.constants.ByteValue;
import org.jetbrains.jet.lang.resolve.constants.CharValue;
import org.jetbrains.jet.lang.resolve.constants.CompileTimeConstant;
import org.jetbrains.jet.lang.resolve.constants.DoubleValue;
import org.jetbrains.jet.lang.resolve.constants.EnumValue;
import org.jetbrains.jet.lang.resolve.constants.FloatValue;
import org.jetbrains.jet.lang.resolve.constants.IntValue;
import org.jetbrains.jet.lang.resolve.constants.JavaClassValue;
import org.jetbrains.jet.lang.resolve.constants.LongValue;
import org.jetbrains.jet.lang.resolve.constants.NullValue;
import org.jetbrains.jet.lang.resolve.constants.ShortValue;
import org.jetbrains.jet.lang.resolve.constants.StringValue;
import org.jetbrains.jet.lang.resolve.java.DescriptorSearchRule;
import org.jetbrains.jet.lang.resolve.java.resolver.DescriptorResolverUtils;
import org.jetbrains.jet.lang.resolve.java.resolver.JavaAnnotationResolver;
import org.jetbrains.jet.lang.resolve.java.resolver.JavaClassResolver;
import org.jetbrains.jet.lang.resolve.java.resolver.JavaTypeTransformer;
import org.jetbrains.jet.lang.resolve.java.resolver.PostponedTasks;
import org.jetbrains.jet.lang.resolve.java.resolver.TypeVariableResolver;
import org.jetbrains.jet.lang.resolve.java.structure.JavaAnnotation;
import org.jetbrains.jet.lang.resolve.java.structure.JavaAnnotationArgument;
import org.jetbrains.jet.lang.resolve.java.structure.JavaAnnotationAsAnnotationArgument;
import org.jetbrains.jet.lang.resolve.java.structure.JavaArrayAnnotationArgument;
import org.jetbrains.jet.lang.resolve.java.structure.JavaClassObjectAnnotationArgument;
import org.jetbrains.jet.lang.resolve.java.structure.JavaElement;
import org.jetbrains.jet.lang.resolve.java.structure.JavaField;
import org.jetbrains.jet.lang.resolve.java.structure.JavaLiteralAnnotationArgument;
import org.jetbrains.jet.lang.resolve.java.structure.JavaReferenceAnnotationArgument;
import org.jetbrains.jet.lang.resolve.java.structure.JavaType;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.JetTypeImpl;
import org.jetbrains.jet.lang.types.TypeProjectionImpl;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;

public final class JavaAnnotationArgumentResolver {
    public static final FqName JL_CLASS_FQ_NAME = new FqName("java.lang.Class");
    private JavaAnnotationResolver annotationResolver;
    private JavaClassResolver classResolver;
    private JavaTypeTransformer typeTransformer;

    public void setAnnotationResolver(JavaAnnotationResolver annotationResolver) {
        this.annotationResolver = annotationResolver;
    }

    public void setClassResolver(JavaClassResolver classResolver) {
        this.classResolver = classResolver;
    }

    public void setTypeTransformer(JavaTypeTransformer typeTransformer) {
        this.typeTransformer = typeTransformer;
    }

    @Nullable
    public CompileTimeConstant<?> resolveAnnotationArgument(@NotNull FqName annotationFqName, @NotNull JavaAnnotationArgument argument, @NotNull PostponedTasks postponedTasks) {
        if (annotationFqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationFqName", "org/jetbrains/jet/lang/resolve/java/resolver/JavaAnnotationArgumentResolver", "resolveAnnotationArgument"));
        }
        if (argument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argument", "org/jetbrains/jet/lang/resolve/java/resolver/JavaAnnotationArgumentResolver", "resolveAnnotationArgument"));
        }
        if (postponedTasks == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "postponedTasks", "org/jetbrains/jet/lang/resolve/java/resolver/JavaAnnotationArgumentResolver", "resolveAnnotationArgument"));
        }
        if (argument instanceof JavaLiteralAnnotationArgument) {
            return JavaAnnotationArgumentResolver.resolveCompileTimeConstantValue(((JavaLiteralAnnotationArgument)argument).getValue(), null);
        }
        if (argument instanceof JavaReferenceAnnotationArgument) {
            return this.resolveFromReference(((JavaReferenceAnnotationArgument)argument).resolve(), postponedTasks);
        }
        if (argument instanceof JavaArrayAnnotationArgument) {
            Name argumentName = argument.getName();
            return this.resolveFromArray(annotationFqName, argumentName == null ? JavaAnnotationResolver.DEFAULT_ANNOTATION_MEMBER_NAME : argumentName, ((JavaArrayAnnotationArgument)argument).getElements(), postponedTasks);
        }
        if (argument instanceof JavaAnnotationAsAnnotationArgument) {
            return this.resolveFromAnnotation(((JavaAnnotationAsAnnotationArgument)argument).getAnnotation(), postponedTasks);
        }
        if (argument instanceof JavaClassObjectAnnotationArgument) {
            return this.resolveFromJavaClassObjectType(((JavaClassObjectAnnotationArgument)argument).getReferencedType());
        }
        return null;
    }

    @Nullable
    private CompileTimeConstant<?> resolveFromAnnotation(@NotNull JavaAnnotation value, @NotNull PostponedTasks taskList) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/jet/lang/resolve/java/resolver/JavaAnnotationArgumentResolver", "resolveFromAnnotation"));
        }
        if (taskList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "taskList", "org/jetbrains/jet/lang/resolve/java/resolver/JavaAnnotationArgumentResolver", "resolveFromAnnotation"));
        }
        AnnotationDescriptor descriptor = this.annotationResolver.resolveAnnotation(value, taskList);
        return descriptor == null ? null : new AnnotationValue(descriptor);
    }

    @Nullable
    private CompileTimeConstant<?> resolveFromArray(@NotNull FqName annotationFqName, @NotNull Name argumentName, @NotNull List<JavaAnnotationArgument> elements, @NotNull PostponedTasks taskList) {
        if (annotationFqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationFqName", "org/jetbrains/jet/lang/resolve/java/resolver/JavaAnnotationArgumentResolver", "resolveFromArray"));
        }
        if (argumentName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argumentName", "org/jetbrains/jet/lang/resolve/java/resolver/JavaAnnotationArgumentResolver", "resolveFromArray"));
        }
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "org/jetbrains/jet/lang/resolve/java/resolver/JavaAnnotationArgumentResolver", "resolveFromArray"));
        }
        if (taskList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "taskList", "org/jetbrains/jet/lang/resolve/java/resolver/JavaAnnotationArgumentResolver", "resolveFromArray"));
        }
        ClassDescriptor annotationClass = this.classResolver.resolveClass(annotationFqName, DescriptorSearchRule.INCLUDE_KOTLIN_SOURCES, taskList);
        if (annotationClass == null) {
            return null;
        }
        ValueParameterDescriptor valueParameter = DescriptorResolverUtils.getAnnotationParameterByName(argumentName, annotationClass);
        if (valueParameter == null) {
            return null;
        }
        ArrayList values = new ArrayList(elements.size());
        for (JavaAnnotationArgument argument : elements) {
            CompileTimeConstant<?> value = this.resolveAnnotationArgument(annotationFqName, argument, taskList);
            values.add(value == null ? NullValue.NULL : value);
        }
        return new ArrayValue(values, valueParameter.getType());
    }

    @Nullable
    private CompileTimeConstant<?> resolveFromReference(@Nullable JavaElement element, @NotNull PostponedTasks taskList) {
        if (taskList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "taskList", "org/jetbrains/jet/lang/resolve/java/resolver/JavaAnnotationArgumentResolver", "resolveFromReference"));
        }
        if (!(element instanceof JavaField)) {
            return null;
        }
        JavaField field = (JavaField)element;
        if (!field.isEnumEntry()) {
            return null;
        }
        FqName fqName = field.getContainingClass().getFqName();
        if (fqName == null) {
            return null;
        }
        ClassDescriptor enumClass = this.classResolver.resolveClass(fqName, DescriptorSearchRule.INCLUDE_KOTLIN_SOURCES, taskList);
        if (enumClass == null) {
            return null;
        }
        ClassifierDescriptor classifier = enumClass.getUnsubstitutedInnerClassesScope().getClassifier(field.getName());
        if (!(classifier instanceof ClassDescriptor)) {
            return null;
        }
        return new EnumValue((ClassDescriptor)classifier);
    }

    @Nullable
    private CompileTimeConstant<?> resolveFromJavaClassObjectType(@NotNull JavaType javaType) {
        if (javaType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javaType", "org/jetbrains/jet/lang/resolve/java/resolver/JavaAnnotationArgumentResolver", "resolveFromJavaClassObjectType"));
        }
        JetType type = this.typeTransformer.transformToType(javaType, TypeVariableResolver.EMPTY);
        ClassDescriptor jlClass = this.classResolver.resolveClass(JL_CLASS_FQ_NAME, DescriptorSearchRule.IGNORE_KOTLIN_SOURCES);
        if (jlClass == null) {
            return null;
        }
        List<TypeProjectionImpl> arguments2 = Collections.singletonList(new TypeProjectionImpl(type));
        JetTypeImpl javaClassType = new JetTypeImpl(jlClass.getAnnotations(), jlClass.getTypeConstructor(), false, arguments2, jlClass.getMemberScope(arguments2));
        return new JavaClassValue(javaClassType);
    }

    @Nullable
    public static CompileTimeConstant<?> resolveCompileTimeConstantValue(@Nullable Object value, @Nullable JetType expectedType) {
        if (value instanceof String) {
            return new StringValue((String)value);
        }
        if (value instanceof Byte) {
            return new ByteValue((Byte)value);
        }
        if (value instanceof Short) {
            return new ShortValue((Short)value);
        }
        if (value instanceof Character) {
            return new CharValue(((Character)value).charValue());
        }
        if (value instanceof Integer) {
            KotlinBuiltIns builtIns = KotlinBuiltIns.getInstance();
            Integer integer = (Integer)value;
            if (((Object)builtIns.getShortType()).equals(expectedType)) {
                return new ShortValue(integer.shortValue());
            }
            if (((Object)builtIns.getByteType()).equals(expectedType)) {
                return new ByteValue(integer.byteValue());
            }
            if (((Object)builtIns.getCharType()).equals(expectedType)) {
                return new CharValue((char)integer.intValue());
            }
            return new IntValue(integer);
        }
        if (value instanceof Long) {
            return new LongValue((Long)value);
        }
        if (value instanceof Float) {
            return new FloatValue(((Float)value).floatValue());
        }
        if (value instanceof Double) {
            return new DoubleValue((Double)value);
        }
        if (value instanceof Boolean) {
            return BooleanValue.valueOf((Boolean)value);
        }
        if (value == null) {
            return NullValue.NULL;
        }
        return null;
    }
}

