/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.constants;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationArgumentVisitor;
import org.jetbrains.jet.lang.resolve.constants.CompileTimeConstant;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;

public class EnumValue
implements CompileTimeConstant<ClassDescriptor> {
    private final ClassDescriptor value;

    public EnumValue(@NotNull ClassDescriptor value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/jet/lang/resolve/constants/EnumValue", "<init>"));
        }
        this.value = value;
    }

    @Override
    @NotNull
    public ClassDescriptor getValue() {
        ClassDescriptor classDescriptor = this.value;
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/constants/EnumValue", "getValue"));
        }
        return classDescriptor;
    }

    @Override
    @NotNull
    public JetType getType(@NotNull KotlinBuiltIns kotlinBuiltIns) {
        if (kotlinBuiltIns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kotlinBuiltIns", "org/jetbrains/jet/lang/resolve/constants/EnumValue", "getType"));
        }
        JetType type = this.value.getClassObjectType();
        assert (type != null) : "Enum entry should have a class object: " + this.value;
        JetType jetType = type;
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/constants/EnumValue", "getType"));
        }
        return jetType;
    }

    @Override
    public <R, D> R accept(AnnotationArgumentVisitor<R, D> visitor, D data2) {
        return visitor.visitEnumValue(this, data2);
    }

    public String toString() {
        return this.getType(KotlinBuiltIns.getInstance()) + "." + this.value.getName();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.value.equals(((EnumValue)o).value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }
}

