/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve;

import java.util.Queue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.CallableMemberDescriptor;
import org.jetbrains.jet.lang.descriptors.Visibilities;

public class VisibilityUtil {
    @NotNull
    public static CallableMemberDescriptor findMemberWithMaxVisibility(@NotNull Queue<CallableMemberDescriptor> descriptors) {
        if (descriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "org/jetbrains/jet/lang/resolve/VisibilityUtil", "findMemberWithMaxVisibility"));
        }
        CallableMemberDescriptor descriptor = descriptors.element();
        for (CallableMemberDescriptor candidate : descriptors) {
            Integer result = Visibilities.compare(descriptor.getVisibility(), candidate.getVisibility());
            if (result == null || result >= 0) continue;
            descriptor = candidate;
        }
        CallableMemberDescriptor callableMemberDescriptor = descriptor;
        if (callableMemberDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/VisibilityUtil", "findMemberWithMaxVisibility"));
        }
        return callableMemberDescriptor;
    }
}

