/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.psi.stubs.elements;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.util.io.StringRef;
import java.io.IOException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.psi.JetNamedFunction;
import org.jetbrains.jet.lang.psi.stubs.PsiJetFunctionStub;
import org.jetbrains.jet.lang.psi.stubs.elements.JetStubElementType;
import org.jetbrains.jet.lang.psi.stubs.elements.JetStubElementTypes;
import org.jetbrains.jet.lang.psi.stubs.elements.StubIndexServiceFactory;
import org.jetbrains.jet.lang.psi.stubs.impl.PsiJetFunctionStubImpl;
import org.jetbrains.jet.lang.resolve.name.FqName;

public class JetFunctionElementType
extends JetStubElementType<PsiJetFunctionStub, JetNamedFunction> {
    public JetFunctionElementType(@NotNull @NonNls String debugName) {
        if (debugName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugName", "org/jetbrains/jet/lang/psi/stubs/elements/JetFunctionElementType", "<init>"));
        }
        super(debugName);
    }

    @Override
    public JetNamedFunction createPsiFromAst(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/jet/lang/psi/stubs/elements/JetFunctionElementType", "createPsiFromAst"));
        }
        return new JetNamedFunction(node);
    }

    @Override
    public JetNamedFunction createPsi(@NotNull PsiJetFunctionStub stub) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "org/jetbrains/jet/lang/psi/stubs/elements/JetFunctionElementType", "createPsi"));
        }
        return new JetNamedFunction(stub);
    }

    @Override
    public boolean shouldCreateStub(ASTNode node) {
        PsiElement psi;
        if (super.shouldCreateStub(node) && (psi = node.getPsi()) instanceof JetNamedFunction) {
            JetNamedFunction function = (JetNamedFunction)psi;
            return function.getName() != null;
        }
        return false;
    }

    @Override
    public PsiJetFunctionStub createStub(@NotNull JetNamedFunction psi, @NotNull StubElement parentStub) {
        if (psi == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psi", "org/jetbrains/jet/lang/psi/stubs/elements/JetFunctionElementType", "createStub"));
        }
        if (parentStub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentStub", "org/jetbrains/jet/lang/psi/stubs/elements/JetFunctionElementType", "createStub"));
        }
        boolean isTopLevel = psi.getParent() instanceof JetFile;
        boolean isExtension = psi.getReceiverTypeRef() != null;
        FqName qualifiedName = psi.getFqName();
        return new PsiJetFunctionStubImpl((IStubElementType)JetStubElementTypes.FUNCTION, parentStub, psi.getName(), isTopLevel, qualifiedName, isExtension);
    }

    @Override
    public void serialize(@NotNull PsiJetFunctionStub stub, @NotNull StubOutputStream dataStream) throws IOException {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "org/jetbrains/jet/lang/psi/stubs/elements/JetFunctionElementType", "serialize"));
        }
        if (dataStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataStream", "org/jetbrains/jet/lang/psi/stubs/elements/JetFunctionElementType", "serialize"));
        }
        dataStream.writeName(stub.getName());
        dataStream.writeBoolean(stub.isTopLevel());
        FqName topFQName = stub.getTopFQName();
        dataStream.writeName(topFQName != null ? topFQName.toString() : null);
        dataStream.writeBoolean(stub.isExtension());
    }

    @Override
    @NotNull
    public PsiJetFunctionStub deserialize(@NotNull StubInputStream dataStream, StubElement parentStub) throws IOException {
        if (dataStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataStream", "org/jetbrains/jet/lang/psi/stubs/elements/JetFunctionElementType", "deserialize"));
        }
        StringRef name = dataStream.readName();
        boolean isTopLevel = dataStream.readBoolean();
        StringRef topFQNameStr = dataStream.readName();
        FqName fqName = topFQNameStr != null ? new FqName(topFQNameStr.toString()) : null;
        boolean isExtension = dataStream.readBoolean();
        PsiJetFunctionStubImpl psiJetFunctionStubImpl = new PsiJetFunctionStubImpl((IStubElementType)JetStubElementTypes.FUNCTION, parentStub, name, isTopLevel, fqName, isExtension);
        if (psiJetFunctionStubImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/stubs/elements/JetFunctionElementType", "deserialize"));
        }
        return psiJetFunctionStubImpl;
    }

    @Override
    public void indexStub(@NotNull PsiJetFunctionStub stub, @NotNull IndexSink sink) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "org/jetbrains/jet/lang/psi/stubs/elements/JetFunctionElementType", "indexStub"));
        }
        if (sink == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sink", "org/jetbrains/jet/lang/psi/stubs/elements/JetFunctionElementType", "indexStub"));
        }
        StubIndexServiceFactory.getInstance().indexFunction(stub, sink);
    }
}

