/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.descriptors;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.CallableMemberDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ConstructorDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptorVisitor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.Modality;
import org.jetbrains.jet.lang.descriptors.PropertySetterDescriptor;
import org.jetbrains.jet.lang.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.Visibilities;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.ClassDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.impl.ConstructorDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.impl.DeclarationDescriptorNonRootImpl;
import org.jetbrains.jet.lang.descriptors.impl.PropertyDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.impl.PropertyGetterDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.impl.ReceiverParameterDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.impl.ScriptCodeDescriptor;
import org.jetbrains.jet.lang.resolve.DescriptorFactory;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.resolve.scopes.RedeclarationHandler;
import org.jetbrains.jet.lang.resolve.scopes.WritableScope;
import org.jetbrains.jet.lang.resolve.scopes.WritableScopeImpl;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ScriptReceiver;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeSubstitutor;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;

public class ScriptDescriptor
extends DeclarationDescriptorNonRootImpl {
    public static final String LAST_EXPRESSION_VALUE_FIELD_NAME = "rv";
    private static final Name NAME = Name.special("<script>");
    private final int priority;
    private JetType returnType;
    private List<ValueParameterDescriptor> valueParameters;
    private final ScriptCodeDescriptor scriptCodeDescriptor;
    private final ReceiverParameterDescriptor implicitReceiver;
    private final ClassDescriptorImpl classDescriptor;
    private final WritableScopeImpl classScope;

    public ScriptDescriptor(@NotNull DeclarationDescriptor containingDeclaration, int priority, @NotNull JetScope scriptScope, @NotNull Name className) {
        if (containingDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingDeclaration", "org/jetbrains/jet/lang/descriptors/ScriptDescriptor", "<init>"));
        }
        if (scriptScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scriptScope", "org/jetbrains/jet/lang/descriptors/ScriptDescriptor", "<init>"));
        }
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "org/jetbrains/jet/lang/descriptors/ScriptDescriptor", "<init>"));
        }
        super(containingDeclaration, Collections.<AnnotationDescriptor>emptyList(), NAME);
        this.scriptCodeDescriptor = new ScriptCodeDescriptor(this);
        this.implicitReceiver = new ReceiverParameterDescriptorImpl(this, KotlinBuiltIns.getInstance().getAnyType(), new ScriptReceiver(this));
        this.priority = priority;
        this.classDescriptor = new ClassDescriptorImpl(containingDeclaration, className, Modality.FINAL, Collections.singleton(KotlinBuiltIns.getInstance().getAnyType()));
        this.classScope = new WritableScopeImpl(scriptScope, containingDeclaration, RedeclarationHandler.DO_NOTHING, "script members");
        this.classScope.changeLockLevel(WritableScope.LockLevel.BOTH);
        this.classDescriptor.initialize(this.classScope, new HashSet<ConstructorDescriptor>(), null);
    }

    public void initialize(@NotNull JetType returnType, @NotNull List<? extends PropertyDescriptorImpl> properties, @NotNull List<? extends FunctionDescriptor> functions) {
        if (returnType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "returnType", "org/jetbrains/jet/lang/descriptors/ScriptDescriptor", "initialize"));
        }
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "org/jetbrains/jet/lang/descriptors/ScriptDescriptor", "initialize"));
        }
        if (functions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functions", "org/jetbrains/jet/lang/descriptors/ScriptDescriptor", "initialize"));
        }
        this.returnType = returnType;
        this.scriptCodeDescriptor.initialize(this.implicitReceiver, this.valueParameters, returnType);
        PropertyDescriptorImpl propertyDescriptor = new PropertyDescriptorImpl(this.classDescriptor, Collections.<AnnotationDescriptor>emptyList(), Modality.FINAL, Visibilities.PUBLIC, false, Name.identifier(LAST_EXPRESSION_VALUE_FIELD_NAME), CallableMemberDescriptor.Kind.DECLARATION);
        propertyDescriptor.setType(returnType, Collections.emptyList(), this.classDescriptor.getThisAsReceiverParameter(), ReceiverParameterDescriptor.NO_RECEIVER_PARAMETER);
        propertyDescriptor.initialize(null, null);
        this.classScope.addPropertyDescriptor(propertyDescriptor);
        for (PropertyDescriptorImpl propertyDescriptorImpl : properties) {
            ScriptDescriptor.initializeWithDefaultGetterSetter(propertyDescriptorImpl);
            this.classScope.addPropertyDescriptor(propertyDescriptorImpl);
        }
        for (FunctionDescriptor functionDescriptor : functions) {
            this.classScope.addFunctionDescriptor(functionDescriptor);
        }
    }

    public static void initializeWithDefaultGetterSetter(PropertyDescriptorImpl propertyDescriptor) {
        PropertySetterDescriptor setter;
        PropertyGetterDescriptorImpl getter = propertyDescriptor.getGetter();
        if (getter == null && propertyDescriptor.getVisibility() != Visibilities.PRIVATE) {
            getter = DescriptorFactory.createDefaultGetter(propertyDescriptor);
            getter.initialize(propertyDescriptor.getType());
        }
        if ((setter = propertyDescriptor.getSetter()) == null && propertyDescriptor.isVar()) {
            setter = DescriptorFactory.createDefaultSetter(propertyDescriptor);
        }
        propertyDescriptor.initialize(getter, setter);
    }

    public int getPriority() {
        return this.priority;
    }

    @NotNull
    public JetType getReturnType() {
        JetType jetType = this.returnType;
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/ScriptDescriptor", "getReturnType"));
        }
        return jetType;
    }

    @NotNull
    public List<ValueParameterDescriptor> getValueParameters() {
        List<ValueParameterDescriptor> list2 = this.valueParameters;
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/ScriptDescriptor", "getValueParameters"));
        }
        return list2;
    }

    @NotNull
    public ScriptCodeDescriptor getScriptCodeDescriptor() {
        ScriptCodeDescriptor scriptCodeDescriptor = this.scriptCodeDescriptor;
        if (scriptCodeDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/ScriptDescriptor", "getScriptCodeDescriptor"));
        }
        return scriptCodeDescriptor;
    }

    @NotNull
    public ReceiverParameterDescriptor getThisAsReceiverParameter() {
        ReceiverParameterDescriptor receiverParameterDescriptor = this.implicitReceiver;
        if (receiverParameterDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/ScriptDescriptor", "getThisAsReceiverParameter"));
        }
        return receiverParameterDescriptor;
    }

    @Override
    public DeclarationDescriptor substitute(@NotNull TypeSubstitutor substitutor) {
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "org/jetbrains/jet/lang/descriptors/ScriptDescriptor", "substitute"));
        }
        throw new IllegalStateException("nothing to substitute in script");
    }

    @Override
    public <R, D> R accept(DeclarationDescriptorVisitor<R, D> visitor, D data2) {
        return visitor.visitScriptDescriptor(this, data2);
    }

    public void setValueParameters(@NotNull List<ValueParameterDescriptor> valueParameters) {
        if (valueParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueParameters", "org/jetbrains/jet/lang/descriptors/ScriptDescriptor", "setValueParameters"));
        }
        this.valueParameters = valueParameters;
        ConstructorDescriptorImpl constructorDescriptor = new ConstructorDescriptorImpl(this.classDescriptor, Collections.<AnnotationDescriptor>emptyList(), true).initialize(Collections.<TypeParameterDescriptor>emptyList(), valueParameters, Visibilities.PUBLIC);
        constructorDescriptor.setReturnType(this.classDescriptor.getDefaultType());
        this.classDescriptor.getConstructors().add(constructorDescriptor);
        this.classDescriptor.setPrimaryConstructor(constructorDescriptor);
        for (ValueParameterDescriptor parameter : valueParameters) {
            PropertyDescriptorImpl propertyDescriptor = new PropertyDescriptorImpl(this.classDescriptor, Collections.<AnnotationDescriptor>emptyList(), Modality.FINAL, Visibilities.PUBLIC, false, parameter.getName(), CallableMemberDescriptor.Kind.DECLARATION);
            propertyDescriptor.setType(parameter.getType(), Collections.emptyList(), this.classDescriptor.getThisAsReceiverParameter(), ReceiverParameterDescriptor.NO_RECEIVER_PARAMETER);
            propertyDescriptor.initialize(null, null);
            this.classScope.addPropertyDescriptor(propertyDescriptor);
        }
    }

    @NotNull
    public ClassDescriptor getClassDescriptor() {
        ClassDescriptorImpl classDescriptorImpl = this.classDescriptor;
        if (classDescriptorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/ScriptDescriptor", "getClassDescriptor"));
        }
        return classDescriptorImpl;
    }
}

