/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xmlb;

import com.intellij.util.xmlb.AbstractCollectionBinding;
import com.intellij.util.xmlb.Accessor;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

class CollectionBinding
extends AbstractCollectionBinding {
    public CollectionBinding(ParameterizedType type, Accessor accessor) {
        super(CollectionBinding.getComponentClass(type), "collection", accessor);
    }

    private static Class getComponentClass(ParameterizedType type) {
        Type arg = type.getActualTypeArguments()[0];
        if (arg instanceof ParameterizedType) {
            return (Class)((ParameterizedType)arg).getRawType();
        }
        return (Class)arg;
    }

    @Override
    Object processResult(Collection result, Object target) {
        if (this.myAccessor == null) {
            return result;
        }
        assert (target != null) : "Null target in " + this.myAccessor;
        assert (target instanceof Collection) : "Wrong target: " + target.getClass() + " in " + this.myAccessor;
        Collection c = (Collection)target;
        c.clear();
        c.addAll(result);
        return target;
    }

    @Override
    protected String getCollectionTagName(Object target) {
        if (target instanceof Set) {
            return "set";
        }
        if (target instanceof List) {
            return "list";
        }
        return super.getCollectionTagName(target);
    }

    @Override
    protected Collection createCollection(String tagName) {
        if (tagName.equals("set")) {
            return new HashSet();
        }
        if (tagName.equals("list")) {
            return new ArrayList();
        }
        return super.createCollection(tagName);
    }
}

