/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.declaration;

import com.google.dart.compiler.backend.js.ast.JsArrayLiteral;
import com.google.dart.compiler.backend.js.ast.JsDocComment;
import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsFunction;
import com.google.dart.compiler.backend.js.ast.JsInvocation;
import com.google.dart.compiler.backend.js.ast.JsLiteral;
import com.google.dart.compiler.backend.js.ast.JsNameRef;
import com.google.dart.compiler.backend.js.ast.JsObjectLiteral;
import com.google.dart.compiler.backend.js.ast.JsPropertyInitializer;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.Trinity;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassKind;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.psi.JetClassOrObject;
import org.jetbrains.jet.lang.psi.JetObjectDeclaration;
import org.jetbrains.jet.lang.psi.JetParameter;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeConstructor;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.k2js.translate.LabelGenerator;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.declaration.DeclarationBodyVisitor;
import org.jetbrains.k2js.translate.declaration.PropertyTranslator;
import org.jetbrains.k2js.translate.expression.LiteralFunctionTranslator;
import org.jetbrains.k2js.translate.general.AbstractTranslator;
import org.jetbrains.k2js.translate.initializer.ClassInitializerTranslator;
import org.jetbrains.k2js.translate.initializer.InitializerUtils;
import org.jetbrains.k2js.translate.utils.BindingUtils;
import org.jetbrains.k2js.translate.utils.JsDescriptorUtils;
import org.jetbrains.k2js.translate.utils.PsiUtils;
import org.jetbrains.k2js.translate.utils.TranslationUtils;

public final class ClassTranslator
extends AbstractTranslator {
    @NotNull
    private final JetClassOrObject classDeclaration;
    @NotNull
    private final ClassDescriptor descriptor;

    @NotNull
    public static JsInvocation generateClassCreation(@NotNull JetClassOrObject classDeclaration, @NotNull TranslationContext context) {
        if (classDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDeclaration", "org/jetbrains/k2js/translate/declaration/ClassTranslator", "generateClassCreation"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/declaration/ClassTranslator", "generateClassCreation"));
        }
        JsInvocation jsInvocation = new ClassTranslator(classDeclaration, context).translate();
        if (jsInvocation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/declaration/ClassTranslator", "generateClassCreation"));
        }
        return jsInvocation;
    }

    @NotNull
    public static JsInvocation generateClassCreation(@NotNull JetClassOrObject classDeclaration, @NotNull ClassDescriptor descriptor, @NotNull TranslationContext context) {
        if (classDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDeclaration", "org/jetbrains/k2js/translate/declaration/ClassTranslator", "generateClassCreation"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/k2js/translate/declaration/ClassTranslator", "generateClassCreation"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/declaration/ClassTranslator", "generateClassCreation"));
        }
        JsInvocation jsInvocation = new ClassTranslator(classDeclaration, descriptor, context).translate();
        if (jsInvocation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/declaration/ClassTranslator", "generateClassCreation"));
        }
        return jsInvocation;
    }

    @NotNull
    public static JsExpression generateObjectLiteral(@NotNull JetObjectDeclaration objectDeclaration, @NotNull TranslationContext context) {
        if (objectDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "objectDeclaration", "org/jetbrains/k2js/translate/declaration/ClassTranslator", "generateObjectLiteral"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/declaration/ClassTranslator", "generateObjectLiteral"));
        }
        JsExpression jsExpression = new ClassTranslator(objectDeclaration, context).translateObjectLiteralExpression();
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/declaration/ClassTranslator", "generateObjectLiteral"));
        }
        return jsExpression;
    }

    @NotNull
    public static JsExpression generateObjectLiteral(@NotNull JetObjectDeclaration objectDeclaration, @NotNull ClassDescriptor descriptor, @NotNull TranslationContext context) {
        if (objectDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "objectDeclaration", "org/jetbrains/k2js/translate/declaration/ClassTranslator", "generateObjectLiteral"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/k2js/translate/declaration/ClassTranslator", "generateObjectLiteral"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/declaration/ClassTranslator", "generateObjectLiteral"));
        }
        JsExpression jsExpression = new ClassTranslator(objectDeclaration, descriptor, context).translateObjectLiteralExpression();
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/declaration/ClassTranslator", "generateObjectLiteral"));
        }
        return jsExpression;
    }

    ClassTranslator(@NotNull JetClassOrObject classDeclaration, @NotNull TranslationContext context) {
        if (classDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDeclaration", "org/jetbrains/k2js/translate/declaration/ClassTranslator", "<init>"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/declaration/ClassTranslator", "<init>"));
        }
        this(classDeclaration, BindingUtils.getClassDescriptor(context.bindingContext(), classDeclaration), context);
    }

    ClassTranslator(@NotNull JetClassOrObject classDeclaration, @NotNull ClassDescriptor descriptor, @NotNull TranslationContext context) {
        if (classDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDeclaration", "org/jetbrains/k2js/translate/declaration/ClassTranslator", "<init>"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/k2js/translate/declaration/ClassTranslator", "<init>"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/declaration/ClassTranslator", "<init>"));
        }
        super(context);
        this.descriptor = descriptor;
        this.classDeclaration = classDeclaration;
    }

    @NotNull
    private JsExpression translateObjectLiteralExpression() {
        ClassDescriptor containingClass = JsDescriptorUtils.getContainingClass(this.descriptor);
        if (containingClass == null) {
            JsInvocation jsInvocation = this.translate(this.context());
            if (jsInvocation == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/declaration/ClassTranslator", "translateObjectLiteralExpression"));
            }
            return jsInvocation;
        }
        JsExpression jsExpression = this.context().literalFunctionTranslator().translate(containingClass, this.context(), this.classDeclaration, this.descriptor, this);
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/declaration/ClassTranslator", "translateObjectLiteralExpression"));
        }
        return jsExpression;
    }

    @NotNull
    public JsInvocation translate() {
        JsInvocation jsInvocation = this.translate(this.context());
        if (jsInvocation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/declaration/ClassTranslator", "translate"));
        }
        return jsInvocation;
    }

    @NotNull
    public JsInvocation translate(@NotNull TranslationContext declarationContext) {
        if (declarationContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declarationContext", "org/jetbrains/k2js/translate/declaration/ClassTranslator", "translate"));
        }
        JsInvocation jsInvocation = new JsInvocation(this.context().namer().classCreateInvocation(this.descriptor), this.getClassCreateInvocationArguments(declarationContext));
        if (jsInvocation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/declaration/ClassTranslator", "translate"));
        }
        return jsInvocation;
    }

    private boolean isTrait() {
        return this.descriptor.getKind().equals((Object)ClassKind.TRAIT);
    }

    private List<JsExpression> getClassCreateInvocationArguments(@NotNull TranslationContext declarationContext) {
        boolean hasStaticProperties;
        JsNameRef qualifiedReference;
        boolean isTopLevelDeclaration;
        if (declarationContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declarationContext", "org/jetbrains/k2js/translate/declaration/ClassTranslator", "getClassCreateInvocationArguments"));
        }
        ArrayList<JsExpression> invocationArguments = new ArrayList<JsExpression>();
        final SmartList<JsPropertyInitializer> properties = new SmartList<JsPropertyInitializer>();
        final SmartList<JsPropertyInitializer> staticProperties = new SmartList<JsPropertyInitializer>();
        boolean bl = isTopLevelDeclaration = this.context() == declarationContext;
        if (!isTopLevelDeclaration) {
            qualifiedReference = null;
        } else if (this.descriptor.getKind().isSingleton() || DescriptorUtils.isAnonymousObject(this.descriptor)) {
            qualifiedReference = null;
            declarationContext.literalFunctionTranslator().setDefinitionPlace(new NotNullLazyValue<Trinity<List<JsPropertyInitializer>, LabelGenerator, JsExpression>>(){

                @Override
                @NotNull
                public Trinity<List<JsPropertyInitializer>, LabelGenerator, JsExpression> compute() {
                    Trinity<List<JsPropertyInitializer>, LabelGenerator, JsExpression> trinity = LiteralFunctionTranslator.createPlace(properties, ClassTranslator.this.context().getThisObject(ClassTranslator.this.descriptor));
                    if (trinity == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/declaration/ClassTranslator$1", "compute"));
                    }
                    return trinity;
                }
            });
        } else {
            qualifiedReference = declarationContext.getQualifiedReference(this.descriptor);
            declarationContext.literalFunctionTranslator().setDefinitionPlace(new NotNullLazyValue<Trinity<List<JsPropertyInitializer>, LabelGenerator, JsExpression>>(){

                @Override
                @NotNull
                public Trinity<List<JsPropertyInitializer>, LabelGenerator, JsExpression> compute() {
                    Trinity<List<JsPropertyInitializer>, LabelGenerator, JsExpression> trinity = LiteralFunctionTranslator.createPlace(staticProperties, qualifiedReference);
                    if (trinity == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/declaration/ClassTranslator$2", "compute"));
                    }
                    return trinity;
                }
            });
        }
        invocationArguments.add(this.getSuperclassReferences(declarationContext));
        if (!this.isTrait()) {
            JsFunction initializer = new ClassInitializerTranslator(this.classDeclaration, declarationContext).generateInitializeMethod();
            invocationArguments.add(initializer.getBody().getStatements().isEmpty() ? JsLiteral.NULL : initializer);
        }
        this.translatePropertiesAsConstructorParameters(declarationContext, properties);
        DeclarationBodyVisitor bodyVisitor = new DeclarationBodyVisitor(properties, staticProperties);
        bodyVisitor.traverseContainer(this.classDeclaration, declarationContext);
        this.mayBeAddEnumEntry(bodyVisitor.getEnumEntryList(), staticProperties, declarationContext);
        if (isTopLevelDeclaration) {
            declarationContext.literalFunctionTranslator().setDefinitionPlace(null);
        }
        boolean bl2 = hasStaticProperties = !staticProperties.isEmpty();
        if (!properties.isEmpty() || hasStaticProperties) {
            if (properties.isEmpty()) {
                invocationArguments.add(JsLiteral.NULL);
            } else {
                if (qualifiedReference != null) {
                    invocationArguments.add(new JsDocComment("lends", new JsNameRef("prototype", (JsExpression)qualifiedReference)));
                }
                invocationArguments.add(new JsObjectLiteral(properties, true));
            }
        }
        if (hasStaticProperties) {
            invocationArguments.add(new JsDocComment("lends", qualifiedReference));
            invocationArguments.add(new JsObjectLiteral(staticProperties, true));
        }
        return invocationArguments;
    }

    private void mayBeAddEnumEntry(@NotNull List<JsPropertyInitializer> enumEntryList, @NotNull List<JsPropertyInitializer> staticProperties, @NotNull TranslationContext declarationContext) {
        if (enumEntryList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "enumEntryList", "org/jetbrains/k2js/translate/declaration/ClassTranslator", "mayBeAddEnumEntry"));
        }
        if (staticProperties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "staticProperties", "org/jetbrains/k2js/translate/declaration/ClassTranslator", "mayBeAddEnumEntry"));
        }
        if (declarationContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declarationContext", "org/jetbrains/k2js/translate/declaration/ClassTranslator", "mayBeAddEnumEntry"));
        }
        if (this.descriptor.getKind() == ClassKind.ENUM_CLASS) {
            JsInvocation invocation = this.context().namer().enumEntriesObjectCreateInvocation();
            invocation.getArguments().add(new JsObjectLiteral(enumEntryList, true));
            JsFunction fun = TranslationUtils.simpleReturnFunction(declarationContext.getScopeForDescriptor(this.descriptor), invocation);
            staticProperties.add(InitializerUtils.createClassObjectInitializer(fun, declarationContext));
        } else assert (enumEntryList.isEmpty()) : "Only enum class may have enum entry. Class kind is: " + (Object)((Object)this.descriptor.getKind());
    }

    private JsExpression getSuperclassReferences(@NotNull TranslationContext declarationContext) {
        if (declarationContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declarationContext", "org/jetbrains/k2js/translate/declaration/ClassTranslator", "getSuperclassReferences"));
        }
        List<JsExpression> superClassReferences = this.getSupertypesNameReferences();
        if (superClassReferences.isEmpty()) {
            return JsLiteral.NULL;
        }
        return TranslationUtils.simpleReturnFunction(declarationContext.scope(), new JsArrayLiteral(superClassReferences));
    }

    @NotNull
    private List<JsExpression> getSupertypesNameReferences() {
        List<JetType> supertypes = JsDescriptorUtils.getSupertypesWithoutFakes(this.descriptor);
        if (supertypes.isEmpty()) {
            List<JsExpression> list2 = Collections.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/declaration/ClassTranslator", "getSupertypesNameReferences"));
            }
            return list2;
        }
        if (supertypes.size() == 1) {
            JetType type = supertypes.get(0);
            ClassDescriptor supertypeDescriptor = DescriptorUtils.getClassDescriptorForType(type);
            List<JsExpression> list3 = Collections.singletonList(this.getClassReference(supertypeDescriptor));
            if (list3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/declaration/ClassTranslator", "getSupertypesNameReferences"));
            }
            return list3;
        }
        HashSet<TypeConstructor> supertypeConstructors = new HashSet<TypeConstructor>();
        for (JetType type : supertypes) {
            supertypeConstructors.add(type.getConstructor());
        }
        List<TypeConstructor> sortedAllSuperTypes = TypeUtils.topologicallySortSuperclassesAndRecordAllInstances(this.descriptor.getDefaultType(), new HashMap<TypeConstructor, Set<JetType>>(), new HashSet<TypeConstructor>());
        ArrayList<JsExpression> supertypesRefs = new ArrayList<JsExpression>();
        for (TypeConstructor typeConstructor : sortedAllSuperTypes) {
            if (!supertypeConstructors.contains(typeConstructor)) continue;
            ClassDescriptor supertypeDescriptor = DescriptorUtils.getClassDescriptorForTypeConstructor(typeConstructor);
            supertypesRefs.add(this.getClassReference(supertypeDescriptor));
        }
        ArrayList<JsExpression> arrayList = supertypesRefs;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/declaration/ClassTranslator", "getSupertypesNameReferences"));
        }
        return arrayList;
    }

    @NotNull
    private JsNameRef getClassReference(@NotNull ClassDescriptor superClassDescriptor) {
        if (superClassDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superClassDescriptor", "org/jetbrains/k2js/translate/declaration/ClassTranslator", "getClassReference"));
        }
        JsNameRef jsNameRef = this.context().getQualifiedReference(superClassDescriptor);
        if (jsNameRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/declaration/ClassTranslator", "getClassReference"));
        }
        return jsNameRef;
    }

    private void translatePropertiesAsConstructorParameters(@NotNull TranslationContext classDeclarationContext, @NotNull List<JsPropertyInitializer> result) {
        if (classDeclarationContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDeclarationContext", "org/jetbrains/k2js/translate/declaration/ClassTranslator", "translatePropertiesAsConstructorParameters"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/k2js/translate/declaration/ClassTranslator", "translatePropertiesAsConstructorParameters"));
        }
        for (JetParameter parameter : PsiUtils.getPrimaryConstructorParameters(this.classDeclaration)) {
            PropertyDescriptor descriptor = BindingUtils.getPropertyDescriptorForConstructorParameter(this.bindingContext(), parameter);
            if (descriptor == null) continue;
            PropertyTranslator.translateAccessors(descriptor, result, classDeclarationContext);
        }
    }
}

