/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.types;

import org.jetbrains.jet.lang.types.TypeConstructor;
import org.jetbrains.jet.lang.types.TypeProjection;
import org.jetbrains.jet.lang.types.TypeSubstitution;

public class CompositeTypeSubstitution
implements TypeSubstitution {
    private final TypeSubstitution[] inner;

    public CompositeTypeSubstitution(TypeSubstitution ... inner) {
        if (inner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inner", "org/jetbrains/jet/lang/types/CompositeTypeSubstitution", "<init>"));
        }
        this.inner = inner;
    }

    @Override
    public TypeProjection get(TypeConstructor key) {
        for (TypeSubstitution substitution : this.inner) {
            TypeProjection value = substitution.get(key);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    @Override
    public boolean isEmpty() {
        for (TypeSubstitution substitution : this.inner) {
            if (substitution.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (TypeSubstitution substitution : this.inner) {
            builder.append(substitution).append(" * ");
        }
        return builder.toString();
    }
}

