/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.psi;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.JetNodeTypes;
import org.jetbrains.jet.lang.psi.IfNotParsed;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetSimpleNameExpression;
import org.jetbrains.jet.lang.psi.JetVisitor;
import org.jetbrains.jet.lang.psi.JetVisitorVoid;
import org.jetbrains.jet.lang.psi.JetWhenCondition;
import org.jetbrains.jet.lexer.JetTokens;

public class JetWhenConditionInRange
extends JetWhenCondition {
    public JetWhenConditionInRange(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/jet/lang/psi/JetWhenConditionInRange", "<init>"));
        }
        super(node);
    }

    public boolean isNegated() {
        return this.getNode().findChildByType(JetTokens.NOT_IN) != null;
    }

    @IfNotParsed
    @Nullable
    public JetExpression getRangeExpression() {
        for (ASTNode node = this.getOperationReference().getNode().getTreeNext(); node != null; node = node.getTreeNext()) {
            PsiElement psi = node.getPsi();
            if (!(psi instanceof JetExpression)) continue;
            return (JetExpression)psi;
        }
        return null;
    }

    @Override
    public void accept(@NotNull JetVisitorVoid visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/jet/lang/psi/JetWhenConditionInRange", "accept"));
        }
        visitor.visitWhenConditionInRange(this);
    }

    @Override
    public <R, D> R accept(@NotNull JetVisitor<R, D> visitor, D data2) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/jet/lang/psi/JetWhenConditionInRange", "accept"));
        }
        return visitor.visitWhenConditionInRange(this, data2);
    }

    public JetSimpleNameExpression getOperationReference() {
        return (JetSimpleNameExpression)this.findChildByType(JetNodeTypes.OPERATION_REFERENCE);
    }
}

