/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen.intrinsics;

import com.intellij.psi.PsiElement;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.asm4.Type;
import org.jetbrains.asm4.commons.InstructionAdapter;
import org.jetbrains.jet.codegen.AsmUtil;
import org.jetbrains.jet.codegen.ExpressionCodegen;
import org.jetbrains.jet.codegen.StackValue;
import org.jetbrains.jet.codegen.intrinsics.IntrinsicMethod;
import org.jetbrains.jet.codegen.state.GenerationState;
import org.jetbrains.jet.lang.psi.JetExpression;

public class BinaryOp
implements IntrinsicMethod {
    private final int opcode;

    public BinaryOp(int opcode) {
        this.opcode = opcode;
    }

    @Override
    public StackValue generate(ExpressionCodegen codegen, InstructionAdapter v, @NotNull Type expectedType, PsiElement element, List<JetExpression> arguments, StackValue receiver, @NotNull GenerationState state) {
        boolean nullable;
        if (expectedType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expectedType", "org/jetbrains/jet/codegen/intrinsics/BinaryOp", "generate"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/jet/codegen/intrinsics/BinaryOp", "generate"));
        }
        boolean bl = nullable = expectedType.getSort() == 10;
        if (nullable) {
            expectedType = AsmUtil.unboxType(expectedType);
        }
        if (arguments.size() == 1) {
            if (receiver != null) {
                receiver.put(expectedType, v);
            }
            codegen.gen(arguments.get(0), this.shift() ? Type.INT_TYPE : expectedType);
        } else {
            codegen.gen(arguments.get(0), expectedType);
            codegen.gen(arguments.get(1), this.shift() ? Type.INT_TYPE : expectedType);
        }
        v.visitInsn(expectedType.getOpcode(this.opcode));
        if (nullable) {
            StackValue stackValue = StackValue.onStack(expectedType);
            expectedType = AsmUtil.boxType(expectedType);
            stackValue.put(expectedType, v);
        }
        return StackValue.onStack(expectedType);
    }

    private boolean shift() {
        return this.opcode == 120 || this.opcode == 122 || this.opcode == 124;
    }
}

