/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ConcurrentFactoryMap;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import org.jetbrains.annotations.NotNull;

public class ReflectionCache {
    private static final ConcurrentFactoryMap<Class, Class> ourSuperClasses = new ConcurrentFactoryMap<Class, Class>(){

        @Override
        protected Class create(Class key) {
            return key.getSuperclass();
        }
    };
    private static final ConcurrentFactoryMap<Class, Class[]> ourInterfaces = new ConcurrentFactoryMap<Class, Class[]>(){

        @Override
        @NotNull
        protected Class[] create(Class key) {
            Class<?>[] classes = key.getInterfaces();
            Class[] classArray = classes.length == 0 ? ArrayUtil.EMPTY_CLASS_ARRAY : classes;
            if (classArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ReflectionCache$2", "create"));
            }
            return classArray;
        }
    };
    private static final ConcurrentFactoryMap<Class, Boolean> ourIsInterfaces = new ConcurrentFactoryMap<Class, Boolean>(){

        @Override
        @NotNull
        protected Boolean create(Class key) {
            Boolean bl = key.isInterface();
            if (bl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ReflectionCache$3", "create"));
            }
            return bl;
        }
    };
    private static final ConcurrentFactoryMap<Class, TypeVariable[]> ourTypeParameters = new ConcurrentFactoryMap<Class, TypeVariable[]>(){

        @Override
        @NotNull
        protected TypeVariable[] create(Class key) {
            TypeVariable[] typeVariableArray = key.getTypeParameters();
            if (typeVariableArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ReflectionCache$4", "create"));
            }
            return typeVariableArray;
        }
    };
    private static final ConcurrentFactoryMap<Class, Type[]> ourGenericInterfaces = new ConcurrentFactoryMap<Class, Type[]>(){

        @Override
        @NotNull
        protected Type[] create(Class key) {
            Type[] typeArray = key.getGenericInterfaces();
            if (typeArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ReflectionCache$5", "create"));
            }
            return typeArray;
        }
    };
    private static final ConcurrentFactoryMap<ParameterizedType, Type[]> ourActualTypeArguments = new ConcurrentFactoryMap<ParameterizedType, Type[]>(){

        @Override
        @NotNull
        protected Type[] create(ParameterizedType key) {
            Type[] typeArray = key.getActualTypeArguments();
            if (typeArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ReflectionCache$6", "create"));
            }
            return typeArray;
        }
    };

    public static Class getSuperClass(@NotNull Class aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/ReflectionCache", "getSuperClass"));
        }
        return (Class)ourSuperClasses.get(aClass);
    }

    @NotNull
    public static Class[] getInterfaces(@NotNull Class aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/ReflectionCache", "getInterfaces"));
        }
        Class[] classArray = (Class[])ourInterfaces.get(aClass);
        if (classArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ReflectionCache", "getInterfaces"));
        }
        return classArray;
    }

    public static boolean isAssignable(@NotNull Class ancestor, Class descendant) {
        if (ancestor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/ReflectionCache", "isAssignable"));
        }
        return ancestor == descendant || ancestor.isAssignableFrom(descendant);
    }

    public static boolean isInstance(Object instance, @NotNull Class clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/util/ReflectionCache", "isInstance"));
        }
        return clazz.isInstance(instance);
    }
}

