/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.SmartPsiFileRange;
import org.jetbrains.annotations.NotNull;

public abstract class SmartPointerManager {
    @NotNull
    public abstract SmartPsiFileRange createSmartPsiFileRangePointer(@NotNull PsiFile var1, @NotNull TextRange var2);

    public static SmartPointerManager getInstance(Project project) {
        return ServiceManager.getService(project, SmartPointerManager.class);
    }

    @NotNull
    public abstract <E extends PsiElement> SmartPsiElementPointer<E> createSmartPsiElementPointer(@NotNull E var1);

    @NotNull
    public abstract <E extends PsiElement> SmartPsiElementPointer<E> createSmartPsiElementPointer(@NotNull E var1, PsiFile var2);

    @NotNull
    public <E extends PsiElement> SmartPsiElementPointer<E> createLazyPointer(@NotNull E element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/SmartPointerManager", "createLazyPointer"));
        }
        SmartPsiElementPointer<E> smartPsiElementPointer = this.createSmartPsiElementPointer(element);
        if (smartPsiElementPointer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/SmartPointerManager", "createLazyPointer"));
        }
        return smartPsiElementPointer;
    }

    public abstract boolean pointToTheSameElement(@NotNull SmartPsiElementPointer var1, @NotNull SmartPsiElementPointer var2);

    public abstract boolean removePointer(@NotNull SmartPsiElementPointer var1);
}

