/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.core;

import com.intellij.codeInsight.runner.JavaMainMethodProvider;
import com.intellij.core.CoreApplicationEnvironment;
import com.intellij.core.CoreJavaDirectoryService;
import com.intellij.core.CorePsiPackageImplementationHelper;
import com.intellij.ide.highlighter.ArchiveFileType;
import com.intellij.ide.highlighter.JavaClassFileType;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.lang.LanguageASTFactory;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.lang.java.JavaParserDefinition;
import com.intellij.navigation.ItemPresentationProviders;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.projectRoots.JavaVersionService;
import com.intellij.openapi.util.ClassExtension;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.ClassFileViewProviderFactory;
import com.intellij.psi.EmptySubstitutor;
import com.intellij.psi.FileTypeFileViewProviders;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.augment.PsiAugmentProvider;
import com.intellij.psi.impl.EmptySubstitutorImpl;
import com.intellij.psi.impl.LanguageConstantExpressionEvaluator;
import com.intellij.psi.impl.PsiExpressionEvaluator;
import com.intellij.psi.impl.compiled.ClassFileStubBuilder;
import com.intellij.psi.impl.compiled.ClsStubBuilderFactory;
import com.intellij.psi.impl.compiled.DefaultClsStubBuilderFactory;
import com.intellij.psi.impl.file.PsiPackageImplementationHelper;
import com.intellij.psi.impl.source.tree.CoreJavaASTFactory;
import com.intellij.psi.presentation.java.ClassPresentationProvider;
import com.intellij.psi.presentation.java.FieldPresentationProvider;
import com.intellij.psi.presentation.java.MethodPresentationProvider;
import com.intellij.psi.presentation.java.PackagePresentationProvider;
import com.intellij.psi.presentation.java.VariablePresentationProvider;
import com.intellij.psi.stubs.BinaryFileStubBuilders;

public class JavaCoreApplicationEnvironment
extends CoreApplicationEnvironment {
    public JavaCoreApplicationEnvironment(Disposable parentDisposable) {
        super(parentDisposable);
        this.registerFileType(JavaClassFileType.INSTANCE, "class");
        this.registerFileType(JavaFileType.INSTANCE, "java");
        this.registerFileType(ArchiveFileType.INSTANCE, "jar;zip");
        this.addExplicitExtension(FileTypeFileViewProviders.INSTANCE, JavaClassFileType.INSTANCE, new ClassFileViewProviderFactory());
        this.addExplicitExtension(BinaryFileStubBuilders.INSTANCE, JavaClassFileType.INSTANCE, new ClassFileStubBuilder());
        this.addExplicitExtension(LanguageASTFactory.INSTANCE, JavaLanguage.INSTANCE, new CoreJavaASTFactory());
        this.addExplicitExtension(LanguageParserDefinitions.INSTANCE, JavaLanguage.INSTANCE, new JavaParserDefinition());
        this.addExplicitExtension(LanguageConstantExpressionEvaluator.INSTANCE, JavaLanguage.INSTANCE, new PsiExpressionEvaluator());
        JavaCoreApplicationEnvironment.registerExtensionPoint(Extensions.getRootArea(), ClsStubBuilderFactory.EP_NAME, ClsStubBuilderFactory.class);
        JavaCoreApplicationEnvironment.registerExtensionPoint(Extensions.getRootArea(), PsiAugmentProvider.EP_NAME, PsiAugmentProvider.class);
        JavaCoreApplicationEnvironment.registerExtensionPoint(Extensions.getRootArea(), JavaMainMethodProvider.EP_NAME, JavaMainMethodProvider.class);
        this.addExtension(ClsStubBuilderFactory.EP_NAME, new DefaultClsStubBuilderFactory());
        this.myApplication.registerService(PsiPackageImplementationHelper.class, new CorePsiPackageImplementationHelper());
        this.myApplication.registerService(EmptySubstitutor.class, new EmptySubstitutorImpl());
        this.myApplication.registerService(JavaDirectoryService.class, this.createJavaDirectoryService());
        this.myApplication.registerService(JavaVersionService.class, new JavaVersionService());
        this.addExplicitExtension(ItemPresentationProviders.INSTANCE, PsiPackage.class, new PackagePresentationProvider());
        this.addExplicitExtension(ItemPresentationProviders.INSTANCE, PsiClass.class, new ClassPresentationProvider());
        this.addExplicitExtension(ItemPresentationProviders.INSTANCE, PsiMethod.class, new MethodPresentationProvider());
        this.addExplicitExtension(ItemPresentationProviders.INSTANCE, PsiField.class, new FieldPresentationProvider());
        this.addExplicitExtension(ItemPresentationProviders.INSTANCE, PsiLocalVariable.class, new VariablePresentationProvider());
        this.addExplicitExtension(ItemPresentationProviders.INSTANCE, PsiParameter.class, new VariablePresentationProvider());
    }

    protected CoreJavaDirectoryService createJavaDirectoryService() {
        return new CoreJavaDirectoryService();
    }

    public <T> void addExplicitExtension(final ClassExtension<T> instance, final Class clazz, final T object2) {
        instance.addExplicitExtension(clazz, object2);
        Disposer.register(this.getParentDisposable(), new Disposable(){

            @Override
            public void dispose() {
                instance.removeExplicitExtension(clazz, object2);
            }
        });
    }
}

