/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.expression.foreach;

import com.google.common.collect.Lists;
import com.google.dart.compiler.backend.js.ast.JsArrayAccess;
import com.google.dart.compiler.backend.js.ast.JsBinaryOperation;
import com.google.dart.compiler.backend.js.ast.JsBlock;
import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsFor;
import com.google.dart.compiler.backend.js.ast.JsPrefixOperation;
import com.google.dart.compiler.backend.js.ast.JsStatement;
import com.google.dart.compiler.backend.js.ast.JsUnaryOperator;
import com.google.dart.compiler.backend.js.ast.JsVars;
import java.util.ArrayList;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetForExpression;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.k2js.translate.context.TemporaryVariable;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.expression.foreach.ForTranslator;
import org.jetbrains.k2js.translate.general.Translation;
import org.jetbrains.k2js.translate.intrinsic.functions.factories.CompositeFIF;
import org.jetbrains.k2js.translate.utils.BindingUtils;
import org.jetbrains.k2js.translate.utils.JsAstUtils;
import org.jetbrains.k2js.translate.utils.PsiUtils;
import org.jetbrains.k2js.translate.utils.TemporariesUtils;

public final class ArrayForTranslator
extends ForTranslator {
    @NotNull
    private final TemporaryVariable loopRange;
    @NotNull
    private final TemporaryVariable end;
    @NotNull
    private final TemporaryVariable index;

    @NotNull
    public static JsStatement doTranslate(@NotNull JetForExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/k2js/translate/expression/foreach/ArrayForTranslator", "doTranslate"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/expression/foreach/ArrayForTranslator", "doTranslate"));
        }
        JsBlock jsBlock = new ArrayForTranslator(expression, context).translate();
        if (jsBlock == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/foreach/ArrayForTranslator", "doTranslate"));
        }
        return jsBlock;
    }

    public static boolean isApplicable(@NotNull JetForExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/k2js/translate/expression/foreach/ArrayForTranslator", "isApplicable"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/expression/foreach/ArrayForTranslator", "isApplicable"));
        }
        JetExpression loopRange = PsiUtils.getLoopRange(expression);
        JetType rangeType = BindingUtils.getTypeForExpression(context.bindingContext(), loopRange);
        return DescriptorUtils.getClassDescriptorForType(rangeType).getName().asString().equals("Array") || DescriptorUtils.getClassDescriptorForType(rangeType).getName().asString().equals("IntArray");
    }

    private ArrayForTranslator(@NotNull JetForExpression forExpression, @NotNull TranslationContext context) {
        if (forExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "forExpression", "org/jetbrains/k2js/translate/expression/foreach/ArrayForTranslator", "<init>"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/expression/foreach/ArrayForTranslator", "<init>"));
        }
        super(forExpression, context);
        this.loopRange = context.declareTemporary(Translation.translateAsExpression(PsiUtils.getLoopRange(this.expression), context));
        JsExpression length = CompositeFIF.LENGTH_PROPERTY_INTRINSIC.apply(this.loopRange.reference(), Collections.<JsExpression>emptyList(), this.context());
        this.end = this.context().declareTemporary(length);
        this.index = this.context().declareTemporary(this.program().getNumberLiteral(0));
    }

    @NotNull
    private JsBlock translate() {
        ArrayList<JsStatement> blockStatements = Lists.newArrayList();
        blockStatements.add(TemporariesUtils.temporariesInitialization(this.loopRange, this.end).makeStmt());
        blockStatements.add(new JsFor(this.getInitExpression(), this.getCondition(), this.getIncrementExpression(), this.getBody()));
        JsBlock jsBlock = new JsBlock(blockStatements);
        if (jsBlock == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/foreach/ArrayForTranslator", "translate"));
        }
        return jsBlock;
    }

    @NotNull
    private JsStatement getBody() {
        JsArrayAccess arrayAccess = new JsArrayAccess(this.loopRange.reference(), this.index.reference());
        JsStatement jsStatement = this.translateBody(arrayAccess);
        if (jsStatement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/foreach/ArrayForTranslator", "getBody"));
        }
        return jsStatement;
    }

    @NotNull
    private JsVars getInitExpression() {
        JsVars jsVars = JsAstUtils.newVar(this.index.name(), this.program().getNumberLiteral(0));
        if (jsVars == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/foreach/ArrayForTranslator", "getInitExpression"));
        }
        return jsVars;
    }

    @NotNull
    private JsExpression getCondition() {
        JsBinaryOperation jsBinaryOperation = JsAstUtils.inequality(this.index.reference(), this.end.reference());
        if (jsBinaryOperation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/foreach/ArrayForTranslator", "getCondition"));
        }
        return jsBinaryOperation;
    }

    @NotNull
    private JsExpression getIncrementExpression() {
        JsPrefixOperation jsPrefixOperation = new JsPrefixOperation(JsUnaryOperator.INC, this.index.reference());
        if (jsPrefixOperation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/foreach/ArrayForTranslator", "getIncrementExpression"));
        }
        return jsPrefixOperation;
    }
}

