/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.scopes;

import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.resolve.name.LabelName;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.utils.Printer;

public abstract class AbstractScopeAdapter
implements JetScope {
    @NotNull
    protected abstract JetScope getWorkerScope();

    @Override
    @NotNull
    public List<ReceiverParameterDescriptor> getImplicitReceiversHierarchy() {
        List<ReceiverParameterDescriptor> list2 = this.getWorkerScope().getImplicitReceiversHierarchy();
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/scopes/AbstractScopeAdapter", "getImplicitReceiversHierarchy"));
        }
        return list2;
    }

    @Override
    @NotNull
    public Collection<FunctionDescriptor> getFunctions(@NotNull Name name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/resolve/scopes/AbstractScopeAdapter", "getFunctions"));
        }
        Collection<FunctionDescriptor> collection = this.getWorkerScope().getFunctions(name);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/scopes/AbstractScopeAdapter", "getFunctions"));
        }
        return collection;
    }

    @Override
    public NamespaceDescriptor getNamespace(@NotNull Name name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/resolve/scopes/AbstractScopeAdapter", "getNamespace"));
        }
        return this.getWorkerScope().getNamespace(name);
    }

    @Override
    public ClassifierDescriptor getClassifier(@NotNull Name name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/resolve/scopes/AbstractScopeAdapter", "getClassifier"));
        }
        return this.getWorkerScope().getClassifier(name);
    }

    @Override
    @NotNull
    public Collection<VariableDescriptor> getProperties(@NotNull Name name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/resolve/scopes/AbstractScopeAdapter", "getProperties"));
        }
        Collection<VariableDescriptor> collection = this.getWorkerScope().getProperties(name);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/scopes/AbstractScopeAdapter", "getProperties"));
        }
        return collection;
    }

    @Override
    public VariableDescriptor getLocalVariable(@NotNull Name name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/resolve/scopes/AbstractScopeAdapter", "getLocalVariable"));
        }
        return this.getWorkerScope().getLocalVariable(name);
    }

    @Override
    @NotNull
    public DeclarationDescriptor getContainingDeclaration() {
        DeclarationDescriptor declarationDescriptor = this.getWorkerScope().getContainingDeclaration();
        if (declarationDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/scopes/AbstractScopeAdapter", "getContainingDeclaration"));
        }
        return declarationDescriptor;
    }

    @Override
    @NotNull
    public Collection<DeclarationDescriptor> getDeclarationsByLabel(LabelName labelName) {
        Collection<DeclarationDescriptor> collection = this.getWorkerScope().getDeclarationsByLabel(labelName);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/scopes/AbstractScopeAdapter", "getDeclarationsByLabel"));
        }
        return collection;
    }

    @Override
    @NotNull
    public Collection<DeclarationDescriptor> getAllDescriptors() {
        Collection<DeclarationDescriptor> collection = this.getWorkerScope().getAllDescriptors();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/scopes/AbstractScopeAdapter", "getAllDescriptors"));
        }
        return collection;
    }

    @Override
    @NotNull
    public Collection<DeclarationDescriptor> getOwnDeclaredDescriptors() {
        Collection<DeclarationDescriptor> collection = this.getWorkerScope().getOwnDeclaredDescriptors();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/scopes/AbstractScopeAdapter", "getOwnDeclaredDescriptors"));
        }
        return collection;
    }

    @Override
    public void printScopeStructure(@NotNull Printer p) {
        if (p == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "org/jetbrains/jet/lang/resolve/scopes/AbstractScopeAdapter", "printScopeStructure"));
        }
        p.println(this.getClass().getSimpleName(), " {");
        p.pushIndent();
        p.print("worker =");
        this.getWorkerScope().printScopeStructure(p.withholdIndentOnce());
        p.popIndent();
        p.println("}");
    }
}

