/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.lazy.descriptors;

import com.google.common.collect.Sets;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import jet.Function0;
import jet.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.psi.JetClassOrObject;
import org.jetbrains.jet.lang.psi.JetDeclaration;
import org.jetbrains.jet.lang.psi.JetFunction;
import org.jetbrains.jet.lang.psi.JetMultiDeclaration;
import org.jetbrains.jet.lang.psi.JetNamedFunction;
import org.jetbrains.jet.lang.psi.JetParameter;
import org.jetbrains.jet.lang.psi.JetProperty;
import org.jetbrains.jet.lang.psi.JetTypedef;
import org.jetbrains.jet.lang.resolve.calls.autocasts.DataFlowInfo;
import org.jetbrains.jet.lang.resolve.lazy.ResolveSession;
import org.jetbrains.jet.lang.resolve.lazy.ResolveSessionUtils;
import org.jetbrains.jet.lang.resolve.lazy.data.JetClassInfoUtil;
import org.jetbrains.jet.lang.resolve.lazy.declarations.DeclarationProvider;
import org.jetbrains.jet.lang.resolve.lazy.descriptors.LazyClassDescriptor;
import org.jetbrains.jet.lang.resolve.lazy.storage.LazyResolveStorageManager;
import org.jetbrains.jet.lang.resolve.name.LabelName;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.storage.MemoizedFunctionToNotNull;
import org.jetbrains.jet.storage.NotNullLazyValue;
import org.jetbrains.jet.utils.Printer;

public abstract class AbstractLazyMemberScope<D extends DeclarationDescriptor, DP extends DeclarationProvider>
implements JetScope {
    protected final ResolveSession resolveSession;
    protected final DP declarationProvider;
    protected final D thisDescriptor;
    private final MemoizedFunctionToNotNull<Name, List<ClassDescriptor>> classDescriptors;
    private final MemoizedFunctionToNotNull<Name, Set<FunctionDescriptor>> functionDescriptors;
    private final MemoizedFunctionToNotNull<Name, Set<VariableDescriptor>> propertyDescriptors;
    private final NotNullLazyValue<Collection<DeclarationDescriptor>> allDescriptors;

    protected AbstractLazyMemberScope(@NotNull ResolveSession resolveSession, @NotNull DP declarationProvider, @NotNull D thisDescriptor) {
        if (resolveSession == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveSession", "org/jetbrains/jet/lang/resolve/lazy/descriptors/AbstractLazyMemberScope", "<init>"));
        }
        if (declarationProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declarationProvider", "org/jetbrains/jet/lang/resolve/lazy/descriptors/AbstractLazyMemberScope", "<init>"));
        }
        if (thisDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "thisDescriptor", "org/jetbrains/jet/lang/resolve/lazy/descriptors/AbstractLazyMemberScope", "<init>"));
        }
        this.resolveSession = resolveSession;
        this.declarationProvider = declarationProvider;
        this.thisDescriptor = thisDescriptor;
        LazyResolveStorageManager storageManager = resolveSession.getStorageManager();
        this.classDescriptors = storageManager.createMemoizedFunction(new Function1<Name, List<ClassDescriptor>>(){

            @Override
            public List<ClassDescriptor> invoke(Name name) {
                return AbstractLazyMemberScope.this.resolveClassDescriptor(name);
            }
        });
        this.functionDescriptors = storageManager.createMemoizedFunction(new Function1<Name, Set<FunctionDescriptor>>(){

            @Override
            public Set<FunctionDescriptor> invoke(Name name) {
                return AbstractLazyMemberScope.this.doGetFunctions(name);
            }
        });
        this.propertyDescriptors = storageManager.createMemoizedFunction(new Function1<Name, Set<VariableDescriptor>>(){

            @Override
            public Set<VariableDescriptor> invoke(Name name) {
                return AbstractLazyMemberScope.this.doGetProperties(name);
            }
        });
        this.allDescriptors = storageManager.createLazyValue(new Function0<Collection<DeclarationDescriptor>>(){

            @Override
            public Collection<DeclarationDescriptor> invoke() {
                return AbstractLazyMemberScope.this.computeAllDescriptors();
            }
        });
    }

    @Nullable
    private List<ClassDescriptor> resolveClassDescriptor(final @NotNull Name name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/resolve/lazy/descriptors/AbstractLazyMemberScope", "resolveClassDescriptor"));
        }
        Collection<JetClassOrObject> classOrObjectDeclarations = this.declarationProvider.getClassOrObjectDeclarations(name);
        return ContainerUtil.mapNotNull(classOrObjectDeclarations, new Function<JetClassOrObject, ClassDescriptor>(){

            @Override
            public ClassDescriptor fun(JetClassOrObject classOrObject) {
                return new LazyClassDescriptor(AbstractLazyMemberScope.this.resolveSession, (DeclarationDescriptor)AbstractLazyMemberScope.this.thisDescriptor, name, JetClassInfoUtil.createClassLikeInfo(classOrObject));
            }
        });
    }

    @Override
    public ClassifierDescriptor getClassifier(@NotNull Name name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/resolve/lazy/descriptors/AbstractLazyMemberScope", "getClassifier"));
        }
        return (ClassifierDescriptor)AbstractLazyMemberScope.first((List)this.classDescriptors.invoke(name));
    }

    private static <T> T first(@NotNull List<T> list2) {
        if (list2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "org/jetbrains/jet/lang/resolve/lazy/descriptors/AbstractLazyMemberScope", "first"));
        }
        if (list2.isEmpty()) {
            return null;
        }
        return list2.get(0);
    }

    @NotNull
    public Set<FunctionDescriptor> getFunctions(@NotNull Name name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/resolve/lazy/descriptors/AbstractLazyMemberScope", "getFunctions"));
        }
        Set set = (Set)this.functionDescriptors.invoke(name);
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/descriptors/AbstractLazyMemberScope", "getFunctions"));
        }
        return set;
    }

    @NotNull
    private Set<FunctionDescriptor> doGetFunctions(@NotNull Name name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/resolve/lazy/descriptors/AbstractLazyMemberScope", "doGetFunctions"));
        }
        LinkedHashSet<FunctionDescriptor> result = Sets.newLinkedHashSet();
        Collection<JetNamedFunction> declarations = this.declarationProvider.getFunctionDeclarations(name);
        for (JetNamedFunction functionDeclaration : declarations) {
            JetScope resolutionScope = this.getScopeForMemberDeclarationResolution(functionDeclaration);
            result.add(this.resolveSession.getInjector().getDescriptorResolver().resolveFunctionDescriptorWithAnnotationArguments((DeclarationDescriptor)this.thisDescriptor, resolutionScope, functionDeclaration, this.resolveSession.getTrace(), DataFlowInfo.EMPTY));
        }
        this.getNonDeclaredFunctions(name, result);
        LinkedHashSet<FunctionDescriptor> linkedHashSet = result;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/descriptors/AbstractLazyMemberScope", "doGetFunctions"));
        }
        return linkedHashSet;
    }

    @NotNull
    protected abstract JetScope getScopeForMemberDeclarationResolution(JetDeclaration var1);

    protected abstract void getNonDeclaredFunctions(@NotNull Name var1, @NotNull Set<FunctionDescriptor> var2);

    @NotNull
    public Set<VariableDescriptor> getProperties(@NotNull Name name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/resolve/lazy/descriptors/AbstractLazyMemberScope", "getProperties"));
        }
        Set set = (Set)this.propertyDescriptors.invoke(name);
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/descriptors/AbstractLazyMemberScope", "getProperties"));
        }
        return set;
    }

    @NotNull
    public Set<VariableDescriptor> doGetProperties(@NotNull Name name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/resolve/lazy/descriptors/AbstractLazyMemberScope", "doGetProperties"));
        }
        LinkedHashSet<VariableDescriptor> result = Sets.newLinkedHashSet();
        Collection<JetProperty> declarations = this.declarationProvider.getPropertyDeclarations(name);
        for (JetProperty propertyDeclaration : declarations) {
            JetScope resolutionScope = this.getScopeForMemberDeclarationResolution(propertyDeclaration);
            PropertyDescriptor propertyDescriptor = this.resolveSession.getInjector().getDescriptorResolver().resolvePropertyDescriptor((DeclarationDescriptor)this.thisDescriptor, resolutionScope, propertyDeclaration, this.resolveSession.getTrace(), DataFlowInfo.EMPTY);
            result.add(propertyDescriptor);
            this.resolveSession.getInjector().getAnnotationResolver().resolveAnnotationsArguments(propertyDescriptor, this.resolveSession.getTrace(), resolutionScope);
        }
        this.getNonDeclaredProperties(name, result);
        LinkedHashSet<VariableDescriptor> linkedHashSet = result;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/descriptors/AbstractLazyMemberScope", "doGetProperties"));
        }
        return linkedHashSet;
    }

    protected abstract void getNonDeclaredProperties(@NotNull Name var1, @NotNull Set<VariableDescriptor> var2);

    @Override
    public VariableDescriptor getLocalVariable(@NotNull Name name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/resolve/lazy/descriptors/AbstractLazyMemberScope", "getLocalVariable"));
        }
        return null;
    }

    @Override
    @NotNull
    public DeclarationDescriptor getContainingDeclaration() {
        D d = this.thisDescriptor;
        if (d == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/descriptors/AbstractLazyMemberScope", "getContainingDeclaration"));
        }
        return d;
    }

    @Override
    @NotNull
    public Collection<DeclarationDescriptor> getDeclarationsByLabel(@NotNull LabelName labelName) {
        if (labelName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "labelName", "org/jetbrains/jet/lang/resolve/lazy/descriptors/AbstractLazyMemberScope", "getDeclarationsByLabel"));
        }
        Set<DeclarationDescriptor> set = Collections.emptySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/descriptors/AbstractLazyMemberScope", "getDeclarationsByLabel"));
        }
        return set;
    }

    @Override
    @NotNull
    public Collection<DeclarationDescriptor> getAllDescriptors() {
        Collection collection = (Collection)this.allDescriptors.invoke();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/descriptors/AbstractLazyMemberScope", "getAllDescriptors"));
        }
        return collection;
    }

    @NotNull
    private Collection<DeclarationDescriptor> computeAllDescriptors() {
        LinkedHashSet<DeclarationDescriptor> result = new LinkedHashSet<DeclarationDescriptor>();
        for (JetDeclaration declaration : this.declarationProvider.getAllDeclarations()) {
            if (declaration instanceof JetClassOrObject) {
                JetClassOrObject classOrObject = (JetClassOrObject)declaration;
                result.addAll((Collection)this.classDescriptors.invoke(ResolveSessionUtils.safeNameForLazyResolve(classOrObject.getNameAsName())));
                continue;
            }
            if (declaration instanceof JetFunction) {
                JetFunction function = (JetFunction)declaration;
                result.addAll(this.getFunctions(ResolveSessionUtils.safeNameForLazyResolve(function)));
                continue;
            }
            if (declaration instanceof JetProperty) {
                JetProperty property2 = (JetProperty)declaration;
                result.addAll(this.getProperties(ResolveSessionUtils.safeNameForLazyResolve(property2)));
                continue;
            }
            if (declaration instanceof JetParameter) {
                JetParameter parameter = (JetParameter)declaration;
                result.addAll(this.getProperties(ResolveSessionUtils.safeNameForLazyResolve(parameter)));
                continue;
            }
            if (declaration instanceof JetTypedef || declaration instanceof JetMultiDeclaration) continue;
            throw new IllegalArgumentException("Unsupported declaration kind: " + declaration);
        }
        this.addExtraDescriptors(result);
        LinkedHashSet<DeclarationDescriptor> linkedHashSet = result;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/descriptors/AbstractLazyMemberScope", "computeAllDescriptors"));
        }
        return linkedHashSet;
    }

    protected abstract void addExtraDescriptors(@NotNull Collection<DeclarationDescriptor> var1);

    @Override
    @NotNull
    public List<ReceiverParameterDescriptor> getImplicitReceiversHierarchy() {
        ReceiverParameterDescriptor receiver = this.getImplicitReceiver();
        if (receiver != null) {
            List<ReceiverParameterDescriptor> list2 = Collections.singletonList(receiver);
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/descriptors/AbstractLazyMemberScope", "getImplicitReceiversHierarchy"));
            }
            return list2;
        }
        List<ReceiverParameterDescriptor> list3 = Collections.emptyList();
        if (list3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/descriptors/AbstractLazyMemberScope", "getImplicitReceiversHierarchy"));
        }
        return list3;
    }

    @Nullable
    protected abstract ReceiverParameterDescriptor getImplicitReceiver();

    public abstract String toString();

    @Override
    @NotNull
    public Collection<DeclarationDescriptor> getOwnDeclaredDescriptors() {
        Collection<DeclarationDescriptor> collection = this.getAllDescriptors();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/descriptors/AbstractLazyMemberScope", "getOwnDeclaredDescriptors"));
        }
        return collection;
    }

    @Override
    public void printScopeStructure(@NotNull Printer p) {
        if (p == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "org/jetbrains/jet/lang/resolve/lazy/descriptors/AbstractLazyMemberScope", "printScopeStructure"));
        }
        p.println(this.getClass().getSimpleName(), " {");
        p.pushIndent();
        p.println("thisDescriptor = ", this.thisDescriptor);
        p.popIndent();
        p.println("}");
    }
}

