/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.PlatformToKotlinClassMap;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptorNonRoot;
import org.jetbrains.jet.lang.descriptors.ModuleDescriptor;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.diagnostics.Errors;
import org.jetbrains.jet.lang.psi.JetElement;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.psi.JetImportDirective;
import org.jetbrains.jet.lang.psi.JetImportsFactory;
import org.jetbrains.jet.lang.psi.JetPsiUtil;
import org.jetbrains.jet.lang.psi.JetScript;
import org.jetbrains.jet.lang.psi.JetSimpleNameExpression;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.ImportPath;
import org.jetbrains.jet.lang.resolve.Importer;
import org.jetbrains.jet.lang.resolve.QualifiedExpressionResolver;
import org.jetbrains.jet.lang.resolve.TemporaryBindingTrace;
import org.jetbrains.jet.lang.resolve.TopDownAnalysisContext;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.resolve.scopes.WritableScope;

public class ImportsResolver {
    @NotNull
    private TopDownAnalysisContext context;
    @NotNull
    private ModuleDescriptor moduleDescriptor;
    @NotNull
    private QualifiedExpressionResolver qualifiedExpressionResolver;
    @NotNull
    private BindingTrace trace;
    @NotNull
    private JetImportsFactory importsFactory;

    public void setContext(@NotNull TopDownAnalysisContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/resolve/ImportsResolver", "setContext"));
        }
        this.context = context;
    }

    public void setModuleDescriptor(@NotNull ModuleDescriptor moduleDescriptor) {
        if (moduleDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleDescriptor", "org/jetbrains/jet/lang/resolve/ImportsResolver", "setModuleDescriptor"));
        }
        this.moduleDescriptor = moduleDescriptor;
    }

    public void setTrace(@NotNull BindingTrace trace) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/ImportsResolver", "setTrace"));
        }
        this.trace = trace;
    }

    public void setQualifiedExpressionResolver(@NotNull QualifiedExpressionResolver qualifiedExpressionResolver) {
        if (qualifiedExpressionResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedExpressionResolver", "org/jetbrains/jet/lang/resolve/ImportsResolver", "setQualifiedExpressionResolver"));
        }
        this.qualifiedExpressionResolver = qualifiedExpressionResolver;
    }

    public void setImportsFactory(@NotNull JetImportsFactory importsFactory) {
        if (importsFactory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importsFactory", "org/jetbrains/jet/lang/resolve/ImportsResolver", "setImportsFactory"));
        }
        this.importsFactory = importsFactory;
    }

    public void processTypeImports(@NotNull JetScope rootScope) {
        if (rootScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootScope", "org/jetbrains/jet/lang/resolve/ImportsResolver", "processTypeImports"));
        }
        this.processImports(QualifiedExpressionResolver.LookupMode.ONLY_CLASSES, rootScope);
    }

    public void processMembersImports(@NotNull JetScope rootScope) {
        if (rootScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootScope", "org/jetbrains/jet/lang/resolve/ImportsResolver", "processMembersImports"));
        }
        this.processImports(QualifiedExpressionResolver.LookupMode.EVERYTHING, rootScope);
    }

    private void processImports(@NotNull QualifiedExpressionResolver.LookupMode lookupMode, @NotNull JetScope rootScope) {
        if (lookupMode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lookupMode", "org/jetbrains/jet/lang/resolve/ImportsResolver", "processImports"));
        }
        if (rootScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootScope", "org/jetbrains/jet/lang/resolve/ImportsResolver", "processImports"));
        }
        for (JetFile file : this.context.getNamespaceDescriptors().keySet()) {
            WritableScope namespaceScope = this.context.getNamespaceScopes().get(file);
            this.processImportsInFile(lookupMode, namespaceScope, Lists.newArrayList(file.getImportDirectives()), rootScope);
        }
        for (JetScript script : this.context.getScripts().keySet()) {
            WritableScope scriptScope = this.context.getScriptScopes().get(script);
            this.processImportsInFile(lookupMode, scriptScope, script.getImportDirectives(), rootScope);
        }
    }

    private void processImportsInFile(@NotNull QualifiedExpressionResolver.LookupMode lookupMode, WritableScope scope, List<JetImportDirective> directives, JetScope rootScope) {
        if (lookupMode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lookupMode", "org/jetbrains/jet/lang/resolve/ImportsResolver", "processImportsInFile"));
        }
        ImportsResolver.processImportsInFile(lookupMode, scope, directives, rootScope, this.moduleDescriptor, this.trace, this.qualifiedExpressionResolver, this.importsFactory);
    }

    public static void processImportsInFile(QualifiedExpressionResolver.LookupMode lookupMode, @NotNull WritableScope namespaceScope, @NotNull List<JetImportDirective> importDirectives, @NotNull JetScope rootScope, @NotNull ModuleDescriptor module, @NotNull BindingTrace trace, @NotNull QualifiedExpressionResolver qualifiedExpressionResolver, @NotNull JetImportsFactory importsFactory) {
        if (namespaceScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namespaceScope", "org/jetbrains/jet/lang/resolve/ImportsResolver", "processImportsInFile"));
        }
        if (importDirectives == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importDirectives", "org/jetbrains/jet/lang/resolve/ImportsResolver", "processImportsInFile"));
        }
        if (rootScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootScope", "org/jetbrains/jet/lang/resolve/ImportsResolver", "processImportsInFile"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/jet/lang/resolve/ImportsResolver", "processImportsInFile"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/ImportsResolver", "processImportsInFile"));
        }
        if (qualifiedExpressionResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedExpressionResolver", "org/jetbrains/jet/lang/resolve/ImportsResolver", "processImportsInFile"));
        }
        if (importsFactory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importsFactory", "org/jetbrains/jet/lang/resolve/ImportsResolver", "processImportsInFile"));
        }
        Importer.DelayedImporter delayedImporter = new Importer.DelayedImporter(namespaceScope);
        if (lookupMode == QualifiedExpressionResolver.LookupMode.EVERYTHING) {
            namespaceScope.clearImports();
        }
        for (ImportPath defaultImportPath : module.getDefaultImports()) {
            TemporaryBindingTrace temporaryTrace = TemporaryBindingTrace.create(trace, "transient trace to resolve default imports");
            JetImportDirective defaultImportDirective = importsFactory.createImportDirective(defaultImportPath);
            qualifiedExpressionResolver.processImportReference(defaultImportDirective, rootScope, namespaceScope, delayedImporter, temporaryTrace, module, lookupMode);
        }
        HashMap<JetImportDirective, Collection<? extends DeclarationDescriptor>> resolvedDirectives = Maps.newHashMap();
        for (JetImportDirective importDirective : importDirectives) {
            Collection<? extends DeclarationDescriptor> descriptors = qualifiedExpressionResolver.processImportReference(importDirective, rootScope, namespaceScope, delayedImporter, trace, module, lookupMode);
            if (!descriptors.isEmpty()) {
                resolvedDirectives.put(importDirective, descriptors);
            }
            JetExpression importedReference = importDirective.getImportedReference();
            if (lookupMode == QualifiedExpressionResolver.LookupMode.ONLY_CLASSES || importedReference == null) continue;
            for (DeclarationDescriptor declarationDescriptor : descriptors) {
                ImportsResolver.reportPlatformClassMappedToKotlin(module, trace, importedReference, declarationDescriptor);
            }
        }
        delayedImporter.processImports();
        if (lookupMode == QualifiedExpressionResolver.LookupMode.EVERYTHING) {
            for (JetImportDirective importDirective : importDirectives) {
                ImportsResolver.reportUselessImport(importDirective, namespaceScope, resolvedDirectives, trace);
            }
        }
    }

    public static void reportPlatformClassMappedToKotlin(@NotNull ModuleDescriptor module, @NotNull BindingTrace trace, @NotNull JetElement element, @NotNull DeclarationDescriptor descriptor) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/jet/lang/resolve/ImportsResolver", "reportPlatformClassMappedToKotlin"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/ImportsResolver", "reportPlatformClassMappedToKotlin"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/jet/lang/resolve/ImportsResolver", "reportPlatformClassMappedToKotlin"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/resolve/ImportsResolver", "reportPlatformClassMappedToKotlin"));
        }
        if (!(descriptor instanceof ClassDescriptor)) {
            return;
        }
        PlatformToKotlinClassMap platformToKotlinMap = module.getPlatformToKotlinClassMap();
        Collection<ClassDescriptor> kotlinAnalogsForClass = platformToKotlinMap.mapPlatformClass((ClassDescriptor)descriptor);
        if (!kotlinAnalogsForClass.isEmpty()) {
            trace.report(Errors.PLATFORM_CLASS_MAPPED_TO_KOTLIN.on(element, kotlinAnalogsForClass));
        }
    }

    private static void reportUselessImport(@NotNull JetImportDirective importDirective, @NotNull WritableScope namespaceScope, @NotNull Map<JetImportDirective, Collection<? extends DeclarationDescriptor>> resolvedDirectives, @NotNull BindingTrace trace) {
        if (importDirective == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importDirective", "org/jetbrains/jet/lang/resolve/ImportsResolver", "reportUselessImport"));
        }
        if (namespaceScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namespaceScope", "org/jetbrains/jet/lang/resolve/ImportsResolver", "reportUselessImport"));
        }
        if (resolvedDirectives == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvedDirectives", "org/jetbrains/jet/lang/resolve/ImportsResolver", "reportUselessImport"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/ImportsResolver", "reportUselessImport"));
        }
        JetExpression importedReference = importDirective.getImportedReference();
        if (importedReference == null || !resolvedDirectives.containsKey(importDirective)) {
            return;
        }
        Name aliasName = JetPsiUtil.getAliasName(importDirective);
        if (aliasName == null) {
            return;
        }
        boolean uselessHiddenImport = true;
        for (DeclarationDescriptor declarationDescriptor : resolvedDirectives.get(importDirective)) {
            DeclarationDescriptorNonRoot isResolved = null;
            if (declarationDescriptor instanceof ClassDescriptor) {
                isResolved = namespaceScope.getClassifier(aliasName);
            } else if (declarationDescriptor instanceof VariableDescriptor) {
                isResolved = namespaceScope.getLocalVariable(aliasName);
            } else if (declarationDescriptor instanceof NamespaceDescriptor) {
                isResolved = namespaceScope.getNamespace(aliasName);
            }
            if (isResolved != null && isResolved != declarationDescriptor) continue;
            uselessHiddenImport = false;
        }
        if (uselessHiddenImport) {
            trace.report(Errors.USELESS_HIDDEN_IMPORT.on(importedReference));
        }
        if (!importDirective.isAllUnder() && importedReference instanceof JetSimpleNameExpression && importDirective.getAliasName() == null) {
            trace.report(Errors.USELESS_SIMPLE_IMPORT.on(importedReference));
        }
    }
}

