/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.parsing;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.parsing.JetScriptDefinition;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.resolve.AnalyzerScriptParameter;

public class JetScriptDefinitionProvider {
    private final HashMap<String, JetScriptDefinition> scripts = new HashMap();
    private final HashSet<PsiFile> scriptsFiles = new HashSet();
    private static final JetScriptDefinition standardScript = new JetScriptDefinition(".ktscript", Collections.<AnalyzerScriptParameter>emptyList());

    public JetScriptDefinitionProvider() {
        this.addScriptDefinition(standardScript);
    }

    public void markFileAsScript(JetFile file) {
        this.scriptsFiles.add(file);
    }

    public static JetScriptDefinitionProvider getInstance(Project project) {
        return ServiceManager.getService(project, JetScriptDefinitionProvider.class);
    }

    public JetScriptDefinition findScriptDefinition(PsiFile psiFile) {
        boolean force = this.scriptsFiles.contains(psiFile);
        String name = psiFile.getName();
        for (Map.Entry<String, JetScriptDefinition> e : this.scripts.entrySet()) {
            if (!name.endsWith(e.getKey())) continue;
            return e.getValue();
        }
        if (force) {
            return standardScript;
        }
        return null;
    }

    public boolean isScript(PsiFile psiFile) {
        return this.findScriptDefinition(psiFile) != null;
    }

    public void addScriptDefinition(@NotNull JetScriptDefinition scriptDefinition) {
        if (scriptDefinition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scriptDefinition", "org/jetbrains/jet/lang/parsing/JetScriptDefinitionProvider", "addScriptDefinition"));
        }
        this.scripts.put(scriptDefinition.getExtension(), scriptDefinition);
    }

    public void addScriptDefinitions(List<JetScriptDefinition> definitions) {
        for (JetScriptDefinition definition : definitions) {
            this.addScriptDefinition(definition);
        }
    }
}

