/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen;

import com.google.common.collect.Lists;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.codegen.ClassBuilder;

public abstract class ClassBuilderOnDemand {
    private ClassBuilder classBuilder;
    private final List<ClassBuilderCallback> optionalDeclarations = Lists.newArrayList();

    @NotNull
    protected abstract ClassBuilder createClassBuilder();

    public void addOptionalDeclaration(@NotNull ClassBuilderCallback callback) {
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "org/jetbrains/jet/codegen/ClassBuilderOnDemand", "addOptionalDeclaration"));
        }
        this.optionalDeclarations.add(callback);
        if (this.classBuilder != null) {
            callback.doSomething(this.classBuilder);
        }
    }

    @NotNull
    public ClassBuilder getClassBuilder() {
        if (this.classBuilder == null) {
            this.classBuilder = this.createClassBuilder();
            for (ClassBuilderCallback callback : this.optionalDeclarations) {
                callback.doSomething(this.classBuilder);
            }
        }
        ClassBuilder classBuilder = this.classBuilder;
        if (classBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/ClassBuilderOnDemand", "getClassBuilder"));
        }
        return classBuilder;
    }

    public void done() {
        if (this.classBuilder != null) {
            this.classBuilder.done();
        }
    }

    public boolean isActivated() {
        return this.classBuilder != null;
    }

    static interface ClassBuilderCallback {
        public void doSomething(@NotNull ClassBuilder var1);
    }
}

