/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.cli.jvm.compiler;

import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Function;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.cli.jvm.compiler.JetCoreEnvironment;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.resolve.java.JetFilesProvider;

public class CliJetFilesProvider
extends JetFilesProvider {
    private final JetCoreEnvironment environment;
    private final Function<JetFile, Collection<JetFile>> allFiles = new Function<JetFile, Collection<JetFile>>(){

        @Override
        public Collection<JetFile> fun(JetFile file) {
            return CliJetFilesProvider.this.environment.getSourceFiles();
        }
    };

    public CliJetFilesProvider(JetCoreEnvironment environment) {
        this.environment = environment;
    }

    @Override
    public Function<JetFile, Collection<JetFile>> sampleToAllFilesInModule() {
        return this.allFiles;
    }

    public List<JetFile> allInScope(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/jet/cli/jvm/compiler/CliJetFilesProvider", "allInScope"));
        }
        ArrayList<JetFile> answer = new ArrayList<JetFile>();
        for (JetFile file : this.environment.getSourceFiles()) {
            if (!scope.contains(file.getVirtualFile())) continue;
            answer.add(file);
        }
        return answer;
    }

    @Override
    public boolean isFileInScope(@NotNull JetFile file, @NotNull GlobalSearchScope scope) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/jet/cli/jvm/compiler/CliJetFilesProvider", "isFileInScope"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/jet/cli/jvm/compiler/CliJetFilesProvider", "isFileInScope"));
        }
        return scope.contains(file.getVirtualFile()) && this.environment.getSourceFiles().contains(file);
    }
}

