/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class FileContentUtilCore {
    public static void reparseFiles(final @NotNull Collection<VirtualFile> files) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/FileContentUtilCore", "reparseFiles"));
        }
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                THashSet events = new THashSet();
                for (VirtualFile file : files) {
                    FileContentUtilCore.saveOrReload(file, events);
                }
                BulkFileListener publisher = ApplicationManager.getApplication().getMessageBus().syncPublisher(VirtualFileManager.VFS_CHANGES);
                ArrayList eventList = new ArrayList(events);
                publisher.before(eventList);
                publisher.after(eventList);
            }
        });
    }

    private static void saveOrReload(VirtualFile file, Collection<VFilePropertyChangeEvent> events) {
        Document document;
        if (file == null || file.isDirectory() || !file.isValid()) {
            return;
        }
        FileDocumentManager documentManager = FileDocumentManager.getInstance();
        if (documentManager.isFileModified(file) && (document = documentManager.getDocument(file)) != null) {
            documentManager.saveDocument(document);
        }
        events.add(new VFilePropertyChangeEvent("FileContentUtilCore.saveOrReload", file, "name", file.getName(), file.getName(), false));
    }
}

