/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.lang.ASTNode;
import com.intellij.lang.FileASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.LighterAST;
import com.intellij.lang.LighterASTNode;
import com.intellij.lang.LighterASTTokenNode;
import com.intellij.lang.ParserDefinition;
import com.intellij.openapi.diagnostic.LogUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiFile;
import com.intellij.psi.StubBuilder;
import com.intellij.psi.stubs.ILightStubElementType;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.PsiFileStubImpl;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.ILightStubFileElementType;
import com.intellij.util.CharTable;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Stack;
import com.intellij.util.diff.FlyweightCapableTreeStructure;
import gnu.trove.TIntStack;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LightStubBuilder
implements StubBuilder {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.stubs.LightStubBuilder");

    @Override
    public StubElement buildStubTree(@NotNull PsiFile file) {
        LighterAST tree;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/stubs/LightStubBuilder", "buildStubTree"));
        }
        FileType fileType = file.getFileType();
        if (!(fileType instanceof LanguageFileType)) {
            LOG.error("File is not of LanguageFileType: " + fileType + ", " + file);
            return null;
        }
        Language language = ((LanguageFileType)fileType).getLanguage();
        IFileElementType contentType = ((ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(language)).getFileNodeType();
        if (!(contentType instanceof ILightStubFileElementType)) {
            LOG.error("File is not of ILightStubFileElementType: " + contentType + ", " + file);
            return null;
        }
        FileASTNode node = file.getNode();
        assert (node != null) : file;
        if (!node.isParsed()) {
            ILightStubFileElementType type = (ILightStubFileElementType)contentType;
            tree = new FCTSBackedLighterAST(node.getCharTable(), type.parseContentsLight(node));
        } else {
            tree = new TreeBackedLighterAST(node);
        }
        StubElement rootStub = this.createStubForFile(file, tree);
        this.buildStubTree(tree, tree.getRoot(), rootStub);
        return rootStub;
    }

    @NotNull
    protected StubElement createStubForFile(@NotNull PsiFile file, @NotNull LighterAST tree) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/stubs/LightStubBuilder", "createStubForFile"));
        }
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/stubs/LightStubBuilder", "createStubForFile"));
        }
        PsiFileStubImpl<PsiFile> psiFileStubImpl = new PsiFileStubImpl<PsiFile>(file);
        if (psiFileStubImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/stubs/LightStubBuilder", "createStubForFile"));
        }
        return psiFileStubImpl;
    }

    protected void buildStubTree(@NotNull LighterAST tree, @NotNull LighterASTNode root, @NotNull StubElement rootStub) {
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/stubs/LightStubBuilder", "buildStubTree"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/stubs/LightStubBuilder", "buildStubTree"));
        }
        if (rootStub == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/psi/stubs/LightStubBuilder", "buildStubTree"));
        }
        Stack<LighterASTNode> parents = new Stack<LighterASTNode>();
        TIntStack childNumbers = new TIntStack();
        Stack<List> kinderGarden = new Stack<List>();
        Stack<StubElement> parentStubs = new Stack<StubElement>();
        LighterASTNode parent = null;
        LighterASTNode element = root;
        List children = null;
        int childNumber = 0;
        StubElement parentStub = rootStub;
        block0: while (element != null) {
            List kids;
            StubElement stub = this.createStub(tree, element, parentStub);
            if (!(parent != null && this.skipNode(tree, parent, element) || (kids = tree.getChildren(element)).isEmpty())) {
                if (parent != null) {
                    parents.push(parent);
                    childNumbers.push(childNumber);
                    kinderGarden.push(children);
                    parentStubs.push(parentStub);
                }
                parent = element;
                children = kids;
                childNumber = 0;
                element = children.get(0);
                parentStub = stub;
                if (!this.skipNode(tree, parent, element)) continue;
            }
            while (children != null && ++childNumber < children.size()) {
                element = children.get(childNumber);
                if (this.skipNode(tree, parent, element)) continue;
                continue block0;
            }
            element = null;
            while (!parents.isEmpty()) {
                parent = (LighterASTNode)parents.pop();
                childNumber = childNumbers.pop();
                children = (List)kinderGarden.pop();
                parentStub = (StubElement)parentStubs.pop();
                while (++childNumber < children.size()) {
                    element = (LighterASTNode)children.get(childNumber);
                    if (this.skipNode(tree, parent, element)) continue;
                    continue block0;
                }
                element = null;
            }
        }
    }

    protected StubElement createStub(LighterAST tree, LighterASTNode element, StubElement parentStub) {
        IElementType elementType = element.getTokenType();
        if (elementType instanceof IStubElementType) {
            if (elementType instanceof ILightStubElementType) {
                ILightStubElementType lightElementType = (ILightStubElementType)elementType;
                if (lightElementType.shouldCreateStub(tree, element, parentStub)) {
                    return lightElementType.createStub(tree, element, parentStub);
                }
            } else {
                LOG.error("Element is not of ILightStubElementType: " + LogUtil.objectAndClass(elementType) + ", " + element);
            }
        }
        return parentStub;
    }

    private boolean skipNode(@NotNull LighterAST tree, @NotNull LighterASTNode parent, @NotNull LighterASTNode node) {
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/stubs/LightStubBuilder", "skipNode"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/stubs/LightStubBuilder", "skipNode"));
        }
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/psi/stubs/LightStubBuilder", "skipNode"));
        }
        if (tree instanceof TreeBackedLighterAST) {
            return this.skipChildProcessingWhenBuildingStubs(((TreeBackedLighterAST)tree).unwrap(parent), ((TreeBackedLighterAST)tree).unwrap(node));
        }
        return this.skipChildProcessingWhenBuildingStubs(tree, parent, node);
    }

    @Override
    public boolean skipChildProcessingWhenBuildingStubs(@NotNull ASTNode parent, @NotNull ASTNode node) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/stubs/LightStubBuilder", "skipChildProcessingWhenBuildingStubs"));
        }
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/stubs/LightStubBuilder", "skipChildProcessingWhenBuildingStubs"));
        }
        return false;
    }

    protected boolean skipChildProcessingWhenBuildingStubs(@NotNull LighterAST tree, @NotNull LighterASTNode parent, @NotNull LighterASTNode node) {
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/stubs/LightStubBuilder", "skipChildProcessingWhenBuildingStubs"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/stubs/LightStubBuilder", "skipChildProcessingWhenBuildingStubs"));
        }
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/psi/stubs/LightStubBuilder", "skipChildProcessingWhenBuildingStubs"));
        }
        return false;
    }

    private static class TreeBackedLighterAST
    extends LighterAST {
        private final FileASTNode myRoot;

        public TreeBackedLighterAST(FileASTNode root) {
            super(root.getCharTable());
            this.myRoot = root;
        }

        @Override
        @NotNull
        public LighterASTNode getRoot() {
            LighterASTNode lighterASTNode = TreeBackedLighterAST.wrap(this.myRoot);
            if (lighterASTNode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/stubs/LightStubBuilder$TreeBackedLighterAST", "getRoot"));
            }
            return lighterASTNode;
        }

        @Override
        public LighterASTNode getParent(@NotNull LighterASTNode node) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/stubs/LightStubBuilder$TreeBackedLighterAST", "getParent"));
            }
            return TreeBackedLighterAST.wrap(((NodeWrapper)node).myNode.getTreeParent());
        }

        @Override
        @NotNull
        public List<LighterASTNode> getChildren(@NotNull LighterASTNode parent) {
            if (parent == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/stubs/LightStubBuilder$TreeBackedLighterAST", "getChildren"));
            }
            ASTNode[] children = ((NodeWrapper)parent).myNode.getChildren(null);
            if (children == null || children.length == 0) {
                List<LighterASTNode> list2 = ContainerUtil.emptyList();
                if (list2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/stubs/LightStubBuilder$TreeBackedLighterAST", "getChildren"));
                }
                return list2;
            }
            ArrayList<LighterASTNode> result = new ArrayList<LighterASTNode>(children.length);
            for (ASTNode child : children) {
                result.add(TreeBackedLighterAST.wrap(child));
            }
            ArrayList<LighterASTNode> arrayList = result;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/stubs/LightStubBuilder$TreeBackedLighterAST", "getChildren"));
            }
            return arrayList;
        }

        @Nullable
        private static LighterASTNode wrap(@Nullable ASTNode node) {
            if (node == null) {
                return null;
            }
            if (node.getFirstChildNode() == null && node.getTextLength() > 0) {
                return new TokenNodeWrapper(node);
            }
            return new NodeWrapper(node);
        }

        @NotNull
        public ASTNode unwrap(LighterASTNode node) {
            ASTNode aSTNode = ((NodeWrapper)node).myNode;
            if (aSTNode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/stubs/LightStubBuilder$TreeBackedLighterAST", "unwrap"));
            }
            return aSTNode;
        }

        private static class TokenNodeWrapper
        extends NodeWrapper
        implements LighterASTTokenNode {
            public TokenNodeWrapper(ASTNode node) {
                super(node);
            }

            @Override
            public CharSequence getText() {
                return this.myNode.getText();
            }

            @Override
            public String toString() {
                return "token wrapper[" + this.myNode + "]";
            }
        }

        private static class NodeWrapper
        implements LighterASTNode {
            protected final ASTNode myNode;

            public NodeWrapper(ASTNode node) {
                this.myNode = node;
            }

            @Override
            public IElementType getTokenType() {
                return this.myNode.getElementType();
            }

            @Override
            public int getStartOffset() {
                return this.myNode.getStartOffset();
            }

            @Override
            public int getEndOffset() {
                return this.myNode.getStartOffset() + this.myNode.getTextLength();
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (!(o instanceof NodeWrapper)) {
                    return false;
                }
                NodeWrapper that = (NodeWrapper)o;
                return !(this.myNode != null ? !this.myNode.equals(that.myNode) : that.myNode != null);
            }

            public int hashCode() {
                return this.myNode.hashCode();
            }

            public String toString() {
                return "node wrapper[" + this.myNode + "]";
            }
        }
    }

    private static class FCTSBackedLighterAST
    extends LighterAST {
        private final FlyweightCapableTreeStructure<LighterASTNode> myTreeStructure;

        public FCTSBackedLighterAST(CharTable charTable, FlyweightCapableTreeStructure<LighterASTNode> treeStructure) {
            super(charTable);
            this.myTreeStructure = treeStructure;
        }

        @Override
        @NotNull
        public LighterASTNode getRoot() {
            LighterASTNode lighterASTNode = this.myTreeStructure.getRoot();
            if (lighterASTNode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/stubs/LightStubBuilder$FCTSBackedLighterAST", "getRoot"));
            }
            return lighterASTNode;
        }

        @Override
        public LighterASTNode getParent(@NotNull LighterASTNode node) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/stubs/LightStubBuilder$FCTSBackedLighterAST", "getParent"));
            }
            return this.myTreeStructure.getParent(node);
        }

        @Override
        @NotNull
        public List<LighterASTNode> getChildren(@NotNull LighterASTNode parent) {
            if (parent == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/stubs/LightStubBuilder$FCTSBackedLighterAST", "getChildren"));
            }
            Ref<T[]> into = new Ref<T[]>();
            int numKids = this.myTreeStructure.getChildren(this.myTreeStructure.prepareForGetChildren(parent), into);
            List<LighterASTNode> list2 = numKids > 0 ? ContainerUtil.newArrayList(into.get(), 0, numKids) : ContainerUtil.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/stubs/LightStubBuilder$FCTSBackedLighterAST", "getChildren"));
            }
            return list2;
        }
    }
}

