/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.intrinsic.functions.patterns;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.CallableMemberDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.k2js.translate.context.Namer;
import org.jetbrains.k2js.translate.intrinsic.functions.patterns.DescriptorPredicate;
import org.jetbrains.k2js.translate.intrinsic.functions.patterns.NamePredicate;

public final class PatternBuilder {
    @NotNull
    private static final NamePredicate JET = new NamePredicate("jet");
    @NotNull
    private static final Name KOTLIN_NAME = Name.identifier(Namer.KOTLIN_LOWER_NAME);

    private PatternBuilder() {
    }

    @NotNull
    public static DescriptorPredicate pattern(@NotNull NamePredicate checker, @NotNull String stringWithPattern) {
        if (checker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "checker", "org/jetbrains/k2js/translate/intrinsic/functions/patterns/PatternBuilder", "pattern"));
        }
        if (stringWithPattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stringWithPattern", "org/jetbrains/k2js/translate/intrinsic/functions/patterns/PatternBuilder", "pattern"));
        }
        ArrayList<NamePredicate> checkers = Lists.newArrayList(checker);
        checkers.addAll(PatternBuilder.parseStringAsCheckerList(stringWithPattern));
        DescriptorPredicate descriptorPredicate = PatternBuilder.pattern(checkers);
        if (descriptorPredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/intrinsic/functions/patterns/PatternBuilder", "pattern"));
        }
        return descriptorPredicate;
    }

    @NotNull
    public static DescriptorPredicate pattern(@NotNull String stringWithPattern, @NotNull NamePredicate checker) {
        if (stringWithPattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stringWithPattern", "org/jetbrains/k2js/translate/intrinsic/functions/patterns/PatternBuilder", "pattern"));
        }
        if (checker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "checker", "org/jetbrains/k2js/translate/intrinsic/functions/patterns/PatternBuilder", "pattern"));
        }
        ArrayList<NamePredicate> checkers = Lists.newArrayList(PatternBuilder.parseStringAsCheckerList(stringWithPattern));
        checkers.add(checker);
        DescriptorPredicate descriptorPredicate = PatternBuilder.pattern(checkers);
        if (descriptorPredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/intrinsic/functions/patterns/PatternBuilder", "pattern"));
        }
        return descriptorPredicate;
    }

    @NotNull
    public static DescriptorPredicate pattern(@NotNull String string) {
        if (string == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "string", "org/jetbrains/k2js/translate/intrinsic/functions/patterns/PatternBuilder", "pattern"));
        }
        List<NamePredicate> checkers = PatternBuilder.parseStringAsCheckerList(string);
        DescriptorPredicate descriptorPredicate = PatternBuilder.pattern(checkers);
        if (descriptorPredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/intrinsic/functions/patterns/PatternBuilder", "pattern"));
        }
        return descriptorPredicate;
    }

    @NotNull
    private static List<NamePredicate> parseStringAsCheckerList(@NotNull String stringWithPattern) {
        if (stringWithPattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stringWithPattern", "org/jetbrains/k2js/translate/intrinsic/functions/patterns/PatternBuilder", "parseStringAsCheckerList"));
        }
        String[] subPatterns = stringWithPattern.split("\\.");
        ArrayList<NamePredicate> checkers = Lists.newArrayList();
        for (String subPattern : subPatterns) {
            String[] validNames = subPattern.split("\\|");
            checkers.add(new NamePredicate(validNames));
        }
        ArrayList<NamePredicate> arrayList = checkers;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/intrinsic/functions/patterns/PatternBuilder", "parseStringAsCheckerList"));
        }
        return arrayList;
    }

    @NotNull
    private static DescriptorPredicate pattern(@NotNull List<NamePredicate> checkers) {
        if (checkers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "checkers", "org/jetbrains/k2js/translate/intrinsic/functions/patterns/PatternBuilder", "pattern"));
        }
        assert (!checkers.isEmpty());
        final ArrayList<NamePredicate> checkersWithPrefixChecker = Lists.newArrayList();
        if (!checkers.get(0).apply(KOTLIN_NAME)) {
            checkersWithPrefixChecker.add(JET);
        }
        checkersWithPrefixChecker.addAll(checkers);
        assert (checkersWithPrefixChecker.size() > 1);
        DescriptorPredicate descriptorPredicate = new DescriptorPredicate(){

            @Override
            public boolean apply(@NotNull FunctionDescriptor descriptor) {
                if (descriptor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/k2js/translate/intrinsic/functions/patterns/PatternBuilder$1", "apply"));
                }
                try {
                    return this.doApply(descriptor);
                }
                catch (IllegalArgumentException e) {
                    return false;
                }
            }

            private boolean doApply(@NotNull FunctionDescriptor descriptor) {
                if (descriptor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/k2js/translate/intrinsic/functions/patterns/PatternBuilder$1", "doApply"));
                }
                List<Name> nameParts = DescriptorUtils.getFQName(descriptor).pathSegments();
                if (nameParts.size() != checkersWithPrefixChecker.size()) {
                    return false;
                }
                return this.allNamePartsValid(nameParts);
            }

            private boolean allNamePartsValid(@NotNull List<Name> nameParts) {
                if (nameParts == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameParts", "org/jetbrains/k2js/translate/intrinsic/functions/patterns/PatternBuilder$1", "allNamePartsValid"));
                }
                for (int i = 0; i < nameParts.size(); ++i) {
                    Name namePart = nameParts.get(i);
                    NamePredicate correspondingPredicate = (NamePredicate)checkersWithPrefixChecker.get(i);
                    if (correspondingPredicate.apply(namePart)) continue;
                    return false;
                }
                return true;
            }
        };
        if (descriptorPredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/intrinsic/functions/patterns/PatternBuilder", "pattern"));
        }
        return descriptorPredicate;
    }

    @NotNull
    public static DescriptorPredicate pattern(NamePredicate ... checkers) {
        if (checkers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "checkers", "org/jetbrains/k2js/translate/intrinsic/functions/patterns/PatternBuilder", "pattern"));
        }
        DescriptorPredicate descriptorPredicate = PatternBuilder.pattern(Arrays.asList(checkers));
        if (descriptorPredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/intrinsic/functions/patterns/PatternBuilder", "pattern"));
        }
        return descriptorPredicate;
    }

    @NotNull
    public static DescriptorPredicateImpl pattern(String ... names) {
        if (names == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "names", "org/jetbrains/k2js/translate/intrinsic/functions/patterns/PatternBuilder", "pattern"));
        }
        DescriptorPredicateImpl descriptorPredicateImpl = new DescriptorPredicateImpl(names);
        if (descriptorPredicateImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/intrinsic/functions/patterns/PatternBuilder", "pattern"));
        }
        return descriptorPredicateImpl;
    }

    @NotNull
    public static DescriptorPredicateImpl pattern(@NotNull String[] root, String ... names) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "org/jetbrains/k2js/translate/intrinsic/functions/patterns/PatternBuilder", "pattern"));
        }
        if (names == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "names", "org/jetbrains/k2js/translate/intrinsic/functions/patterns/PatternBuilder", "pattern"));
        }
        DescriptorPredicateImpl descriptorPredicateImpl = new DescriptorPredicateImpl(names).root(root);
        if (descriptorPredicateImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/intrinsic/functions/patterns/PatternBuilder", "pattern"));
        }
        return descriptorPredicateImpl;
    }

    private static boolean isRootNamespace(DeclarationDescriptor declarationDescriptor) {
        return declarationDescriptor instanceof NamespaceDescriptor && DescriptorUtils.isRootNamespace((NamespaceDescriptor)declarationDescriptor);
    }

    public static class DescriptorPredicateImpl
    implements DescriptorPredicate {
        private final String[] names;
        private boolean receiverParameterExists;
        private String[] root;
        private boolean checkOverridden;

        public DescriptorPredicateImpl(String ... names) {
            this.names = names;
        }

        public DescriptorPredicateImpl receiverExists() {
            this.receiverParameterExists = true;
            return this;
        }

        public DescriptorPredicateImpl root(String ... root) {
            this.root = root;
            return this;
        }

        public DescriptorPredicateImpl checkOverridden() {
            this.checkOverridden = true;
            return this;
        }

        private boolean check(FunctionDescriptor functionDescriptor) {
            int nameIndex;
            String[] list2;
            DeclarationDescriptor descriptor = functionDescriptor.getContainingDeclaration();
            if (this.root == null) {
                list2 = this.names;
                nameIndex = list2.length - 2;
            } else {
                assert (this.names.length == 1);
                list2 = this.root;
                nameIndex = list2.length - 1;
            }
            do {
                if (nameIndex == -1) {
                    return PatternBuilder.isRootNamespace(descriptor);
                }
                if (PatternBuilder.isRootNamespace(descriptor)) {
                    return false;
                }
                if (descriptor.getName().asString().equals(list2[nameIndex--])) continue;
                return false;
            } while ((descriptor = descriptor.getContainingDeclaration()) != null);
            return false;
        }

        @Override
        public boolean apply(@NotNull FunctionDescriptor functionDescriptor) {
            DeclarationDescriptor descriptor;
            if (functionDescriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/k2js/translate/intrinsic/functions/patterns/PatternBuilder$DescriptorPredicateImpl", "apply"));
            }
            if (functionDescriptor.getReceiverParameter() == null == this.receiverParameterExists) {
                return false;
            }
            int nameIndex = this.names.length - 1;
            if (!functionDescriptor.getName().asString().equals(this.names[nameIndex--])) {
                return false;
            }
            if (functionDescriptor.getKind() == CallableMemberDescriptor.Kind.FAKE_OVERRIDE) {
                assert (functionDescriptor.getOverriddenDescriptors().size() > 0);
                descriptor = functionDescriptor.getOverriddenDescriptors().iterator().next();
            } else {
                descriptor = functionDescriptor;
            }
            String[] list2 = this.names;
            while ((descriptor = descriptor.getContainingDeclaration()) != null) {
                if (nameIndex == -1) {
                    if (PatternBuilder.isRootNamespace(descriptor)) {
                        return list2 == this.root || this.root == null;
                    }
                    if (this.root == null) {
                        return false;
                    }
                    nameIndex = this.root.length - 1;
                    list2 = this.root;
                } else if (PatternBuilder.isRootNamespace(descriptor)) {
                    return false;
                }
                if (descriptor.getName().asString().equals(list2[nameIndex--])) continue;
                return this.checkOverridden && this.checkOverridden(functionDescriptor);
            }
            return false;
        }

        private boolean checkOverridden(FunctionDescriptor functionDescriptor) {
            Set<? extends FunctionDescriptor> overriddenDescriptors = functionDescriptor.getOverriddenDescriptors();
            if (overriddenDescriptors.isEmpty()) {
                return false;
            }
            for (FunctionDescriptor functionDescriptor2 : overriddenDescriptors) {
                if (functionDescriptor2.getKind() == CallableMemberDescriptor.Kind.FAKE_OVERRIDE) {
                    for (FunctionDescriptor functionDescriptor3 : functionDescriptor2.getOverriddenDescriptors()) {
                        if (!this.check(functionDescriptor3) && !this.checkOverridden(functionDescriptor3)) continue;
                        return true;
                    }
                    continue;
                }
                if (!this.check(functionDescriptor2) && !this.checkOverridden(functionDescriptor2)) continue;
                return true;
            }
            return false;
        }
    }
}

