/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.context;

import com.google.dart.compiler.backend.js.ast.JsBlock;
import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsFunction;
import com.google.dart.compiler.backend.js.ast.JsLiteral;
import com.google.dart.compiler.backend.js.ast.JsName;
import com.google.dart.compiler.backend.js.ast.JsNameRef;
import com.google.dart.compiler.backend.js.ast.JsProgram;
import com.google.dart.compiler.backend.js.ast.JsScope;
import com.google.dart.compiler.backend.js.ast.JsStatement;
import com.intellij.psi.PsiElement;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.k2js.translate.context.AliasingContext;
import org.jetbrains.k2js.translate.context.DynamicContext;
import org.jetbrains.k2js.translate.context.Namer;
import org.jetbrains.k2js.translate.context.StaticContext;
import org.jetbrains.k2js.translate.context.TemporaryConstVariable;
import org.jetbrains.k2js.translate.context.TemporaryVariable;
import org.jetbrains.k2js.translate.context.UsageTracker;
import org.jetbrains.k2js.translate.expression.LiteralFunctionTranslator;
import org.jetbrains.k2js.translate.intrinsic.Intrinsics;
import org.jetbrains.k2js.translate.utils.BindingUtils;
import org.jetbrains.k2js.translate.utils.JsDescriptorUtils;

public class TranslationContext {
    @NotNull
    private final DynamicContext dynamicContext;
    @NotNull
    private final StaticContext staticContext;
    @NotNull
    private final AliasingContext aliasingContext;
    @Nullable
    private final UsageTracker usageTracker;
    private final HashMap<JsExpression, TemporaryConstVariable> expressionToTempConstVariableCache;

    @NotNull
    public static TranslationContext rootContext(@NotNull StaticContext staticContext, JsFunction rootFunction) {
        if (staticContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "staticContext", "org/jetbrains/k2js/translate/context/TranslationContext", "rootContext"));
        }
        DynamicContext rootDynamicContext = DynamicContext.rootContext(rootFunction.getScope(), rootFunction.getBody());
        AliasingContext rootAliasingContext = AliasingContext.getCleanContext();
        TranslationContext translationContext = new TranslationContext(staticContext, rootDynamicContext, rootAliasingContext, null);
        if (translationContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/context/TranslationContext", "rootContext"));
        }
        return translationContext;
    }

    private TranslationContext(@NotNull StaticContext staticContext, @NotNull DynamicContext dynamicContext, @NotNull AliasingContext aliasingContext, @Nullable UsageTracker usageTracker) {
        if (staticContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "staticContext", "org/jetbrains/k2js/translate/context/TranslationContext", "<init>"));
        }
        if (dynamicContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dynamicContext", "org/jetbrains/k2js/translate/context/TranslationContext", "<init>"));
        }
        if (aliasingContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aliasingContext", "org/jetbrains/k2js/translate/context/TranslationContext", "<init>"));
        }
        this.expressionToTempConstVariableCache = new HashMap();
        this.dynamicContext = dynamicContext;
        this.staticContext = staticContext;
        this.aliasingContext = aliasingContext;
        this.usageTracker = usageTracker;
    }

    private TranslationContext(@NotNull TranslationContext parent, @NotNull AliasingContext aliasingContext) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "org/jetbrains/k2js/translate/context/TranslationContext", "<init>"));
        }
        if (aliasingContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aliasingContext", "org/jetbrains/k2js/translate/context/TranslationContext", "<init>"));
        }
        this(parent.staticContext, parent.dynamicContext, aliasingContext, parent.usageTracker);
    }

    private TranslationContext(@NotNull TranslationContext parent, @NotNull JsFunction fun, @NotNull AliasingContext aliasingContext, @Nullable UsageTracker usageTracker) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "org/jetbrains/k2js/translate/context/TranslationContext", "<init>"));
        }
        if (fun == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fun", "org/jetbrains/k2js/translate/context/TranslationContext", "<init>"));
        }
        if (aliasingContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aliasingContext", "org/jetbrains/k2js/translate/context/TranslationContext", "<init>"));
        }
        this(parent.staticContext, DynamicContext.newContext(fun.getScope(), fun.getBody()), aliasingContext, usageTracker == null ? parent.usageTracker : usageTracker);
    }

    @Nullable
    public UsageTracker usageTracker() {
        return this.usageTracker;
    }

    public DynamicContext dynamicContext() {
        return this.dynamicContext;
    }

    @NotNull
    public TranslationContext contextWithScope(@NotNull JsFunction fun) {
        if (fun == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fun", "org/jetbrains/k2js/translate/context/TranslationContext", "contextWithScope"));
        }
        TranslationContext translationContext = new TranslationContext(this, fun, this.aliasingContext, null);
        if (translationContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/context/TranslationContext", "contextWithScope"));
        }
        return translationContext;
    }

    @NotNull
    private TranslationContext contextWithScope(@NotNull JsScope newScope, @NotNull JsBlock block, @NotNull AliasingContext aliasingContext, @Nullable UsageTracker usageTracker) {
        if (newScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newScope", "org/jetbrains/k2js/translate/context/TranslationContext", "contextWithScope"));
        }
        if (block == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "block", "org/jetbrains/k2js/translate/context/TranslationContext", "contextWithScope"));
        }
        if (aliasingContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aliasingContext", "org/jetbrains/k2js/translate/context/TranslationContext", "contextWithScope"));
        }
        TranslationContext translationContext = new TranslationContext(this.staticContext, DynamicContext.newContext(newScope, block), aliasingContext, usageTracker);
        if (translationContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/context/TranslationContext", "contextWithScope"));
        }
        return translationContext;
    }

    @NotNull
    public TranslationContext newFunctionBody(@NotNull JsFunction fun, @Nullable AliasingContext aliasingContext, @Nullable UsageTracker usageTracker) {
        if (fun == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fun", "org/jetbrains/k2js/translate/context/TranslationContext", "newFunctionBody"));
        }
        TranslationContext translationContext = new TranslationContext(this, fun, aliasingContext == null ? new AliasingContext(this.aliasingContext) : aliasingContext, usageTracker);
        if (translationContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/context/TranslationContext", "newFunctionBody"));
        }
        return translationContext;
    }

    @NotNull
    public TranslationContext innerBlock(@NotNull JsBlock block) {
        if (block == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "block", "org/jetbrains/k2js/translate/context/TranslationContext", "innerBlock"));
        }
        TranslationContext translationContext = new TranslationContext(this.staticContext, this.dynamicContext.innerBlock(block), this.aliasingContext, this.usageTracker);
        if (translationContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/context/TranslationContext", "innerBlock"));
        }
        return translationContext;
    }

    @NotNull
    public TranslationContext newDeclaration(@NotNull DeclarationDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/k2js/translate/context/TranslationContext", "newDeclaration"));
        }
        TranslationContext translationContext = this.contextWithScope(this.getScopeForDescriptor(descriptor), this.getBlockForDescriptor(descriptor), this.aliasingContext, this.usageTracker);
        if (translationContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/context/TranslationContext", "newDeclaration"));
        }
        return translationContext;
    }

    @NotNull
    public TranslationContext innerContextWithThisAliased(@NotNull DeclarationDescriptor correspondingDescriptor, @NotNull JsNameRef alias) {
        if (correspondingDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "correspondingDescriptor", "org/jetbrains/k2js/translate/context/TranslationContext", "innerContextWithThisAliased"));
        }
        if (alias == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "alias", "org/jetbrains/k2js/translate/context/TranslationContext", "innerContextWithThisAliased"));
        }
        TranslationContext translationContext = new TranslationContext(this, this.aliasingContext.inner(correspondingDescriptor, alias));
        if (translationContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/context/TranslationContext", "innerContextWithThisAliased"));
        }
        return translationContext;
    }

    @NotNull
    public TranslationContext innerContextWithAliasesForExpressions(@NotNull Map<JetExpression, JsName> aliases) {
        if (aliases == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aliases", "org/jetbrains/k2js/translate/context/TranslationContext", "innerContextWithAliasesForExpressions"));
        }
        TranslationContext translationContext = new TranslationContext(this, this.aliasingContext.withExpressionsAliased(aliases));
        if (translationContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/context/TranslationContext", "innerContextWithAliasesForExpressions"));
        }
        return translationContext;
    }

    @NotNull
    public TranslationContext innerContextWithDescriptorsAliased(@NotNull Map<DeclarationDescriptor, JsExpression> aliases) {
        if (aliases == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aliases", "org/jetbrains/k2js/translate/context/TranslationContext", "innerContextWithDescriptorsAliased"));
        }
        TranslationContext translationContext = new TranslationContext(this, this.aliasingContext.withDescriptorsAliased(aliases));
        if (translationContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/context/TranslationContext", "innerContextWithDescriptorsAliased"));
        }
        return translationContext;
    }

    @NotNull
    public JsBlock getBlockForDescriptor(@NotNull DeclarationDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/k2js/translate/context/TranslationContext", "getBlockForDescriptor"));
        }
        if (descriptor instanceof CallableDescriptor) {
            JsBlock jsBlock = this.getFunctionObject((CallableDescriptor)descriptor).getBody();
            if (jsBlock == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/context/TranslationContext", "getBlockForDescriptor"));
            }
            return jsBlock;
        }
        JsBlock jsBlock = new JsBlock();
        if (jsBlock == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/context/TranslationContext", "getBlockForDescriptor"));
        }
        return jsBlock;
    }

    @NotNull
    public BindingContext bindingContext() {
        BindingContext bindingContext = this.staticContext.getBindingContext();
        if (bindingContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/context/TranslationContext", "bindingContext"));
        }
        return bindingContext;
    }

    @NotNull
    public JsScope getScopeForDescriptor(@NotNull DeclarationDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/k2js/translate/context/TranslationContext", "getScopeForDescriptor"));
        }
        JsScope jsScope = this.staticContext.getScopeForDescriptor(descriptor);
        if (jsScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/context/TranslationContext", "getScopeForDescriptor"));
        }
        return jsScope;
    }

    @NotNull
    public JsName getNameForElement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/k2js/translate/context/TranslationContext", "getNameForElement"));
        }
        DeclarationDescriptor descriptor = BindingUtils.getDescriptorForElement(this.bindingContext(), element);
        JsName jsName = this.getNameForDescriptor(descriptor);
        if (jsName == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/context/TranslationContext", "getNameForElement"));
        }
        return jsName;
    }

    @NotNull
    public JsName getNameForDescriptor(@NotNull DeclarationDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/k2js/translate/context/TranslationContext", "getNameForDescriptor"));
        }
        JsName jsName = this.staticContext.getNameForDescriptor(descriptor);
        if (jsName == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/context/TranslationContext", "getNameForDescriptor"));
        }
        return jsName;
    }

    @NotNull
    public JsName declarePropertyOrPropertyAccessorName(@NotNull DeclarationDescriptor descriptor, @NotNull String name, boolean fresh) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/k2js/translate/context/TranslationContext", "declarePropertyOrPropertyAccessorName"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/k2js/translate/context/TranslationContext", "declarePropertyOrPropertyAccessorName"));
        }
        JsName jsName = this.staticContext.declarePropertyOrPropertyAccessorName(descriptor, name, fresh);
        if (jsName == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/context/TranslationContext", "declarePropertyOrPropertyAccessorName"));
        }
        return jsName;
    }

    @NotNull
    public JsNameRef getQualifiedReference(@NotNull DeclarationDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/k2js/translate/context/TranslationContext", "getQualifiedReference"));
        }
        JsNameRef jsNameRef = this.staticContext.getQualifiedReference(descriptor);
        if (jsNameRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/context/TranslationContext", "getQualifiedReference"));
        }
        return jsNameRef;
    }

    @Nullable
    public JsNameRef getQualifierForDescriptor(@NotNull DeclarationDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/k2js/translate/context/TranslationContext", "getQualifierForDescriptor"));
        }
        return this.staticContext.getQualifierForDescriptor(descriptor);
    }

    @NotNull
    public TemporaryVariable declareTemporary(@Nullable JsExpression initExpression) {
        TemporaryVariable temporaryVariable = this.dynamicContext.declareTemporary(initExpression);
        if (temporaryVariable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/context/TranslationContext", "declareTemporary"));
        }
        return temporaryVariable;
    }

    @NotNull
    public TemporaryConstVariable getOrDeclareTemporaryConstVariable(@NotNull JsExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/k2js/translate/context/TranslationContext", "getOrDeclareTemporaryConstVariable"));
        }
        TemporaryConstVariable tempVar = this.expressionToTempConstVariableCache.get(expression);
        if (tempVar == null) {
            TemporaryVariable tmpVar = this.declareTemporary(expression);
            tempVar = new TemporaryConstVariable(tmpVar.name(), tmpVar.assignmentExpression());
            this.expressionToTempConstVariableCache.put(expression, tempVar);
            this.expressionToTempConstVariableCache.put(tmpVar.assignmentExpression(), tempVar);
        }
        TemporaryConstVariable temporaryConstVariable = tempVar;
        if (temporaryConstVariable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/context/TranslationContext", "getOrDeclareTemporaryConstVariable"));
        }
        return temporaryConstVariable;
    }

    public void associateExpressionToLazyValue(JsExpression expression, TemporaryConstVariable temporaryConstVariable) {
        assert (expression == temporaryConstVariable.assignmentExpression());
        this.expressionToTempConstVariableCache.put(expression, temporaryConstVariable);
    }

    @NotNull
    public Namer namer() {
        Namer namer = this.staticContext.getNamer();
        if (namer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/context/TranslationContext", "namer"));
        }
        return namer;
    }

    @NotNull
    public Intrinsics intrinsics() {
        Intrinsics intrinsics = this.staticContext.getIntrinsics();
        if (intrinsics == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/context/TranslationContext", "intrinsics"));
        }
        return intrinsics;
    }

    @NotNull
    public JsProgram program() {
        JsProgram jsProgram = this.staticContext.getProgram();
        if (jsProgram == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/context/TranslationContext", "program"));
        }
        return jsProgram;
    }

    @NotNull
    public JsScope scope() {
        JsScope jsScope = this.dynamicContext.getScope();
        if (jsScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/context/TranslationContext", "scope"));
        }
        return jsScope;
    }

    @NotNull
    public AliasingContext aliasingContext() {
        AliasingContext aliasingContext = this.aliasingContext;
        if (aliasingContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/context/TranslationContext", "aliasingContext"));
        }
        return aliasingContext;
    }

    @NotNull
    public LiteralFunctionTranslator literalFunctionTranslator() {
        LiteralFunctionTranslator literalFunctionTranslator = this.staticContext.getLiteralFunctionTranslator();
        if (literalFunctionTranslator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/context/TranslationContext", "literalFunctionTranslator"));
        }
        return literalFunctionTranslator;
    }

    @NotNull
    public JsFunction getFunctionObject(@NotNull CallableDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/k2js/translate/context/TranslationContext", "getFunctionObject"));
        }
        JsFunction jsFunction = this.staticContext.getFunctionWithScope(descriptor);
        if (jsFunction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/context/TranslationContext", "getFunctionObject"));
        }
        return jsFunction;
    }

    public void addStatementToCurrentBlock(@NotNull JsStatement statement) {
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "org/jetbrains/k2js/translate/context/TranslationContext", "addStatementToCurrentBlock"));
        }
        this.dynamicContext.jsBlock().getStatements().add(statement);
    }

    @Nullable
    public JsExpression getAliasForDescriptor(@NotNull DeclarationDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/k2js/translate/context/TranslationContext", "getAliasForDescriptor"));
        }
        if (this.usageTracker != null) {
            this.usageTracker.triggerUsed(descriptor);
        }
        return this.aliasingContext.getAliasForDescriptor(descriptor);
    }

    @NotNull
    public JsExpression getThisObject(@NotNull DeclarationDescriptor descriptor) {
        JsExpression alias;
        DeclarationDescriptor effectiveDescriptor;
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/k2js/translate/context/TranslationContext", "getThisObject"));
        }
        if (descriptor instanceof CallableDescriptor) {
            effectiveDescriptor = JsDescriptorUtils.getExpectedReceiverDescriptor((CallableDescriptor)descriptor);
            assert (effectiveDescriptor != null);
        } else {
            effectiveDescriptor = descriptor;
        }
        if (this.usageTracker != null) {
            this.usageTracker.triggerUsed(effectiveDescriptor);
        }
        JsExpression jsExpression = (alias = this.aliasingContext.getAliasForDescriptor(effectiveDescriptor)) == null ? JsLiteral.THIS : alias;
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/context/TranslationContext", "getThisObject"));
        }
        return jsExpression;
    }
}

